/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.taggedio.TaggedReader;
import inform.agent.web.utils.Color;
import java.io.IOException;

public class WebBorders {
    private static final int TAG_WEB_BORDER_LEFT = 1;
    private static final int TAG_WEB_BORDER_RIGHT = 2;
    private static final int TAG_WEB_BORDER_TOP = 3;
    private static final int TAG_WEB_BORDER_BOTTOM = 4;
    private static final int TAG_WEB_BORDER_HORZ = 5;
    private static final int TAG_WEB_BORDER_VERT = 6;
    public final Border left;
    public final Border right;
    public final Border top;
    public final Border bottom;
    public final Border horizontal;
    public final Border vertical;

    public WebBorders(TaggedReader reader) throws IOException {
        Border v;
        Border h = v = new Border(Border.Style.THIN, 0);
        Border b = v;
        Border t = v;
        Border r = v;
        Border l = v;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    l = new Border(reader.getSubStreamReader());
                    break;
                }
                case 2: {
                    r = new Border(reader.getSubStreamReader());
                    break;
                }
                case 3: {
                    t = new Border(reader.getSubStreamReader());
                    break;
                }
                case 4: {
                    b = new Border(reader.getSubStreamReader());
                    break;
                }
                case 5: {
                    h = new Border(reader.getSubStreamReader());
                    break;
                }
                case 6: {
                    v = new Border(reader.getSubStreamReader());
                }
            }
        }
        this.left = l;
        this.right = r;
        this.top = t;
        this.bottom = b;
        this.horizontal = h;
        this.vertical = v;
    }

    public void appendCssTo(Appendable to) throws IOException {
        to.append("border-left:");
        this.left.appendCssTo(to);
        to.append(';');
        to.append("border-right:");
        this.right.appendCssTo(to);
        to.append(';');
        to.append("border-top:");
        this.top.appendCssTo(to);
        to.append(';');
        to.append("border-bottom:");
        this.bottom.appendCssTo(to);
        to.append(';');
    }

    public static class Border {
        private static final int TAG_WEB_BORDER_STYLE = 1;
        private static final int TAG_WEB_BORDER_COLOR = 2;
        public final Style style;
        public final int color;

        public Border(Style style, int color) {
            this.style = style;
            this.color = color;
        }

        public Border(TaggedReader reader) throws IOException {
            Style s = Style.THIN;
            int c = 0;
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        s = Style.values()[reader.getInt()];
                        break;
                    }
                    case 2: {
                        c = reader.getInt();
                    }
                }
            }
            this.style = s;
            this.color = c;
        }

        public void appendCssTo(Appendable to) throws IOException {
            this.style.appendCssTo(to);
            if (this.style != Style.NONE) {
                to.append(' ').append(Color.toHtml(this.color));
            }
        }

        public static enum Style {
            NONE(0, "none"),
            DOTTED(1, "dotted"),
            THIN(1, "solid"),
            MEDIUM(2, "solid"),
            THICK(3, "solid"),
            DOUBLE(1, "double");

            public final int width;
            public final String style;

            private Style(int width, String style) {
                this.width = width;
                this.style = style;
            }

            private void appendCssTo(Appendable to) throws IOException {
                if (this.width > 0) {
                    to.append(Integer.toString(this.width)).append("px ");
                }
                to.append(this.style);
            }
        }
    }
}

