/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Ini;
import inform.agent.db.types.DataType;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.WebPanel;
import inform.agent.web.forms.components.WebMenu;
import inform.agent.web.forms.expr.JsEvaluator;
import inform.agent.web.utils.Color;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

@JSRequire(value={"static.wcl.controls.Wrapper", "static.wcl.Align", "static.wcl.SizeConstrain", "static.wcl.Utils"})
public abstract class WebControl
extends SmartScriptableObject
implements IntegerHash.Entry,
JsonWriter.JsonPropable {
    public static final int TAG_WEB_WIDTH = 2;
    public static final int TAG_WEB_HEIGHT = 3;
    public static final int TAG_WEB_HORZ_ALIGN = 4;
    public static final int TAG_WEB_VERT_ALIGN = 5;
    public static final int TAG_WEB_FONT = 6;
    public static final int TAG_WEB_COLOR = 7;
    public static final int TAG_WEB_INVISIBLE = 8;
    public static final int TAG_WEB_SPLIT_ARRANGE = 16;
    public static final int TAG_WEB_DISABLED = 17;
    public static final int TAG_WEB_READONLY = 19;
    public static final int TAG_WEB_CONTROL_NAME = 20;
    public static final int TAG_WEB_DESCRIPTION = 21;
    public static final int TAG_WEB_MAX_WIDTH = 24;
    public static final int TAG_WEB_MAX_HEIGHT = 25;
    public static final int TAG_WEB_MARGINS = 26;
    public static final int TAG_WEB_MARGINS_LEFT = 1;
    public static final int TAG_WEB_MARGINS_RIGHT = 2;
    public static final int TAG_WEB_MARGINS_TOP = 3;
    public static final int TAG_WEB_MARGINS_BOTTOM = 4;
    public static final int TAG_WEB_MARGINS_VERTICAL = 5;
    public static final int TAG_WEB_MARGINS_HORIZONTAL = 6;
    public static final int TAG_WEB_SCRIPT_TAG = 27;
    protected final int id;
    protected final boolean isSubControl;
    protected WebControlContainer parent;
    private String name;
    protected String description;
    protected double width;
    protected double height;
    protected double maxWidth;
    protected double maxHeight;
    protected WebFont font;
    private WebFont _effectiveFont;
    protected int color = 0x1FFFFFFF;
    protected boolean visible = true;
    protected boolean readonly;
    protected boolean splitArrange = false;
    private boolean _enabled = true;
    protected VertAlign alignVert = VertAlign.DEFAULT;
    protected HorzAlign alignHorz = HorzAlign.DEFAULT;
    protected double indentLeft;
    protected double indentRight;
    protected double indentTop;
    protected double indentBottom;
    protected String tag = "";

    public WebControl(int id, WebControlContainer parent, boolean isSubControl) {
        this.id = id;
        this.isSubControl = isSubControl;
        this.parent = parent;
        this.setParentScope(parent);
    }

    public void setHAlign(HorzAlign al) {
        this.alignHorz = al;
    }

    public HorzAlign getHAlign() {
        return this.alignHorz;
    }

    public String name() {
        return this.name;
    }

    public void load(TaggedReader reader) throws IOException {
        while (reader.next()) {
            this.loadTag(reader);
        }
    }

    protected HtmlWriter appendStyles(HtmlWriter writer, Resolver resolver) throws IOException {
        if (!this.visible) {
            writer.style("display", "none");
        }
        if (this.color != 0x1FFFFFFF) {
            writer.style("background-color", Color.toHtml(this.color));
        }
        return writer;
    }

    protected boolean isEnabled() {
        if (this.parent != null && !this.parent.isEnabled()) {
            return false;
        }
        return this._enabled;
    }

    protected HtmlWriter appendAttributes(HtmlWriter writer, Resolver resolver) throws IOException {
        if (!this.isEnabled()) {
            writer.attr("disabled");
        }
        if (this.readonly) {
            writer.attr("readonly");
        }
        return writer;
    }

    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
    }

    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        this.generate(html, resolver);
        json.object().underscore("Wrapper", this).prop("item").js("cbi(" + this.id + ")").end();
    }

    private final void generateConstrained(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        if (this.width != 0.0 || this.maxWidth != 0.0 || this.height != 0.0 || this.maxHeight != 0.0) {
            json.object().underscore("SizeConstrain", this);
            if (this.width != 0.0) {
                json.prop("minx").val(this.width + "mm");
            }
            if (this.height != 0.0) {
                json.prop("miny").val(this.height + "mm");
            }
            if (this.maxWidth != 0.0) {
                json.prop("maxx").val(this.maxWidth + "mm");
            }
            if (this.maxHeight != 0.0) {
                json.prop("maxy").val(this.maxHeight + "mm");
            }
            this.generateAligned(html, json.prop("item"), resolver);
            json.end();
        } else {
            this.generateAligned(html, json, resolver);
        }
    }

    public final void generate(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        if (this.indentLeft != 0.0 || this.indentRight != 0.0 || this.indentTop != 0.0 || this.indentBottom != 0.0) {
            json.object().underscore("Utils.Indent", this);
            json.prop("lm").val(this.indentLeft + "mm");
            json.prop("rm").val(this.indentRight + "mm");
            json.prop("tm").val(this.indentTop + "mm");
            json.prop("bm").val(this.indentBottom + "mm");
            this.generateConstrained(html, json.prop("item"), resolver);
            json.end();
        } else {
            this.generateConstrained(html, json, resolver);
        }
    }

    private static int horzAlignToInt(HorzAlign a) {
        switch (a) {
            case CENTER: {
                return 1;
            }
            case RIGHT: {
                return 2;
            }
            case JUSTIFY: {
                return 3;
            }
        }
        return 0;
    }

    private static int vertAlignToInt(VertAlign a) {
        switch (a) {
            case MIDDLE: {
                return 1;
            }
            case BOTTOM: {
                return 2;
            }
            case JUSTIFY: {
                return 3;
            }
        }
        return 0;
    }

    static int calcFlowType(int pad, HorzAlign ha, VertAlign va) {
        if (ha == HorzAlign.DEFAULT) {
            ha = HorzAlign.JUSTIFY;
        }
        if (va == VertAlign.DEFAULT) {
            va = VertAlign.JUSTIFY;
        }
        int flowType = 0;
        int ftah = WebControl.horzAlignToInt(ha);
        int ftav = WebControl.vertAlignToInt(va);
        flowType = (pad & 2) == 0 ? ftah & 3 | ftav << 4 & 0x30 : ftav & 3 | ftah << 4 & 0x30;
        return flowType |= 0xC & pad << 2;
    }

    @Override
    public void commonProp(JsonWriter json) throws IOException {
        if (this.id == 0) {
            return;
        }
        int flowType = WebControl.calcFlowType(this.getParentArrangeDirections(), this.alignHorz, this.alignVert);
        json.prop("flowType").val(flowType);
        if (Ini.WebDebugInfo) {
            json.prop("wdiID").val(this.id);
            if (!Strings.isVoid(this.name)) {
                json.prop("wdiNAME").val(this.name);
            }
        }
    }

    void addScriptProp(JsonWriter json, Resolver resolver) throws IOException {
        if (!this.isSubControl && resolver.hasFormScript) {
            if (!Strings.isVoid(this.name)) {
                json.prop("scriptName").val(this.name);
            }
            json.prop("formScript").js("formScript");
        }
    }

    protected HorzAlign getEffectiveHorzAlign() {
        return this.alignHorz;
    }

    protected VertAlign getEffectiveVertAlign() {
        return this.alignVert;
    }

    private void generateAligned(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        VertAlign va;
        int pad = this.getParentArrangeDirections();
        HorzAlign ha = this.getEffectiveHorzAlign();
        if (ha == HorzAlign.DEFAULT && pad != 0) {
            ha = HorzAlign.JUSTIFY;
        }
        if ((va = this.getEffectiveVertAlign()) == VertAlign.DEFAULT || (pad & 2) != 0) {
            va = VertAlign.JUSTIFY;
        }
        if (ha != HorzAlign.JUSTIFY || va != VertAlign.JUSTIFY) {
            json.object().underscore("Align", this).prop("horz").js("Align.HORZ.").js(ha.name()).prop("vert").js("Align.VERT.").js(va.name());
            this.generate_(html, json.prop("item"), resolver);
            json.end();
        } else {
            this.generate_(html, json, resolver);
        }
    }

    protected int getParentArrangeDirections() {
        if (this.parent instanceof WebPanel) {
            return 1 << ((WebPanel)this.parent).arrangeDirection;
        }
        return 0;
    }

    private void loadIndentation(TaggedReader in) throws IOException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.indentLeft = in.getDouble();
                    break;
                }
                case 2: {
                    this.indentRight = in.getDouble();
                    break;
                }
                case 3: {
                    this.indentTop = in.getDouble();
                    break;
                }
                case 4: {
                    this.indentBottom = in.getDouble();
                }
            }
        }
    }

    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 2: {
                this.width = reader.getDouble();
                break;
            }
            case 3: {
                this.height = reader.getDouble();
                break;
            }
            case 4: {
                this.alignHorz = HorzAlign.values()[reader.getInt()];
                break;
            }
            case 5: {
                this.alignVert = VertAlign.values()[reader.getInt()];
                break;
            }
            case 6: {
                this.font = new WebFont(reader.getStreamReader(), this);
                break;
            }
            case 7: {
                this.color = reader.getInt();
                break;
            }
            case 8: {
                this.visible = false;
                break;
            }
            case 16: {
                this.splitArrange = true;
                break;
            }
            case 17: {
                this._enabled = false;
                break;
            }
            case 19: {
                this.readonly = true;
                break;
            }
            case 20: {
                this.name = reader.getString();
                break;
            }
            case 21: {
                this.description = reader.getString();
                break;
            }
            case 24: {
                this.maxWidth = reader.getDouble();
                break;
            }
            case 25: {
                this.maxHeight = reader.getDouble();
                break;
            }
            case 26: {
                this.loadIndentation(reader.getSubStreamReader());
                break;
            }
            case 27: {
                this.tag = reader.getString();
            }
        }
    }

    protected WebFont effectiveFont() {
        if (this._effectiveFont != null) {
            return this._effectiveFont;
        }
        String nm = this.font == null || this.font.name == null ? this.parentEffectiveFont().name : this.font.name;
        int sz = this.font == null || this.font.size <= 0 ? this.parentEffectiveFont().size : this.font.size;
        int cl = this.font == null || this.font.color == 0x1FFFFFFF ? this.parentEffectiveFont().color : this.font.color;
        int st = this.font == null || this.font.style == 0 ? this.parentEffectiveFont().style : this.font.style;
        this._effectiveFont = new WebFont(nm, sz, cl, st, this);
        return this._effectiveFont;
    }

    protected boolean invalidateEffectiveFont() {
        if (this._effectiveFont == null) {
            return false;
        }
        this._effectiveFont = null;
        return true;
    }

    private WebFont parentEffectiveFont() {
        return this.parent == null ? WebFont.DEFAULT : this.parent.effectiveFont();
    }

    protected String iarr2str(int[] array) {
        StringBuilder result = new StringBuilder();
        boolean nc = false;
        for (int f : array) {
            if (nc) {
                result.append(',');
            }
            result.append(f);
            nc = true;
        }
        return result.toString();
    }

    protected void appendDataBindingsTo(HtmlWriter to, int dsid, int[] fid) throws IOException {
        if (dsid != 0) {
            to.attr("data-datasource", dsid);
        }
        if (fid != null) {
            to.attr("data-datafield", this.iarr2str(fid));
        }
    }

    protected void appendDataBindingsToWithSuffix(HtmlWriter to, int dsid, int[] fid, String suffix) throws IOException {
        if (dsid != 0) {
            to.attr("data-datasource".concat(suffix), dsid);
        }
        if (fid != null) {
            to.attr("data-datafield".concat(suffix), this.iarr2str(fid));
        }
    }

    protected void appendDataBindingsAsExpressionTo(HtmlWriter to, int dsid, int[] fid) throws IOException {
        if (dsid == 0 || fid == null) {
            return;
        }
        to.attr("data-expression", "fld(" + dsid + "," + Arrays.toString(fid) + ")");
    }

    protected boolean hasdb(int dsid, int[] fid) {
        return dsid != 0 && fid != null && fid.length > 0;
    }

    protected String db2expr(int dsid, int[] fid) {
        return "fld(" + dsid + "," + Arrays.toString(fid) + ")";
    }

    protected String expr2str(JsEvaluator expression, Resolver resolver) throws IOException {
        StringBuilder result = new StringBuilder();
        expression.generate(result, resolver);
        return result.toString();
    }

    @SmartScriptableObject.PropertyTag
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @SmartScriptableObject.PropertyTag
    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @SmartScriptableObject.PropertyTag
    public int getTextColor() {
        return this.font == null ? 0x1FFFFFFF : this.font.color;
    }

    public void setTextColor(int v) {
        this.getFont().setColor(v);
    }

    @SmartScriptableObject.PropertyTag
    public WebFont getFont() {
        if (this.font == null) {
            this.font = this.effectiveFont();
        }
        return this.font;
    }

    WebControl clone(WebControlContainer parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int key() {
        return this.id;
    }

    DataType resolveDataType(int ... fpath) {
        return null;
    }

    static HashSet<String> addScriptEvent(HashSet<String> events, String event) {
        if (Strings.isVoid(event)) {
            return events;
        }
        if (events == null) {
            events = new HashSet();
        }
        events.add(event);
        return events;
    }

    public static enum HorzAlign {
        DEFAULT,
        LEFT,
        CENTER,
        RIGHT,
        JUSTIFY;

    }

    public static enum VertAlign {
        DEFAULT,
        TOP,
        BOTTOM,
        MIDDLE,
        BASELINE,
        JUSTIFY;

    }

    protected static class WebEvent {
        private final int[] data;

        public WebEvent(byte[] data) {
            this.data = LittleEndian.toIntArray(data);
        }

        public String toValue() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.data.length / 2; ++i) {
                if (i != 0) {
                    result.append(';');
                }
                result.append(this.data[i * 2 + 0]).append(':').append(this.data[i * 2 + 1]);
            }
            return result.toString();
        }

        protected boolean isDropdown(Resolver resolver) {
            return this.data.length == 2 && resolver.resolveComponent(this.data[0]) instanceof WebMenu;
        }
    }

    public static class WebFont
    extends SmartScriptableObject {
        static final WebFont DEFAULT = new WebFont("Arial", 10, 0, 0, null);
        public static final int FS_BOLD = 1;
        public static final int FS_ITALIC = 2;
        public static final int FS_UNDERLINE = 4;
        public static final int FS_STRIKEOUT = 8;
        public static final String S_FS_BOLD = "fsBold";
        public static final String S_FS_ITALIC = "fsItalic";
        public static final String S_FS_UNDERLINE = "fsUnderline";
        public static final String S_FS_STRIKEOUT = "fsStrikeOut";
        private static final int TAG_WEB_FONT_NAME = 1;
        private static final int TAG_WEB_FONT_STYLE = 2;
        private static final int TAG_WEB_FONT_COLOR = 3;
        private static final int TAG_WEB_FONT_SIZE = 4;
        private final WebControl owner;
        private String name;
        private int size;
        private int color;
        private int style;

        public WebFont(String name, int size, int color, int style, WebControl owner) {
            this.name = name;
            this.size = size;
            this.color = color;
            this.style = style;
            this.owner = owner;
        }

        public WebFont(TaggedReader reader, WebControl owner) throws IOException {
            this.owner = owner;
            String _name = null;
            int _size = 0;
            int _color = 0x1FFFFFFF;
            int _style = 0;
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        _name = reader.getString();
                        break;
                    }
                    case 2: {
                        _style = reader.getInt() | 0xF0000000;
                        break;
                    }
                    case 3: {
                        _color = reader.getInt();
                        break;
                    }
                    case 4: {
                        _size = reader.getInt();
                    }
                }
            }
            this.name = _name;
            this.size = _size;
            this.color = _color;
            this.style = _style;
        }

        public String toCss() {
            StringBuilder result = new StringBuilder();
            if (this.name != null) {
                result.append("font-family:").append(this.name).append(';');
            }
            if (this.size > 0) {
                result.append("font-size:").append(this.size).append("pt;");
            }
            if (this.style != 0) {
                result.append("font-weight:").append((this.style & 1) != 0 ? "bold" : "normal").append(';');
                result.append("font-style:").append((this.style & 2) != 0 ? "italic" : "normal").append(';');
                result.append("text-decoration:");
                if ((this.style & 0xC) != 0) {
                    if ((this.style & 4) != 0) {
                        result.append("underline");
                    }
                    if ((this.style & 8) != 0) {
                        result.append("line-through");
                    }
                } else {
                    result.append("none");
                }
                result.append(';');
            }
            if (this.color != 0x1FFFFFFF) {
                result.append("color:").append(Color.toHtml(this.color)).append(';');
            }
            return result.toString();
        }

        public void appendCssTo(HtmlWriter writer) throws IOException {
            if (this.name != null) {
                writer.style("font-family", this.name);
            }
            if (this.size > 0) {
                writer.style("font-size", this.size, "pt");
            }
            if (this.style != 0) {
                writer.style("font-weight", (this.style & 1) != 0 ? "bold" : "normal").style("font-style", (this.style & 2) != 0 ? "italic" : "normal");
                Object td = "";
                if ((this.style & 0xC) != 0) {
                    if ((this.style & 4) != 0) {
                        td = "underline";
                    }
                    if ((this.style & 8) != 0) {
                        td = (String)td + " line-through";
                    }
                } else {
                    td = "none";
                }
                writer.style("text-decoration", td);
            }
            if (this.color != 0x1FFFFFFF) {
                writer.style("color", Color.toHtml(this.color));
            }
        }

        public JsonWriter appentTo(JsonWriter json) throws IOException {
            if (this.name != null) {
                json.prop("font-family").val(this.name);
            }
            if (this.size > 0) {
                json.prop("font-size").val(String.valueOf(this.size).concat("pt"));
            }
            if (this.style != 0) {
                if ((this.style & 1) != 0) {
                    json.prop("font-weight").val("bold");
                }
                if ((this.style & 2) != 0) {
                    json.prop("font-style").val("italic");
                }
                if ((this.style & 0xC) != 0) {
                    Object td = "";
                    if ((this.style & 4) != 0) {
                        td = "underline";
                    }
                    if ((this.style & 8) != 0) {
                        td = (String)td + " line-through";
                    }
                    json.prop("text-decoration").val(((String)td).trim());
                }
            }
            if (this.color != 0x1FFFFFFF) {
                json.prop("color").val(Color.toHtml(this.color));
            }
            return json;
        }

        @SmartScriptableObject.PropertyTag
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.owner.invalidateEffectiveFont();
        }

        @SmartScriptableObject.PropertyTag
        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
            this.owner.invalidateEffectiveFont();
        }

        @SmartScriptableObject.PropertyTag
        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
            this.owner.invalidateEffectiveFont();
        }

        public int getStyleAsInt() {
            return this.style;
        }

        @SmartScriptableObject.PropertyTag
        public String getStyle() {
            StringBuilder out = new StringBuilder();
            boolean nc = false;
            if ((this.style & 1) != 0) {
                out.append(S_FS_BOLD);
                nc = true;
            }
            if ((this.style & 2) != 0) {
                if (nc) {
                    out.append(',');
                }
                out.append(S_FS_ITALIC);
                nc = true;
            }
            if ((this.style & 4) != 0) {
                if (nc) {
                    out.append(',');
                }
                out.append(S_FS_UNDERLINE);
                nc = true;
            }
            if ((this.style & 8) != 0) {
                if (nc) {
                    out.append(',');
                }
                out.append(S_FS_STRIKEOUT);
            }
            return out.toString();
        }

        public void setStyle(String style) {
            int st = 0;
            for (String s : style.split(",")) {
                if (S_FS_BOLD.equals(s)) {
                    st |= 1;
                    continue;
                }
                if (S_FS_ITALIC.equals(s)) {
                    st |= 2;
                    continue;
                }
                if (S_FS_UNDERLINE.equals(s)) {
                    st |= 4;
                    continue;
                }
                if (!S_FS_STRIKEOUT.equals(s)) continue;
                st |= 8;
            }
            this.style = st;
            this.owner.invalidateEffectiveFont();
        }
    }

    static interface JSGenerator {
        public void generate(Appendable var1, String var2, WebForm.Task var3) throws IOException;
    }
}

