/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.expr.JsEvaluator;
import inform.agent.web.forms.expr.JsExpression;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import java.io.IOException;

@JSRequire(value={"WebEdit", "static.wcl.controls.Label", "static.wcl.layouts.Flow", "css!WebEdit"})
public class WebEdit
extends WebControlContainer
implements DatasourceUsage {
    private static final int TAG_WEB_EDIT_CAPTION = 40;
    private static final int TAG_WEB_EDIT_DATASOURCE = 41;
    private static final int TAG_WEB_EDIT_FIELD = 42;
    private static final int TAG_WEB_EDIT_FORMAT = 43;
    private static final int TAG_WEB_EDIT_FORMAT_OPTION = 44;
    private static final int TAG_WEB_EDIT_DATA_TYPE = 45;
    private static final int TAG_WEB_EDIT_EXPRESSION = 46;
    private static final int TAG_WEB_EDIT_MULTILINE = 49;
    private static final int TAG_WEB_EDIT_DATA_SELECTOR = 50;
    private static final int TAG_WEB_EDIT_EVENT = 51;
    private static final int TAG_WEB_EDIT_EVENT_EDIT_ONLY = 52;
    private static final int TAG_WEB_EDIT_MAX_WIDTH = 53;
    private static final int TAG_WEB_EDIT_MAX_HEIGHT = 54;
    private static final int TAG_WEB_EDIT_MIN_WIDTH = 55;
    private static final int TAG_WEB_EDIT_MIN_HEIGHT = 56;
    private final Caption caption = new Caption(this);
    protected boolean multiline;
    private int datasourceId;
    private int[] fieldId;
    private int formatId;
    private DataType dataType;
    private byte[] formatOption;
    private JsEvaluator expression;
    private DataSelector dataSelector;
    private WebControl.WebEvent event;
    private boolean eventEditOnly = true;
    private int minCharWidth;
    private int minCharHeight;
    private int maxCharWidth;
    private int maxCharHeight;

    public WebEdit(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
        WebEdit.defineProperty(this, "title", this.caption, 1);
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        if (this.dataSelector != null) {
            out.append((Object)this, this.dataSelector.dsid, this.dataSelector.fpath);
            out.append((Object)this, this.dataSelector.dsid, this.dataSelector.dfpath);
        }
        out.append((Object)this, this.datasourceId, this.fieldId);
        if (this.expression != null) {
            this.expression.appendUsedDirectoriesTo(this, out);
        }
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.caption.load(reader.getSubStreamReader());
                break;
            }
            case 41: {
                this.datasourceId = reader.getInt();
                break;
            }
            case 42: {
                this.fieldId = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 43: {
                this.formatId = reader.getInt();
                break;
            }
            case 44: {
                this.formatOption = reader.getRaw();
                break;
            }
            case 45: {
                this.dataType = DataType.getDataTypeById(reader.getInt());
                break;
            }
            case 46: {
                this.expression = JsExpression.loadAndCompile(reader.getStreamReader());
                break;
            }
            case 49: {
                this.multiline = true;
                break;
            }
            case 50: {
                this.dataSelector = new DataSelector(reader.getSubStreamReader());
                break;
            }
            case 51: {
                this.event = new WebControl.WebEvent(reader.getRaw());
                break;
            }
            case 52: {
                this.eventEditOnly = reader.getBoolean();
                break;
            }
            case 53: {
                this.maxCharWidth = reader.getInt();
                break;
            }
            case 54: {
                this.maxCharHeight = reader.getInt();
                break;
            }
            case 55: {
                this.minCharWidth = reader.getInt();
                break;
            }
            case 56: {
                this.minCharHeight = reader.getInt();
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    Caption visibleCaption() {
        return this.caption.visible ? this.caption : null;
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        this.generateHtml(html, resolver);
        Caption cap = this.visibleCaption();
        if (cap != null) {
            json.object().underscore("Flow", this);
            switch (cap.position) {
                case 0: 
                case 2: {
                    json.prop("gap").val(2).prop("type").js("Flow.HORZ");
                    break;
                }
                case 1: 
                case 3: {
                    json.prop("gap").val(1).prop("type").js("Flow.VERT");
                }
            }
            json.prop("items").array();
            switch (cap.position) {
                case 0: {
                    cap.generate(html, json.prop(), resolver);
                    this.generateJson(json.prop(), resolver);
                    break;
                }
                case 1: {
                    cap.generate(html, json.prop(), resolver);
                    this.generateJson(json.prop(), resolver);
                    break;
                }
                case 2: {
                    this.generateJson(json.prop(), resolver);
                    cap.generate(html, json.prop(), resolver);
                    break;
                }
                case 3: {
                    this.generateJson(json.prop(), resolver);
                    cap.generate(html, json.prop(), resolver);
                }
            }
            json.end().end();
        } else {
            this.generateJson(json, resolver);
        }
    }

    void generateHtml(HtmlWriter html, Resolver resolver) throws IOException {
        html.tag("span").attr("class", "edit").attr("id", this.id);
        this.generateEdit(html, resolver);
        html.end();
    }

    void generateJson(JsonWriter json, Resolver resolver) throws IOException {
        if (!this.multiline) {
            json.object().underscore("Align", this).prop("vert").js("Align.VERT.MIDDLE").prop("item");
        }
        json.object().underscore("WebEdit.WclControl", this).prop("minw").val(this.minCharWidth).prop("minh").val(this.minCharHeight).prop("maxw").val(this.maxCharWidth).prop("maxh").val(this.maxCharHeight).prop("item").js("cbi(" + this.id + ")").prop("cmps").js("components").end();
        if (!this.multiline) {
            json.end();
        }
    }

    void generateEdit(HtmlWriter writer, Resolver resolver) throws IOException {
        if (this.multiline) {
            writer.tag("textarea");
            if (this.height > 0.0) {
                writer.style("height", this.height, "mm");
            }
        } else {
            writer.tag("input");
            DataType dt = this.dataType;
            if (this.dataType == null) {
                dt = resolver.resolveDataType(this.datasourceId, this.fieldId);
            }
            switch (dt) {
                case BIG_NUMBER: 
                case FLOAT: 
                case INTEGER: {
                    writer.attr("type", "number");
                    break;
                }
                default: {
                    writer.attr("type", "text");
                }
            }
            if (this.formatId != 0) {
                writer.attr("data-format", this.formatId);
                if (this.formatOption != null) {
                    writer.attr("fmtopt", Base64BinString.Encode(this.formatOption));
                }
            }
            if (this.dataSelector != null) {
                StringBuilder dsel = new StringBuilder();
                dsel.append(this.dataSelector.dsid).append(':');
                if (this.dataSelector.fpath != null) {
                    dsel.append(this.iarr2str(this.dataSelector.fpath));
                }
                dsel.append(':');
                if (this.dataSelector.dfpath != null) {
                    dsel.append(this.iarr2str(this.dataSelector.dfpath));
                }
                dsel.append(':');
                if (this.dataSelector.param != 0) {
                    dsel.append(this.dataSelector.param);
                }
                if (this.dataSelector.only) {
                    dsel.append(":only");
                }
                writer.attr("data-selector", dsel);
                if (this.dataSelector.event != null) {
                    writer.attr("data-select-action", this.dataSelector.event.toValue());
                }
            }
            if (this.event != null) {
                writer.attr("data-action", this.event.toValue());
                if (this.eventEditOnly) {
                    writer.attr("data-action-editonly");
                }
            }
        }
        this.appendAttributes(writer, resolver);
        this.appendDataBindingsTo(writer, this.datasourceId, this.fieldId);
        if (this.width > 0.0) {
            writer.style("width", this.width, "mm");
        }
        if (this.font != null) {
            this.font.appendCssTo(writer);
        }
        if (this.expression != null) {
            writer.attr("data-expression", this.expr2str(this.expression, resolver));
        } else {
            this.appendDataBindingsAsExpressionTo(writer, this.datasourceId, this.fieldId);
        }
        writer.end();
    }

    private static class DataSelector {
        static final int TAG_WEB_DATASELECTOR_DATASOURCE_ID = 1;
        static final int TAG_WEB_DATASELECTOR_FIELD_PATH = 2;
        static final int TAG_WEB_DATASELECTOR_DISPLAY_PATH = 3;
        static final int TAG_WEB_DATASELECTOR_SELECT_ONLY = 6;
        static final int TAG_WEB_DATASELECTOR_SELECT_PARAM_ID = 7;
        static final int TAG_WEB_DATASELECTOR_EVENT = 8;
        final int dsid;
        final int[] fpath;
        final int[] dfpath;
        final boolean only;
        final int param;
        final WebControl.WebEvent event;

        DataSelector(TaggedReader reader) throws IOException {
            int _dsid = 0;
            int[] _fpath = null;
            int[] _dfpath = null;
            boolean _only = false;
            int _param = 0;
            WebControl.WebEvent _event = null;
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        _dsid = reader.getInt();
                        break;
                    }
                    case 2: {
                        _fpath = LittleEndian.toIntArray(reader.getRaw());
                        break;
                    }
                    case 3: {
                        _dfpath = LittleEndian.toIntArray(reader.getRaw());
                        break;
                    }
                    case 6: {
                        _only = true;
                        break;
                    }
                    case 7: {
                        _param = reader.getInt();
                        break;
                    }
                    case 8: {
                        _event = new WebControl.WebEvent(reader.getRaw());
                    }
                }
            }
            this.dsid = _dsid;
            this.fpath = _fpath;
            this.dfpath = _dfpath;
            this.only = _only;
            this.param = _param;
            this.event = _event;
        }
    }

    static class Caption
    extends WebControl {
        static final int WCP_LEFT = 0;
        static final int WCP_TOP = 1;
        static final int WCP_RIGHT = 2;
        static final int WCP_BOTTOM = 3;
        static final int TAG_WEB_EDIT_CAPTION_TEXT = 1;
        static final int TAG_WEB_EDIT_CAPTION_POS = 2;
        static final int TAG_WEB_EDIT_CAPTION_HALIGN = 3;
        static final int TAG_WEB_EDIT_CAPTION_VALIGN = 4;
        static final int TAG_WEB_EDIT_CAPTION_FONT = 5;
        static final int TAG_WEB_EDIT_CAPTION_COLOR = 6;
        static final int TAG_WEB_EDIT_CAPTION_VISIBLE = 7;
        String text;
        int position;

        public Caption(WebControlContainer parent) {
            super(0, parent, true);
            this.visible = false;
        }

        @SmartScriptableObject.PropertyTag
        public String getText() {
            return this.text;
        }

        public void setText(String v) {
            this.text = v;
        }

        @Override
        protected void loadTag(TaggedReader reader) throws IOException {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.text = reader.getString();
                    break;
                }
                case 2: {
                    this.position = reader.getInt();
                    break;
                }
                case 3: {
                    this.alignHorz = WebControl.HorzAlign.values()[reader.getInt()];
                    break;
                }
                case 4: {
                    this.alignVert = WebControl.VertAlign.values()[reader.getInt()];
                    break;
                }
                case 5: {
                    this.font = new WebControl.WebFont(reader.getStreamReader(), this);
                    break;
                }
                case 6: {
                    this.color = reader.getInt();
                    break;
                }
                case 7: {
                    this.visible = true;
                }
            }
        }

        void generate(HtmlWriter writer, Resolver resolver, boolean span) throws IOException {
            writer.tag(span ? "span" : "div");
            if (!span && this.alignHorz != WebControl.HorzAlign.DEFAULT) {
                writer.style("text-align", this.alignHorz.name().toLowerCase());
            }
            if (span && this.alignVert != WebControl.VertAlign.DEFAULT) {
                writer.style("vertical-align", this.alignVert.name().toLowerCase());
            }
            writer.text(this.text).end();
        }

        @Override
        protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
            json.object().underscore("Label", this).prop("text").val(this.text).prop("style").object();
            ((WebEdit)this.parent).effectiveFont().appentTo(json).end().end();
        }
    }
}

