/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebScript;
import inform.agent.web.forms.expr.JsEvaluator;
import inform.agent.web.forms.expr.JsExpression;
import inform.agent.web.utils.Color;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.HashSet;

@JSRequire(value={"WebLabel", "static.wcl.controls.Label", "inform.agent.web.Expressions"})
public class WebLabel
extends WebControl
implements DatasourceUsage,
WebScript.EventHolder {
    private static final int TAG_WEB_LABEL_TEXT = 40;
    private static final int TAG_WEB_LABEL_DATASOURCE = 41;
    private static final int TAG_WEB_LABEL_FIELD = 42;
    private static final int TAG_WEB_LABEL_FORMAT = 43;
    private static final int TAG_WEB_LABEL_FORMAT_OPTION = 44;
    private static final int TAG_WEB_LABEL_DATA_TYPE = 45;
    private static final int TAG_WEB_LABEL_EXPRESSION = 46;
    private static final int TAG_WEB_LABEL_ON_CLICK = 47;
    private static final int TAG_WEB_LABEL_EVENT = 48;
    private String text;
    private int datasourceId;
    private int[] fieldId;
    private int formatId;
    private int dataType;
    private byte[] formatOption;
    private JsEvaluator expression;
    protected WebControl.WebEvent event;
    private String onClick;

    public WebLabel(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @SmartScriptableObject.PropertyTag
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.text = reader.getString();
                break;
            }
            case 41: {
                this.datasourceId = reader.getInt();
                break;
            }
            case 42: {
                this.fieldId = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 43: {
                this.formatId = reader.getInt();
                break;
            }
            case 44: {
                this.formatOption = reader.getRaw();
                break;
            }
            case 45: {
                this.dataType = reader.getInt();
                break;
            }
            case 46: {
                this.expression = JsExpression.loadAndCompile(reader.getStreamReader());
                break;
            }
            case 47: {
                this.onClick = reader.getAnsi();
                break;
            }
            case 48: {
                this.event = new WebControl.WebEvent(reader.getRaw());
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        writer.tag("span").attr("id", this.id).attr("class", "label");
        if (this.font != null) {
            this.font.appendCssTo(writer);
        }
        if (this.width != 0.0) {
            writer.style("width", this.width, "mm");
        }
        if (this.alignHorz != WebControl.HorzAlign.DEFAULT) {
            writer.style("text-align", this.alignHorz.name().toLowerCase());
        }
        this.appendStyles(writer, resolver);
        if (this.formatId != 0) {
            writer.attr("data-format", this.formatId);
        }
        if (this.expression != null) {
            writer.attr("data-expression", this.expr2str(this.expression, resolver));
        } else {
            this.appendDataBindingsAsExpressionTo(writer, this.datasourceId, this.fieldId);
        }
        if (this.dataType != 0) {
            writer.attr("data-datatype", this.dataType);
        }
        this.appendDataBindingsTo(writer, this.datasourceId, this.fieldId);
        writer.text(this.text).end();
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        json.object();
        json.underscore("Label", this);
        boolean enabled = this.isEnabled();
        if (!enabled) {
            json.prop("enabled").val(enabled);
        }
        json.prop("tag").val(this.getTag());
        json.prop("text").js("WebLabel.model(");
        json.object();
        if (this.formatId != 0) {
            json.prop("fmt").val(this.formatId);
            if (this.formatOption != null) {
                json.prop("fmtopt").val(Base64BinString.Encode(this.formatOption));
            }
        }
        json.prop("cmps").js("components");
        if (this.expression != null) {
            json.prop("exp").val(this.expr2str(this.expression, resolver));
        } else if (this.hasdb(this.datasourceId, this.fieldId)) {
            json.prop("exp").val(this.db2expr(this.datasourceId, this.fieldId));
        }
        if (this.dataType == 0 && this.hasdb(this.datasourceId, this.fieldId)) {
            this.dataType = resolver.resolveDataType(this.datasourceId, this.fieldId).getTypeId();
        }
        if (this.dataType != 0) {
            json.prop("typ").val(this.dataType);
        }
        json.prop("text").val(this.text);
        json.end().js(")");
        json.prop("style").object();
        if (!this.visible) {
            json.prop("display").val("none");
        }
        if (this.color != 0x1FFFFFFF) {
            json.prop("background-color").val(Color.toHtml(this.color));
        }
        this.effectiveFont().appentTo(json).end();
        this.addScriptProp(json, resolver);
        if (!Strings.isVoid(this.onClick) && resolver.hasFormScript) {
            json.prop("scriptclick").js("formScript." + this.onClick);
        } else if (this.event != null) {
            json.prop("onclick").js("cact(new WF.ActionList(").val(this.event.toValue()).js(",components))");
        }
        json.end();
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        out.append((Object)this, this.datasourceId, this.fieldId);
        if (this.expression != null) {
            this.expression.appendUsedDirectoriesTo(this, out);
        }
    }

    @Override
    public HashSet<String> getScriptEvents(HashSet<String> events) {
        return WebLabel.addScriptEvent(events, this.onClick);
    }
}

