/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebEdit;
import inform.agent.web.utils.Color;
import inform.common.SmartScriptableObject;
import java.io.IOException;

@JSRequire(value={"WebPanel", "static.wcl.layouts.Flow"})
public class WebPanel
extends WebControlContainer {
    protected static final int TAG_WF_PANEL_INTERNAL_MARGINS = 40;
    protected static final int TAG_WF_PANEL_ARRANGE_DIRECTION = 41;
    protected static final int TAG_WF_PANEL_SPLITTERS = 42;
    protected static final int TAG_WF_PANEL_TYPE = 43;
    protected static final int WAD_HORIZONTAL = 0;
    protected static final int WAD_VERTICAL = 1;
    protected static final int WPT_LAYOUT = 0;
    protected static final int WPT_BLOCK = 1;
    protected int panelType;
    private InternalMargins margins = InternalMargins.DEFAULT;
    private boolean splitters;
    protected int arrangeDirection = 0;

    public WebPanel(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 43: {
                this.panelType = reader.getInt();
                break;
            }
            case 40: {
                this.margins = new InternalMargins(reader.getSubStreamReader());
                break;
            }
            case 41: {
                this.arrangeDirection = reader.getInt();
                break;
            }
            case 42: {
                this.splitters = true;
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    protected WebControl.HorzAlign getEffectiveHorzAlign() {
        if (this.alignHorz == WebControl.HorzAlign.DEFAULT && this.parent != null) {
            return WebControl.HorzAlign.JUSTIFY;
        }
        return this.alignHorz;
    }

    @Override
    protected WebControl.VertAlign getEffectiveVertAlign() {
        if (this.alignVert == WebControl.VertAlign.DEFAULT && this.parent != null) {
            return WebControl.VertAlign.JUSTIFY;
        }
        return this.alignVert;
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        WebControl.HorzAlign iha = this.alignInternalHorz;
        WebControl.VertAlign iva = this.alignInternalVert;
        int pad = this.getParentArrangeDirections();
        if (iha == WebControl.HorzAlign.DEFAULT || (pad & 2) != 0) {
            iha = WebControl.HorzAlign.JUSTIFY;
        }
        if (iva == WebControl.VertAlign.DEFAULT || (pad & 1) != 0) {
            iva = WebControl.VertAlign.JUSTIFY;
        }
        if (iha != WebControl.HorzAlign.JUSTIFY || iva != WebControl.VertAlign.JUSTIFY) {
            json.object().underscore("Align", this).prop("horz").js("Align.HORZ.").js(iha.name()).prop("vert").js("Align.VERT.").js(iva.name());
            this.generateInAlign(html, json.prop("item"), resolver);
            json.end();
        } else {
            this.generateInAlign(html, json, resolver);
        }
    }

    private void generateInAlign(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        boolean vertical;
        boolean hasSeps = false;
        int idx = 0;
        for (WebControl c : this.controls) {
            if (c.splitArrange && idx > 0) {
                hasSeps = true;
                break;
            }
            ++idx;
        }
        boolean bl = vertical = this.arrangeDirection == 1;
        if (hasSeps) {
            json.object();
            json.underscore("Flow", this);
            json.prop("type").js(vertical ? "Flow.HORZ" : "Flow.VERT");
            json.prop("items").array().prop();
        }
        int idx2 = 0;
        for (WebControl c : this.controls) {
            if (c.splitArrange || idx2 == 0) {
                if (idx2 != 0) {
                    json.end().end().prop();
                }
                json.object();
                if (this.splitters) {
                    json.underscore("WebPanel.Splitters", this).prop("type").js(vertical ? "Flow.VERT" : "Flow.HORZ");
                } else if (vertical) {
                    json.underscore("WebPanel.WclControl", this);
                } else {
                    json.underscore("Flow", this).prop("type").js(vertical ? "Flow.VERT" : "Flow.HORZ");
                }
                if (this.panelType == 1) {
                    json.prop("block").val(true);
                    if (this.color != 0x1FFFFFFF) {
                        json.prop("style").object();
                        json.prop("background-color").val(Color.toHtml(this.color));
                        json.end();
                    }
                }
                json.prop("items").array();
            }
            if (c.visible) {
                if (vertical && c instanceof WebEdit) {
                    this.generateEdit((WebEdit)c, html, json.prop(), resolver);
                } else {
                    c.generate(html, json.prop(), resolver);
                }
            }
            ++idx2;
        }
        if (idx2 > 0) {
            json.end().end();
        } else {
            json.object().underscore("Flow", this).prop("type").js("Flow.HORZ").end();
        }
        if (hasSeps) {
            json.end().end();
        }
    }

    private void generateEdit(WebEdit edit, HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        WebEdit.Caption cap = edit.visibleCaption();
        if (cap == null || cap.position != 0 && cap.position != 2) {
            edit.generate(html, json, resolver);
            return;
        }
        json.array();
        json.prop();
        if (cap.position == 0) {
            cap.generate(html, json, resolver);
        } else {
            json.js("null");
        }
        edit.generateHtml(html, resolver);
        edit.generateJson(json.prop(), resolver);
        json.prop();
        if (cap.position == 2) {
            cap.generate(html, json, resolver);
        } else {
            json.js("null");
        }
        json.end();
    }

    @SmartScriptableObject.FunctionTag
    public WebControl appendCloneOf(WebControl control) {
        WebControl clone = control.clone(this.parent);
        this.controls.add(clone);
        return clone;
    }

    private static class InternalMargins {
        static final double DEF_INTERNAL_MARGINS = 2.0;
        static final InternalMargins DEFAULT = new InternalMargins(2.0, 2.0);
        static final int TAG_WEB_MARGINS_VERTICAL = 5;
        static final int TAG_WEB_MARGINS_HORIZONTAL = 6;
        final double vertical;
        final double horizontal;

        public InternalMargins(double vertical, double horizontal) {
            this.vertical = vertical;
            this.horizontal = horizontal;
        }

        public InternalMargins(TaggedReader reader) throws IOException {
            double _v = 2.0;
            double _h = 2.0;
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 5: {
                        _v = reader.getDouble();
                        break;
                    }
                    case 6: {
                        _h = reader.getDouble();
                    }
                }
            }
            this.vertical = _v;
            this.horizontal = _h;
        }
    }
}

