/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import java.io.IOException;

@JSRequire(value={"WebScheme"})
public class WebScheme
extends WebControl
implements DatasourceUsage {
    private static final int TAG_WF_SCHEME_KEEP_NODE = 40;
    private static final int TAG_WF_SCHEME_DATASOURCE = 41;
    private static final int TAG_WF_SCHEME_FIELD = 42;
    private static final int TAG_WF_SCHEME_PROPERTY_X = 43;
    private static final int TAG_WF_SCHEME_PROPERTY_Y = 44;
    private static final int TAG_WF_SCHEME_PROPERTY_Z = 45;
    private static final int TAG_WF_SCHEME_PROPERTY_LAYERS_CONFIG = 46;
    private static final int TAG_WF_SCHEME_PROPERTY_SHAPE_ID = 47;
    private static final int TAG_WF_SCHEME_PROPERTY_OBJECT_ID = 48;
    private static final int TAG_WF_SCHEME_PROPERTY_OBJECT_NAME = 49;
    private static final int TAG_WF_SCHEME_MOUSE_CLICK_EVENT = 50;
    private double keepNode;
    private int dsid;
    private int[] field;
    private int propX;
    private int propY;
    private int propZ;
    private int propLayersConfig;
    private int propShapeID;
    private int propObjectID;
    private int propObjectName;
    private WebControl.WebEvent eventMouseClick;

    public WebScheme(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.keepNode = reader.getNodeID();
                break;
            }
            case 41: {
                this.dsid = reader.getInt();
                break;
            }
            case 42: {
                this.field = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 43: {
                this.propX = reader.getInt();
                break;
            }
            case 44: {
                this.propY = reader.getInt();
                break;
            }
            case 45: {
                this.propZ = reader.getInt();
                break;
            }
            case 46: {
                this.propLayersConfig = reader.getInt();
                break;
            }
            case 47: {
                this.propShapeID = reader.getInt();
                break;
            }
            case 48: {
                this.propObjectID = reader.getInt();
                break;
            }
            case 49: {
                this.propObjectName = reader.getInt();
                break;
            }
            case 50: {
                this.eventMouseClick = new WebControl.WebEvent(reader.getRaw());
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        writer.tag("div").attr("class", "scheme").attr("id", this.id);
        if (this.width != 0.0) {
            writer.style("width", this.width, "mm");
        }
        if (this.height != 0.0) {
            writer.style("height", this.height, "mm");
        }
        writer.style("border", "1px solid #ccc");
        writer.style("background-color", "white");
        if (this.keepNode != 0.0) {
            writer.attr("data-keepNode", (long)this.keepNode);
        }
        this.appendDataBindingsTo(writer, this.dsid, this.field);
        if (this.propX != 0) {
            writer.attr("data-propX", this.propX);
        }
        if (this.propY != 0) {
            writer.attr("data-propY", this.propY);
        }
        if (this.propZ != 0) {
            writer.attr("data-propZ", this.propZ);
        }
        if (this.propLayersConfig != 0) {
            writer.attr("data-propLayersConfig", this.propLayersConfig);
        }
        if (this.propShapeID != 0) {
            writer.attr("data-propShapeID", this.propShapeID);
        }
        if (this.propObjectID != 0) {
            writer.attr("data-propObjectID", this.propObjectID);
        }
        if (this.propObjectName != 0) {
            writer.attr("data-propObjectName", this.propObjectName);
        }
        if (this.eventMouseClick != null) {
            writer.attr("data-actionMouseClick", this.eventMouseClick.toValue());
        }
        writer.end();
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        out.append((Object)this, this.dsid, this.field);
    }
}

