/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebScript;
import java.io.IOException;
import java.util.HashSet;

@JSRequire(value={"WebToolbar", "static.wcl.controls.Toolbar", "static.wcl.controls.Button", "static.wcl.layouts.Flow"})
public class WebToolbar
extends WebControlContainer {
    private static final int WF_TOOLBUTTON = 503;

    public WebToolbar(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        writer.tag("div").attr("class", "toolbar");
        if (this.id != 0) {
            writer.attr("id", this.id);
        }
        int idx = 0;
        for (WebControl c : this.controls) {
            Button b = (Button)c;
            if (b.separator && idx > 0) {
                writer.end().tag("div").attr("class", "toolbar");
            }
            b.generate(writer, resolver);
            ++idx;
        }
        writer.end();
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        boolean hasSeps = false;
        int idx = 0;
        for (WebControl c : this.controls) {
            if (((Button)c).separator && idx > 0) {
                hasSeps = true;
                break;
            }
            ++idx;
        }
        if (hasSeps) {
            json.object();
            json.underscore("Flow", this);
            json.prop("type").js("Flow.HORZ");
            json.prop("gap").val(1);
            json.prop("items").array().prop();
        }
        json.object();
        json.underscore("Toolbar", this);
        json.prop("items").array();
        idx = 0;
        for (WebControl c : this.controls) {
            Button b = (Button)c;
            if (b.separator && idx > 0) {
                json.end().end().prop().object().underscore("Toolbar", this).prop("items").array();
            }
            if (c.visible) {
                c.generate(html, json.prop(), resolver);
            }
            ++idx;
        }
        json.end().end();
        if (hasSeps) {
            json.end().end();
        }
    }

    @Override
    protected WebControl createTypedControl(int type, int id, int options) {
        if (type == 503) {
            return new Button(id, this);
        }
        return super.createTypedControl(type, id, options);
    }

    protected static class Button
    extends WebControl
    implements DatasourceUsage,
    WebScript.EventHolder {
        static final int TAG_WEB_TOOLBUTTON_CAPTION = 40;
        static final int TAG_WEB_TOOLBUTTON_HINT = 41;
        static final int TAG_WEB_TOOLBUTTON_IMAGE_ID = 42;
        static final int TAG_WEB_TOOLBUTTON_ONCLICK = 43;
        static final int TAG_WEB_TOOLBUTTON_MENU = 44;
        static final int TAG_WEB_TOOLBUTTON_SEPARATOR = 47;
        static final int TAG_WEB_TOOLBUTTON_DATASOURCE = 48;
        static final int TAG_WEB_TOOLBUTTON_CAPTION_FIELD = 49;
        static final int TAG_WEB_TOOLBUTTON_IMAGE_FIELD = 50;
        static final int TAG_WEB_TOOLBUTTON_EVENT = 53;
        String caption;
        String hint;
        String onClick;
        int imageId;
        boolean separator;
        int dsid;
        int[] fcap;
        int[] fimg;
        WebControl.WebEvent event;

        Button(int id, WebControlContainer parent) {
            super(id, parent, false);
        }

        @Override
        protected void loadTag(TaggedReader reader) throws IOException {
            switch (reader.getCurrentTag()) {
                case 40: {
                    this.caption = reader.getString();
                    break;
                }
                case 41: {
                    this.hint = reader.getString();
                    break;
                }
                case 42: {
                    this.imageId = reader.getInt();
                    break;
                }
                case 43: {
                    this.onClick = reader.getString();
                    break;
                }
                case 47: {
                    this.separator = true;
                    break;
                }
                case 48: {
                    this.dsid = reader.getInt();
                    break;
                }
                case 49: {
                    this.fcap = LittleEndian.toIntArray(reader.getRaw());
                    break;
                }
                case 50: {
                    this.fimg = LittleEndian.toIntArray(reader.getRaw());
                    break;
                }
                case 53: {
                    this.event = new WebControl.WebEvent(reader.getRaw());
                    break;
                }
                default: {
                    super.loadTag(reader);
                }
            }
        }

        @Override
        public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
            writer.tag("button").attr("id", this.id);
            this.appendAttributes(writer, resolver);
            this.appendStyles(writer, resolver);
            if (this.hint != null) {
                writer.attr("title", this.hint);
            }
            Object cap = this.caption;
            if (this.event != null) {
                writer.attr("data-action", this.event.toValue());
                if (this.event.isDropdown(resolver)) {
                    if (cap == null) {
                        cap = "";
                    }
                    cap = (String)cap + "<span class='dd'>&#9660;</span>";
                }
            }
            if (this.onClick != null) {
                writer.attr("data-click", this.onClick);
            }
            if (this.dsid != 0) {
                writer.attr("data-datasource", this.dsid);
                if (this.fcap != null) {
                    writer.attr("data-capfield", this.iarr2str(this.fcap));
                }
                if (this.fimg != null) {
                    writer.attr("data-imgfield", this.iarr2str(this.fimg));
                }
            }
            if (this.imageId != 0) {
                writer.tag("img").attr("data-icon", this.imageId).end();
                if (cap != null) {
                    writer.tag("span").html(cap).end();
                }
            } else if (cap != null) {
                writer.html(cap);
            }
            writer.end();
        }

        @Override
        protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
            json.object();
            if (this.dsid == 0) {
                json.underscore("Button", this);
            } else {
                json.underscore("WebToolbar.VeerButton", this);
                json.prop("ds").js("components[").val(this.dsid).js("]");
                if (this.fcap != null) {
                    json.prop("fcap").js("DM.mkFieldPath(").val(this.fcap).js(",").val(this.dsid).js(",components)");
                }
                if (this.fimg != null) {
                    json.prop("fimg").js("DM.mkFieldPath(").val(this.fimg).js(",").val(this.dsid).js(",components)");
                }
            }
            boolean enabled = this.isEnabled();
            if (!enabled) {
                json.prop("enabled").val(enabled);
            }
            json.prop("tag").val(this.getTag());
            if (!this.visible) {
                json.prop("display").val("none");
            }
            this.addScriptProp(json, resolver);
            Object cap = this.caption;
            if (!Strings.isVoid(this.onClick) && resolver.hasFormScript) {
                json.prop("scriptclick").js("formScript." + this.onClick);
            } else if (this.event != null) {
                json.prop("onclick").js("cact(new WF.ActionList(").val(this.event.toValue()).js(",components))");
                if (this.event.isDropdown(resolver)) {
                    if (cap == null) {
                        cap = "";
                    }
                    cap = (String)cap + " &#9660;";
                }
            }
            if (cap != null) {
                json.prop("text").val(cap);
            }
            if (this.imageId != 0) {
                json.prop("icon").val(this.imageId);
            }
            if (this.hint != null) {
                json.prop("hint").val(this.hint);
            }
            json.end();
        }

        @Override
        public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
            out.append((Object)this, this.dsid, this.fcap);
            out.append((Object)this, this.dsid, this.fimg);
        }

        @Override
        public HashSet<String> getScriptEvents(HashSet<String> events) {
            return Button.addScriptEvent(events, this.onClick);
        }
    }
}

