/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.components;

import inform.adt.LittleEndian;
import inform.adt.collections.IntegerIntegerMap;
import inform.adt.taggedio.TaggedReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.web.JSON;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.components.WebComponentContainer;
import inform.agent.web.forms.components.WebLauncher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class WebFormLauncher
extends WebLauncher {
    private static final int TAG_WEB_FORM_LAUNCHER_MODE = 43;
    private static final int TAG_WEB_FORM_LAUNCHER_DS_MAP = 44;
    private static final int TAG_WEB_FORM_LAUNCHER_FIELD_MAP = 45;
    private static final int TAG_SS_FIELD_MAP_ITEM = 1;
    private int mode;
    private final IntegerIntegerMap dsmap = new IntegerIntegerMap();
    private final Collection<FieldMapEntry> fmap = new ArrayList<FieldMapEntry>();

    public WebFormLauncher(int id, int options, WebComponentContainer parent) {
        super(id, parent);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 43: {
                this.mode = reader.getInt();
                break;
            }
            case 44: {
                TaggedReader rr = reader.getSubStreamReader();
                while (rr.next()) {
                    int src = rr.getInt();
                    int tgt = rr.getInt();
                    this.dsmap.put(tgt, src);
                }
                break;
            }
            case 45: {
                TaggedReader rrr = reader.getSubStreamReader();
                while (rrr.next()) {
                    if (rrr.getCurrentTag() != 1) continue;
                    this.fmap.add(new FieldMapEntry(rrr.getSubStreamReader()));
                }
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    protected boolean needAllParameterValues() {
        return false;
    }

    @Override
    protected void appendExtraProperties(Appendable out, String pad) throws IOException {
        out.append('\n').append(pad).append("\t,type:\"form\",mode:").append(Integer.toString(this.mode));
        boolean nc = false;
        StringBuilder dsmaps = new StringBuilder();
        StringBuilder aptods = new StringBuilder();
        for (IntegerIntegerMap.Cursor c : this.dsmap) {
            if (nc) {
                dsmaps.append(',');
            } else {
                aptods.append("\n\t\t").append(pad).append("datamodel._datasources[").append(c.value).append(']');
            }
            dsmaps.append("\n\t\t").append(pad).append(c.key).append(":datamodel._datasources[").append(c.value).append(']');
            nc = true;
        }
        StringBuilder dfmaps = new StringBuilder();
        nc = false;
        for (FieldMapEntry e : this.fmap) {
            if (nc) {
                dfmaps.append(',');
            }
            dfmaps.append("\n\t\t").append(pad).append("{ds:").append(e.dsid).append(",sf:").append(JSON.toString(e.field)).append(",target:").append("datamodel._datasources[").append(e.dtid).append("]._fbyid[").append(e.tfield).append("]}");
            nc = true;
        }
        if (dsmaps.length() > 0) {
            out.append('\n').append(pad).append("\t,dsmappings:{").append(dsmaps).append('\n').append(pad).append("\t}");
        }
        if (dfmaps.length() > 0) {
            out.append('\n').append(pad).append("\t,dfmappings:[").append(dfmaps).append('\n').append(pad).append("\t]");
        }
        if (aptods.length() > 0) {
            out.append('\n').append(pad).append("\t,appendtods:[").append(aptods).append('\n').append(pad).append("\t]");
        }
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        super.appendUsedDirectoriesTo(out);
        if (!this.dsmap.empty()) {
            WebForm form = WebForm.load(MtdEngine.getValidNode(this.node.id).getRealNode());
            DatasourceUsage.Scanner scanner = form.scan();
            for (IntegerIntegerMap.Cursor c : this.dsmap) {
                DatasourceUsage.Scanner.Fields ds = scanner.datasources.get(c.key);
                if (ds == null) continue;
                out.append(c.value, ds.fields);
            }
        }
    }

    private static class FieldMapEntry {
        static final int TAG_SS_FIELD_MAP_SOURCE_DATASOURCE = 1;
        static final int TAG_SS_FIELD_MAP_SOURCE_FIELD = 2;
        static final int TAG_SS_FIELD_MAP_TARGET_DATASOURCE = 3;
        static final int TAG_SS_FIELD_MAP_TARGET_FIELD = 4;
        final int dsid;
        final int[] field;
        final int dtid;
        final int tfield;

        FieldMapEntry(TaggedReader reader) throws IOException {
            int _dsid = 0;
            int[] _field = null;
            int _dtid = 0;
            int _tfield = 0;
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        _dsid = reader.getInt();
                        break;
                    }
                    case 2: {
                        _field = LittleEndian.toIntArray(reader.getRaw());
                        break;
                    }
                    case 3: {
                        _dtid = reader.getInt();
                        break;
                    }
                    case 4: {
                        _tfield = reader.getInt();
                    }
                }
            }
            this.dsid = _dsid;
            this.field = _field;
            this.dtid = _dtid;
            this.tfield = _tfield;
        }
    }
}

