/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.reports.document.DocFont;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Font;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;

public class PageNumbers {
    public boolean enabled = false;
    public int location = 0;
    public int align = 0;
    public boolean fromFirstPage = true;
    public double margin = 10.0;
    public final Font font = new Font();
    public String caption = "";
    private DocFont docFont = null;
    public boolean useBlackAndWhite = false;
    public int enumSection = -1;

    public PageNumbers(Scriptable parentScope) {
    }

    public void prepareStore(Document document) {
        if (this.enabled) {
            this.docFont = document.getDocFont(this.font);
        }
        this.useBlackAndWhite = document.getUseBlackAndWhite();
    }

    public void assign(PageNumbers pn) {
        this.enabled = pn.enabled;
        this.location = pn.location;
        this.align = pn.align;
        this.fromFirstPage = pn.fromFirstPage;
        this.margin = pn.margin;
        this.font.assign(pn.font);
        this.caption = pn.caption;
        this.useBlackAndWhite = pn.useBlackAndWhite;
        this.enumSection = pn.enumSection;
    }

    public void load(byte[] content) throws IOException {
        TaggedReader reader = new TaggedReader(content);
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.enabled = reader.getBoolean();
                    break;
                }
                case 2: {
                    this.location = reader.getInt();
                    break;
                }
                case 3: {
                    this.align = reader.getInt();
                    break;
                }
                case 4: {
                    this.fromFirstPage = reader.getBoolean();
                    break;
                }
                case 5: {
                    this.margin = reader.getDouble();
                    break;
                }
                case 6: {
                    this.font.load(reader.getStreamReader());
                    break;
                }
                case 7: {
                    this.caption = reader.getString();
                    break;
                }
                case 8: {
                    this.enumSection = reader.getInt();
                }
            }
        }
    }

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.enabled = in.getBoolean();
                    break;
                }
                case 2: {
                    this.location = in.getInt();
                    break;
                }
                case 3: {
                    this.align = in.getInt();
                    break;
                }
                case 4: {
                    this.fromFirstPage = in.getBoolean();
                    break;
                }
                case 5: {
                    this.margin = in.getDouble();
                    break;
                }
                case 6: {
                    TaggedReader reader = in.getSubStreamReader();
                    Font f = this.getFont();
                    f.load(reader);
                    this.setFont(f);
                    break;
                }
                case 7: {
                    this.caption = in.getString();
                    break;
                }
                case 8: {
                    this.enumSection = in.getInt();
                }
            }
        }
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Font getFont() {
        Font someFont = this.font;
        if (this.docFont != null) {
            someFont = this.docFont;
        }
        if (this.useBlackAndWhite) {
            someFont.setColor(0);
        }
        return someFont;
    }

    public void setFont(Font font) {
        this.font.assign(font);
    }

    public boolean getFromFirstPage() {
        return this.fromFirstPage;
    }

    public void setFromFirstPage(boolean fromFirstPage) {
        this.fromFirstPage = fromFirstPage;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public void stroreAs(int tag, TaggedWriter out) throws IOException {
        if (!this.enabled) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        writer.putBool(1, this.enabled);
        writer.putInt32(2, this.location);
        writer.putInt32(3, this.align);
        writer.putBool(4, this.fromFirstPage);
        writer.putDouble(5, this.margin);
        writer.putInt32(6, this.docFont.id());
        if (!Strings.isVoid(this.caption)) {
            writer.putString(7, this.caption);
        }
        if (this.enumSection >= 0) {
            writer.putInt32(8, this.enumSection);
        }
        writer.flush();
        if (stream.size() != 0) {
            out.putRaw(tag, stream.internalBuffer(), stream.size());
        }
    }
}

