/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.Task;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatManager;
import inform.agent.web.data.Datamodel;
import inform.agent.web.expr.WebExpression;
import inform.agent.web.reports.controls.ReportColumn;
import inform.agent.web.reports.controls.ReportControlFactory;
import inform.agent.web.reports.controls.ReportLabel;
import inform.agent.web.reports.controls.ReportRow;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocColumns;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.CellIndent;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.KeySet;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.VerticalAlign;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.mozilla.javascript.Scriptable;

public class ReportCell
extends WebControlContainer<WebControl> {
    private static final int TAG_WEB_TABLE_CELL_COLUMN = 40;
    private static final int TAG_WEB_TABLE_CELL_COLSPAN = 41;
    private static final int TAG_WEB_TABLE_CELL_ROWSPAN = 42;
    private static final int TAG_WEB_TABLE_CELL_FORMAT = 43;
    private static final int TAG_WEB_TABLE_CELL_FORMAT_OPTIONS = 44;
    private static final int TAG_WEB_TABLE_CELL_DATA_TYPE = 45;
    private static final int TAG_WEB_TABLE_CELL_MARGINS = 46;
    private static final int TAG_WEB_TABLE_CELL_INDENT = 47;
    private static final int TAG_WEB_TABLE_CELL_SUPPESSION = 48;
    private static final int TAG_WEB_TABLE_CELL_TEXT = 49;
    private static final int TAG_REPORT_CELL_DATASOURCE_ID = 81;
    private static final int TAG_REPORT_CELL_FIELD_ID = 82;
    private static final int TAG_REPORT_CELL_KEY = 83;
    private static final int TAG_REPORT_CELL_SUMMARY = 84;
    private static final int TAG_REPORT_CELL_EXPRESSION = 85;
    private static final int TAG_WEB_REP_IN_ONE_LINE = 86;
    final ReportRow row;
    private final Borders borders;
    private ReportColumn column = null;
    private String text = null;
    private KeySet downMergeKey = null;
    private KeySet rightMergeKey = null;
    int colSpan = 1;
    int rowSpan = 1;
    int columnIndex = -1;
    private int datasourceId = 0;
    private int[] fieldIdPath = null;
    private Dataset datasource = null;
    private DatasetField field = null;
    private WebExpression expression = null;
    private Format format = null;
    private int formatId = 0;
    private byte[] formatOptions = null;
    private DataType dataType = null;
    final TableMargins margins;
    private CellIndent indent = null;
    private String onGetData = null;
    private HorizontalAlign hAlign = HorizontalAlign.DEFAULT;
    private VerticalAlign vAlign = VerticalAlign.DEFAULT;
    private int suppress = 1;
    private int summaryFunction = 0;
    private boolean inOneLine = false;
    private String inOneLineSeparator = ",";
    private int inOneLineDatasourceId = 0;
    private Dataset inOneLineDatasource = null;
    int docIndex = -1;
    DocCell gdCell = null;
    private static final int KEY_TYPE_MERGE_DOWN = 0;
    private static final int KEY_TYPE_MERGE_RIGHT = 1;

    public ReportCell(Task task, ReportRow row, ComponentHeader header) {
        super(task, null, header);
        this.borders = new Borders(null);
        this.margins = new TableMargins(null);
        this.row = row;
    }

    public ReportCell(Task task, ReportRow row, int id, String name) {
        super(task, null, id, name);
        this.borders = new Borders(null);
        this.margins = new TableMargins(null);
        this.row = row;
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 11: {
                this.borders.load(in.getSubStreamReader());
                break;
            }
            case 40: {
                this.columnIndex = in.getInt();
                break;
            }
            case 41: {
                this.colSpan = in.getInt();
                break;
            }
            case 42: {
                this.rowSpan = in.getInt();
                break;
            }
            case 4: {
                this.hAlign = HorizontalAlign.create(in.getInt());
                break;
            }
            case 5: {
                this.vAlign = VerticalAlign.create(in.getInt());
                break;
            }
            case 43: {
                this.formatId = in.getInt();
                break;
            }
            case 44: {
                this.formatOptions = in.getRaw();
                break;
            }
            case 45: {
                this.dataType = DataType.getDataTypeById(in.getInt());
                break;
            }
            case 81: {
                this.datasourceId = in.getInt();
                break;
            }
            case 82: {
                if (in.getCurrentTagSize() == 0) break;
                this.fieldIdPath = LittleEndian.toIntArray(in.getRaw());
                break;
            }
            case 46: {
                this.margins.load(in.getSubStreamReader());
                break;
            }
            case 83: {
                int mergeType = in.getInt();
                KeySet set = null;
                switch (mergeType) {
                    case 0: {
                        set = this.downMergeKey = new KeySet(this.task, null);
                        break;
                    }
                    case 1: {
                        set = this.rightMergeKey = new KeySet(this.task, null);
                    }
                }
                if (set == null) break;
                set.load(in.getSubStreamReader());
                break;
            }
            case 47: {
                this.indent = new CellIndent();
                this.indent.load(in.getSubStreamReader());
                break;
            }
            case 12: {
                this.onGetData = in.getAnsi();
                break;
            }
            case 48: {
                this.suppress = in.getInt();
                break;
            }
            case 49: {
                this.text = in.getString();
                break;
            }
            case 84: {
                TaggedReader stream = in.getSubStreamReader();
                while (stream.next()) {
                    switch (stream.getCurrentTag()) {
                        case 1: {
                            this.summaryFunction = stream.getInt();
                        }
                    }
                }
                break;
            }
            case 86: {
                this.inOneLine = true;
                TaggedReader stream = in.getStreamReader();
                while (stream.next()) {
                    switch (stream.getCurrentTag()) {
                        case 1: {
                            this.inOneLineSeparator = stream.getString();
                            break;
                        }
                        case 2: {
                            this.inOneLineDatasourceId = stream.getInt();
                        }
                    }
                }
                break;
            }
            case 85: {
                this.expression = new WebExpression(null, this.task);
                this.expression.load(in.getStreamReader());
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        this.datasource = null;
        this.inOneLineDatasource = null;
        this.field = null;
        this.column = this.row.table.columns.get(this.columnIndex);
        if (this.expression != null) {
            this.expression.afterLoad();
        }
        if (this.datasourceId != 0 && this.fieldIdPath != null) {
            this.datasource = this.task.getComponents().findDataset(this.datasourceId);
            if (this.datasource != null) {
                this.field = this.datasource.findFieldPath(this.fieldIdPath);
            }
        }
        if (this.inOneLineDatasourceId != 0) {
            this.inOneLineDatasource = this.task.getComponents().findDataset(this.inOneLineDatasourceId);
        }
        if (this.inOneLineDatasource == null) {
            this.inOneLineDatasource = this.datasource;
        }
        if (this.field != null) {
            this.dataType = this.field.getDataType();
        }
        if (this.dataType == null) {
            this.dataType = DataType.STRING;
        }
        if (this.downMergeKey != null) {
            this.downMergeKey.afterLoad();
        }
        if (this.rightMergeKey != null) {
            this.rightMergeKey.afterLoad();
        }
        this.format = FormatManager.createFormat(this.formatId, this.dataType, this.formatOptions);
        if (this.indent != null) {
            this.indent.afterLoad(this.task);
        }
        super.afterLoad();
    }

    @Override
    protected WebControl createElementControl(ComponentHeader header) throws IOException, TaggedReaderException, InformException {
        return ReportControlFactory.createControl(this.task, null, header);
    }

    @Override
    public void print(Writer out) throws IOException {
        out.append("<td>");
        for (WebControl c : this.controls) {
            c.print(out);
        }
        out.append("</td>");
    }

    @Override
    public String getClassName() {
        return "ReportCell";
    }

    @Override
    public boolean isSubControl() {
        return true;
    }

    @Override
    public void setupDatamodel(Datamodel datamodel) {
        super.setupDatamodel(datamodel);
        if (this.expression != null) {
            this.expression.setupDatamodel(datamodel);
        }
        if (this.field != null) {
            datamodel.add(this.datasource);
        }
        if (this.downMergeKey != null) {
            this.downMergeKey.setupDatamodel(datamodel);
        }
        if (this.rightMergeKey != null) {
            this.rightMergeKey.setupDatamodel(datamodel);
        }
        if (this.indent != null) {
            this.indent.setupDatamodel(datamodel);
        }
    }

    @Override
    public void beforeGenerate() {
        this.hasBindedData = false;
        for (WebControl control : this.controls) {
            control.beforeGenerate();
            if (!control.hasBindedData) continue;
            this.hasBindedData = true;
        }
        if (this.expression != null && this.expression.hasBindedData()) {
            this.hasBindedData = true;
        }
        if (this.field != null) {
            this.hasBindedData = true;
        }
    }

    void beginGenerate(Document document, DocTable table) {
        if (table != null) {
            DocColumns columns = table.getColumns();
            this.docIndex = columns.indexOf(this.column);
        } else {
            this.docIndex = -1;
        }
    }

    public void updateCellValue(Document document, DocRow row) throws Exception {
        ArrayList<DocCell> cells;
        DocCell cell = null;
        if (row != null && (cell = (cells = row.getCells()).get(this.docIndex)) == null) {
            return;
        }
        this.updateCellValue(document, row, cell);
    }

    @Override
    public int getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(int color) {
    }

    @Override
    public Font getFont() {
        return super.getFont();
    }

    public boolean getIsDataSelected() throws Exception {
        return this.column.isVeerDataSelected();
    }

    public void updateCellValue(Document document, DocRow row, DocCell cell) throws Exception {
    }

    @Override
    public boolean isGenerated() {
        return this.column != null && this.column.isGenerated();
    }

    public void generate(Document document, DocRow row) throws Exception {
        Object cell = null;
    }

    void endGenerate(Document document, DocTable table) {
        this.docIndex = -1;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public HorizontalAlign horizontalAlign() {
        return this.hAlign;
    }

    public VerticalAlign verticalAlign() {
        return this.vAlign;
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) throws InformException {
        assert (scope instanceof ReportRow);
        return this.createClone(task, (ReportRow)scope);
    }

    public ReportCell createClone(Task task, ReportRow row) throws InformException {
        ReportCell cell = new ReportCell(task, row, task.generateId(), ReportCell.cloneName(row, this.getName()));
        return cell;
    }

    public void addText(String text) {
        ReportLabel label = new ReportLabel(this.task, null, this.task.generateId(), null);
        label.setText(text);
        this.controls.add(label);
    }

    public int getDataType() {
        if (this.dataType == null) {
            return DataType.STRING.toInt();
        }
        return this.dataType.toInt();
    }

    public void setDataType(int dataType) throws InformException {
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) throws InformException {
    }

    public int getAlign() {
        if (this.hAlign == null) {
            return HorizontalAlign.LEFT.value();
        }
        return this.hAlign.value();
    }

    public void setAlign(int align) {
    }

    public int getVertAlign() {
        if (this.vAlign == null) {
            return VerticalAlign.DEFAULT.value();
        }
        return this.vAlign.value();
    }

    public void setVertAlign(int align) {
    }

    public Borders internalBorders() {
        return this.borders;
    }

    public Borders getBorders() {
        return this.borders;
    }

    public TableMargins getMargins() {
        return this.margins;
    }

    public ReportColumn getColumn() {
        return this.column;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Object getField() {
        return this.field;
    }

    public void setField(DatasourceField field) throws InformException {
        if (this.gdCell != null) {
            return;
        }
        if (this.field == field) {
            return;
        }
        this.field = field;
        if (field != null) {
            if (field.getDescriptor().getType() != this.dataType) {
                this.dataType = field.getDescriptor().getType();
                this.setFormat(this.format);
            }
        } else {
            this.dataType = DataType.STRING;
            this.setFormat(this.format);
        }
    }

    public KeySet getDownMergeKey() {
        if (this.downMergeKey == null) {
            this.downMergeKey = new KeySet(this.task, null);
        }
        return this.downMergeKey;
    }

    public KeySet getRightMergeKey() {
        if (this.rightMergeKey == null) {
            this.rightMergeKey = new KeySet(this.task, null);
        }
        return this.rightMergeKey;
    }

    public Object getValue() {
        if (this.gdCell == null) {
            return Scriptable.NOT_FOUND;
        }
        return this.gdCell.getCellValue().getValue();
    }

    public void setValue(Object v) {
    }

    public String getOnGetData() {
        return this.onGetData;
    }

    public void setOnGetData(String onGetData) {
        this.onGetData = onGetData;
    }

    private class InOneLine {
        public static final int TAG_WEB_REP_IOL_SEPARATOR = 1;
        public static final int TAG_WEB_REP_IOL_DATASOURCE = 2;

        private InOneLine() {
        }
    }
}

