/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.Task;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatManager;
import inform.agent.web.data.Datamodel;
import inform.agent.web.expr.WebExpression;
import inform.agent.web.reports.controls.Control;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.Container;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.TypedValue;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Scriptable;

public class ReportField
extends WebControl
implements Control {
    private static final int TAG_WEB_LABEL_TEXT = 40;
    private static final int TAG_WEB_LABEL_DATASOURCE = 41;
    private static final int TAG_WEB_LABEL_FIELD = 42;
    private static final int TAG_WEB_LABEL_FORMAT = 43;
    private static final int TAG_WEB_LABEL_FORMAT_OPTION = 44;
    private static final int TAG_WEB_LABEL_DATA_TYPE = 45;
    private static final int TAG_WEB_LABEL_EXPRESSION = 46;
    private String text;
    private int datasourceId = 0;
    private int[] fieldIdPath = null;
    private Dataset datasource = null;
    private DatasetField field = null;
    private WebExpression expression = null;
    private Format format = null;
    private int formatId = 0;
    private byte[] formatOptions = null;
    private DataType dataType = null;

    @Override
    public void beforeGenerate() {
        this.hasBindedData = this.expression != null && this.expression.hasBindedData() ? true : this.field != null;
    }

    @Override
    public void setupDatamodel(Datamodel datamodel) {
        if (this.expression != null) {
            this.expression.setupDatamodel(datamodel);
        } else if (this.field != null) {
            datamodel.add(this.datasource);
        }
    }

    @Override
    public boolean isSubControl() {
        return true;
    }

    @Override
    public void generate(Document document, Container container) throws Exception {
        if (container != null && this.getVisible()) {
            DocText documentText = container.addText();
            documentText.setVisible(this.isVisible());
            int color = this.getColor();
            Font font = this.getFont();
            if (document.getUseBlackAndWhite()) {
                color = 0x1FFFFFFF;
                font.setColor(0);
            }
            documentText.setFont(font);
            documentText.setColor(color);
            documentText.setWidth(this.getWidth());
            if (this.expression != null) {
                if (this.format == null) {
                    this.format = FormatManager.createFormat(0, this.dataType, null);
                }
                this.expression.select();
                TypedValue value = this.expression.evaluate();
                if (value != null) {
                    documentText.setText(this.format.format(value.getValue()));
                }
            } else if (this.field == null) {
                documentText.setText(this.text);
            } else {
                if (this.format == null) {
                    this.format = FormatManager.createFormat(0, this.dataType, null);
                }
                if (!this.datasource.isSelected()) {
                    this.datasource.executeSelect();
                }
                if (!this.datasource.isCurrentRowAvailable() && !this.datasource.next()) {
                    return;
                }
                if (this.datasourceId != -1) {
                    documentText.setText(this.format.format(this.field.getAvailableValue()));
                } else {
                    Parameter p = (Parameter)this.field;
                    if (p.getIsIgnored()) {
                        documentText.setText("\u0412\u0441\u0435");
                    } else if (p.getValueCount() == 1) {
                        documentText.setText(this.format.format(p.getAvailableValue()));
                    } else {
                        StringBuilder buff = new StringBuilder();
                        for (int i = 0; i < p.getValueCount(); ++i) {
                            if (i > 0) {
                                buff.append(",");
                            }
                            buff.append(this.format.format(p.getAsStringByIndex(i)));
                        }
                        documentText.setText(buff.toString());
                    }
                }
            }
        }
    }

    public ReportField(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
    }

    public ReportField(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) {
        assert (scope instanceof WebControlContainer);
        return this.createClone(task, (WebControlContainer)scope);
    }

    public WebControl createClone(Task task, WebControlContainer container) {
        ReportField label = new ReportField(task, null, task.generateId(), ReportField.cloneName(container, this.getName()));
        label.assignProps(this);
        label.text = this.text;
        return label;
    }

    @Override
    protected void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 40: {
                this.text = in.getAnsi();
                break;
            }
            case 41: {
                this.datasourceId = in.getInt();
                break;
            }
            case 42: {
                this.fieldIdPath = LittleEndian.toIntArray(in.getRaw());
                break;
            }
            case 43: {
                this.formatId = in.getInt();
                break;
            }
            case 44: {
                this.formatOptions = in.getRaw();
                break;
            }
            case 45: {
                this.dataType = DataType.getDataTypeById(in.getInt());
                break;
            }
            case 46: {
                this.expression = new WebExpression(null, this.task);
                this.expression.load(in.getStreamReader());
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        this.datasource = null;
        this.field = null;
        if (this.expression != null) {
            this.expression.afterLoad();
        } else if (this.datasourceId != 0 && this.fieldIdPath != null) {
            this.datasource = this.task.getComponents().findDataset(this.datasourceId);
            if (this.datasource != null) {
                this.field = this.datasource.findFieldPath(this.fieldIdPath);
            }
        }
        if (this.field != null) {
            this.dataType = this.field.getDataType();
        }
        if (this.dataType == null) {
            this.dataType = DataType.STRING;
        }
        this.format = FormatManager.createFormat(this.formatId, this.dataType, this.formatOptions);
    }

    @Override
    public void print(Writer out) throws IOException {
        out.append(this.text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    @Override
    public String getClassName() {
        return "Field";
    }
}

