/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.MtdEngine;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Task;
import inform.agent.web.IconServlet;
import inform.agent.web.data.Datamodel;
import inform.agent.web.reports.controls.Control;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.Container;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.ImageInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Scriptable;

public class ReportImage
extends WebControl
implements Control {
    private static final int TAG_WEB_IMAGE_NODEID = 40;
    private static final int TAG_WEB_IMAGE_INDEX = 41;
    private static final int TAG_WEB_IMAGE_SIZE = 42;
    private static final int TAG_WEB_IMAGE_DATASOURCE = 43;
    private static final int TAG_WEB_IMAGE_FIELD = 44;
    private static final int TAG_WEB_IMAGE_PROPORTIONAL = 47;
    private int datasourceId = 0;
    private int[] fieldIdPath = null;
    private Dataset datasource = null;
    private DatasetField field = null;
    private boolean autoSize = true;
    private int imageSize = 16;
    private int imageId = 0;
    private double nodeId = 0.0;

    @Override
    public void beforeGenerate() {
        this.hasBindedData = this.field != null;
    }

    @Override
    public void setupDatamodel(Datamodel datamodel) {
        if (this.field != null) {
            datamodel.add(this.datasource);
        }
    }

    @Override
    public boolean isSubControl() {
        return true;
    }

    @Override
    public void generate(Document document, Container container) throws Exception {
        if (container != null && this.getVisible() && this.isGenerated()) {
            IconServlet.CacheEntry.Bytes[] images;
            DocImage docImage = container.addImage();
            docImage.setVisible(this.isVisible());
            if (!this.autoSize) {
                docImage.setWidth(this.getWidth());
                docImage.setHeight(this.getHeight());
            }
            byte[] imageContent = null;
            if (this.field != null) {
                if (!this.datasource.isSelected()) {
                    this.datasource.executeSelect();
                }
                if (!this.datasource.isCurrentRowAvailable() && !this.datasource.next()) {
                    return;
                }
                if (!this.field.getIsNull()) {
                    imageContent = ValueCaster.toBytes(this.field.getAvailableValue());
                }
            } else if (this.nodeId != 0.0) {
                imageContent = MtdEngine.getNodeContent(this.nodeId);
            } else if (this.imageId >= 0 && (images = IconServlet.image(this.imageId)) != null && images.length > 0) {
                int i;
                for (i = 1; i < images.length && images[i].size >= this.imageSize; ++i) {
                }
                imageContent = images[--i].data;
            }
            docImage.setImageContent(imageContent);
            if (this.autoSize && imageContent != null) {
                ByteArrayInputStream bs = new ByteArrayInputStream(imageContent);
                ImageInfo ii = new ImageInfo();
                ii.setInput(bs);
                if (!ii.check()) {
                    throw new Exception("Unsupported image format");
                }
                double width_mm = (double)ii.getPhysicalWidthInch() * 25.4;
                double height_mm = (double)ii.getPhysicalHeightInch() * 25.4;
                if (width_mm >= 0.0 && height_mm >= 0.0) {
                    docImage.setWidth(width_mm);
                    docImage.setHeight(height_mm);
                } else {
                    docImage.setWidth(25.4 * (double)ii.getWidth() / 96.0);
                    docImage.setHeight(25.4 * (double)ii.getHeight() / 96.0);
                }
            }
        }
    }

    public ReportImage(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
    }

    public ReportImage(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) {
        assert (scope instanceof WebControlContainer);
        return this.createClone(task, (WebControlContainer)scope);
    }

    public WebControl createClone(Task task, WebControlContainer container) {
        ReportImage image = new ReportImage(task, null, task.generateId(), ReportImage.cloneName(container, this.getName()));
        image.assignProps(this);
        image.datasourceId = this.datasourceId;
        image.fieldIdPath = this.fieldIdPath;
        image.autoSize = this.autoSize;
        image.imageSize = this.imageSize;
        image.imageId = this.imageId;
        image.nodeId = this.nodeId;
        return image;
    }

    @Override
    protected void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        block0 : switch (tag) {
            case 40: {
                in.skip();
                this.nodeId = in.getDouble(151);
                break;
            }
            case 43: {
                this.datasourceId = in.getInt();
                break;
            }
            case 44: {
                this.fieldIdPath = LittleEndian.toIntArray(in.getRaw());
                break;
            }
            case 2: {
                this.autoSize = false;
                this.width = in.getDouble();
                break;
            }
            case 3: {
                this.autoSize = false;
                this.height = in.getDouble();
                break;
            }
            case 41: {
                this.imageId = in.getInt();
                break;
            }
            case 42: {
                switch (in.getInt()) {
                    case 0: {
                        this.imageSize = 16;
                        break block0;
                    }
                    case 1: {
                        this.imageSize = 24;
                        break block0;
                    }
                    case 2: {
                        this.imageSize = 32;
                        break block0;
                    }
                }
                this.imageSize = 16;
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        this.datasource = null;
        this.field = null;
        if (this.datasourceId != 0 && this.fieldIdPath != null) {
            this.datasource = this.task.getComponents().findDataset(this.datasourceId);
            if (this.datasource != null) {
                this.field = this.datasource.findFieldPath(this.fieldIdPath);
            }
        }
    }

    @Override
    public void print(Writer out) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public String getClassName() {
        return "Image";
    }
}

