/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.utils.HorizontalAlign;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.javascript.Scriptable;

public abstract class WebControlContainer<T extends WebControl>
extends WebControl {
    public static final int TAG_WEB_CONTROL_ID = 1;
    public static final int TAG_WEB_CONTROL_TYPE = 2;
    public static final int TAG_WEB_CONTROL_OPTIONS = 3;
    protected final ArrayList<T> controls = new ArrayList();
    protected HorizontalAlign align = HorizontalAlign.DEFAULT;

    public WebControlContainer(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
    }

    protected WebControlContainer(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
    }

    protected abstract T createElementControl(ComponentHeader var1) throws IOException, InformException;

    @Override
    public void setupDatamodel(Datamodel datamodel) {
        super.setupDatamodel(datamodel);
        for (WebControl control : this.controls) {
            control.setupDatamodel(datamodel);
        }
    }

    public WebControl getByName(String name) {
        if (this.controls != null) {
            for (WebControl control : this.controls) {
                if (!name.equals(control.getName())) continue;
                return control;
            }
        }
        return null;
    }

    public T getByID(int id) {
        if (this.controls != null) {
            for (WebControl control : this.controls) {
                if (id != control.getId()) continue;
                return (T)control;
            }
        }
        return null;
    }

    boolean validIndex(int index) {
        return 0 <= index && index < this.controls.size();
    }

    @Override
    public Object get(String name, Scriptable start) {
        WebControl obj = this.getByName(name);
        return obj;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.validIndex(index)) {
            return this.controls.get(index);
        }
        return Scriptable.NOT_FOUND;
    }

    public int getLength() {
        return this.controls.size();
    }

    @Override
    public int size() {
        return this.controls.size();
    }

    protected void registerControl(WebControl control) {
        String name = control.getName();
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 1: {
                int id = in.getInt();
                int type = in.getInt(2);
                int options = in.getInt(3);
                ComponentHeader h = new ComponentHeader(id, options, type);
                T c = this.createElementControl(h);
                if (c == null) break;
                ((ServerSideComponent)c).load(in.getSubStreamReader());
                this.registerControl((WebControl)c);
                this.controls.add(c);
                break;
            }
            case 4: {
                this.align = HorizontalAlign.create(in.getInt());
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        for (WebControl control : this.controls) {
            control.afterLoad();
        }
    }

    @Override
    public void beforeGenerate() {
        for (WebControl control : this.controls) {
            if (!control.isGenerated()) continue;
            control.beforeGenerate();
        }
    }
}

