/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.BorderStyle;
import inform.agent.web.utils.Borders;
import java.io.IOException;

public class DocBorders {
    private static final int LEFT_MASK = 255;
    private static final int RIGHT_MASK = 65280;
    private static final int TOP_MASK = 0xFF0000;
    private static final int BOTTOM_MASK = -16777216;
    private static final int LEFT_STYLE_SHIFT = 0;
    private static final int LEFT_COLOR_SHIFT = 4;
    private static final int LEFT_SHIFT = 0;
    private static final int RIGHT_STYLE_SHIFT = 8;
    private static final int RIGHT_COLOR_SHIFT = 12;
    private static final int RIGHT_SHIFT = 8;
    private static final int TOP_STYLE_SHIFT = 16;
    private static final int TOP_COLOR_SHIFT = 20;
    private static final int TOP_SHIFT = 16;
    private static final int BOTTOM_STYLE_SHIFT = 24;
    private static final int BOTTOM_COLOR_SHIFT = 28;
    private static final int BOTTOM_SHIFT = 24;
    private static final int COLOR_SHIFT = 4;
    private static final int COLOR_MASK = 240;
    private static final int STYLE_MASK = 15;
    public static final int COLORS = 15;
    private static final int LEFT_STYLE_MASK = 15;
    private static final int LEFT_COLOR_MASK = 240;
    private static final int RIGHT_STYLE_MASK = 3840;
    private static final int RIGHT_COLOR_MASK = 61440;
    private static final int TOP_STYLE_MASK = 983040;
    private static final int TOP_COLOR_MASK = 0xF00000;
    private static final int BOTTOM_STYLE_MASK = 0xF000000;
    private static final int BOTTOM_COLOR_MASK = -268435456;

    private static int get(int b, int s) {
        return b >> s & 0xF;
    }

    private static int set(int b, int s, int m, int v) {
        return b & ~m | v << s & m;
    }

    private static int borderStyleTo(Document document, BorderStyle bs) {
        return document.colorToBorderColor(bs.getColor()) << 4 & 0xF0 | bs.getType() & 0xF;
    }

    public static int setLeft(int b, Document document, BorderStyle bs) {
        return DocBorders.set(b, 0, 255, DocBorders.borderStyleTo(document, bs));
    }

    public static int setLeft(int b, int bs) {
        return DocBorders.set(b, 0, 255, bs);
    }

    public static int setLeftStyle(int b, int bs) {
        return DocBorders.set(b, 0, 15, bs);
    }

    public static int setLeftColor(Document document, int b, int bs) {
        return DocBorders.set(b, 4, 240, document.colorToBorderColor(bs));
    }

    public static int setRight(int b, Document document, BorderStyle bs) {
        return DocBorders.set(b, 8, 65280, DocBorders.borderStyleTo(document, bs));
    }

    public static int setRightStyle(int b, int bs) {
        return DocBorders.set(b, 8, 3840, bs);
    }

    public static int setRightColor(Document document, int b, int bs) {
        return DocBorders.set(b, 12, 61440, document.colorToBorderColor(bs));
    }

    public static int setRight(int b, int bs) {
        return DocBorders.set(b, 8, 65280, bs);
    }

    public static int setTopStyle(int b, int bs) {
        return DocBorders.set(b, 16, 983040, bs);
    }

    public static int setTopColor(Document document, int b, int bs) {
        return DocBorders.set(b, 20, 0xF00000, document.colorToBorderColor(bs));
    }

    public static int setTop(int b, Document document, BorderStyle bs) {
        return DocBorders.set(b, 16, 0xFF0000, DocBorders.borderStyleTo(document, bs));
    }

    public static int setTop(int b, int bs) {
        return DocBorders.set(b, 16, 0xFF0000, bs);
    }

    public static int setBottomStyle(int b, int bs) {
        return DocBorders.set(b, 24, 0xF000000, bs);
    }

    public static int setBottomColor(Document document, int b, int bs) {
        return DocBorders.set(b, 28, -268435456, document.colorToBorderColor(bs));
    }

    public static int setBottom(int b, Document document, BorderStyle bs) {
        return DocBorders.set(b, 24, -16777216, DocBorders.borderStyleTo(document, bs));
    }

    public static int setBottom(int b, int bs) {
        return DocBorders.set(b, 24, -16777216, bs);
    }

    public static int left(int b) {
        return DocBorders.get(b, 0);
    }

    public static int right(int b) {
        return DocBorders.get(b, 8);
    }

    public static int top(int b) {
        return DocBorders.get(b, 16);
    }

    public static int bottom(int b) {
        return DocBorders.get(b, 24);
    }

    public static int leftColor(Document document, int b) {
        return document.borderColorToColor(DocBorders.get(b, 4));
    }

    public static int leftStyle(int b) {
        return DocBorders.get(b, 0);
    }

    public static int rightColor(Document document, int b) {
        return document.borderColorToColor(DocBorders.get(b, 12));
    }

    public static int rightStyle(int b) {
        return DocBorders.get(b, 8);
    }

    public static int topColor(Document document, int b) {
        return document.borderColorToColor(DocBorders.get(b, 20));
    }

    public static int topStyle(int b) {
        return DocBorders.get(b, 16);
    }

    public static int bottomColor(Document document, int b) {
        return document.borderColorToColor(DocBorders.get(b, 28));
    }

    public static int bottomStyle(int b) {
        return DocBorders.get(b, 24);
    }

    public static int assign(Document document, Borders d) {
        int b = 0;
        b = DocBorders.setTop(b, document, d.getTopBorder());
        b = DocBorders.setBottom(b, document, d.getBottomBorder());
        b = DocBorders.setLeft(b, document, d.getLeftBorder());
        b = DocBorders.setRight(b, document, d.getRightBorder());
        return b;
    }

    public static void store(Document document, int b, TaggedWriter out) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(s);
        w.putInt32(1, DocBorders.leftStyle(b));
        w.putInt32(2, DocBorders.leftColor(document, b));
        w.flush();
        out.putRaw(1, s.internalBuffer(), s.size());
        s.reset();
        w.reset(s);
        w.putInt32(1, DocBorders.rightStyle(b));
        w.putInt32(2, DocBorders.rightColor(document, b));
        w.flush();
        out.putRaw(2, s.internalBuffer(), s.size());
        s.reset();
        w.reset(s);
        w.putInt32(1, DocBorders.topStyle(b));
        w.putInt32(2, DocBorders.topColor(document, b));
        w.flush();
        out.putRaw(3, s.internalBuffer(), s.size());
        s.reset();
        w.reset(s);
        w.putInt32(1, DocBorders.bottomStyle(b));
        w.putInt32(2, DocBorders.bottomColor(document, b));
        w.flush();
        out.putRaw(4, s.internalBuffer(), s.size());
        out.flush();
    }

    public static void storeAs(int b, Document document, int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        DocBorders.store(document, b, writer);
        out.putRaw(tag, stream);
    }
}

