/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.web.IconServlet;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.IDocumentElement;
import inform.agent.web.reports.document.Type;
import inform.agent.web.utils.ImageInfo;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class DocImage
extends DocComponent {
    public static final int IMAGE_TYPE_UNKNOWN = 0;
    public static final int IMAGE_TYPE_BMP = 1;
    public static final int IMAGE_TYPE_ICON = 2;
    public static final int IMAGE_TYPE_WMF = 3;
    public static final int IMAGE_TYPE_EMF = 4;
    public static final int IMAGE_TYPE_GIF = 5;
    public static final int IMAGE_TYPE_JPEG = 6;
    public static final int IMAGE_TYPE_PNG = 7;
    private final IDocumentElement parent;
    private byte[] imageContent;
    private boolean autoSize = true;
    private int imageSize = 16;
    private int imageId = 0;
    private double nodeId = 0.0;
    private boolean proportional = false;
    private int imageType = 0;
    private String urlLink = "";
    private boolean useMultiCell = false;

    public DocImage(IDocumentElement parent) {
        super(parent.getDocument());
        this.parent = parent;
        this.imageContent = null;
    }

    @Override
    public Type getType() {
        return Type.IMAGE;
    }

    @Override
    public IDocumentElement getParent() {
        return this.parent;
    }

    public byte[] getImageContent() {
        return this.imageContent;
    }

    public void setImageContent(byte[] imageContent) {
        this.imageContent = imageContent;
    }

    public int getImageType() {
        return this.imageType;
    }

    public String getUrlLink() {
        return this.urlLink;
    }

    public boolean getUseMultiCell() {
        return this.useMultiCell;
    }

    @Override
    public void beforeLoad() throws InformException, IOException {
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        block0 : switch (tag) {
            case 2: {
                this.width = in.getDouble();
                this.autoSize = false;
                break;
            }
            case 3: {
                this.height = in.getDouble();
                this.autoSize = false;
                break;
            }
            case 47: {
                this.proportional = true;
                break;
            }
            case 40: {
                in.skip();
                this.nodeId = in.getDouble(151);
                break;
            }
            case 41: {
                this.imageId = in.getInt();
                break;
            }
            case 48: {
                this.imageType = in.getInt();
                break;
            }
            case 49: {
                this.urlLink = in.getAnsi();
                break;
            }
            case 42: {
                switch (in.getInt()) {
                    case 0: {
                        this.imageSize = 16;
                        break block0;
                    }
                    case 1: {
                        this.imageSize = 24;
                        break block0;
                    }
                    case 2: {
                        this.imageSize = 32;
                        break block0;
                    }
                }
                this.imageSize = 16;
                break;
            }
            case 43: {
                this.imageContent = in.getRaw();
                break;
            }
            case 50: {
                this.useMultiCell = true;
            }
        }
    }

    private void updateIconContent(byte[] data, int size) throws IOException {
        if (size >= this.imageSize) {
            return;
        }
        int delta = Math.round(((float)this.imageSize - (float)size) / 2.0f);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage src = ImageIO.read(in);
        BufferedImage dst = new BufferedImage(this.imageSize, this.imageSize, 2);
        Graphics2D g2 = dst.createGraphics();
        g2.drawImage((Image)src, delta, delta, null);
        g2.dispose();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)dst, "png", out);
        this.imageContent = out.toByteArray();
    }

    @Override
    public void afterLoad() throws InformException, IOException {
        IconServlet.CacheEntry.Bytes[] images;
        if (this.nodeId != 0.0) {
            this.imageContent = MtdEngine.getNodeContent(this.nodeId);
        } else if (this.imageId > 0 && (images = IconServlet.image(this.imageId)) != null && images.length > 0) {
            int i;
            for (i = 1; i < images.length && images[i].size >= this.imageSize; ++i) {
            }
            this.imageContent = images[--i].data;
            this.updateIconContent(images[i].data, images[i].size);
            this.imageType = 7;
        }
        if (this.imageType == 4 || this.imageType == 3) {
            return;
        }
        if ((this.autoSize || this.proportional) && this.imageContent != null) {
            ByteArrayInputStream bs = new ByteArrayInputStream(this.imageContent);
            ImageInfo ii = new ImageInfo();
            ii.setInput(bs);
            double width_org = this.width;
            double height_org = this.height;
            this.width = 0.0;
            this.height = 0.0;
            if (this.imageType == 0 || width_org == 0.0 && height_org == 0.0) {
                if (!ii.check()) {
                    throw new InformException("Unsupported image format");
                }
                switch (ii.getFormat()) {
                    case 3: {
                        this.imageType = 1;
                        break;
                    }
                    case 1: {
                        this.imageType = 5;
                        break;
                    }
                    case 0: {
                        this.imageType = 6;
                        break;
                    }
                    case 2: {
                        this.imageType = 7;
                    }
                }
                double width_mm = (double)ii.getPhysicalWidthInch() * 25.4;
                double height_mm = (double)ii.getPhysicalHeightInch() * 25.4;
                if (width_mm >= 0.0 && height_mm >= 0.0) {
                    this.width = width_mm;
                    this.height = height_mm;
                } else {
                    this.width = 25.4 * (double)ii.getWidth() / 96.0;
                    this.height = 25.4 * (double)ii.getHeight() / 96.0;
                }
            }
            if (this.proportional && this.width != 0.0 && width_org != 0.0) {
                this.height = this.height * width_org / this.width;
                this.width = width_org;
            }
            if (this.height == 0.0 || this.width == 0.0) {
                this.height = height_org;
                this.width = width_org;
            }
        }
    }
}

