/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.reports.document.Components;
import inform.agent.web.reports.document.Container;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.SectionElement;
import inform.agent.web.reports.document.Type;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.VerticalAlign;
import java.io.IOException;
import java.util.Collections;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class DocParagraph
extends SectionElement
implements Container {
    public static final int LINE_ALIGN_PAGE_WIDTH = 0;
    public static final int LINE_ALIGN_TABLE_WIDTH = 1;
    private final Components components = new Components();
    private HorizontalAlign align;
    private VerticalAlign vAlign;
    private double marginTop = -1.0;
    private double marginBottom = -1.0;
    private double marginLeft = -1.0;
    private double marginRight = -1.0;
    private final Borders borders = new Borders(null);
    private boolean isBegin;
    private int lineAlign = 0;
    private boolean wordWrap = false;

    public DocParagraph(DocSection section) {
        super(section);
    }

    public String getClassName() {
        return "Paragraph";
    }

    @Override
    public void prepareStore() {
        super.prepareStore();
        this.components.prepareStore();
    }

    @Override
    public void finalizeDocument() {
        super.finalizeDocument();
        this.components.cleanup();
    }

    @Override
    public void store(TaggedWriter out) throws InformException, IOException {
        if (!this.isVisible()) {
            return;
        }
        super.store(out);
        this.components.store(out, null);
    }

    @Override
    public void beforeLoad() throws InformException, IOException {
        super.beforeLoad();
        this.align(HorizontalAlign.DEFAULT);
        this.vAlign(VerticalAlign.DEFAULT);
        this.isBegin = false;
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 2: {
                this.borders.load(in.getStreamReader());
                break;
            }
            case 3: {
                this.align = HorizontalAlign.create(in.getInt());
                break;
            }
            case 41: {
                this.lineAlign = in.getInt();
                break;
            }
            case 4: {
                this.vAlign = VerticalAlign.create(in.getInt());
                break;
            }
            case 42: {
                this.wordWrap = true;
                break;
            }
            case 43: {
                this.height = in.getDouble();
                break;
            }
            case 40: {
                TaggedReader reader = in.getSubStreamReader();
                while (reader.next()) {
                    switch (reader.getCurrentTag()) {
                        case 3: {
                            this.marginTop = reader.getDouble();
                            break;
                        }
                        case 4: {
                            this.marginBottom = reader.getDouble();
                            break;
                        }
                        case 1: {
                            this.marginLeft = reader.getDouble();
                            break;
                        }
                        case 2: {
                            this.marginRight = reader.getDouble();
                        }
                    }
                }
                break;
            }
            case 39: {
                this.isBegin = true;
                break;
            }
            case 1: {
                if (!this.isBegin) break;
                Type type = Type.create(in.getInt());
                switch (type) {
                    case TEXT: {
                        DocText text = this.addText();
                        text.load(in.getStreamReader());
                        break;
                    }
                    case IMAGE: {
                        DocImage image = this.addImage();
                        image.load(in.getStreamReader());
                    }
                }
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    public int getLineAlign() {
        return this.lineAlign;
    }

    public void setBorders(Borders borders) {
        this.borders.assign(borders);
    }

    public Borders getBorders() {
        return this.borders;
    }

    @Override
    public Type getType() {
        return Type.PARAGRAPH;
    }

    @Override
    public DocText addText() {
        return (DocText)this.components.add(new DocText(this));
    }

    @Override
    public DocImage addImage() {
        return (DocImage)this.components.add(new DocImage(this));
    }

    public static Object appendText(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        DocParagraph p = (DocParagraph)((Object)thisObj);
        return p.components.addText(p.document, args);
    }

    public Iterable<DocComponent> components() {
        return Collections.unmodifiableCollection(this.components.elements);
    }

    public HorizontalAlign align() {
        return this.align;
    }

    public void align(HorizontalAlign align) {
        this.align = align;
    }

    public VerticalAlign vAlign() {
        return this.vAlign;
    }

    public void vAlign(VerticalAlign vAlign) {
        this.vAlign = vAlign;
    }

    public double marginTop() {
        return this.marginTop;
    }

    public double marginBottom() {
        return this.marginBottom;
    }

    public void marginTop(double marginTop) {
        this.marginTop = marginTop;
    }

    public void marginBottom(double marginBottom) {
        this.marginBottom = marginBottom;
    }

    public double marginLeft() {
        return this.marginLeft;
    }

    public void marginLeft(double marginLeft) {
        this.marginLeft = marginLeft;
    }

    public double marginRight() {
        return this.marginRight;
    }

    public void marginRight(double marginRight) {
        this.marginRight = marginRight;
    }

    public boolean getWordWrap() {
        return this.wordWrap;
    }
}

