/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.reports.controls.ReportColumn;
import inform.agent.web.reports.controls.ReportRow;
import inform.agent.web.reports.controls.ReportTable;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocColumn;
import inform.agent.web.reports.document.DocColumns;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.SectionElement;
import inform.agent.web.reports.document.Type;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.CellPositions;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.KeyValues;
import inform.agent.web.utils.RowKeyValues;
import inform.agent.web.utils.TableMargins;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class DocTable
extends SectionElement {
    private final ReportTable control;
    protected DocColumns columns = new DocColumns();
    final ArrayList<DocRow> rows = new ArrayList();
    private final Borders borders;
    private HorizontalAlign align = null;
    private double bottomMargin = 4.0;
    private TableMargins cellMargins = null;
    public int fixed_cols = 0;
    public boolean place_completely = false;
    public boolean transport_header = false;
    final HashMap<RowKeyValues, DocRow> gropedRows = new HashMap();
    private final RowKeyValues rowKeyValues = new RowKeyValues();
    private boolean isBegin;

    public DocTable(DocSection section, ReportTable control) {
        super(section);
        this.borders = new Borders(null);
        this.control = control;
        if (control != null) {
            for (ReportColumn column : control.getColumnList()) {
                this.columns.add(new DocColumn(this, column, column.getGrouped(), column.getVisible(), column.getColor(), column.getSuppressBlank()));
            }
        }
    }

    public DocTable(DocSection section) {
        this(section, null);
    }

    public DocRow addRow(ReportRow control, DocRow afterRow, int RowType, boolean AutoFilter) {
        if (afterRow != null) {
            return this.insertRow(afterRow, control, true, RowType, AutoFilter);
        }
        DocRow row = new DocRow(this, control, RowType, AutoFilter);
        row.docRowIndex = this.rows.size();
        row.height(control.getHeight());
        this.rows.add(row);
        return row;
    }

    public DocRow insertRow(DocRow atRow, ReportRow control, boolean after, int RowType, boolean AutoFilter) {
        DocRow row = new DocRow(this, control, RowType, AutoFilter);
        row.height(control.getHeight());
        int index = atRow.docRowIndex;
        if (after) {
            ++index;
        }
        this.rows.add(index, row);
        while (index < this.rows.size()) {
            this.rows.get((int)index).docRowIndex = index;
            ++index;
        }
        return row;
    }

    public DocColumns getColumns() {
        return this.columns;
    }

    public double getColGroupWidth(int colIdx, int colSpan) {
        double buff = 0.0;
        double maxColIndex = colIdx + colSpan - 1;
        if (colIdx < 0 || maxColIndex >= (double)this.columns.size()) {
            return buff;
        }
        int colIndex = colIdx;
        while ((double)colIndex <= maxColIndex) {
            buff += this.columns.get(colIndex).getWidth();
            ++colIndex;
        }
        return buff;
    }

    public void setColumns(DocColumns columns) {
        this.columns = columns;
    }

    public Borders effectiveBorders() {
        if (this.borders.isInherited() && this.control != null) {
            return this.control.getBorders();
        }
        return this.borders;
    }

    public DocRow getGroupRow(ReportRow row, KeyValues groupKey) {
        this.rowKeyValues.set(row, groupKey);
        return this.gropedRows.get(this.rowKeyValues);
    }

    private void hideColumn(int colIndex) {
    }

    private void calculateCellSpan(int colIndex, int rowIndex) {
    }

    private void calculateCellMergeKey(int colIndex, int rowIndex) throws InformException {
    }

    @Override
    public void calculate(CellPositions positions) throws InformException {
    }

    @Override
    public void prepareStore() {
        super.prepareStore();
        for (DocRow row : this.rows) {
            row.prepareStore();
        }
    }

    @Override
    public void finalizeDocument() {
        super.finalizeDocument();
        for (DocRow row : this.rows) {
            row.finalizeDocument();
        }
    }

    @Override
    public void store(TaggedWriter out) throws InformException, IOException {
        if (!this.isVisible()) {
            return;
        }
        super.store(out);
        Borders borders = this.effectiveBorders();
        borders.docStoreAs(2, out);
        if (this.align != null) {
            out.putInt32(3, this.align.value());
        }
        out.putEmpty(39);
        for (DocRow row : this.rows) {
            if (!row.isVisible()) continue;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(stream);
            row.store(writer);
            writer.flush();
            if (stream.size() == 0) continue;
            out.putRaw(40, stream);
        }
    }

    @Override
    public void beforeLoad() throws InformException, IOException {
        super.beforeLoad();
        this.align = HorizontalAlign.DEFAULT;
        this.cellMargins = new TableMargins();
        this.cellMargins.update();
        this.isBegin = false;
    }

    @Override
    public void afterLoad() throws InformException, IOException {
        super.afterLoad();
        this.setAllEffectiveCells();
    }

    void setAllEffectiveCells() {
        int rowIndex = 0;
        for (DocRow r : this.rows()) {
            int colIndex = 0;
            for (DocCell c : r.getCells()) {
                if (c.getHashKey() == 0L) {
                    ++colIndex;
                    continue;
                }
                if (c.rowSpan() > 1 || c.colSpan() > 1) {
                    for (int i = rowIndex; i < rowIndex + c.rowSpan(); ++i) {
                        for (int j = colIndex; j < colIndex + c.colSpan(); ++j) {
                            DocCell buffCell;
                            if (i >= this.rows.size()) continue;
                            DocRow row = this.rows.get(i);
                            if (j >= row.cells.size() || (buffCell = row.cells.get(j)) == c) continue;
                            buffCell.setEffectiveCell(c);
                        }
                    }
                }
                ++colIndex;
            }
            ++rowIndex;
        }
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 2: {
                this.borders.load(in.getStreamReader());
                break;
            }
            case 3: {
                this.align = HorizontalAlign.create(in.getInt());
                break;
            }
            case 5: {
                this.width = in.getDouble();
                break;
            }
            case 43: {
                this.bottomMargin = in.getDouble();
                break;
            }
            case 41: {
                this.fixed_cols = in.getInt();
                break;
            }
            case 44: {
                this.place_completely = true;
                break;
            }
            case 45: {
                this.transport_header = true;
                break;
            }
            case 42: {
                TaggedReader reader = in.getStreamReader();
                while (reader.next()) {
                    switch (reader.getCurrentTag()) {
                        case 5: {
                            double colWidth = reader.getDouble();
                            DocColumn column = new DocColumn(this);
                            column.setWidth(colWidth);
                            this.columns.add(column);
                        }
                    }
                }
                break;
            }
            case 39: {
                this.isBegin = true;
                this.getDocument().getTask().getHost().idle();
                break;
            }
            case 40: {
                if (!this.isBegin) break;
                DocRow row = new DocRow(this, false);
                this.rows.add(row);
                for (DocColumn column : this.columns.values()) {
                    row.appendColumn(column);
                }
                row.load(in.getStreamReader());
                this.isBegin = false;
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public Type getType() {
        return Type.TABLE;
    }

    public DocColumn appendColumn() {
        DocColumn column = new DocColumn(this);
        this.columns.add(column);
        for (DocRow row : this.rows) {
            row.appendColumn(column);
        }
        return column;
    }

    public DocColumn insertColumnBefore(DocColumn before) {
        int index = this.columns.indexOf(before);
        if (index < 0) {
            return null;
        }
        DocColumn column = new DocColumn(this);
        this.columns.insert(index, column);
        for (DocRow row : this.rows) {
            row.insertColumn(column, before);
        }
        return column;
    }

    public DocColumn insertColumnAfter(DocColumn after) {
        int index = this.columns.indexOf(after);
        if (index < 0) {
            return null;
        }
        if (++index == this.columns.size()) {
            return this.appendColumn();
        }
        DocColumn column = new DocColumn(this);
        this.columns.insert(index, column);
        for (DocRow row : this.rows) {
            row.insertColumn(column, after);
        }
        return column;
    }

    public DocRow appendRow() {
        DocRow row = new DocRow(this);
        this.rows.add(row);
        return row;
    }

    public String getClassName() {
        return "Table";
    }

    DocCell effectiveCellAt(int cellIndex, int rowIndex) {
        if (cellIndex < 0 || cellIndex >= this.columns.size()) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return null;
        }
        DocRow row = this.rows.get(rowIndex);
        return row.cells.get((int)cellIndex).effectiveCell;
    }

    DocCell effectiveLeftCell(int cellIndex, int rowIndex) {
        if (cellIndex >= this.columns.size()) {
            cellIndex = this.columns.size() - 1;
        }
        if (cellIndex < 0) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return null;
        }
        DocRow row = this.rows.get(rowIndex);
        DocCell currentCell = row.cells.get((int)cellIndex).effectiveCell;
        if (currentCell == null) {
            return null;
        }
        for (int i = cellIndex - 1; i >= 0; --i) {
            DocCell cell = row.cells.get((int)i).effectiveCell;
            if (cell == currentCell) continue;
            return cell;
        }
        return null;
    }

    DocCell effectiveRightCell(int cellIndex, int rowIndex) {
        if (cellIndex < 0) {
            cellIndex = 0;
        }
        if (cellIndex >= this.columns.size()) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return null;
        }
        DocRow row = this.rows.get(rowIndex);
        DocCell currentCell = row.cells.get((int)cellIndex).effectiveCell;
        if (currentCell == null) {
            return null;
        }
        for (int i = cellIndex + 1; i < this.columns.size(); ++i) {
            DocCell cell = row.cells.get((int)i).effectiveCell;
            if (cell == currentCell) continue;
            return cell;
        }
        return null;
    }

    DocCell effectiveTopCell(int cellIndex, int rowIndex) {
        if (cellIndex < 0 || cellIndex >= this.columns.size()) {
            return null;
        }
        if (rowIndex >= this.rows.size()) {
            rowIndex = this.rows.size() - 1;
        }
        if (rowIndex < 0) {
            return null;
        }
        DocRow row = this.rows.get(rowIndex);
        DocCell currentCell = row.cells.get((int)cellIndex).effectiveCell;
        if (currentCell == null) {
            return null;
        }
        for (int i = rowIndex - 1; i >= 0; --i) {
            row = this.rows.get(i);
            DocCell cell = row.cells.get((int)cellIndex).effectiveCell;
            if (cell == currentCell) continue;
            return cell;
        }
        return null;
    }

    DocCell effectiveBottomCell(int cellIndex, int rowIndex) {
        if (cellIndex < 0 || cellIndex >= this.columns.size()) {
            return null;
        }
        if (rowIndex < 0) {
            rowIndex = -1;
        }
        if (rowIndex >= this.rows.size()) {
            return null;
        }
        DocRow row = this.rows.get(rowIndex);
        DocCell currentCell = row.cells.get((int)cellIndex).effectiveCell;
        if (currentCell == null) {
            return null;
        }
        for (int i = rowIndex + 1; i < this.rows.size(); ++i) {
            row = this.rows.get(i);
            DocCell cell = row.cells.get((int)cellIndex).effectiveCell;
            if (cell == currentCell) continue;
            return cell;
        }
        return null;
    }

    public HorizontalAlign align() {
        return this.align;
    }

    public void setAlign(HorizontalAlign align) {
        this.align = align;
    }

    public double bottomMargin() {
        return this.bottomMargin;
    }

    public void bottomMargin(double v) {
        this.bottomMargin = v;
    }

    public Iterable<DocRow> rows() {
        return Collections.unmodifiableCollection(this.rows);
    }

    public DocRow getRow(int Index2) {
        return this.rows.get(Index2);
    }

    public int rowCount() {
        return this.rows.size();
    }

    public TableMargins getCellMargins() {
        return this.cellMargins;
    }

    public void setCellMargins(TableMargins cellMargins) {
        this.cellMargins = cellMargins;
    }

    public double getTableWidth() {
        double result = 0.0;
        for (int i = 0; i < this.columns.size(); ++i) {
            result += this.columns.get(i).getWidth();
        }
        return result;
    }

    public void insertDummyColumn(DocColumn c, int idx) {
    }

    public void removeDuplicateBorders() {
    }
}

