/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.IDocumentElement;
import inform.agent.web.reports.document.Type;
import java.io.IOException;

public class DocText
extends DocComponent {
    private final IDocumentElement parent;
    private String text;
    private boolean htmlFormatted = false;
    private int documentWriterFieldKind = 0;
    private String urlLink = "";
    private long hashKey = 0L;

    public DocText(IDocumentElement parent) {
        this(parent, "");
    }

    public DocText(IDocumentElement parent, String text) {
        super(parent.getDocument());
        this.text = text;
        this.parent = parent;
    }

    @Override
    public Type getType() {
        return Type.TEXT;
    }

    @Override
    public IDocumentElement getParent() {
        return this.parent;
    }

    @Override
    public void prepareStore() {
        super.prepareStore();
    }

    @Override
    public void finalizeDocument() {
        super.finalizeDocument();
    }

    @Override
    public void store(TaggedWriter out) throws InformException, IOException {
        if (!this.isVisible()) {
            return;
        }
        super.store(out);
        out.putEmpty(39);
        if (this.documentWriterFieldKind != 0) {
            out.putInt32(41, this.documentWriterFieldKind);
        } else if (!Strings.isVoid(this.text)) {
            out.putString(40, this.text);
        }
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 43: {
                this.hashKey = in.getUnsignedInt();
                this.useParentFont = false;
                Document doc = this.getDocument();
                if (doc == null) break;
                this.setFont(doc.getFattyCellStyleById(this.hashKey).getFont());
                this.setColor(doc.getFattyCellStyleById(this.hashKey).getColor());
                break;
            }
            case 40: {
                this.text = in.getString();
                break;
            }
            case 41: {
                this.documentWriterFieldKind = in.getInt();
                break;
            }
            case 42: {
                this.urlLink = in.getString();
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    public String getClassName() {
        return "Text";
    }

    public boolean getHtmlFormatted() {
        return this.htmlFormatted;
    }

    public void setHtmlFormatted(boolean htmlFormatted) {
        this.htmlFormatted = htmlFormatted;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getDocumentWriterFiedKind() {
        return this.documentWriterFieldKind;
    }

    public void setDocumentWriterFieldKind(int fieldKind) {
        this.documentWriterFieldKind = fieldKind;
    }

    public String getUrlLink() {
        return this.urlLink;
    }
}

