/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.reports.ReportTask;
import inform.agent.web.reports.controls.PageSettings;
import inform.agent.web.reports.controls.ReportPageOrientation;
import inform.agent.web.reports.document.DocElement;
import inform.agent.web.reports.document.DocFont;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.FontCache;
import inform.agent.web.reports.document.Type;
import inform.agent.web.reports.style.CellStyle;
import inform.agent.web.reports.style.DocCellStyleTable;
import inform.agent.web.reports.style.DocTextStyleTable;
import inform.agent.web.reports.style.TextStyle;
import inform.agent.web.utils.CellPositions;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.TableMargins;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class Document
extends DocElement {
    public static final int PROFILE_POINT_DOCUMENT_GENERATE = 0;
    public static final int PROFILE_POINT_DOCUMENT_LOADING = 1;
    public static final int PROFILE_POINT_DOCUMENT_FINALIZE = 2;
    public static final int PROFILE_POINT_FILTER_GENERATING = 3;
    public boolean useHashedCellStyle = false;
    public final ArrayList<CellStyle> fattyCellStyles = new ArrayList();
    private CellStyle _lastFattyCellStyle = new CellStyle();
    private final CellStyle _defaultFattyCellStyle = new CellStyle();
    private final Context context;
    private final ArrayList<DocSection> sections = new ArrayList();
    private final ArrayList<DocImage> images = new ArrayList();
    private String imageBaseURL = "";
    private final ReportTask task;
    private final FontCache fontCache = new FontCache();
    private final PageSettings rootPageSettings;
    private final DocTextStyleTable textStyles = new DocTextStyleTable();
    private final DocCellStyleTable cellStyles = new DocCellStyleTable();
    private final HashMap<TableMargins, TableMargins> marginCache = new HashMap();
    private final TextStyle defaultTextStyle = new TextStyle();
    private final int[] borderColors = new int[15];
    private int borderColorCount = 0;
    private boolean _useBlackAndWhite = false;
    private static final int SECTION_KIND_BODY = 0;
    private static final int SECTION_KIND_FIRST_PAGE_HEADER = 1;
    private static final int SECTION_KIND_NEXT_PAGE_HEADER = 2;
    private static final int SECTION_KIND_ALL_PAGE_HEADER = 3;
    private static final int SECTION_KIND_FIRST_PAGE_FOOTER = 4;
    private static final int SECTION_KIND_NEXT_PAGE_FOOTER = 5;
    private static final int SECTION_KIND_ALL_PAGE_FOOTER = 6;
    private DocSection _section = null;
    private DocSection _firstSection = null;
    private DocSection _currentHeaderFooter = null;
    private boolean isFirstSection;
    private boolean isBody;
    private StringBuilder _profileInfo = null;
    private ArrayList<ProfileInfo> _infoList = new ArrayList();

    public Document(Scriptable scope, Context context, ReportTask task) {
        super(null);
        this.context = context;
        this.task = task;
        this.rootPageSettings = new PageSettings(null);
        this.style = this.defaultTextStyle;
        this.resetProfile();
    }

    public void setDocumentFont(Font font) {
        this.defaultTextStyle.setFont(font);
        this.textStyles.add(this, font, 0x1FFFFFFF);
        this.borderColorCount = 1;
        this.borderColors[0] = 0;
    }

    public TextStyle createDefaultTextStyle() {
        return new TextStyle(this.defaultTextStyle);
    }

    public int colorToBorderColor(int color) {
        for (int borderColor = 0; borderColor < this.borderColorCount; ++borderColor) {
            if (this.borderColors[borderColor] != color) continue;
            return borderColor;
        }
        if (this.borderColorCount == this.borderColors.length) {
            return 0;
        }
        this.borderColors[this.borderColorCount] = color;
        return this.borderColorCount++;
    }

    public int borderColorToColor(int borderColor) {
        if (borderColor < 0 || borderColor >= this.borderColorCount) {
            return 0;
        }
        return this.borderColors[borderColor];
    }

    public DocFont getDocFont(Font font) {
        return this.fontCache.getFont(font);
    }

    public TableMargins getDocMargins(TableMargins margins) {
        TableMargins dm = this.marginCache.get(margins);
        if (dm == null) {
            dm = new TableMargins();
            dm.assign(margins);
            this.marginCache.put(dm, dm);
        }
        return dm;
    }

    public Object executeEvent(Scriptable sender, String script, String title, Object[] args) {
        return null;
    }

    public Object executeEvent(Scriptable sender, String script, String title) {
        return this.executeEvent(sender, script, title, null);
    }

    @Override
    public Type getType() {
        return Type.DOCUMENT;
    }

    @Override
    public DocElement getParent() {
        return null;
    }

    public DocSection appendSection() {
        DocSection section = new DocSection(this);
        this.sections.add(section);
        return section;
    }

    public String getClassName() {
        return "Document";
    }

    @Override
    protected void actualizeStyle() {
        this.actualizeStyle(this);
    }

    @Override
    public void prepareStore() {
        super.prepareStore();
        for (DocSection section : this.sections) {
            section.prepareStore();
        }
    }

    @Override
    public void finalizeDocument() {
        this.beginProfile(2);
        super.finalizeDocument();
        for (DocSection section : this.sections) {
            section.finalizeDocument();
        }
        this.endProfile(2);
    }

    @Override
    public void store(TaggedWriter out) throws InformException, IOException {
        this.prepareStore();
        CellPositions positions = new CellPositions();
        for (DocSection section : this.sections) {
            section.calculate(positions);
        }
        this.fontCache.storeAs(7, out);
        super.store(out);
        positions.storeAs(6, out);
        out.putEmpty(39);
        for (DocSection section : this.sections) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(stream);
            section.store(writer);
            writer.flush();
            if (stream.size() == 0) continue;
            out.putRaw(40, stream);
        }
    }

    @Override
    public void beforeLoad() throws InformException, IOException {
        this._firstSection = this._section = this.appendSection();
        this.isFirstSection = true;
        this.isBody = true;
        this._currentHeaderFooter = null;
        Font f = new Font();
        f.setName("Times New Roman");
        f.setSize(10);
        this.setDocumentFont(f);
        this.useParentFont = false;
        this.beginProfile(1);
    }

    @Override
    public void afterLoad() throws InformException, IOException {
        this.endProfile(1);
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 39: {
                break;
            }
            case 52: {
                int sk = in.getInt();
                switch (sk) {
                    case 0: {
                        this.isBody = true;
                        this._currentHeaderFooter = null;
                        break;
                    }
                    case 1: {
                        this.isBody = false;
                        this._currentHeaderFooter = this._firstSection.createHeader(1);
                        break;
                    }
                    case 2: {
                        this.isBody = false;
                        this._currentHeaderFooter = this._firstSection.createHeader(2);
                        break;
                    }
                    case 3: {
                        this.isBody = false;
                        this._currentHeaderFooter = this._firstSection.createHeader(0);
                        break;
                    }
                    case 4: {
                        this.isBody = false;
                        this._currentHeaderFooter = this._firstSection.createFooter(1);
                        break;
                    }
                    case 5: {
                        this.isBody = false;
                        this._currentHeaderFooter = this._firstSection.createFooter(2);
                        break;
                    }
                    case 6: {
                        this.isBody = false;
                        this._currentHeaderFooter = this._firstSection.createFooter(0);
                    }
                }
                break;
            }
            case 40: {
                if (!this.isFirstSection && this.isBody) {
                    this._section = this.appendSection();
                }
                byte[] sectionContent = in.getRaw();
                TaggedReader sectionReader = new TaggedReader(sectionContent);
                if (this.isBody) {
                    this._section.load(sectionReader);
                } else if (this._currentHeaderFooter != null) {
                    this._currentHeaderFooter.load(sectionReader);
                }
                if (this.isFirstSection && this.isBody) {
                    this.rootPageSettings.font.assign(this._section.getFont());
                    this.rootPageSettings.color = this._section.getColor();
                    this.rootPageSettings.pageMargins.assign(this._section.margins());
                    this.rootPageSettings.pageWidth = this._section.getPageWidth();
                    this.rootPageSettings.pageHeight = this._section.getPageHeight();
                    this.rootPageSettings.orientation = ReportPageOrientation.create(this._section.getOrientation().value());
                    this.rootPageSettings.headerMargin = this._section.getHeaderMargin();
                    this.rootPageSettings.footerMargin = this._section.getFooterMargin();
                }
                if (!this.isBody) break;
                this.isFirstSection = false;
            }
        }
    }

    public Iterable<DocSection> sections() {
        return Collections.unmodifiableCollection(this.sections);
    }

    public ReportTask getTask() {
        return this.task;
    }

    public int addImage(DocImage im) {
        this.images.add(im);
        return this.images.size() - 1;
    }

    public int getLastImageId() {
        return this.images.size() - 1;
    }

    public byte[] getImageContent(int idx) {
        if (idx < this.images.size()) {
            return this.images.get(idx).getImageContent();
        }
        return null;
    }

    public void setImageBaseURL(String base) {
        this.imageBaseURL = base;
    }

    public String getImageBaseURL() {
        return this.imageBaseURL;
    }

    public void setRootPageSettings(PageSettings p) {
        this.rootPageSettings.assign(p);
    }

    public PageSettings getRootPageSettings() {
        return this.rootPageSettings;
    }

    public DocTextStyleTable textStyles() {
        return this.textStyles;
    }

    public DocCellStyleTable cellStyles() {
        return this.cellStyles;
    }

    public boolean getUseBlackAndWhite() {
        return this._useBlackAndWhite;
    }

    public void setUseBlackAndWhite(boolean bw) {
        this._useBlackAndWhite = bw;
    }

    public int sectionCount() {
        return this.sections.size();
    }

    public String getServerProfilerInfo() throws IOException, InformException {
        this._profileInfo.append("Total server time: ");
        this._profileInfo.append(this._infoList.get((int)0).finishProfileTime - this._infoList.get((int)0).startProfileTime);
        this._profileInfo.append(" msec.\n");
        for (ProfileInfo pi : this._infoList) {
            long sum = pi.finishProfileTime - pi.startProfileTime;
            switch (pi.pointId) {
                case 1: {
                    this._profileInfo.append("Loading: ");
                    this._profileInfo.append(sum);
                    this._profileInfo.append(" msec.\n");
                    break;
                }
                case 2: {
                    this._profileInfo.append("Finalize: ");
                    this._profileInfo.append(sum);
                    this._profileInfo.append(" msec.\n");
                    break;
                }
                case 3: {
                    this._profileInfo.append("Filter: ");
                    this._profileInfo.append(sum);
                    this._profileInfo.append(" msec.\n");
                    break;
                }
            }
        }
        return this._profileInfo.toString();
    }

    public void resetProfile() {
        this._profileInfo = new StringBuilder();
        this._infoList.clear();
    }

    public void beginProfile(int pointId) throws InformException {
        ProfileInfo buff = new ProfileInfo();
        buff.pointId = pointId;
        buff.startProfileTime = System.currentTimeMillis();
        this._infoList.add(buff);
    }

    public void endProfile(int pointId) throws InformException {
        long buff = System.currentTimeMillis();
        for (ProfileInfo pi : this._infoList) {
            if (pi.pointId != pointId) continue;
            pi.finishProfileTime = buff;
            break;
        }
    }

    public CellStyle getFattyCellStyleById(long hashKey) {
        if (hashKey == 0L) {
            this._lastFattyCellStyle = this._defaultFattyCellStyle;
        }
        if (this._lastFattyCellStyle.getHashKey() == hashKey) {
            return this._lastFattyCellStyle;
        }
        for (CellStyle cs : this.fattyCellStyles) {
            if (cs == null || cs.getHashKey() != hashKey) continue;
            this._lastFattyCellStyle = cs;
            return cs;
        }
        return this._lastFattyCellStyle;
    }

    private static class ProfileInfo {
        public int pointId = 0;
        public long startProfileTime = 0L;
        public long finishProfileTime = 0L;

        private ProfileInfo() {
        }
    }
}

