/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.generators;

import inform.adt.InformException;
import inform.agent.web.reports.controls.PageNumbers;
import inform.agent.web.reports.controls.ReportPageOrientation;
import inform.agent.web.reports.document.DocBorders;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Type;
import inform.agent.web.reports.generators.CustomXWPFDocument;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.CellPositions;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.ImageInfo;
import inform.agent.web.utils.VerticalAlign;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.wp.usermodel.HeaderFooterType;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.Document;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlToken;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrEx;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHeightRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHexColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJcTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;

public class DocxGenerator
implements WebReportGenerator {
    private static final double TWIPS = 56.694;
    private final inform.agent.web.reports.document.Document doc;
    private final String caption;
    private CustomXWPFDocument docx;
    private boolean _useTitlePage = false;
    private XWPFHeader defaultHeader = null;
    private XWPFHeader firstHeader = null;
    private XWPFFooter defaultFooter = null;
    private XWPFFooter firstFooter = null;
    private XmlToken xmlCellParaPrToken = null;

    public DocxGenerator(inform.agent.web.reports.document.Document doc, String caption) throws Exception {
        this.doc = doc;
        this.caption = URLEncoder.encode(caption, "UTF-8").replace('+', ' ');
        this._useTitlePage = false;
    }

    @Override
    public void generateHeaders(HttpServletResponse resp) throws Exception {
        resp.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        resp.setHeader("Content-disposition", String.format("attachment; filename*=\"utf8'ru-ru'%s.docx\"", this.caption.isEmpty() ? "noname" : this.caption));
    }

    private ParagraphAlignment convertToXWPFHAlignment(HorizontalAlign val) {
        switch (val) {
            case LEFT: {
                return ParagraphAlignment.LEFT;
            }
            case CENTER: {
                return ParagraphAlignment.CENTER;
            }
            case RIGHT: {
                return ParagraphAlignment.RIGHT;
            }
            case WIDTH: {
                return ParagraphAlignment.BOTH;
            }
        }
        return ParagraphAlignment.LEFT;
    }

    private String getColorString(int c) throws InformException {
        return String.format("%02X%02X%02X", c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF);
    }

    private void fillFontProps(Font f, XWPFRun run) throws InformException {
        run.setColor(this.getColorString(f.getColor()));
        run.setBold((f.getStyle() & 1) != 0);
        run.setItalic((f.getStyle() & 2) != 0);
        run.setStrikeThrough((f.getStyle() & 8) != 0);
        if ((f.getStyle() & 4) != 0) {
            run.setUnderline(UnderlinePatterns.SINGLE);
        }
        String fontName = f.getName();
        int fontSize = f.getSize();
        CTFonts fonts = run.getCTR().getRPr().addNewRFonts();
        fonts.setAscii(fontName);
        fonts.setHAnsi(fontName);
        fonts.setCs(fontName);
        run.setFontSize(fontSize);
    }

    private void fillTextProps(CTR ctr, DocText text) throws InformException {
        if (ctr == null) {
            return;
        }
        Font f = text.getFont();
        CTRPr rPr = ctr.addNewRPr();
        rPr.addNewColor().xsetVal(this.createHEXColor(f.getColor()));
        if ((f.getStyle() & 1) != 0) {
            rPr.addNewB();
        }
        if ((f.getStyle() & 2) != 0) {
            rPr.addNewI();
        }
        if ((f.getStyle() & 8) != 0) {
            rPr.addNewStrike();
        }
        if ((f.getStyle() & 4) != 0) {
            rPr.addNewU().setVal(STUnderline.SINGLE);
        }
        if ((f.getStyle() & 0x10) != 0) {
            rPr.addNewVertAlign().setVal(STVerticalAlignRun.SUPERSCRIPT);
        }
        CTFonts fonts = rPr.addNewRFonts();
        fonts.setAscii(f.getName());
        fonts.setHAnsi(f.getName());
        fonts.setCs(f.getName());
        rPr.addNewSz().setVal((Object)BigInteger.valueOf(2L * (long)f.getSize()));
        if (text.getEffectiveColor() != 0x1FFFFFFF) {
            rPr.addNewShd().xsetFill(this.createHEXColor(text.getEffectiveColor()));
        }
    }

    private void convertTextToRun(DocText t, XWPFParagraph paragraph) throws InformException {
        CTP ctp = paragraph.getCTP();
        CTR ctr = null;
        CTSimpleField field = null;
        switch (t.getDocumentWriterFiedKind()) {
            case 0: {
                ctr = ctp.addNewR();
                if (t.getText().equalsIgnoreCase("\t")) {
                    ctr.addNewTab();
                    break;
                }
                String allText = t.getText().replaceAll("\\r", "");
                String[] Lines2 = allText.split("\n");
                for (int i = 0; i < Lines2.length; ++i) {
                    CTText text = ctr.addNewT();
                    text.setSpace(SpaceAttribute.Space.PRESERVE);
                    text.setStringValue(Lines2[i]);
                    if (i >= Lines2.length - 1) continue;
                    ctr.addNewBr();
                }
                break;
            }
            case 2: {
                field = ctp.addNewFldSimple();
                ctr = field.addNewR();
                field.setInstr("NUMPAGES");
                ctr.addNewT().setStringValue("[\u041a\u043e\u043b-\u0432\u043e \u0441\u0442\u0440]");
                break;
            }
            case 1: {
                field = ctp.addNewFldSimple();
                ctr = field.addNewR();
                field.setInstr("PAGE");
                ctr.addNewT().setStringValue("[\u2116 \u0441\u0442\u0440]");
            }
        }
        this.fillTextProps(ctr, t);
    }

    private void writeBackgroundImage(CustomXWPFDocument docx, DocSection s, XWPFParagraph paragraph) throws Exception {
        if (docx == null || s == null || paragraph == null) {
            return;
        }
        if (s.getBGImageID() == 0.0) {
            return;
        }
        byte[] data = s.getBGImageContent();
        String blipId = "";
        if (data != null) {
            ByteArrayInputStream bs = new ByteArrayInputStream(data);
            ImageInfo ii = new ImageInfo();
            ii.setInput(bs);
            if (!ii.check()) {
                throw new Exception("Unsupported image format");
            }
            switch (ii.getFormat()) {
                case 3: {
                    blipId = docx.addPictureData(data, Document.PICTURE_TYPE_BMP);
                    break;
                }
                case 1: {
                    blipId = docx.addPictureData(data, Document.PICTURE_TYPE_GIF);
                    break;
                }
                case 0: {
                    blipId = docx.addPictureData(data, Document.PICTURE_TYPE_JPEG);
                    break;
                }
                case 2: {
                    blipId = docx.addPictureData(data, Document.PICTURE_TYPE_PNG);
                }
            }
            docx.createPicture(paragraph, blipId, s.getBGWidth(), s.getBGHeight(), s.getBGLeft(), s.getBGTop(), true);
        }
    }

    private void insertPicture(XWPFParagraph paragraph, DocImage im, XWPFHeaderFooter header) throws Exception {
        byte[] data = im.getImageContent();
        String blipId = "";
        if (data != null) {
            int imageType = im.getImageType();
            if (imageType == 0) {
                ByteArrayInputStream bs = new ByteArrayInputStream(data);
                ImageInfo ii = new ImageInfo();
                ii.setInput(bs);
                if (!ii.check()) {
                    throw new Exception("Unsupported image format");
                }
                switch (ii.getFormat()) {
                    case 3: {
                        imageType = 1;
                        break;
                    }
                    case 1: {
                        imageType = 5;
                        break;
                    }
                    case 0: {
                        imageType = 6;
                        break;
                    }
                    case 2: {
                        imageType = 7;
                    }
                }
            }
            switch (imageType) {
                case 1: {
                    if (header == null) {
                        blipId = this.docx.addPictureData(data, Document.PICTURE_TYPE_BMP);
                        break;
                    }
                    blipId = header.addPictureData(data, Document.PICTURE_TYPE_BMP);
                    break;
                }
                case 5: {
                    if (header == null) {
                        blipId = this.docx.addPictureData(data, Document.PICTURE_TYPE_GIF);
                        break;
                    }
                    blipId = header.addPictureData(data, Document.PICTURE_TYPE_GIF);
                    break;
                }
                case 6: {
                    if (header == null) {
                        blipId = this.docx.addPictureData(data, Document.PICTURE_TYPE_JPEG);
                        break;
                    }
                    blipId = header.addPictureData(data, Document.PICTURE_TYPE_JPEG);
                    break;
                }
                case 7: {
                    if (header == null) {
                        blipId = this.docx.addPictureData(data, Document.PICTURE_TYPE_PNG);
                        break;
                    }
                    blipId = header.addPictureData(data, Document.PICTURE_TYPE_PNG);
                    break;
                }
                case 4: {
                    if (header == null) {
                        blipId = this.docx.addPictureData(data, Document.PICTURE_TYPE_EMF);
                        break;
                    }
                    blipId = header.addPictureData(data, Document.PICTURE_TYPE_EMF);
                    break;
                }
                case 3: {
                    blipId = header == null ? this.docx.addPictureData(data, Document.PICTURE_TYPE_WMF) : header.addPictureData(data, Document.PICTURE_TYPE_WMF);
                }
            }
            this.docx.createPicture(paragraph, blipId, im.getWidth(), im.getHeight());
            this.doc.addImage(im);
        }
    }

    private void generatePageBreak() throws Exception {
        assert (this.docx != null);
        XWPFParagraph paragraph = this.docx.createParagraph();
        XWPFRun run = paragraph.createRun();
        run.addBreak(BreakType.PAGE);
    }

    private void generateParagraph(DocParagraph p, XWPFHeaderFooter header, XWPFTableCell cell, int parIndex) throws Exception {
        assert (this.docx != null);
        XWPFParagraph paragraph = null;
        paragraph = header == null ? (cell == null ? this.docx.createParagraph() : (parIndex == 0 ? (XWPFParagraph)cell.getParagraphs().get(0) : cell.addParagraph())) : header.createParagraph();
        paragraph.setIndentFromLeft(this.docXunit(p.marginLeft()));
        CTPPr pPr = paragraph.getCTP().getPPr() == null ? paragraph.getCTP().addNewPPr() : paragraph.getCTP().getPPr();
        pPr.addNewAdjustRightInd().setVal((Object)"0");
        pPr.addNewAutoSpaceDE().setVal((Object)"0");
        pPr.addNewAutoSpaceDN().setVal((Object)"0");
        pPr.addNewWidowControl().setVal((Object)"0");
        if (p.getEffectiveColor() != 0x1FFFFFFF) {
            pPr.addNewShd().xsetFill(this.createHEXColor(p.getEffectiveColor()));
        }
        CTSpacing spacing = pPr.addNewSpacing();
        spacing.setBefore((Object)new BigInteger(this.docXunitStr(p.marginTop())));
        spacing.setAfter((Object)new BigInteger(this.docXunitStr(p.marginBottom())));
        spacing.setLine((Object)BigInteger.valueOf(240L));
        spacing.setLineRule(STLineSpacingRule.AUTO);
        CTPBdr bord = pPr.addNewPBdr();
        Borders borders = p.getBorders();
        this.processBorder(borders.getBottomColor(), borders.getBottom(), bord.addNewBottom());
        this.processBorder(borders.getTopColor(), borders.getTop(), bord.addNewTop());
        this.processBorder(borders.getLeftColor(), borders.getLeft(), bord.addNewLeft());
        this.processBorder(borders.getRightColor(), borders.getRight(), bord.addNewRight());
        for (DocComponent cm : p.components()) {
            switch (cm.getType()) {
                case PARAGRAPH: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TEXT: {
                    this.convertTextToRun((DocText)cm, paragraph);
                    break;
                }
                case IMAGE: {
                    DocImage im = (DocImage)cm;
                    this.insertPicture(paragraph, im, header);
                    break;
                }
            }
        }
        if (p.align() != HorizontalAlign.LEFT) {
            paragraph.setAlignment(this.convertToXWPFHAlignment(p.align()));
        }
    }

    private STJcTable.Enum convertToJcAlign(HorizontalAlign val) {
        switch (val) {
            case LEFT: {
                return STJcTable.LEFT;
            }
            case CENTER: {
                return STJcTable.CENTER;
            }
            case RIGHT: {
                return STJcTable.RIGHT;
            }
            case WIDTH: {
                return STJcTable.LEFT;
            }
        }
        return STJcTable.LEFT;
    }

    private STHexColor createHEXColor(int color) throws InformException {
        STHexColor c = (STHexColor)STHexColor.Factory.newInstance();
        c.setStringValue(this.getColorString(color));
        return c;
    }

    private void processBorder(int s_borderColor, int s_borderStyle, CTBorder d_border) throws InformException {
        d_border.xsetColor(this.createHEXColor(s_borderColor));
        switch (s_borderStyle) {
            case 0: {
                d_border.setVal(STBorder.NIL);
                break;
            }
            case 1: {
                d_border.setVal(STBorder.DOTTED);
                break;
            }
            case 2: {
                d_border.setSz(new BigInteger("8"));
                d_border.setVal(STBorder.THICK);
                break;
            }
            case 3: {
                d_border.setSz(new BigInteger("16"));
                d_border.setVal(STBorder.THICK);
                break;
            }
            case 4: {
                d_border.setSz(new BigInteger("24"));
                d_border.setVal(STBorder.THICK);
                break;
            }
            case 5: {
                d_border.setVal(STBorder.DOUBLE);
                break;
            }
            default: {
                d_border.setVal(STBorder.NONE);
            }
        }
    }

    private XWPFTableCell.XWPFVertAlign convertToXWPFVertAlign(VerticalAlign val) {
        switch (val) {
            case TOP: {
                return XWPFTableCell.XWPFVertAlign.TOP;
            }
            case BOTTOM: {
                return XWPFTableCell.XWPFVertAlign.BOTTOM;
            }
            case MIDDLE: {
                return XWPFTableCell.XWPFVertAlign.CENTER;
            }
            case BASELINE: {
                return XWPFTableCell.XWPFVertAlign.BOTTOM;
            }
        }
        return XWPFTableCell.XWPFVertAlign.CENTER;
    }

    private static void setCellTextDirection(int textOrientationValue, XWPFTableCell cell) throws Exception {
        if (textOrientationValue == 0 || cell == null) {
            return;
        }
        CTTcPr cPr = cell.getCTTc().getTcPr();
        if (cPr == null) {
            cPr = cell.getCTTc().addNewTcPr();
        }
        String xmlStr = "";
        xmlStr = textOrientationValue == 1 ? "<w:textDirection xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" w:val=\"btLr\" />" : "<w:textDirection xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" w:val=\"tbRl\" />";
        XmlToken xmlToken = null;
        try {
            xmlToken = (XmlToken)XmlToken.Factory.parse(xmlStr);
        }
        catch (XmlException xe) {
            xe.printStackTrace();
        }
        cPr.set((XmlObject)xmlToken);
    }

    private void setCellParaPr(CTPPr ppr, DocCell cell) throws Exception {
        if (ppr == null) {
            return;
        }
        ppr.set((XmlObject)this.xmlCellParaPrToken);
        if (cell == null) {
            return;
        }
        Font f = cell.getFont();
        if (f == null) {
            return;
        }
        CTParaRPr rPr = ppr.getRPr();
        rPr.addNewColor().xsetVal(this.createHEXColor(f.getColor()));
        if ((f.getStyle() & 1) != 0) {
            rPr.addNewB();
        }
        if ((f.getStyle() & 2) != 0) {
            rPr.addNewI();
        }
        if ((f.getStyle() & 8) != 0) {
            rPr.addNewStrike();
        }
        if ((f.getStyle() & 4) != 0) {
            rPr.addNewU().setVal(STUnderline.SINGLE);
        }
        CTFonts fonts = rPr.getRFontsArray(0);
        fonts.setAscii(f.getName());
        fonts.setHAnsi(f.getName());
        fonts.setCs(f.getName());
        rPr.getSzArray(0).setVal((Object)BigInteger.valueOf(2L * (long)f.getSize()));
        rPr.getSzCsArray(0).setVal((Object)BigInteger.valueOf(2L * (long)f.getSize()));
        if (cell.getEffectiveColor() != 0x1FFFFFFF) {
            rPr.addNewShd().xsetFill(this.createHEXColor(cell.getEffectiveColor()));
        }
    }

    private void generateCell(DocCell s_cell, XWPFTableCell d_cell, double width, boolean onlyStyle, XWPFHeaderFooter header) throws Exception {
        CTTcPr cPr = d_cell.getCTTc().getTcPr();
        if (cPr == null) {
            cPr = d_cell.getCTTc().addNewTcPr();
        }
        DocxGenerator.setCellTextDirection(s_cell.getTextOrientation(), d_cell);
        if (s_cell.getEffectiveColor() != 0x1FFFFFFF) {
            cPr.addNewShd().xsetFill(this.createHEXColor(s_cell.getEffectiveColor()));
        }
        int borders = s_cell.borders();
        CTTcBorders d_borders = cPr.getTcBorders() == null ? cPr.addNewTcBorders() : cPr.getTcBorders();
        this.processBorder(DocBorders.bottomColor(this.doc, borders), DocBorders.bottomStyle(borders), d_borders.getBottom() == null ? d_borders.addNewBottom() : d_borders.getBottom());
        this.processBorder(DocBorders.topColor(this.doc, borders), DocBorders.topStyle(borders), d_borders.getTop() == null ? d_borders.addNewTop() : d_borders.getTop());
        this.processBorder(DocBorders.leftColor(this.doc, borders), DocBorders.leftStyle(borders), d_borders.getLeft() == null ? d_borders.addNewLeft() : d_borders.getLeft());
        this.processBorder(DocBorders.rightColor(this.doc, borders), DocBorders.rightStyle(borders), d_borders.getRight() == null ? d_borders.addNewRight() : d_borders.getRight());
        d_cell.setVerticalAlignment(this.convertToXWPFVertAlign(s_cell.verticalAlign()));
        if (onlyStyle) {
            return;
        }
        CTTblWidth ctTblWidth = cPr.getTcW() == null ? cPr.addNewTcW() : cPr.getTcW();
        ctTblWidth.setW((Object)new BigInteger(this.docXunitStr(width)));
        ctTblWidth.setType(STTblWidth.DXA);
        if (!s_cell.isCellWordWrap()) {
            if (cPr.getNoWrap() == null) {
                cPr.addNewNoWrap();
            } else {
                cPr.getNoWrap();
            }
        }
        boolean isCellSimple = true;
        int parIndex = 0;
        for (DocComponent cm : s_cell.components()) {
            if (cm.getType() != Type.PARAGRAPH) continue;
            isCellSimple = false;
            this.generateParagraph((DocParagraph)cm, null, d_cell, parIndex++);
        }
        if (!isCellSimple) {
            return;
        }
        XWPFParagraph paragraph = (XWPFParagraph)d_cell.getParagraphs().get(0);
        CTP ctp = paragraph.getCTP();
        CTPPr ppr = ctp.getPPr() == null ? ctp.addNewPPr() : ctp.getPPr();
        this.setCellParaPr(ppr, s_cell);
        ppr.addNewAdjustRightInd().setVal((Object)"0");
        ppr.addNewAutoSpaceDE().setVal((Object)"0");
        ppr.addNewAutoSpaceDN().setVal((Object)"0");
        ppr.addNewWidowControl().setVal((Object)"0");
        paragraph.setIndentFromLeft(this.docXunit(s_cell.getCellMargins().getLeft()));
        paragraph.setIndentFromRight(this.docXunit(s_cell.getCellMargins().getRight()));
        paragraph.setSpacingBefore(this.docXunit(s_cell.getCellMargins().getTop()));
        paragraph.setSpacingAfter(this.docXunit(s_cell.getCellMargins().getBottom()));
        CTSpacing spacing = ppr.getSpacing() == null ? ppr.addNewSpacing() : ppr.getSpacing();
        spacing.setLineRule(STLineSpacingRule.AUTO);
        spacing.setLine((Object)BigInteger.valueOf(240L));
        if (s_cell.horizontalAlign() != HorizontalAlign.LEFT) {
            paragraph.setAlignment(this.convertToXWPFHAlignment(s_cell.horizontalAlign()));
        }
        if (!s_cell.isCellValueEmpty()) {
            String allText = s_cell.getCellValue().asText();
            String[] Lines2 = allText.split("\n");
            for (int i = 0; i < Lines2.length; ++i) {
                XWPFRun run = paragraph.createRun();
                run.setText(Lines2[i]);
                this.fillFontProps(s_cell.getFont(), run);
                if (i >= Lines2.length - 1) continue;
                run.addBreak();
            }
        }
        for (DocComponent cm : s_cell.components()) {
            switch (cm.getType()) {
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                }
                case TEXT: {
                    this.convertTextToRun((DocText)cm, paragraph);
                    break;
                }
                case IMAGE: {
                    DocImage im = (DocImage)cm;
                    this.insertPicture(paragraph, im, header);
                    break;
                }
            }
        }
    }

    private void generateTable(DocTable t, XWPFHeaderFooter header) throws Exception {
        assert (this.docx != null);
        XWPFTable table = null;
        if (header == null) {
            table = this.docx.createTable();
        } else {
            table = new XWPFTable(header._getHdrFtr().addNewTbl(), (IBody)header);
            header.insertTable(header.getTables().size(), table);
        }
        int nColumns = t.getColumns().size();
        StringBuilder tblPrStr = new StringBuilder();
        tblPrStr.append("<xml-fragment xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">");
        tblPrStr.append("<w:tblW w:w=\"0\" w:type=\"auto\"/>");
        tblPrStr.append("<w:tblLayout w:type=\"fixed\" />");
        tblPrStr.append("<w:tblCellMar>");
        tblPrStr.append("<w:left w:w=\"0\" w:type=\"dxa\" />");
        tblPrStr.append("<w:right w:w=\"0\" w:type=\"dxa\" />");
        tblPrStr.append("<w:top w:w=\"0\" w:type=\"dxa\"/>");
        tblPrStr.append("<w:bottom w:w=\"0\" w:type=\"dxa\"/>");
        tblPrStr.append("</w:tblCellMar>");
        tblPrStr.append("<w:tblLook w:val=\"0000\" />");
        tblPrStr.append("</xml-fragment>");
        CTTbl tblCT = table.getCTTbl();
        CTTblPr tblPr = tblCT.getTblPr();
        try {
            XmlToken tblToken = (XmlToken)XmlToken.Factory.parse(tblPrStr.toString());
            tblPr.set((XmlObject)tblToken);
        }
        catch (XmlException xe) {
            xe.printStackTrace();
        }
        StringBuilder tblGridStr = new StringBuilder();
        tblGridStr.append("<xml-fragment xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">");
        for (int col = 0; col < nColumns; ++col) {
            tblGridStr.append("<w:gridCol w:w=\"");
            tblGridStr.append(this.docXunit(t.getColumns().get(col).getWidth()));
            tblGridStr.append("\" />");
        }
        tblGridStr.append("</xml-fragment>");
        CTTblGrid gridPr = tblCT.addNewTblGrid();
        try {
            XmlToken tblToken = (XmlToken)XmlToken.Factory.parse(tblGridStr.toString());
            gridPr.set((XmlObject)tblToken);
        }
        catch (XmlException xe) {
            xe.printStackTrace();
        }
        CTTblWidth ind = tblPr.addNewTblInd();
        ind.setW((Object)BigInteger.ZERO);
        ind.setType(STTblWidth.DXA);
        if (t.align() != HorizontalAlign.LEFT) {
            tblPr.addNewJc().setVal(this.convertToJcAlign(t.align()));
        }
        if (t.getEffectiveColor() != 0x1FFFFFFF) {
            tblPr.addNewShd().xsetFill(this.createHEXColor(t.getEffectiveColor()));
        }
        int cr = 0;
        int[] rs = new int[nColumns];
        for (int r = 0; r < t.rowCount(); ++r) {
            XWPFTableRow row = table.getRow(r);
            if (row != null) continue;
            table.createRow();
        }
        for (DocRow r : t.rows()) {
            XWPFTableRow row = table.getRow(cr);
            CTTblPrEx prEx = row.getCtRow().getTblPrEx() == null ? row.getCtRow().addNewTblPrEx() : row.getCtRow().getTblPrEx();
            CTTblCellMar cellMar = prEx.addNewTblCellMar();
            cellMar.addNewLeft().setW((Object)"0");
            cellMar.addNewTop().setW((Object)"0");
            cellMar.addNewRight().setW((Object)"0");
            cellMar.addNewBottom().setW((Object)"0");
            if (r.getHeight() != 0.0) {
                CTTrPr trPr = row.getCtRow().getTrPr() == null ? row.getCtRow().addNewTrPr() : row.getCtRow().getTrPr();
                CTHeight ctHeight = trPr.addNewTrHeight();
                ctHeight.setVal((Object)new BigInteger(this.docXunitStr(r.getHeight())));
                ctHeight.setHRule(STHeightRule.AT_LEAST);
            }
            if (r.rowType == 1) {
                row.setRepeatHeader(true);
            }
            int ci = 0;
            int cs = 1;
            for (DocCell c : r.getCells()) {
                if (cs > 1) {
                    --cs;
                    ++ci;
                    continue;
                }
                DocCell effC = c.effectiveCell();
                cs = effC.colSpan();
                XWPFTableCell cell = row.getCell(ci);
                if (cell == null) {
                    cell = row.createCell();
                }
                boolean needRestart = false;
                CTTcPr tcPr = cell.getCTTc().addNewTcPr();
                if (effC == c) {
                    rs[ci] = effC.rowSpan();
                    if (rs[ci] > 1) {
                        needRestart = true;
                    }
                } else if (rs[ci] > 1) {
                    int n = ci++;
                    rs[n] = rs[n] - 1;
                    this.generateCell(effC, cell, 0.0, true, header);
                    tcPr.addNewVMerge().setVal(STMerge.CONTINUE);
                    if (cs <= 1) continue;
                    tcPr.addNewGridSpan().setVal(BigInteger.valueOf(cs));
                    continue;
                }
                double cWidth = 0.0;
                for (int i = ci; i < ci + cs; ++i) {
                    cWidth += t.getColumns().get(i).getWidth();
                }
                this.generateCell(c, cell, cWidth, false, header);
                if (needRestart) {
                    tcPr.addNewVMerge().setVal(STMerge.RESTART);
                }
                if (cs > 1) {
                    tcPr.addNewGridSpan().setVal(BigInteger.valueOf(cs));
                }
                ++ci;
            }
            ++cr;
        }
        StringBuilder botXmlStr = new StringBuilder();
        if (t.bottomMargin() > 0.0) {
            botXmlStr.append("<w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">");
            botXmlStr.append("<w:widowControl w:val=\"0\" />");
            botXmlStr.append("<w:autoSpaceDE w:val=\"0\" />");
            botXmlStr.append("<w:autoSpaceDN w:val=\"0\" />");
            botXmlStr.append("<w:adjustRightInd w:val=\"0\" />");
            botXmlStr.append("<w:spacing w:before=\"0\" w:after=\"");
            botXmlStr.append(this.docXunit(t.bottomMargin()));
            botXmlStr.append("\" w:line=\"240\" w:lineRule=\"auto\" />");
            botXmlStr.append("<w:ind w:left=\"0\" w:right=\"0\" />");
            botXmlStr.append("<w:rPr>");
            botXmlStr.append("<w:rFonts w:cs=\"Times New Roman\" w:hAnsi=\"Times New Roman\" w:ascii=\"Times New Roman\"/>");
            botXmlStr.append("<w:sz w:val=\"2\"/><w:szCs w:val=\"2\"/>");
            botXmlStr.append("</w:rPr>");
            botXmlStr.append("</w:pPr>");
            XWPFParagraph bottomPar = null;
            bottomPar = header == null ? this.docx.createParagraph() : header.createParagraph();
            CTP bCTP = bottomPar.getCTP();
            try {
                XmlToken bottomXMLToken = (XmlToken)XmlToken.Factory.parse(botXmlStr.toString());
                bCTP.set((XmlObject)bottomXMLToken);
            }
            catch (XmlException xe) {
                xe.printStackTrace();
            }
        }
    }

    private void generateComponents(Iterable<? extends DocComponent> components, XWPFHeaderFooter header) throws Exception {
        for (DocComponent docComponent : components) {
            switch (docComponent.getType()) {
                case PARAGRAPH: {
                    this.generateParagraph((DocParagraph)docComponent, header, null, 0);
                    break;
                }
                case PageBreak: {
                    this.generatePageBreak();
                    break;
                }
                case TABLE: {
                    this.generateTable((DocTable)docComponent, header);
                    break;
                }
                case TEXT: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0435\u043a\u0441\u0442\u0430 \u0432\u043d\u0435 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430");
                }
            }
        }
    }

    private STPageOrientation.Enum convertToSTPageOrient(ReportPageOrientation val) {
        switch (val) {
            case PORTRAIT: {
                return STPageOrientation.PORTRAIT;
            }
            case LANDSCAPE: {
                return STPageOrientation.LANDSCAPE;
            }
        }
        return STPageOrientation.PORTRAIT;
    }

    private boolean putHeaderFooterText(DocSection section) throws Exception {
        if (section == null || this.docx == null) {
            return false;
        }
        if (section.getAllPagesHeader() != null) {
            this.generateComponents(section.getAllPagesHeader().elements(), (XWPFHeaderFooter)this.defaultHeader);
        }
        if (section.getFirstPageHeader() != null) {
            this.generateComponents(section.getFirstPageHeader().elements(), (XWPFHeaderFooter)this.firstHeader);
        }
        if (section.getOtherPageHeader() != null) {
            this.generateComponents(section.getOtherPageHeader().elements(), (XWPFHeaderFooter)this.defaultHeader);
        }
        if (section.getAllPagesFooter() != null) {
            this.generateComponents(section.getAllPagesFooter().elements(), (XWPFHeaderFooter)this.defaultFooter);
        }
        if (section.getFirstPageFooter() != null) {
            this.generateComponents(section.getFirstPageFooter().elements(), (XWPFHeaderFooter)this.firstFooter);
        }
        if (section.getOtherPageFooter() != null) {
            this.generateComponents(section.getOtherPageFooter().elements(), (XWPFHeaderFooter)this.defaultFooter);
        }
        return true;
    }

    private boolean setPageNumberText(PageNumbers pageNumbers, XWPFHeaderFooter header) {
        XWPFParagraph parag;
        if (pageNumbers == null || header == null) {
            return false;
        }
        if (header.getParagraphs().isEmpty()) {
            header.createParagraph();
        }
        if ((parag = (XWPFParagraph)header.getParagraphs().get(0)).getRuns().isEmpty()) {
            parag.createRun();
        }
        XWPFRun run = (XWPFRun)parag.getRuns().get(0);
        switch (pageNumbers.getAlign()) {
            case 0: {
                parag.setAlignment(ParagraphAlignment.LEFT);
                parag.setIndentFromLeft(this.docXunit(pageNumbers.getMargin()));
                break;
            }
            case 1: {
                parag.setAlignment(ParagraphAlignment.CENTER);
                parag.setIndentFromLeft(this.docXunit(pageNumbers.getMargin()));
                break;
            }
            case 2: {
                parag.setAlignment(ParagraphAlignment.RIGHT);
                parag.setIndentFromRight(this.docXunit(pageNumbers.getMargin()));
            }
        }
        this.fillFontProps(pageNumbers.getFont(), run);
        run.setText(pageNumbers.getCaption());
        CTR ctr = run.getCTR();
        ctr.addNewRPr();
        CTFldChar fch = ctr.addNewFldChar();
        fch.setFldCharType(STFldCharType.BEGIN);
        ctr.addNewInstrText().setStringValue(" PAGE ");
        ctr.addNewFldChar().setFldCharType(STFldCharType.SEPARATE);
        ctr.addNewT().setStringValue("1");
        ctr.addNewFldChar().setFldCharType(STFldCharType.END);
        return true;
    }

    @Override
    public void generateBody(OutputStream out, String encoding) throws Exception {
        try {
            this.docx = new CustomXWPFDocument();
            this.doc.prepareStore();
            String xmlStr = "<w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rFonts w:cs=\"Arial\" w:hAnsi=\"Arial\" w:ascii=\"Arial\"/><w:sz w:val=\"10\"/><w:szCs w:val=\"10\"/></w:rPr>";
            try {
                this.xmlCellParaPrToken = (XmlToken)XmlToken.Factory.parse(xmlStr);
            }
            catch (XmlException xe) {
                xe.printStackTrace();
            }
            CellPositions positions = new CellPositions();
            int idx = 0;
            int count = this.doc.sectionCount();
            CTSectPr firstSectPr = null;
            DocSection firstSect = null;
            PageNumbers pageNumbers = null;
            boolean isTitlePageNumber = false;
            boolean useDefaultHeader = false;
            boolean useDefaultFooter = false;
            boolean useFirstHeader = false;
            boolean useFirstFooter = false;
            boolean specEnumStart = false;
            CTSectPr specEnumStartSectPr = null;
            for (DocSection s : this.doc.sections()) {
                XWPFParagraph paragraph;
                CTSectPr sectPr;
                if (firstSect == null) {
                    firstSect = s;
                }
                s.calculate(positions);
                this.generateComponents(s.elements(), null);
                CTBody body = this.docx.getDocument().getBody();
                if (idx == count - 1) {
                    CTSectPr cTSectPr = sectPr = body.isSetSectPr() ? body.getSectPr() : body.addNewSectPr();
                    if (firstSectPr == null) {
                        firstSectPr = sectPr;
                    }
                    if (s.getBGImageID() != 0.0) {
                        paragraph = this.docx.createParagraph();
                        this.writeBackgroundImage(this.docx, s, paragraph);
                    }
                } else {
                    paragraph = this.docx.createParagraph();
                    if (paragraph.getRuns().isEmpty()) {
                        paragraph.createRun();
                    }
                    XWPFRun run = (XWPFRun)paragraph.getRuns().get(paragraph.getRuns().size() - 1);
                    run.addBreak(BreakType.PAGE);
                    CTPPr pPr = paragraph.getCTP().isSetPPr() ? paragraph.getCTP().getPPr() : paragraph.getCTP().addNewPPr();
                    CTSectPr cTSectPr = sectPr = pPr.isSetSectPr() ? pPr.getSectPr() : pPr.addNewSectPr();
                    if (idx == s.getPageNumbers().enumSection) {
                        specEnumStartSectPr = sectPr;
                    }
                    if (firstSectPr == null) {
                        firstSectPr = sectPr;
                    }
                    this.writeBackgroundImage(this.docx, s, paragraph);
                }
                ++idx;
                CTPageSz pageSz = sectPr.addNewPgSz();
                pageSz.setW((Object)new BigInteger(this.docXunitStr(s.getPageWidth())));
                pageSz.setH((Object)new BigInteger(this.docXunitStr(s.getPageHeight())));
                pageSz.setOrient(this.convertToSTPageOrient(s.getOrientation()));
                CTPageMar pageMar = sectPr.addNewPgMar();
                pageMar.setLeft((Object)new BigInteger(this.docXunitStr(s.margins().getLeft())));
                pageMar.setRight((Object)new BigInteger(this.docXunitStr(s.margins().getRight())));
                pageMar.setBottom((Object)new BigInteger(this.docXunitStr(s.margins().getBottom())));
                pageMar.setTop((Object)new BigInteger(this.docXunitStr(s.margins().getTop())));
                pageMar.setHeader((Object)new BigInteger(this.docXunitStr(s.getHeaderMargin())));
                pageMar.setFooter((Object)new BigInteger(this.docXunitStr(s.getFooterMargin())));
                pageNumbers = s.getPageNumbers();
                if (pageNumbers != null && pageNumbers.enabled) {
                    if (pageNumbers.enumSection >= 0) {
                        specEnumStart = true;
                    } else if (!pageNumbers.fromFirstPage) {
                        this._useTitlePage = true;
                    } else {
                        isTitlePageNumber = true;
                    }
                }
                if (s.getAllPagesHeader() != null) {
                    useDefaultHeader = true;
                }
                if (s.getAllPagesFooter() != null) {
                    useDefaultFooter = true;
                }
                if (s.getAllPagesHeader() != null || s.getAllPagesFooter() != null) continue;
                if (s.getFirstPageHeader() != null) {
                    useFirstHeader = true;
                }
                if (s.getFirstPageFooter() != null) {
                    useFirstFooter = true;
                }
                if (s.getOtherPageHeader() != null) {
                    useDefaultHeader = true;
                }
                if (s.getOtherPageFooter() != null) {
                    useDefaultFooter = true;
                }
                if (count == 1 && isTitlePageNumber && (s.getFirstPageHeader() == null || s.getOtherPageHeader() == null || s.getFirstPageFooter() == null || s.getOtherPageFooter() == null)) continue;
                this._useTitlePage = true;
            }
            if (firstSect != null) {
                this.docx.setZoomPercent(firstSect.getZoom());
            }
            if (this._useTitlePage && firstSectPr != null) {
                firstSectPr.addNewTitlePg();
            }
            if (count > 1) {
                CTSectPr lastSectPr;
                int relHdrFtrIdx = this.docx.getRelationParts().size();
                if (useDefaultHeader) {
                    this.defaultHeader = this.docx.createHeader(HeaderFooterType.DEFAULT);
                    if (!specEnumStart && firstSectPr != null) {
                        CTHdrFtrRef refDefHdr = firstSectPr.addNewHeaderReference();
                        refDefHdr.setType(STHdrFtr.DEFAULT);
                        refDefHdr.setId(((POIXMLDocumentPart.RelationPart)this.docx.getRelationParts().get(relHdrFtrIdx++)).getRelationship().getId());
                    }
                }
                if (useDefaultFooter) {
                    this.defaultFooter = this.docx.createFooter(HeaderFooterType.DEFAULT);
                    if (!specEnumStart && firstSectPr != null) {
                        CTHdrFtrRef refDefFtr = firstSectPr.addNewFooterReference();
                        refDefFtr.setType(STHdrFtr.DEFAULT);
                        refDefFtr.setId(((POIXMLDocumentPart.RelationPart)this.docx.getRelationParts().get(relHdrFtrIdx++)).getRelationship().getId());
                    }
                }
                if (this._useTitlePage) {
                    if (useFirstHeader && firstSectPr != null) {
                        this.firstHeader = this.docx.createHeader(HeaderFooterType.FIRST);
                        if (!specEnumStart) {
                            CTHdrFtrRef refFHdr = firstSectPr.addNewHeaderReference();
                            refFHdr.setType(STHdrFtr.FIRST);
                            refFHdr.setId(((POIXMLDocumentPart.RelationPart)this.docx.getRelationParts().get(relHdrFtrIdx++)).getRelationship().getId());
                        }
                    }
                    if (useFirstFooter && firstSectPr != null) {
                        this.firstFooter = this.docx.createFooter(HeaderFooterType.FIRST);
                        if (!specEnumStart) {
                            CTHdrFtrRef refFFtr = firstSectPr.addNewFooterReference();
                            refFFtr.setType(STHdrFtr.FIRST);
                            refFFtr.setId(((POIXMLDocumentPart.RelationPart)this.docx.getRelationParts().get(relHdrFtrIdx++)).getRelationship().getId());
                        }
                    }
                }
                if ((lastSectPr = this.docx.getDocument().getBody().getSectPr()) != firstSectPr && lastSectPr.isSetTitlePg()) {
                    lastSectPr.getTitlePg().unsetVal();
                }
            } else {
                if (useDefaultHeader) {
                    this.defaultHeader = this.docx.createHeader(HeaderFooterType.DEFAULT);
                }
                if (useDefaultFooter) {
                    this.defaultFooter = this.docx.createFooter(HeaderFooterType.DEFAULT);
                }
                if (this._useTitlePage) {
                    if (useFirstHeader) {
                        this.firstHeader = this.docx.createHeader(HeaderFooterType.FIRST);
                    }
                    if (useFirstFooter) {
                        this.firstFooter = this.docx.createFooter(HeaderFooterType.FIRST);
                    }
                }
            }
            if (pageNumbers != null && pageNumbers.enabled) {
                XWPFHeader hfFirst;
                XWPFHeader hfDefault;
                CTHdrFtrRef refDefFtr = null;
                if (pageNumbers.location == 0) {
                    hfDefault = this.defaultHeader;
                    hfFirst = this.firstHeader;
                    if (specEnumStart) {
                        refDefFtr = specEnumStartSectPr.addNewHeaderReference();
                    }
                } else {
                    hfDefault = this.defaultFooter;
                    hfFirst = this.firstFooter;
                    if (specEnumStart) {
                        refDefFtr = specEnumStartSectPr.addNewFooterReference();
                    }
                }
                if (refDefFtr != null) {
                    refDefFtr.setType(STHdrFtr.DEFAULT);
                    refDefFtr.setId(((POIXMLDocumentPart.RelationPart)this.docx.getRelationParts().get(this.docx.getRelationParts().size() - 1)).getRelationship().getId());
                    CTPageNumber ctPageNumber = specEnumStartSectPr.addNewPgNumType();
                    ctPageNumber.setStart(BigInteger.valueOf(1L));
                }
                this.setPageNumberText(pageNumbers, (XWPFHeaderFooter)hfDefault);
                if (!this._useTitlePage) {
                    this.setPageNumberText(pageNumbers, (XWPFHeaderFooter)hfFirst);
                }
            }
            for (DocSection s : this.doc.sections()) {
                this.putHeaderFooterText(s);
            }
            XWPFStyles styles = this.docx.getStyles();
            if (styles == null) {
                styles = this.docx.createStyles();
            }
            styles.setSpellingLanguage("ru-RU");
            this.docx.write(out);
            this.docx.close();
        }
        catch (InvocationTargetException e) {
            throw InformException.wrap(e, "\u0412 JDK \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 Freetype \u0438 Fontconfig!");
        }
    }

    private String docXunitStr(double mm) {
        return "" + (int)(mm < 0.0 ? 0.0 : mm * 56.694);
    }

    private int docXunit(double mm) {
        return (int)(mm < 0.0 ? 0.0 : mm * 56.694);
    }
}

