/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.generators;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.AbstractHash;
import inform.adt.collections.Hashing;
import inform.agent.web.reports.controls.PageNumbers;
import inform.agent.web.reports.controls.ReportPageOrientation;
import inform.agent.web.reports.document.DocBorders;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.IDocumentElement;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.ImageInfo;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.TextOrientation;
import inform.agent.web.utils.VerticalAlign;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ODTGenerator
implements WebReportGenerator {
    private static final int WRITING_TARGET_BODY = 0;
    private static final int WRITING_TARGET_HEADER = 1;
    private static final int WRITING_TARGET_FOOTER = 2;
    private static final int HEADERFOOTER_FIRST = 0;
    private static final int HEADERFOOTER_NEXT = 1;
    private static final int HEADERFOOTER_ALL = 2;
    private static final double K_MMP096 = 3.593;
    private final Document doc;
    private final String caption;
    private int _headerFooterKind = 2;
    private int _styleIndex = 0;
    private int _sectionIndex = 0;
    private int _enumStart = -1;
    private int _writingTarget = 0;
    private boolean _transportHeader = false;
    private boolean _tableHeaderOpen = false;
    private boolean _isTitlePage = false;
    private boolean _isLink = false;
    private boolean _sectionBodyStarted = false;
    private boolean _headerStarted = false;
    private boolean _footerStarted = false;
    private boolean _isEmptyBody = false;
    private int _zoom = 100;
    private int _prevColIndex = 0;
    private int _tableColCount = 1;
    private boolean _bodyParagStarted = false;
    private boolean _tableCellStarted = false;
    private DocSection _firstSection = null;
    private final CellStyleTable _cellStyleTable = new CellStyleTable();
    private final RowStyleTable _rowStyleTable = new RowStyleTable();
    private final TextStyleTable _textStyleTable = new TextStyleTable();
    private final ParagraphStyleTable _paragraphStyleTable = new ParagraphStyleTable();
    private final ImageDef _imageDef = new ImageDef();
    private ZipOutputStream _zipOutputStream = null;
    private final StringBuilder _manifestContent = new StringBuilder();
    private final StringBuilder _contentHeadContent = new StringBuilder();
    private final StringBuilder _contentAutomaticStylesContent = new StringBuilder();
    private final StringBuilder _contentBodyContent = new StringBuilder();
    private final StringBuilder _stylesHeadContent = new StringBuilder();
    private final StringBuilder _stylesAutomaticStylesContent = new StringBuilder();
    private final StringBuilder _stylesMasterStylesContent = new StringBuilder();
    private final StringBuilder _titlePageHeaderFooter = new StringBuilder();
    private final StringBuilder _nextPagesHeaderFooter = new StringBuilder();
    private final ArrayList<String> _mediaFileNames = new ArrayList();
    private String bgImageFileName = "";
    private String pageNumberTag = "<text:page-number/>";

    public ODTGenerator(Document doc, String caption) throws Exception {
        this.doc = doc;
        this.caption = URLEncoder.encode(caption, "UTF-8").replace('+', ' ');
    }

    @Override
    public void generateHeaders(HttpServletResponse resp) throws Exception {
        resp.setContentType("application/vnd.oasis.opendocument.text ");
        resp.setHeader("Content-disposition", String.format("attachment; filename*=\"utf8'ru-ru'%s.odt\"", this.caption.isEmpty() ? "noname" : this.caption));
    }

    @Override
    public void generateBody(OutputStream out, String encoding) throws Exception {
        this._zipOutputStream = new ZipOutputStream(out);
        this._zipOutputStream.setMethod(8);
        this._manifestContent.append(this.getManifestTemplate());
        this._contentHeadContent.append(this.getContentTemplate());
        this._contentAutomaticStylesContent.append("<office:automatic-styles>");
        this._contentBodyContent.append("<office:body><office:text text:use-soft-page-breaks=\"true\">");
        this._stylesHeadContent.append(this.getStylesTemplate());
        this._stylesAutomaticStylesContent.append("<office:automatic-styles>");
        this._stylesMasterStylesContent.append("<office:master-styles>");
        this.putBGImage();
        this.startFooterHeaderBuilding();
        for (DocSection s : this.doc.sections()) {
            this.beginSection(s);
            if (this._firstSection == null) {
                this._firstSection = s;
                this._zoom = this._firstSection.getZoom();
                if (this._firstSection.getFirstPageHeader() != null) {
                    this._isTitlePage = true;
                    this._headerFooterKind = 0;
                    this.beginSectionHeader();
                    this.generateComponents(this._firstSection.getFirstPageHeader().elements());
                    this.endSectionHeader();
                }
                if (this._firstSection.getOtherPageHeader() != null) {
                    this._isTitlePage = true;
                    this._headerFooterKind = 1;
                    this.beginSectionHeader();
                    this.generateComponents(this._firstSection.getOtherPageHeader().elements());
                    this.endSectionHeader();
                } else if (this._firstSection.getAllPagesHeader() != null) {
                    this._headerFooterKind = 2;
                    this.beginSectionHeader();
                    this.generateComponents(this._firstSection.getAllPagesHeader().elements());
                    this.endSectionHeader();
                }
                if (this._firstSection.getFirstPageFooter() != null) {
                    this._isTitlePage = true;
                    this._headerFooterKind = 0;
                    this.beginSectionFooter();
                    this.generateComponents(this._firstSection.getFirstPageFooter().elements());
                    this.endSectionFooter();
                }
                if (this._firstSection.getOtherPageFooter() != null) {
                    this._isTitlePage = true;
                    this._headerFooterKind = 1;
                    this.beginSectionFooter();
                    this.generateComponents(this._firstSection.getOtherPageFooter().elements());
                    this.endSectionFooter();
                } else if (this._firstSection.getAllPagesFooter() != null) {
                    this._headerFooterKind = 2;
                    this.beginSectionFooter();
                    this.generateComponents(this._firstSection.getAllPagesFooter().elements());
                    this.endSectionFooter();
                }
            }
            this.beginSectionBody();
            this.generateComponents(s.elements());
            this.endSectionBody();
            this.endSection();
        }
        this.finishFooterHeaderBuilding();
        this._stylesAutomaticStylesContent.append("</office:automatic-styles>");
        this._stylesMasterStylesContent.append("</office:master-styles></office:document-styles>");
        this._contentAutomaticStylesContent.append(this.getBGImageStyleTemplate());
        this._contentAutomaticStylesContent.append("</office:automatic-styles>");
        this._contentBodyContent.append("</office:text></office:body></office:document-content>");
        this._manifestContent.append("</manifest:manifest>");
        this.putMimeType();
        this.putMeta();
        this.putSettings();
        this.putStyles();
        this.putContent();
        this.putManifest();
        this.putMedia();
        this._zipOutputStream.finish();
    }

    private void putBGImage() throws Exception {
        DocSection section = null;
        int index = 1;
        for (DocSection s : this.doc.sections()) {
            if (section == null) {
                section = s;
            }
            if (section.getBGImageID() != 0.0) {
                if (index == 0) {
                    this.writeBGImage(section, index);
                } else if (!section.getBGOnlyFirstPage()) {
                    this.writeBGImage(section, index);
                }
            }
            ++index;
        }
    }

    private void beginSection(DocSection section) throws Exception {
        this._isLink = false;
        this._stylesAutomaticStylesContent.append(this.getStylePageLayout(section));
        this._sectionBodyStarted = false;
    }

    private void beginSectionBody() {
        this._writingTarget = 0;
        this._isEmptyBody = true;
        this._sectionBodyStarted = true;
    }

    private void writePageNumber(PageNumbers pageNumber) throws Exception {
        StringBuilder style = new StringBuilder();
        StringBuilder text = new StringBuilder();
        Font font = pageNumber.getFont();
        ++this._styleIndex;
        this._enumStart = pageNumber.enumSection >= 0 ? pageNumber.enumSection : -1;
        style.append(String.format("<style:style style:name=\"P%d\"", this._styleIndex));
        style.append(" style:family=\"paragraph\">");
        style.append(" <style:paragraph-properties");
        String buffer = ODTGenerator.getInchStrFromMM(pageNumber.getMargin());
        style.append(String.format(" fo:margin-left=\"%sin\"", buffer));
        switch (pageNumber.getAlign()) {
            case 1: {
                buffer = "center";
                break;
            }
            case 2: {
                buffer = "right";
                break;
            }
            default: {
                buffer = "left";
            }
        }
        style.append(String.format(" fo:text-align=\"%s\"", buffer));
        style.append("/></style:style>");
        this._stylesAutomaticStylesContent.append(style.toString());
        text.append(String.format("<text:p text:style-name=\"P%d\">", this._styleIndex));
        style = new StringBuilder();
        ++this._styleIndex;
        style.append(String.format("<style:style style:name=\"T%d\"", this._styleIndex));
        style.append(" style:family=\"text\">");
        style.append("<style:text-properties");
        buffer = ODTGenerator.getColorString(font.getColor());
        if (!buffer.isEmpty()) {
            style.append(String.format(" fo:color=\"%s\"", buffer));
        }
        style.append(String.format(" fo:font-family=\"%s\"", font.getName()));
        style.append(String.format(" fo:font-size=\"%dpt\"", font.getSize()));
        buffer = "normal";
        if ((font.getStyle() & 2) != 0) {
            buffer = "italic";
        }
        style.append(String.format(" fo:font-style=\"%s\"", buffer));
        buffer = "normal";
        if ((font.getStyle() & 1) != 0) {
            buffer = "bold";
        }
        style.append(String.format(" fo:font-weight=\"%s\"", buffer));
        style.append(String.format(" style:font-name=\"%s\"", font.getName()));
        if ((font.getStyle() & 8) != 0) {
            style.append(" style:text-line-through-type=\"single\" style:text-line-through-style=\"solid\"");
        }
        buffer = "none";
        if ((font.getStyle() & 4) != 0) {
            buffer = "solid";
        }
        style.append(String.format(" style:text-underline-style=\"%s\"", buffer));
        if (buffer.equals("solid")) {
            style.append(" style:text-underline-color=\"font-color\"");
            style.append(" style:text-underline-mode=\"continuous\"");
        }
        style.append("/></style:style>");
        this._stylesAutomaticStylesContent.append(style.toString());
        text.append(String.format("<text:span text:style-name=\"T%d\">", this._styleIndex));
        text.append(this._enumStart >= 0 ? "%s" : this.pageNumberTag);
        text.append("</text:span>");
        text.append("</text:p>");
        this._nextPagesHeaderFooter.append(text.toString());
        if (pageNumber.getFromFirstPage()) {
            this._titlePageHeaderFooter.append(text.toString());
        }
    }

    private void beginSectionFooter() throws Exception {
        this._footerStarted = true;
        this._writingTarget = 2;
        if (this._headerFooterKind == 2) {
            this._titlePageHeaderFooter.append("<style:footer>");
            this._nextPagesHeaderFooter.append("<style:footer>");
        } else if (this._headerFooterKind == 0) {
            this._titlePageHeaderFooter.append("<style:footer>");
        } else {
            this._nextPagesHeaderFooter.append("<style:footer>");
        }
        PageNumbers pageNumber = this._firstSection.getPageNumbers();
        if (pageNumber.enabled && pageNumber.location == 1) {
            this.writePageNumber(pageNumber);
        }
    }

    private void beginSectionHeader() throws Exception {
        this._headerStarted = true;
        this._writingTarget = 1;
        if (this._headerFooterKind == 2) {
            this._titlePageHeaderFooter.append("<style:header>");
            this._nextPagesHeaderFooter.append("<style:header>");
        } else if (this._headerFooterKind == 0) {
            this._titlePageHeaderFooter.append("<style:header>");
        } else {
            this._nextPagesHeaderFooter.append("<style:header>");
        }
        PageNumbers pageNumber = this._firstSection.getPageNumbers();
        if (pageNumber.enabled && pageNumber.location == 0) {
            this.writePageNumber(pageNumber);
        }
    }

    private void endSection() {
        if (this._sectionBodyStarted) {
            this.endSectionBody();
        }
        ++this._sectionIndex;
    }

    private void endSectionBody() {
        if (this._isEmptyBody) {
            // empty if block
        }
        this._sectionBodyStarted = false;
    }

    private void endSectionFooter() throws Exception {
        if (this._headerFooterKind == 2) {
            this._titlePageHeaderFooter.append("</style:footer>");
            this._nextPagesHeaderFooter.append("</style:footer>");
        } else if (this._headerFooterKind == 0) {
            this._titlePageHeaderFooter.append("</style:footer>");
        } else {
            this._nextPagesHeaderFooter.append("</style:footer>");
        }
        this._footerStarted = false;
    }

    private void endSectionHeader() throws Exception {
        if (this._headerFooterKind == 2) {
            this._titlePageHeaderFooter.append("</style:header>");
            this._nextPagesHeaderFooter.append("</style:header>");
        } else if (this._headerFooterKind == 0) {
            this._titlePageHeaderFooter.append("</style:header>");
        } else {
            this._nextPagesHeaderFooter.append("</style:header>");
        }
        this._headerStarted = false;
    }

    private void putMimeType() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("mimetype"));
        this._zipOutputStream.write("application/vnd.oasis.opendocument.text".getBytes("UTF-8"));
    }

    private void putMeta() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("meta.xml"));
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<office:document-meta");
        content.append("    xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        content.append("    xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"");
        content.append("    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        content.append("    xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
        content.append("    office:version=\"1.1\">");
        content.append("    <office:meta>");
        content.append("        <meta:generator>ASMO</meta:generator>");
        content.append("        <meta:initial-creator>");
        content.append("        </meta:initial-creator>");
        content.append("        <dc:creator>");
        content.append("        </dc:creator>");
        content.append("        <meta:creation-date>");
        content.append(DateTime.toString(DateTime.currentDate()));
        content.append("        </meta:creation-date>");
        content.append("        <dc:date></dc:date>");
        content.append("        <meta:template xlink:href=\"Normal\" xlink:type=\"simple\"/>");
        content.append("    </office:meta>");
        content.append("</office:document-meta>");
        this._zipOutputStream.write(content.toString().getBytes("UTF-8"));
    }

    private void putSettings() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("settings.xml"));
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<office:document-settings");
        content.append("    office:version=\"1.1\"");
        content.append("    xmlns:anim=\"urn:oasis:names:tc:opendocument:xmlns:animation:1.0\"");
        content.append("    xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\"");
        content.append("    xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\"");
        content.append("    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        content.append("    xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\"");
        content.append("    xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\"");
        content.append("    xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"");
        content.append("    xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\"");
        content.append("    xmlns:math=\"http://www.w3.org/1998/Math/MathML\"");
        content.append("    xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"");
        content.append("    xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\"");
        content.append("    xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        content.append("    xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\"");
        content.append("    xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\"");
        content.append("    xmlns:smil=\"urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0\"");
        content.append("    xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"");
        content.append("    xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\"");
        content.append("    xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\"");
        content.append("    xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\"");
        content.append("    xmlns:xforms=\"http://www.w3.org/2002/xforms\"");
        content.append("    xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        content.append("    <office:settings>");
        content.append("        <config:config-item-set config:name=\"ooo:view-settings\">");
        content.append("            <config:config-item config:name=\"InBrowseMode\" config:type=\"boolean\">false</config:config-item>");
        content.append("            <config:config-item-map-indexed config:name=\"Views\">");
        content.append("                <config:config-item-map-entry>");
        content.append("                    <config:config-item config:name=\"ViewId\" config:type=\"string\">view2</config:config-item>");
        content.append("                    <config:config-item config:name=\"ZoomType\" config:type=\"short\">0</config:config-item>");
        content.append("                    <config:config-item config:name=\"ViewLayoutColumns\" config:type=\"short\">1</config:config-item>");
        content.append("                    <config:config-item config:name=\"ViewLayoutBookMode\" config:type=\"boolean\">false</config:config-item>");
        content.append(String.format("      <config:config-item config:name=\"ZoomFactor\" config:type=\"short\">%d</config:config-item>", this._zoom));
        content.append("                    <config:config-item config:name=\"IsSelectedFrame\" config:type=\"boolean\">false</config:config-item>");
        content.append("                </config:config-item-map-entry>");
        content.append("            </config:config-item-map-indexed>");
        content.append("        </config:config-item-set>");
        content.append("    </office:settings>");
        content.append("</office:document-settings>");
        this._zipOutputStream.write(content.toString().getBytes("UTF-8"));
    }

    private String getBGImageStyleTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("<style:style style:name=\"fr1\" style:parent-style-name=\"Graphics\"");
        content.append(" style:family=\"graphic\">");
        content.append("<style:graphic-properties");
        content.append(" draw:color-mode=\"standard\" draw:image-opacity=\"100%\"");
        content.append(" draw:color-inversion=\"false\" draw:gamma=\"100%\"");
        content.append(" draw:blue=\"0%\" draw:green=\"0%\" draw:red=\"0%\"");
        content.append(" draw:contrast=\"0%\" draw:luminance=\"0%\"");
        content.append(" fo:clip=\"rect(0cm, 0cm, 0cm, 0cm)\"");
        content.append(" style:mirror=\"none\" draw:shadow-opacity=\"100%\"");
        content.append(" style:shadow=\"none\" draw:fill-image-height=\"0cm\"");
        content.append(" draw:fill-image-width=\"0cm\" style:horizontal-rel=\"paragraph\"");
        content.append(" style:horizontal-pos=\"center\" style:vertical-rel=\"page\"");
        content.append(" style:vertical-pos=\"top\" style:number-wrapped-paragraphs=\"no-limit\"");
        content.append(" style:wrap=\"run-through\" style:run-through=\"background\"");
        content.append(String.format(" fo:margin-bottom=\"0cm\" fo:margin-top=\"%.0fcm\"", this._firstSection.getBGTop() / 10.0));
        content.append(String.format(" fo:margin-right=\"0cm\" fo:margin-left=\"%.0fcm\"/>", this._firstSection.getBGLeft() / 10.0));
        content.append("</style:style>");
        return content.toString();
    }

    private String getStylesTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<office:document-styles");
        content.append("    xmlns:anim=\"urn:oasis:names:tc:opendocument:xmlns:animation:1.0\"");
        content.append("    xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\"");
        content.append("    xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\"");
        content.append("    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        content.append("    xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\"");
        content.append("    xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\"");
        content.append("    xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"");
        content.append("    xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\"");
        content.append("    xmlns:math=\"http://www.w3.org/1998/Math/MathML\"");
        content.append("    xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"");
        content.append("    xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\"");
        content.append("    xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        content.append("    xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\"");
        content.append("    xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\"");
        content.append("    xmlns:smil=\"urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0\"");
        content.append("    xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"");
        content.append("    xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\"");
        content.append("    xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\"");
        content.append("    xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\"");
        content.append("    xmlns:xforms=\"http://www.w3.org/2002/xforms\"");
        content.append("    xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        content.append("<office:styles>");
        content.append("<style:style");
        content.append("    style:name=\"LineBreak\"");
        content.append("    style:family=\"paragraph\"");
        content.append("    style:display-name=\"LineBreak\">");
        content.append("<style:paragraph-properties");
        content.append("    fo:break-before=\"page\"/>");
        content.append("</style:style>");
        content.append("<style:style");
        content.append("    style:name=\"ImageInsertion\"");
        content.append("    style:family=\"graphic\"");
        content.append("    style:parent-style-name=\"Graphics\">");
        content.append("<style:graphic-properties");
        content.append("    draw:color-mode=\"standard\"");
        content.append("    draw:image-opacity=\"100%\"");
        content.append("    draw:color-inversion=\"false\"");
        content.append("    draw:gamma=\"100%\"");
        content.append("    draw:blue=\"0%\"");
        content.append("    draw:green=\"0%\"");
        content.append("    draw:red=\"0%\"");
        content.append("    draw:contrast=\"0%\"");
        content.append("    draw:luminance=\"0%\"");
        content.append("    fo:clip=\"rect(0cm, 0cm, 0cm, 0cm)\"");
        content.append("    style:mirror=\"none\"");
        content.append("    style:horizontal-rel=\"paragraph\"");
        content.append("    style:horizontal-pos=\"from-left\"");
        content.append("    style:vertical-rel=\"paragraph\"");
        content.append("    style:vertical-pos=\"from-top\"/>");
        content.append("</style:style>");
        content.append("</office:styles>");
        return content.toString();
    }

    private String getManifestTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<manifest:manifest");
        content.append("    xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\">");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"/\"");
        content.append("        manifest:media-type=\"application/vnd.oasis.opendocument.text\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"META-INF/manifest.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"content.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"meta.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"settings.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"mimetype\"");
        content.append("        manifest:media-type=\"text/plain\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"styles.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        return content.toString();
    }

    private String getContentTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<office:document-content");
        content.append("    xmlns:anim=\"urn:oasis:names:tc:opendocument:xmlns:animation:1.0\"");
        content.append("    xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\"");
        content.append("    xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\"");
        content.append("    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        content.append("    xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\"");
        content.append("    xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\"");
        content.append("    xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"");
        content.append("    xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\"");
        content.append("    xmlns:math=\"http://www.w3.org/1998/Math/MathML\"");
        content.append("    xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"");
        content.append("    xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\"");
        content.append("    xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        content.append("    xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\"");
        content.append("    xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\"");
        content.append("    xmlns:smil=\"urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0\"");
        content.append("    xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"");
        content.append("    xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\"");
        content.append("    xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\"");
        content.append("    xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\"");
        content.append("    xmlns:xforms=\"http://www.w3.org/2002/xforms\"");
        content.append("    xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        return content.toString();
    }

    private void putStyles() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("styles.xml"));
        this._zipOutputStream.write(this._stylesHeadContent.toString().getBytes("UTF-8"));
        this._zipOutputStream.write(this._stylesAutomaticStylesContent.toString().getBytes("UTF-8"));
        this._zipOutputStream.write(this._stylesMasterStylesContent.toString().getBytes("UTF-8"));
    }

    private void putContent() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("content.xml"));
        this._zipOutputStream.write(this._contentHeadContent.toString().getBytes("UTF-8"));
        this._zipOutputStream.write(this._contentAutomaticStylesContent.toString().getBytes("UTF-8"));
        this._zipOutputStream.write(this._contentBodyContent.toString().getBytes("UTF-8"));
    }

    private void putManifest() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("META-INF/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("META-INF/manifest.xml"));
        this._zipOutputStream.write(this._manifestContent.toString().getBytes("UTF-8"));
    }

    private void putMedia() throws Exception {
        if (!this._mediaFileNames.isEmpty()) {
            this._zipOutputStream.putNextEntry(new ZipEntry("media/"));
            for (int i = 0; i < this._mediaFileNames.size(); ++i) {
                this._zipOutputStream.putNextEntry(new ZipEntry("media/" + this._mediaFileNames.get(i)));
                this._zipOutputStream.write(this.doc.getImageContent(i));
            }
        }
    }

    private void startFooterHeaderBuilding() throws Exception {
        this._titlePageHeaderFooter.append("<style:master-page style:name=\"MPF0\" style:page-layout-name=\"PL0\" style:next-style-name=\"MP0\">");
        this._nextPagesHeaderFooter.append("<style:master-page style:name=\"MP%d\" style:page-layout-name=\"PL%d\">");
    }

    private void finishFooterHeaderBuilding() throws Exception {
        this._titlePageHeaderFooter.append("</style:master-page>");
        this._nextPagesHeaderFooter.append("</style:master-page>");
        if (this._isTitlePage) {
            this._stylesMasterStylesContent.append((CharSequence)this._titlePageHeaderFooter);
        }
        for (int i = 0; i < this._sectionIndex; ++i) {
            if (this._enumStart < 0) {
                this._stylesMasterStylesContent.append(String.format(this._nextPagesHeaderFooter.toString(), i, i));
                continue;
            }
            this._stylesMasterStylesContent.append(String.format(this._nextPagesHeaderFooter.toString(), i, i, this._enumStart <= i ? this.pageNumberTag : ""));
        }
    }

    private String getStylePageLayout(DocSection section) throws Exception {
        StringBuilder content = new StringBuilder();
        content.append(String.format("<style:page-layout style:name=\"PL%d\">", this._sectionIndex));
        content.append("<style:page-layout-properties");
        String buffer = section.getOrientation() == ReportPageOrientation.PORTRAIT ? "portrait" : "landscape";
        content.append(String.format(" style:print-orientation=\"%s\"", buffer));
        buffer = ODTGenerator.getInchStrFromMM(section.getPageWidth());
        content.append(String.format(" fo:page-width=\"%sin\"", buffer));
        buffer = ODTGenerator.getInchStrFromMM(section.getPageHeight());
        content.append(String.format(" fo:page-height=\"%sin\"", buffer));
        buffer = ODTGenerator.getInchStrFromMM(section.margins().getLeft());
        content.append(String.format(" fo:margin-left=\"%sin\"", buffer));
        buffer = ODTGenerator.getInchStrFromMM(section.margins().getRight());
        content.append(String.format(" fo:margin-right=\"%sin\"", buffer));
        buffer = ODTGenerator.getInchStrFromMM(section.margins().getTop());
        content.append(String.format(" fo:margin-top=\"%sin\"", buffer));
        buffer = ODTGenerator.getInchStrFromMM(section.margins().getBottom());
        content.append(String.format(" fo:margin-bottom=\"%sin\"", buffer));
        content.append(" style:num-format=\"1\"");
        content.append("></style:page-layout-properties>");
        content.append("<style:header-style>");
        content.append("<style:header-footer-properties");
        content.append(" style:dynamic-spacing=\"true\"/>");
        content.append("</style:header-style>");
        content.append("<style:footer-style>");
        content.append("<style:header-footer-properties");
        content.append(" style:dynamic-spacing=\"true\"/>");
        content.append("</style:footer-style>");
        content.append("</style:page-layout>");
        return content.toString();
    }

    private void generatePageBreak() throws Exception {
        this._contentBodyContent.append("<text:p text:style-name=\"LineBreak\"/>");
    }

    private void generateComponents(Iterable<? extends DocComponent> components) throws Exception {
        for (DocComponent docComponent : components) {
            switch (docComponent.getType()) {
                case PARAGRAPH: {
                    this.generateParagraph((DocParagraph)docComponent);
                    break;
                }
                case PageBreak: {
                    this.generatePageBreak();
                    break;
                }
                case TABLE: {
                    this.generateTable((DocTable)docComponent);
                    break;
                }
                case TEXT: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0435\u043a\u0441\u0442\u0430 \u0432\u043d\u0435 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430");
                }
            }
        }
    }

    private void beginParagraph(DocParagraph p) throws Exception {
        if (!(this._headerStarted || this._footerStarted || this._sectionBodyStarted)) {
            this.beginSectionBody();
        }
        this._bodyParagStarted = true;
        ParagraphStyleEntry entry = this._paragraphStyleTable.add(p, this._isTitlePage && this._sectionIndex == 0, this._isLink, this._writingTarget == 0, this._sectionIndex);
        if (!this._isLink && this._writingTarget == 0) {
            this._isLink = true;
        }
        String buffer = String.format("<text:p text:style-name=\"%s\">", entry.getStyleName());
        if (this._writingTarget == 0) {
            if (!entry._isExists) {
                this._contentAutomaticStylesContent.append(entry.getStyleDef());
            }
        } else if (!entry._isExists) {
            this._stylesAutomaticStylesContent.append(entry.getStyleDef());
        }
        this.appendContent(buffer);
        this._imageDef.horzAlign = p.align();
    }

    private void endParagraph() throws Exception {
        String buffer = "</text:p>";
        this.appendContent(buffer);
        this._bodyParagStarted = false;
    }

    private String changeSpecSymb(String text) throws Exception {
        int i;
        if (text.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int count = text.length();
        boolean isSpace = text.charAt(0) == ' ';
        int spaceCount = 0;
        if (isSpace) {
            for (i = 0; i < count && (text.charAt(i) == ' ' || text.charAt(0) == '\t'); ++i) {
                ++spaceCount;
            }
            result.append(String.format("<text:s text:c=\"%d\"/>", spaceCount));
        }
        block8: for (i = 0; i < count; ++i) {
            char replacement = text.charAt(i);
            switch (replacement) {
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '\n': {
                    result.append("<text:line-break/>");
                    continue block8;
                }
                case '\t': {
                    result.append("<text:tab/>");
                    continue block8;
                }
                default: {
                    result.append(replacement);
                }
            }
        }
        return result.toString();
    }

    private void writeText(DocText text) throws Exception {
        String buffer;
        TextStyleEntry entry = this._textStyleTable.add(text.getFont(), text.getColor(), this._writingTarget == 0);
        if (!entry._isExists) {
            if (this._writingTarget == 0) {
                this._contentAutomaticStylesContent.append(entry.getStyleDef());
            } else {
                this._stylesAutomaticStylesContent.append(entry.getStyleDef());
            }
        }
        switch (text.getDocumentWriterFiedKind()) {
            case 2: {
                buffer = String.format("<text:page-count text:style-name=\"%s\"></text:page-count>", entry.getStyleName());
                break;
            }
            case 1: {
                buffer = String.format("<text:page-number text:style-name=\"%s\"></text:page-number>", entry.getStyleName());
                break;
            }
            default: {
                buffer = String.format("<text:span text:style-name=\"%s\">%s</text:span>", entry.getStyleName(), this.changeSpecSymb(text.getText()));
            }
        }
        this.appendContent(buffer);
    }

    private void writeBGImage(DocSection section, int index) throws Exception {
        byte[] data = section.getBGImageContent();
        if (data == null) {
            return;
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(data);
        ImageInfo ii = new ImageInfo();
        ii.setInput(bs);
        if (!ii.check()) {
            throw new Exception("Unsupported image format");
        }
        if (this.bgImageFileName.isEmpty()) {
            DocImage im = new DocImage((IDocumentElement)this.doc);
            im.setImageContent(data);
            this.doc.addImage(im);
        }
        int pixelWidth = ii.getWidth();
        int pixelHeight = ii.getHeight();
        double width = section.getBGWidth();
        double height = section.getBGHeight();
        if (height == 0.0 || width == 0.0) {
            width = ODTGenerator.strangePixelsToMM(pixelWidth);
            height = ODTGenerator.strangePixelsToMM(pixelHeight);
        }
        StringBuilder style = new StringBuilder();
        if (this.bgImageFileName.isEmpty()) {
            this.bgImageFileName = String.format("image%d.%s", this.doc.getLastImageId(), ii.getFormatName());
            this._mediaFileNames.add(this.bgImageFileName);
            style.append("<manifest:file-entry");
            style.append(String.format(" manifest:media-type=\"%s\"", ii.getMimeType()));
            style.append(String.format(" manifest:full-path=\"media/%s\"", this.bgImageFileName));
            style.append("/>");
            this._manifestContent.append(style.toString());
        }
        style = new StringBuilder();
        style.append("<draw:frame text:anchor-type=\"page\"");
        style.append(String.format(" text:anchor-page-number=\"%d\"", index));
        style.append(" draw:style-name=\"fr1\"");
        style.append(String.format(" svg:width=\"%.0fmm\"", width));
        style.append(String.format(" svg:height=\"%.0fmm\">", height));
        style.append("<draw:image xlink:actuate=\"onLoad\"");
        style.append(" xlink:show=\"embed\" xlink:type=\"simple\"");
        style.append(String.format(" xlink:href=\"media/%s\"/>", this.bgImageFileName));
        style.append("</draw:frame>");
        this.appendContent(style.toString());
    }

    private void insertPicture(DocImage im) throws Exception {
        byte[] data = im.getImageContent();
        if (data == null) {
            return;
        }
        ImageInfo ii = new ImageInfo();
        String mimeType = "";
        String fileExt = "";
        if (im.getImageType() != 4 && im.getImageType() != 3) {
            ByteArrayInputStream bs = new ByteArrayInputStream(data);
            ii.setInput(bs);
            if (!ii.check()) {
                throw new Exception("Unsupported image format");
            }
            fileExt = ii.getFormatName();
            mimeType = ii.getMimeType();
        } else if (im.getImageType() == 3) {
            fileExt = "WMF";
            mimeType = "image/x-wmf";
        } else {
            fileExt = "EMF";
            mimeType = "image/x-emf";
        }
        this.doc.addImage(im);
        double width = im.getWidth();
        double height = im.getHeight();
        if (im.getImageType() != 4 && im.getImageType() != 3) {
            int pixelWidth = ii.getWidth();
            int pixelHeight = ii.getHeight();
            if (height == 0.0 || width == 0.0) {
                width = ODTGenerator.strangePixelsToMM(pixelWidth);
                height = ODTGenerator.strangePixelsToMM(pixelHeight);
            }
        }
        StringBuilder style = new StringBuilder();
        String fileName = String.format("image%d.%s", this.doc.getLastImageId(), fileExt);
        this._mediaFileNames.add(fileName);
        style.append("<manifest:file-entry");
        style.append(String.format(" manifest:media-type=\"%s\"", mimeType));
        style.append(String.format(" manifest:full-path=\"media/%s\"", fileName));
        style.append("/>");
        this._manifestContent.append(style.toString());
        style = new StringBuilder();
        style.append("<draw:frame text:anchor-type=\"as-char\"");
        if (im.getUseMultiCell()) {
            style.append(String.format(" svg:y=\"%.0fmm\"", 0));
            style.append(String.format(" svg:x=\"%.0fmm\"", 0));
        } else if (this._tableCellStarted || this._imageDef.cellHeight != 0.0) {
            double y;
            double x;
            double cellHeight = this._imageDef.cellHeight;
            double cellWidth = this._imageDef.cellWidth;
            HorizontalAlign horAlign = this._imageDef.horzAlign;
            VerticalAlign verAlign = this._imageDef.vertAlign;
            switch (horAlign) {
                case LEFT: 
                case WIDTH: {
                    x = this._imageDef.marginLeft;
                    break;
                }
                default: {
                    x = this._imageDef.marginLeft + (cellWidth - width) / 2.0;
                }
            }
            switch (verAlign) {
                case TOP: {
                    y = this._imageDef.marginTop;
                    break;
                }
                case BOTTOM: {
                    y = cellHeight - height - this._imageDef.marginBottom;
                    break;
                }
                default: {
                    y = (cellHeight - this._imageDef.marginTop - this._imageDef.marginBottom - height) / 2.0;
                }
            }
            style.append(String.format(" svg:y=\"%.0fmm\"", y));
            style.append(String.format(" svg:x=\"%.0fmm\"", x));
        }
        style.append(String.format(" svg:width=\"%.0fmm\"", width));
        style.append(String.format(" svg:height=\"%.0fmm\">", height));
        style.append("<draw:image xlink:actuate=\"onLoad\"");
        style.append(" xlink:show=\"embed\" xlink:type=\"simple\"");
        style.append(String.format(" xlink:href=\"media/%s\"/>", fileName));
        style.append("</draw:frame>");
        this.appendContent(style.toString());
    }

    private void generateParagraph(DocParagraph p) throws Exception {
        this.beginParagraph(p);
        for (DocComponent cm : p.components()) {
            switch (cm.getType()) {
                case PARAGRAPH: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TEXT: {
                    this.writeText((DocText)cm);
                    break;
                }
                case IMAGE: {
                    this.insertPicture((DocImage)cm);
                }
            }
        }
        this.endParagraph();
    }

    private void generateTable(DocTable table) throws Exception {
        this.beginTable(table);
        for (DocRow row : table.rows()) {
            this.beginRow(row);
            for (DocCell cell : row.getCells()) {
                if (cell.getColIdx() == -1) continue;
                this.beginCell(cell);
                for (DocComponent cm : cell.components()) {
                    switch (cm.getType()) {
                        case PARAGRAPH: {
                            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                        }
                        case TABLE: {
                            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                        }
                        case TEXT: {
                            this.writeText((DocText)cm);
                            break;
                        }
                        case IMAGE: {
                            this.insertPicture((DocImage)cm);
                        }
                    }
                }
                this.endCell();
            }
            this.endRow();
        }
        this.endTable();
    }

    private void beginTable(DocTable table) throws Exception {
        String buffer;
        if (!(this._headerStarted || this._footerStarted || this._sectionBodyStarted)) {
            this.beginSectionBody();
        }
        if (table.transport_header && this._writingTarget != 0) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043a\u043e\u043b\u043e\u043d\u0442\u0438\u0442\u0443\u043b\u0430\u0445");
        }
        this._transportHeader = table.transport_header;
        if (this._transportHeader) {
            this._tableHeaderOpen = true;
        }
        ++this._styleIndex;
        StringBuilder style = new StringBuilder();
        StringBuilder text = new StringBuilder();
        style.append("<style:style");
        style.append(String.format(" style:name=\"Table%d\"", this._styleIndex));
        boolean specificEnum = false;
        if (!this._isLink && this._writingTarget == 0) {
            if (!this._isTitlePage || this._sectionIndex != 0) {
                style.append(String.format(" style:master-page-name=\"MP%d\"", this._sectionIndex));
                specificEnum = this._enumStart == this._sectionIndex;
            } else {
                style.append(" style:master-page-name=\"MPF0\"");
            }
            this._isLink = true;
        }
        style.append(" style:family=\"table\">");
        style.append("<style:table-properties");
        style.append(" table:border-model=\"collapsing\"");
        if (specificEnum) {
            style.append(" style:page-number=\"1\" ");
        }
        if (!(buffer = ODTGenerator.getColorString(table.getColor())).isEmpty()) {
            style.append(String.format(" fo:background-color=\"%s\"", buffer));
        }
        buffer = ODTGenerator.getInchStrFromMM(table.bottomMargin());
        style.append(String.format(" fo:margin-bottom=\"%sin\"", buffer));
        switch (table.align()) {
            case CENTER: {
                buffer = "center";
                break;
            }
            case RIGHT: {
                buffer = "right";
                break;
            }
            case WIDTH: {
                buffer = "justify";
                break;
            }
            default: {
                buffer = "left";
            }
        }
        style.append(String.format(" table:align=\"%s\"", buffer));
        buffer = ODTGenerator.getInchStrFromMM(table.getTableWidth());
        style.append(String.format(" style:width=\"%sin\"", buffer));
        style.append("/></style:style>");
        buffer = String.format("<table:table table:style-name=\"Table%d\">", this._styleIndex);
        if (this._writingTarget == 0) {
            this._contentAutomaticStylesContent.append(style.toString());
        } else {
            this._stylesAutomaticStylesContent.append(style.toString());
        }
        this.appendContent(buffer);
        style = new StringBuilder();
        text.append("<table:table-columns>");
        this._tableColCount = table.getColumns().size();
        for (int i = 0; i < this._tableColCount; ++i) {
            ++this._styleIndex;
            text.append(String.format("<table:table-column table:style-name=\"TableColumn%d\"/>", this._styleIndex));
            style.append("<style:style");
            style.append(String.format(" style:name=\"TableColumn%d\" style:family=\"table-column\">", this._styleIndex));
            style.append("<style:table-column-properties");
            style.append(String.format(" style:column-width=\"%sin\"/>", ODTGenerator.getInchStrFromMM(table.getColumns().get(i).getWidth())));
            style.append("</style:style>");
        }
        text.append("</table:table-columns>");
        if (this._transportHeader) {
            text.append("<table:table-header-rows>");
        }
        if (this._writingTarget == 0) {
            this._contentAutomaticStylesContent.append(style.toString());
        } else {
            this._stylesAutomaticStylesContent.append(style.toString());
        }
        this.appendContent(text.toString());
    }

    private void endTable() throws Exception {
        if (this._transportHeader && this._tableHeaderOpen) {
            this._tableHeaderOpen = false;
            this._contentBodyContent.append("</table:table-header-rows>");
        }
        this._transportHeader = false;
        this._tableHeaderOpen = false;
        String buffer = "</table:table>";
        this.appendContent(buffer);
        this._transportHeader = false;
    }

    private void beginRow(DocRow row) throws Exception {
        if (this._transportHeader && this._tableHeaderOpen && row.rowType != 1) {
            this._tableHeaderOpen = false;
            this._contentBodyContent.append("</table:table-header-rows>");
        }
        this._prevColIndex = -1;
        RowStyleEntry entry = this._rowStyleTable.add(row, this._writingTarget == 0);
        String buffer = String.format("<table:table-row table:style-name=\"%s\">", entry.getStyleName());
        if (this._writingTarget == 0) {
            if (!entry._isExists) {
                this._contentAutomaticStylesContent.append(entry.getStyleDef());
            }
        } else if (!entry._isExists) {
            this._stylesAutomaticStylesContent.append(entry.getStyleDef());
        }
        this.appendContent(buffer);
        this._imageDef.cellHeight = row.getHeight();
    }

    private void endRow() throws Exception {
        int prevSpan = this._tableColCount - this._prevColIndex;
        String buffer = "";
        for (int i = 1; i < prevSpan; ++i) {
            buffer = buffer.concat("<table:covered-table-cell/>");
        }
        if (!buffer.isEmpty()) {
            this.appendContent(buffer);
        }
        buffer = "</table:table-row>";
        this.appendContent(buffer);
    }

    private void beginCell(DocCell cell) throws Exception {
        int prevSpan = cell.getColIdx() - this._prevColIndex;
        String buffer = "";
        for (int i = 1; i < prevSpan; ++i) {
            buffer = buffer.concat("<table:covered-table-cell/>");
        }
        if (!buffer.isEmpty()) {
            this.appendContent(buffer);
        }
        this._prevColIndex = cell.getColIdx();
        CellStyleEntry entry = this._cellStyleTable.add(cell, this._writingTarget == 0);
        StringBuilder content = new StringBuilder();
        content.append(String.format("<table:table-cell table:style-name=\"%s\"", entry.getStyleName()));
        if (cell.colSpan() > 1) {
            content.append(String.format(" table:number-columns-spanned=\"%d\"", cell.colSpan()));
        }
        if (cell.rowSpan() > 1) {
            content.append(String.format(" table:number-rows-spanned=\"%d\"", cell.rowSpan()));
        }
        content.append(">");
        if (this._writingTarget == 0) {
            if (!entry._isExists) {
                this._contentAutomaticStylesContent.append(entry.getStyleDef());
            }
        } else if (!entry._isExists) {
            this._stylesAutomaticStylesContent.append(entry.getStyleDef());
        }
        this.appendContent(content.toString());
        DocParagraph parag = new DocParagraph(this._firstSection);
        TableMargins margins = cell.getCellMargins();
        parag.marginLeft(margins.getLeft());
        parag.marginRight(margins.getRight());
        parag.marginTop(margins.getTop());
        parag.marginBottom(margins.getBottom());
        parag.align(cell.horizontalAlign());
        this.beginParagraph(parag);
        this._imageDef.marginBottom = parag.marginBottom();
        this._imageDef.marginLeft = parag.marginLeft();
        this._imageDef.marginRight = parag.marginRight();
        this._imageDef.marginTop = parag.marginTop();
        this._imageDef.cellWidth = parag.getWidth();
        this._imageDef.vertAlign = VerticalAlign.DEFAULT;
        this._tableCellStarted = true;
    }

    private void endCell() throws Exception {
        this.endParagraph();
        String buffer = "</table:table-cell>";
        this.appendContent(buffer);
        this._tableCellStarted = false;
    }

    private void appendContent(String buffer) throws Exception {
        if (this._writingTarget == 0) {
            this._contentBodyContent.append(buffer);
        } else if (this._headerFooterKind == 2) {
            this._titlePageHeaderFooter.append(buffer);
            this._nextPagesHeaderFooter.append(buffer);
        } else if (this._headerFooterKind == 0) {
            this._titlePageHeaderFooter.append(buffer);
        } else {
            this._nextPagesHeaderFooter.append(buffer);
        }
    }

    private static String getInchStrFromMM(double value) throws Exception {
        String res = Double.toString(value / 25.4);
        int idx = res.indexOf(46);
        if (idx >= 0) {
            int len = Math.min(idx + 4, res.length());
            res = res.substring(0, len);
        }
        return res;
    }

    private static String getColorString(int c) throws Exception {
        if (c == 0x1FFFFFFF || c < 0) {
            return "";
        }
        return String.format("#%02X%02X%02X", c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF);
    }

    private static double strangePixelsToMM(int pixels) {
        return (double)pixels / 3.593;
    }

    private String getBorderAttributes(int borders) throws Exception {
        StringBuilder content = new StringBuilder();
        String buffer = ODTGenerator.getColorString(DocBorders.leftColor(this.doc, borders));
        content.append(" fo:border-left=\"");
        switch (DocBorders.leftStyle(borders)) {
            case 1: {
                content.append("0.25pt dotted ");
                content.append(buffer);
                break;
            }
            case 2: {
                content.append("0.25pt solid ");
                content.append(buffer);
                break;
            }
            case 3: {
                content.append("1.00pt solid ");
                content.append(buffer);
                break;
            }
            case 4: {
                content.append("1.75pt solid ");
                content.append(buffer);
                break;
            }
            case 5: {
                content.append("1.75pt double ");
                content.append(buffer);
                break;
            }
            default: {
                content.append("none");
            }
        }
        content.append('\"');
        buffer = ODTGenerator.getColorString(DocBorders.rightColor(this.doc, borders));
        content.append(" fo:border-right=\"");
        switch (DocBorders.rightStyle(borders)) {
            case 1: {
                content.append("0.25pt dotted ");
                content.append(buffer);
                break;
            }
            case 2: {
                content.append("0.25pt solid ");
                content.append(buffer);
                break;
            }
            case 3: {
                content.append("1.00pt solid ");
                content.append(buffer);
                break;
            }
            case 4: {
                content.append("1.75pt solid ");
                content.append(buffer);
                break;
            }
            case 5: {
                content.append("1.75pt double ");
                content.append(buffer);
                break;
            }
            default: {
                content.append("none");
            }
        }
        content.append('\"');
        buffer = ODTGenerator.getColorString(DocBorders.topColor(this.doc, borders));
        content.append(" fo:border-top=\"");
        switch (DocBorders.topStyle(borders)) {
            case 1: {
                content.append("0.25pt dotted ");
                content.append(buffer);
                break;
            }
            case 2: {
                content.append("0.25pt solid ");
                content.append(buffer);
                break;
            }
            case 3: {
                content.append("1.00pt solid ");
                content.append(buffer);
                break;
            }
            case 4: {
                content.append("1.75pt solid ");
                content.append(buffer);
                break;
            }
            case 5: {
                content.append("1.75pt double ");
                content.append(buffer);
                break;
            }
            default: {
                content.append("none");
            }
        }
        content.append('\"');
        buffer = ODTGenerator.getColorString(DocBorders.bottomColor(this.doc, borders));
        content.append(" fo:border-bottom=\"");
        switch (DocBorders.bottomStyle(borders)) {
            case 1: {
                content.append("0.25pt dotted ");
                content.append(buffer);
                break;
            }
            case 2: {
                content.append("0.25pt solid ");
                content.append(buffer);
                break;
            }
            case 3: {
                content.append("1.00pt solid ");
                content.append(buffer);
                break;
            }
            case 4: {
                content.append("1.75pt solid ");
                content.append(buffer);
                break;
            }
            case 5: {
                content.append("1.75pt double ");
                content.append(buffer);
                break;
            }
            default: {
                content.append("none");
            }
        }
        content.append('\"');
        return content.toString();
    }

    private static int getCellStyleHash(DocCell cell) {
        int hash = cell.borders();
        hash = hash << 3 ^ cell.getColor();
        hash = hash << 3 ^ (cell.isCellWordWrap() ? 1 : 0);
        hash = hash << 3 ^ cell.getVertAlign();
        hash = hash << 3 ^ cell.getTextOrientation();
        return hash;
    }

    private static int getRowStyleHash(DocRow row) {
        int hash = row.getColor();
        hash = hash << 3 ^ Hashing.hash(row.getHeight());
        return hash;
    }

    private static int getTextStyleHash(Font font, int fillColor) {
        int hash = fillColor;
        hash = hash << 3 ^ Font.styleHashCodeByFontIndex(font);
        return hash;
    }

    private static int getParagraphStyleHash(Document doc, DocParagraph parag) {
        int hash = parag.getColor();
        hash = hash << 3 ^ parag.align().value();
        hash = hash << 3 ^ Hashing.hash(parag.marginTop());
        hash = hash << 3 ^ Hashing.hash(parag.marginBottom());
        hash = hash << 3 ^ Hashing.hash(parag.marginLeft());
        hash = hash << 3 ^ Hashing.hash(parag.marginRight());
        hash = hash << 3 ^ DocBorders.assign(doc, parag.getBorders());
        return hash;
    }

    private class ParagraphStyleTable
    extends AbstractHash<ParagraphStyleEntry> {
        private ParagraphStyleTable() {
        }

        public ParagraphStyleEntry get(DocParagraph parag, boolean isTitlePage, boolean isLink, boolean isBodyPlacement, int sectionIndex) {
            int m = ((ParagraphStyleEntry[])this.data).length - 1;
            int i = (ODTGenerator.getParagraphStyleHash(ODTGenerator.this.doc, parag) & this.mask) << 1;
            ParagraphStyleEntry e = null;
            while ((e = ((ParagraphStyleEntry[])this.data)[i]) != null) {
                if (e.isEquals(parag, isTitlePage, isLink, isBodyPlacement, sectionIndex)) {
                    e._isExists = true;
                    break;
                }
                i = i + 1 & m;
            }
            return e;
        }

        public ParagraphStyleEntry add(DocParagraph parag, boolean isTitlePage, boolean isLink, boolean isBodyPlacement, int sectionIndex) {
            ParagraphStyleEntry s = this.get(parag, isTitlePage, isLink, isBodyPlacement, sectionIndex);
            if (s != null) {
                return s;
            }
            s = new ParagraphStyleEntry(parag, isTitlePage, isLink, isBodyPlacement, sectionIndex);
            s._index = this.size();
            super.add(s);
            return s;
        }

        @Override
        protected int hash(ParagraphStyleEntry s) {
            assert (s != null);
            return s._hashCode;
        }

        @Override
        protected boolean equals(ParagraphStyleEntry a, ParagraphStyleEntry b) {
            assert (a != null && b != null);
            return a.isEquals(b);
        }

        protected ParagraphStyleEntry[] allocate(int count) {
            return new ParagraphStyleEntry[count];
        }
    }

    private class ParagraphStyleEntry {
        private int _align = 0;
        private int _borders = 0;
        private int _color = 0x1FFFFFFF;
        private double _leftMargin = 0.0;
        private double _topMargin = 0.0;
        private double _bottomMargin = 0.0;
        private double _rightMargin = 0.0;
        private final boolean _isTitlePage;
        private final boolean _isLink;
        private final int _hashCode;
        private int _index = 0;
        private final boolean _isBodyPlacement;
        private boolean _isExists = false;
        private final int _sectionIndex;

        public ParagraphStyleEntry(DocParagraph parag, boolean isTitlePage, boolean isLink, boolean isBodyPlacement, int sectionIndex) {
            this._sectionIndex = sectionIndex;
            this._isBodyPlacement = isBodyPlacement;
            this._isTitlePage = isTitlePage;
            this._isLink = isLink;
            this._align = parag.align().value();
            this._borders = DocBorders.assign(ODTGenerator.this.doc, parag.getBorders());
            this._color = parag.getColor();
            this._leftMargin = parag.marginLeft();
            this._topMargin = parag.marginTop();
            this._bottomMargin = parag.marginBottom();
            this._rightMargin = parag.marginRight();
            this._hashCode = ODTGenerator.getParagraphStyleHash(ODTGenerator.this.doc, parag);
        }

        public boolean isEquals(ParagraphStyleEntry paragraphStyleEntry) {
            return this._borders == paragraphStyleEntry._borders && this._isTitlePage == paragraphStyleEntry._isTitlePage && this._isLink == paragraphStyleEntry._isLink && this._sectionIndex == paragraphStyleEntry._sectionIndex && this._isBodyPlacement == paragraphStyleEntry._isBodyPlacement && this._topMargin == paragraphStyleEntry._topMargin && this._bottomMargin == paragraphStyleEntry._bottomMargin && this._leftMargin == paragraphStyleEntry._leftMargin && this._rightMargin == paragraphStyleEntry._rightMargin && this._align == paragraphStyleEntry._align && this._color == paragraphStyleEntry._color;
        }

        public boolean isEquals(DocParagraph parag, boolean isTitlePage, boolean isLink, boolean isBodyPlacement, int sectionIndex) {
            return this._borders == DocBorders.assign(ODTGenerator.this.doc, parag.getBorders()) && this._isTitlePage == isTitlePage && this._isLink == isLink && this._sectionIndex == sectionIndex && this._isBodyPlacement == isBodyPlacement && this._topMargin == parag.marginTop() && this._bottomMargin == parag.marginBottom() && this._leftMargin == parag.marginLeft() && this._rightMargin == parag.marginRight() && this._align == parag.align().value() && this._color == parag.getColor();
        }

        public String getStyleDef() throws Exception {
            String buffer;
            StringBuilder content = new StringBuilder();
            content.append(String.format("<style:style style:name=\"P%d\"", this._index));
            boolean specificEnum = false;
            if (!this._isLink && this._isBodyPlacement) {
                if (!this._isTitlePage) {
                    content.append(String.format(" style:master-page-name=\"MP%d\"", this._sectionIndex));
                    specificEnum = ODTGenerator.this._enumStart == this._sectionIndex;
                } else {
                    content.append(" style:master-page-name=\"MPF0\"");
                }
            }
            content.append(" style:family=\"paragraph\">");
            content.append(" <style:paragraph-properties");
            if (specificEnum) {
                content.append(" style:page-number=\"1\" ");
            }
            if (!(buffer = ODTGenerator.getColorString(this._color)).isEmpty()) {
                content.append(String.format(" fo:background-color=\"%s\"", buffer));
            }
            content.append(ODTGenerator.this.getBorderAttributes(this._borders));
            buffer = ODTGenerator.getInchStrFromMM(this._bottomMargin);
            content.append(String.format(" fo:margin-bottom=\"%sin\"", buffer));
            buffer = ODTGenerator.getInchStrFromMM(this._leftMargin);
            content.append(String.format(" fo:margin-left=\"%sin\"", buffer));
            buffer = ODTGenerator.getInchStrFromMM(this._rightMargin);
            content.append(String.format(" fo:margin-right=\"%sin\"", buffer));
            buffer = ODTGenerator.getInchStrFromMM(this._topMargin);
            content.append(String.format(" fo:margin-top=\"%sin\"", buffer));
            switch (HorizontalAlign.create(this._align)) {
                case CENTER: {
                    buffer = "center";
                    break;
                }
                case RIGHT: {
                    buffer = "right";
                    break;
                }
                case WIDTH: {
                    buffer = "justify";
                    break;
                }
                default: {
                    buffer = "left";
                }
            }
            content.append(String.format(" fo:text-align=\"%s\"", buffer));
            content.append("/>");
            content.append("<style:text-properties");
            content.append(String.format(" fo:font-family=\"%s\"", ODTGenerator.this._firstSection.getFont().getName()));
            content.append(String.format(" fo:font-size=\"%dpt\"", ODTGenerator.this._firstSection.getFont().getSize()));
            content.append("/>");
            content.append("</style:style>");
            return content.toString();
        }

        public String getStyleName() throws Exception {
            return String.format("P%d", this._index);
        }
    }

    private static class TextStyleTable
    extends AbstractHash<TextStyleEntry> {
        private TextStyleTable() {
        }

        public TextStyleEntry get(Font font, int fillColor, boolean isBodyPlacement) {
            int m = ((TextStyleEntry[])this.data).length - 1;
            int i = (ODTGenerator.getTextStyleHash(font, fillColor) & this.mask) << 1;
            TextStyleEntry e = null;
            while ((e = ((TextStyleEntry[])this.data)[i]) != null) {
                if (e.isEquals(font, fillColor, isBodyPlacement)) {
                    e._isExists = true;
                    break;
                }
                i = i + 1 & m;
            }
            return e;
        }

        public TextStyleEntry add(Font font, int fillColor, boolean isBodyPlacement) {
            TextStyleEntry s = this.get(font, fillColor, isBodyPlacement);
            if (s != null) {
                return s;
            }
            s = new TextStyleEntry(font, fillColor, isBodyPlacement);
            s._index = this.size();
            super.add(s);
            return s;
        }

        @Override
        protected int hash(TextStyleEntry s) {
            assert (s != null);
            return s._hashCode;
        }

        @Override
        protected boolean equals(TextStyleEntry a, TextStyleEntry b) {
            assert (a != null && b != null);
            return a.isEquals(b);
        }

        protected TextStyleEntry[] allocate(int count) {
            return new TextStyleEntry[count];
        }
    }

    private static class TextStyleEntry {
        private final Font _font = new Font();
        private final int _fillColor;
        private final int _hashCode;
        private int _index;
        private final boolean _isBodyPlacement;
        private boolean _isExists;

        public TextStyleEntry(Font font, int fillColor, boolean isBodyPlacement) {
            if (font != null) {
                this._font.assign(font);
            }
            this._fillColor = fillColor;
            this._index = 0;
            this._isExists = false;
            this._isBodyPlacement = isBodyPlacement;
            this._hashCode = ODTGenerator.getTextStyleHash(this._font, fillColor);
        }

        public String getStyleDef() throws Exception {
            StringBuilder content = new StringBuilder();
            content.append(String.format("<style:style style:name=\"T%d\"", this._index));
            content.append(" style:family=\"text\">");
            content.append("<style:text-properties");
            String buffer = ODTGenerator.getColorString(this._fillColor);
            if (!buffer.isEmpty()) {
                content.append(String.format(" fo:background-color=\"%s\"", buffer));
            }
            if (!(buffer = ODTGenerator.getColorString(this._font.getColor())).isEmpty()) {
                content.append(String.format(" fo:color=\"%s\"", buffer));
            }
            content.append(String.format(" fo:font-family=\"%s\"", this._font.getName()));
            content.append(String.format(" fo:font-size=\"%dpt\"", this._font.getSize()));
            buffer = "normal";
            if ((this._font.getStyle() & 2) != 0) {
                buffer = "italic";
            }
            content.append(String.format(" fo:font-style=\"%s\"", buffer));
            buffer = "normal";
            if ((this._font.getStyle() & 1) != 0) {
                buffer = "bold";
            }
            content.append(String.format(" fo:font-weight=\"%s\"", buffer));
            content.append(String.format(" style:font-name=\"%s\"", this._font.getName()));
            if ((this._font.getStyle() & 8) != 0) {
                content.append(" style:text-line-through-type=\"single\" style:text-line-through-style=\"solid\"");
            }
            buffer = "none";
            if ((this._font.getStyle() & 4) != 0) {
                buffer = "solid";
            }
            content.append(String.format(" style:text-underline-style=\"%s\"", buffer));
            if (buffer.equals("solid")) {
                content.append(" style:text-underline-color=\"font-color\"");
                content.append(" style:text-underline-mode=\"continuous\"");
            }
            content.append("/></style:style>");
            return content.toString();
        }

        public String getStyleName() {
            return String.format("T%d", this._index);
        }

        public boolean isEquals(TextStyleEntry textStyleEntry) {
            return this._fillColor == textStyleEntry._fillColor && Font.styleEqualsByFontIndex(this._font, textStyleEntry._font) && this._isBodyPlacement == textStyleEntry._isBodyPlacement;
        }

        public boolean isEquals(Font font, int fillColor, boolean isBodyPlacement) {
            return this._fillColor == fillColor && Font.styleEqualsByFontIndex(this._font, font) && this._isBodyPlacement == isBodyPlacement;
        }
    }

    private static class RowStyleTable
    extends AbstractHash<RowStyleEntry> {
        private RowStyleTable() {
        }

        public RowStyleEntry get(DocRow row, boolean isBodyPlacement) {
            int m = ((RowStyleEntry[])this.data).length - 1;
            int i = (ODTGenerator.getRowStyleHash(row) & this.mask) << 1;
            RowStyleEntry e = null;
            while ((e = ((RowStyleEntry[])this.data)[i]) != null) {
                if (e.isEquals(row, isBodyPlacement)) {
                    e._isExists = true;
                    break;
                }
                i = i + 1 & m;
            }
            return e;
        }

        public RowStyleEntry add(DocRow row, boolean isBodyPlacement) {
            RowStyleEntry s = this.get(row, isBodyPlacement);
            if (s != null) {
                return s;
            }
            s = new RowStyleEntry(row, isBodyPlacement);
            s._index = this.size();
            super.add(s);
            return s;
        }

        @Override
        protected int hash(RowStyleEntry s) {
            assert (s != null);
            return s._hashCode;
        }

        @Override
        protected boolean equals(RowStyleEntry a, RowStyleEntry b) {
            assert (a != null && b != null);
            return a.isEquals(b);
        }

        protected RowStyleEntry[] allocate(int count) {
            return new RowStyleEntry[count];
        }
    }

    private static class RowStyleEntry {
        private int _color;
        private double _height;
        private int _hashCode;
        private int _index;
        private boolean _isBodyPlacement;
        private boolean _isExists;

        public RowStyleEntry(DocRow row, boolean isBodyPlacement) {
            this._color = row.getColor();
            this._height = row.getHeight();
            this._index = 0;
            this._isExists = false;
            this._isBodyPlacement = isBodyPlacement;
            this._hashCode = ODTGenerator.getRowStyleHash(row);
        }

        public String getStyleDef() throws Exception {
            StringBuilder content = new StringBuilder();
            content.append(String.format("<style:style style:name=\"TableRow%d\"", this._index));
            content.append(" style:family=\"table-row\">");
            content.append("<style:table-row-properties");
            String buffer = ODTGenerator.getColorString(this._color);
            if (!buffer.isEmpty()) {
                content.append(String.format(" fo:background-color=\"%s\"", buffer));
            }
            buffer = ODTGenerator.getInchStrFromMM(this._height);
            content.append(String.format(" style:row-height=\"%sin\"", buffer));
            buffer = ODTGenerator.getInchStrFromMM(this._height);
            content.append(String.format(" style:min-row-height=\"%sin\"", buffer));
            content.append("/></style:style>");
            return content.toString();
        }

        public String getStyleName() {
            return String.format("TableRow%d", this._index);
        }

        public boolean isEquals(RowStyleEntry rowStyleEntry) {
            return this._color == rowStyleEntry._color && this._isBodyPlacement == rowStyleEntry._isBodyPlacement && this._height == rowStyleEntry._height;
        }

        public boolean isEquals(DocRow row, boolean isBodyPlacement) {
            return this._color == row.getColor() && this._isBodyPlacement == isBodyPlacement && this._height == row.getHeight();
        }
    }

    private class CellStyleTable
    extends AbstractHash<CellStyleEntry> {
        private CellStyleTable() {
        }

        public CellStyleEntry get(DocCell cell, boolean isBodyPlacement) {
            int m = ((CellStyleEntry[])this.data).length - 1;
            int i = (ODTGenerator.getCellStyleHash(cell) & this.mask) << 1;
            CellStyleEntry e = null;
            while ((e = ((CellStyleEntry[])this.data)[i]) != null) {
                if (e.isEquals(cell, isBodyPlacement)) {
                    e._isExists = true;
                    break;
                }
                i = i + 1 & m;
            }
            return e;
        }

        public CellStyleEntry add(DocCell cell, boolean isBodyPlacement) {
            CellStyleEntry s = this.get(cell, isBodyPlacement);
            if (s != null) {
                return s;
            }
            s = new CellStyleEntry(cell, isBodyPlacement);
            s._index = this.size();
            super.add(s);
            return s;
        }

        @Override
        protected int hash(CellStyleEntry s) {
            assert (s != null);
            return s._hashCode;
        }

        @Override
        protected boolean equals(CellStyleEntry a, CellStyleEntry b) {
            assert (a != null && b != null);
            return a.isEquals(b);
        }

        protected CellStyleEntry[] allocate(int count) {
            return new CellStyleEntry[count];
        }
    }

    private class CellStyleEntry {
        private final int _color;
        private final int _borders;
        private final boolean _wordWrap;
        private final int _vertAlign;
        private final int _orientation;
        private final int _hashCode;
        private int _index;
        private final boolean _isBodyPlacement;
        private boolean _isExists;

        public CellStyleEntry(DocCell cell, boolean isBodyPlacement) {
            this._color = cell.getColor();
            this._borders = cell.borders();
            this._wordWrap = cell.isCellWordWrap();
            this._vertAlign = cell.getVertAlign();
            this._orientation = cell.getTextOrientation();
            this._index = 0;
            this._isExists = false;
            this._isBodyPlacement = isBodyPlacement;
            this._hashCode = ODTGenerator.getCellStyleHash(cell);
        }

        public boolean isEquals(CellStyleEntry cellStyleEntry) {
            return this._borders == cellStyleEntry._borders && this._isBodyPlacement == cellStyleEntry._isBodyPlacement && this._color == cellStyleEntry._color && this._wordWrap == cellStyleEntry._wordWrap && this._vertAlign == cellStyleEntry._vertAlign && this._orientation == cellStyleEntry._orientation;
        }

        public boolean isEquals(DocCell cell, boolean isBodyPlacement) {
            return this._borders == cell.borders() && this._isBodyPlacement == isBodyPlacement && this._color == cell.getColor() && this._wordWrap == cell.isCellWordWrap() && this._vertAlign == cell.getVertAlign() && this._orientation == cell.getTextOrientation();
        }

        public String getStyleDef() throws Exception {
            StringBuilder content = new StringBuilder();
            content.append(String.format("<style:style style:name=\"TableCell%d\"", this._index));
            content.append(" style:family=\"table-cell\">");
            content.append("<style:table-cell-properties");
            String buffer = ODTGenerator.getColorString(this._color);
            if (!buffer.isEmpty()) {
                content.append(String.format(" fo:background-color=\"%s\"", buffer));
            }
            content.append(ODTGenerator.this.getBorderAttributes(this._borders));
            buffer = this._wordWrap ? "wrap" : "no-wrap";
            content.append(String.format(" fo:wrap-option=\"%s\"", buffer));
            if (this._orientation != TextOrientation.LEFT_RIGHT.value()) {
                content.append(" style:writing-mode=\"tb-rl\"");
            }
            switch (VerticalAlign.create(this._vertAlign)) {
                case TOP: {
                    buffer = "top";
                    break;
                }
                case BOTTOM: {
                    buffer = "bottom";
                    break;
                }
                case MIDDLE: {
                    buffer = "middle";
                    break;
                }
                default: {
                    buffer = "automatic";
                }
            }
            content.append(String.format(" style:vertical-align=\"%s\"", buffer));
            content.append("/></style:style>");
            return content.toString();
        }

        public String getStyleName() {
            return String.format("TableCell%d", this._index);
        }
    }

    private static class ImageDef {
        HorizontalAlign horzAlign = HorizontalAlign.DEFAULT;
        VerticalAlign vertAlign = VerticalAlign.DEFAULT;
        double cellHeight = 0.0;
        double cellWidth = 0.0;
        double marginTop = 0.0;
        double marginBottom = 0.0;
        double marginLeft = 0.0;
        double marginRight = 0.0;

        private ImageDef() {
        }
    }
}

