/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.generators;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntHashMap;
import inform.adt.collections.IntegerList;
import inform.agent.db.types.DataType;
import inform.agent.scripts.PageFormatLibrary;
import inform.agent.web.reports.controls.PageNumbers;
import inform.agent.web.reports.controls.ReportPageOrientation;
import inform.agent.web.reports.document.DocBorders;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocColumn;
import inform.agent.web.reports.document.DocColumns;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocPageBreak;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.Type;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.VerticalAlign;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PaperSize;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.util.Units;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlDouble;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlToken;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetData;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;

public class XlsxGenerator
implements WebReportGenerator {
    private static final int CRITICAL_ROW_INDEX = 50;
    private static final int MAX_UNFLUSHED_ROW_COUNT = 15000;
    private static final int MAX_COLUMN_WIDTH = 65200;
    private DataFormat dataFormat = null;
    private final Document doc;
    private final String caption;
    private SXSSFWorkbook wb;
    private SXSSFSheet sheet;
    private int NC;
    private int _frozenCols = 0;
    private int _frozenRows = 0;
    private boolean _isFrozenRows = false;
    private final IntHashMap<FontTableItem> fontTable = new IntHashMap();
    private final IntHashMap<StyleTableItem> styleTable = new IntHashMap();

    public XlsxGenerator(Document doc, String caption) throws Exception {
        this.doc = doc;
        this.caption = URLEncoder.encode(caption, "UTF-8").replace('+', ' ');
    }

    private XSSFColor convertToXSSFColor(int c) throws InformException {
        XSSFColor result = new XSSFColor(new byte[]{0, (byte)(c & 0xFF), (byte)(c >> 8 & 0xFF), (byte)(c >> 16 & 0xFF)});
        if (c == 0) {
            result.setRGB(new byte[]{0, 0, 0});
        }
        return result;
    }

    private XSSFFont convertToXSSFFont(Font font) throws InformException {
        if (this.wb == null) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0448\u0440\u0438\u0444\u0442\u0430 \u0443 \u043d\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u043d\u043e\u0433\u043e Workbook \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        }
        int idx = this.getFontIndex(font);
        if (idx != -1) {
            return (XSSFFont)this.wb.getFontAt((int)((short)idx));
        }
        XSSFFont newFont = (XSSFFont)this.wb.createFont();
        newFont.setColor(this.convertToXSSFColor(font.getColor()));
        newFont.setBold((font.getStyle() & 1) != 0);
        newFont.setFontHeightInPoints((short)font.getSize());
        if (!font.getName().isEmpty()) {
            newFont.setFontName(font.getName());
        }
        newFont.setItalic((font.getStyle() & 2) != 0);
        newFont.setStrikeout((font.getStyle() & 8) != 0);
        newFont.setUnderline((font.getStyle() & 4) != 0 ? (byte)1 : 0);
        newFont.setTypeOffset((font.getStyle() & 0x10) != 0 ? (short)1 : 0);
        this.addFontToFontTable(font, newFont.getIndex());
        return newFont;
    }

    private HorizontalAlignment convertToXSSFHorAlign(HorizontalAlign val) {
        switch (val) {
            case LEFT: {
                return HorizontalAlignment.LEFT;
            }
            case CENTER: {
                return HorizontalAlignment.CENTER;
            }
            case RIGHT: {
                return HorizontalAlignment.RIGHT;
            }
            case WIDTH: {
                return HorizontalAlignment.JUSTIFY;
            }
        }
        return HorizontalAlignment.LEFT;
    }

    private VerticalAlignment convertToXSSVertFAlign(VerticalAlign val) {
        switch (val) {
            case TOP: {
                return VerticalAlignment.TOP;
            }
            case BOTTOM: {
                return VerticalAlignment.BOTTOM;
            }
            case MIDDLE: {
                return VerticalAlignment.CENTER;
            }
            case BASELINE: {
                return VerticalAlignment.JUSTIFY;
            }
        }
        return VerticalAlignment.TOP;
    }

    private BorderStyle convertToXSSFBorderStyle(int val) {
        switch (val) {
            case 0: {
                return BorderStyle.NONE;
            }
            case 1: {
                return BorderStyle.DOTTED;
            }
            case 2: {
                return BorderStyle.THIN;
            }
            case 3: {
                return BorderStyle.MEDIUM;
            }
            case 4: {
                return BorderStyle.THICK;
            }
            case 5: {
                return BorderStyle.DOUBLE;
            }
        }
        return BorderStyle.NONE;
    }

    private boolean verifyCellSequence(CTRow row) {
        switch (row.sizeOfCArray()) {
            case 0: {
                return true;
            }
            case 1: {
                int index = 0;
                CTCell cell = row.getCArray(index);
                CellAddress cellAddress = new CellAddress(cell.getR());
                return cellAddress.getColumn() == index;
            }
        }
        int beginIndex = 0;
        int endIndex = row.sizeOfCArray() - 1;
        CTCell firstCell = row.getCArray(beginIndex);
        CellAddress fCellAddress = new CellAddress(firstCell.getR());
        CTCell lastCell = row.getCArray(endIndex);
        CellAddress lCellAddress = new CellAddress(lastCell.getR());
        return fCellAddress.getColumn() == beginIndex && lCellAddress.getColumn() == endIndex;
    }

    private CTCell addNewCell(int idx, CTRow row, SheetInfo info) {
        CTCell cell;
        if (idx > info.colCount - 1) {
            ++info.colCount;
        }
        String cellAddress = CellReference.convertNumToColString((int)idx) + row.getR();
        if (this.verifyCellSequence(row)) {
            cell = row.addNewC();
            cell.setR(cellAddress);
        } else {
            cell = (CTCell)CTCell.Factory.newInstance();
            cell.setR(cellAddress);
            CTCell[] array = row.getCArray();
            List list = row.getCList();
            int i = -Collections.binarySearch(list, cell, (c1, c2) -> {
                int idx1 = CellReference.convertColStringToIndex((String)c1.getR());
                int idx2 = CellReference.convertColStringToIndex((String)c2.getR());
                return idx1 - idx2;
            });
            if (--i >= 0) {
                list.add(i, cell);
                row.setCArray(list.toArray(array));
                cell = row.getCArray(i);
            } else if (idx < array.length) {
                cell = row.getCArray(idx);
            } else {
                list.add(cell);
                row.setCArray(list.toArray(array));
                cell = row.getCArray(i);
            }
        }
        return cell;
    }

    private CTRow addNewRow(SheetInfo info) {
        int sheetIndex = this.wb.getSheetIndex((Sheet)info.sheet);
        CTWorksheet worksheet = this.wb.getXSSFWorkbook().getSheetAt(sheetIndex).getCTWorksheet();
        CTSheetData sheetData = worksheet.getSheetData();
        if (sheetData == null) {
            sheetData = worksheet.addNewSheetData();
        }
        CTRow row = sheetData.addNewRow();
        row.setR((long)(++info.rowCount));
        return row;
    }

    private CTRow getRow(SheetInfo info, int rowIndex) {
        int sheetIndex = this.wb.getSheetIndex((Sheet)info.sheet);
        CTWorksheet worksheet = this.wb.getXSSFWorkbook().getSheetAt(sheetIndex).getCTWorksheet();
        CTSheetData sheetData = worksheet.getSheetData();
        if (sheetData != null && rowIndex >= 0 && sheetData.sizeOfRowArray() > rowIndex) {
            return sheetData.getRowArray(rowIndex);
        }
        return null;
    }

    private XSSFCellStyle generateCell(DocCell c, DocRow r, CTRow row, int rowIdx, int cellIdx, SheetInfo info) throws InformException {
        boolean isNum;
        DataType dataType = c.getDataType();
        boolean isFormatSeparateThausand = c.isCellFormatSeparateThausand();
        boolean isKeepTailZero = c.isCellFormatKeepTailZero();
        int formatScale = c.getCellFormatScale();
        String text = "";
        XSSFRichTextString content = new XSSFRichTextString();
        if (!c.isCellValueEmpty()) {
            text = c.getCellValue().asText();
            content.setString(text);
        }
        for (DocComponent cm : c.components()) {
            switch (cm.getType()) {
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                }
                case PARAGRAPH: {
                    return this.generateSimpleParagraph((DocParagraph)cm, c, info, row, rowIdx, cellIdx);
                }
                case TEXT: {
                    DocText t = (DocText)cm;
                    boolean isFirst = text.isEmpty();
                    text = t.getText();
                    content.append(text);
                    if (isFirst) break;
                    content.clearFormatting();
                    break;
                }
                case IMAGE: {
                    float picHeight;
                    DocImage im = (DocImage)cm;
                    byte[] data = im.getImageContent();
                    if (data == null) break;
                    int pictureIdx = 0;
                    pictureIdx = im.getImageType() != 4 && im.getImageType() != 3 ? this.wb.addPicture(data, 7) : (im.getImageType() == 3 ? this.wb.addPicture(data, 3) : this.wb.addPicture(data, 2));
                    CreationHelper helper = this.wb.getCreationHelper();
                    ClientAnchor anchor = helper.createClientAnchor();
                    DocTable table = c.getTable();
                    anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                    double imWidth = im.getWidth();
                    int colSpan = c.colSpan();
                    if (im.getUseMultiCell()) {
                        colSpan = table.getColumns().size() - cellIdx;
                    } else {
                        while (imWidth < table.getColGroupWidth(cellIdx, colSpan)) {
                            --colSpan;
                        }
                        if (colSpan < 1) {
                            colSpan = 1;
                        }
                    }
                    anchor.setCol1(cellIdx);
                    anchor.setCol2(cellIdx + colSpan - 1);
                    anchor.setRow1(rowIdx);
                    anchor.setRow2(rowIdx + c.rowSpan() - 1);
                    anchor.setDx1(Units.toEMU((double)0.0));
                    anchor.setDy1(Units.toEMU((double)0.0));
                    anchor.setDx2(Units.toEMU((double)this.mm2pt(im.getWidth())));
                    anchor.setDy2(Units.toEMU((double)this.mm2pt(im.getHeight())));
                    XSSFDrawing drawing = this.sheet.getDrawingPatriarch();
                    if (drawing == null) {
                        drawing = this.sheet.createDrawingPatriarch();
                    }
                    drawing.createPicture(anchor, pictureIdx);
                    if (r.getHeight() == 0.0 && c.rowSpan() == 1 && (double)(picHeight = this.mm2pt(im.getHeight())) > row.getHt()) {
                        row.setHt((double)picHeight);
                    }
                    this.doc.addImage(im);
                    break;
                }
            }
        }
        CTCell cell = this.addNewCell(cellIdx, row, info);
        boolean bl = isNum = !text.isEmpty() && (dataType == DataType.FLOAT || dataType == DataType.INTEGER);
        if (!text.isEmpty() && c.isCellFormula()) {
            CTCellFormula formula = cell.addNewF();
            formula.setStringValue(text);
        } else {
            if (isNum) {
                int intVal = 0;
                double dblVal = 0.0;
                try {
                    if (isFormatSeparateThausand) {
                        text = text.replace(" ", "");
                    }
                    if (dataType == DataType.INTEGER) {
                        intVal = Integer.parseInt(text);
                    } else {
                        dblVal = Double.parseDouble(text);
                    }
                }
                catch (NumberFormatException nfe) {
                    isNum = false;
                }
                if (isNum) {
                    cell.setT(STCellType.N);
                    String value = dataType == DataType.INTEGER ? String.valueOf(intVal) : NumberToTextConverter.toText((double)dblVal);
                    cell.setV(value);
                }
            }
            if (!isNum && !text.isEmpty()) {
                cell.setT(STCellType.INLINE_STR);
                cell.setIs(content.getCTRst());
            }
        }
        StringBuilder fmtStr = new StringBuilder();
        if (isNum) {
            if (isFormatSeparateThausand) {
                fmtStr.append("#,##");
            }
            if (dataType == DataType.INTEGER) {
                fmtStr.append("0");
            } else {
                int p = text.indexOf(46);
                int realScale = 0;
                if (p != -1) {
                    realScale = text.length() - p - 1;
                }
                if (formatScale >= 0 && isKeepTailZero) {
                    realScale = formatScale;
                }
                fmtStr.append("0");
                if (realScale > 0) {
                    fmtStr.append(".");
                    if (realScale > 9) {
                        realScale = 9;
                    }
                    fmtStr.append("0".repeat(realScale));
                }
            }
        } else if (dataType == DataType.STRING && text.length() < 255) {
            fmtStr.append("@");
        }
        int idx = this.getStyleIndex(c, this.dataFormat.getFormat(fmtStr.toString()));
        if (idx != -1) {
            XSSFCellStyle stl = (XSSFCellStyle)this.wb.getCellStyleAt(idx);
            cell.setS((long)stl.getIndex());
            return stl;
        }
        XSSFCellStyle style = (XSSFCellStyle)this.wb.createCellStyle();
        if (!Strings.isVoid(fmtStr.toString())) {
            style.setDataFormat(this.dataFormat.getFormat(fmtStr.toString()));
        }
        if (c.getTextOrientation() != 0) {
            int buff = c.getTextOrientation() == 1 ? 90 : 180;
            style.setRotation((short)buff);
        }
        style.setAlignment(this.convertToXSSFHorAlign(c.horizontalAlign()));
        style.setVerticalAlignment(this.convertToXSSVertFAlign(c.verticalAlign()));
        if (c.getCellMargins().getLeft() > 0.0) {
            style.setIndention((short)(c.getCellMargins().getLeft() / 2.0));
        }
        style.setWrapText(c.isCellWordWrap());
        int bgColor = c.getEffectiveColor();
        if (bgColor != 0x1FFFFFFF && bgColor != 0xFFFFFF) {
            style.setFillForegroundColor(this.convertToXSSFColor(bgColor));
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        style.setFont((org.apache.poi.ss.usermodel.Font)this.convertToXSSFFont(c.getFont()));
        this.applyBorders(style, c.borders());
        this.addStyleToStyleTable(c, this.dataFormat.getFormat(fmtStr.toString()), style.getIndex());
        cell.setS((long)style.getIndex());
        return style;
    }

    private void closeLevels(ArrayList<Level> Levels, ArrayList<Group> Groups, int level, int lastRow, SheetInfo info) {
        for (int i = Levels.size() - 1; i > level; --i) {
            Level L = Levels.get(i);
            Groups.add(new Group(L.beginRow, lastRow, L.hide_kind == 2));
            Levels.remove(i);
        }
    }

    private void generateTable(DocTable t, SheetInfo info) throws InformException {
        if (this._frozenCols < t.fixed_cols) {
            this._frozenCols = t.fixed_cols;
        }
        int curRowIndex = info.rowCount;
        int lastAutoFilterRowIndex = -1;
        int colsInFilter = 0;
        int[] rs = new int[t.getColumns().size()];
        ArrayList<Level> Levels = new ArrayList<Level>();
        ArrayList<Group> Groups = new ArrayList<Group>(100);
        int prev_hide_kind = 0;
        boolean isAutoFilter = false;
        Levels.add(new Level(curRowIndex, 0));
        for (DocRow r : t.rows()) {
            CTRow row;
            if (this.doc != null) {
                this.doc.getTask().getHost().idle();
            }
            if ((row = this.getRow(info, curRowIndex)) == null) {
                row = this.addNewRow(info);
            }
            if (r.getHeight() != 0.0) {
                this.setRowHeight(row, this.mm2pt(r.getHeight()));
            }
            if (r.rowType == 1 && !this._isFrozenRows) {
                this._frozenRows = curRowIndex + 1;
            }
            if (r.autoFilter && !isAutoFilter) {
                colsInFilter = r.size();
                isAutoFilter = true;
            }
            if (r.autoFilter && isAutoFilter) {
                lastAutoFilterRowIndex = curRowIndex;
            }
            int cellIdx = 0;
            int cs = 1;
            for (DocCell c : r.getCells()) {
                CTRow tmp;
                int i;
                if (cs > 1) {
                    --cs;
                    continue;
                }
                if (rs[cellIdx] > 1) {
                    int n = cellIdx++;
                    rs[n] = rs[n] - 1;
                    continue;
                }
                if (c.colSpan() == 0 || c.rowSpan() == 0) {
                    ++cellIdx;
                    continue;
                }
                cs = c.colSpan();
                rs[cellIdx] = c.rowSpan();
                XSSFCellStyle cellStyle = this.generateCell(c, r, row, curRowIndex, cellIdx, info);
                if (c.rowSpan() > 1) {
                    for (i = 1; i < c.rowSpan(); ++i) {
                        tmp = this.getRow(info, curRowIndex + i);
                        if (tmp == null) {
                            tmp = this.addNewRow(info);
                        }
                        CTCell cell = this.addNewCell(cellIdx, tmp, info);
                        cell.setS((long)cellStyle.getIndex());
                    }
                    if (c.colSpan() == 1) {
                        info.sheet.addMergedRegionUnsafe(new CellRangeAddress(curRowIndex, curRowIndex + c.rowSpan() - 1, cellIdx, cellIdx));
                    }
                }
                if (c.colSpan() > 1) {
                    for (i = 0; i < c.rowSpan(); ++i) {
                        tmp = this.getRow(info, curRowIndex + i);
                        for (int j = 1; j < c.colSpan(); ++j) {
                            CTCell cell = this.addNewCell(cellIdx + j, tmp, info);
                            cell.setS((long)cellStyle.getIndex());
                        }
                    }
                    int rwsn = c.rowSpan() - 1;
                    info.sheet.addMergedRegionUnsafe(new CellRangeAddress(curRowIndex, curRowIndex + rwsn, cellIdx, cellIdx + c.colSpan() - 1));
                    cellIdx += c.colSpan() - 1;
                }
                ++cellIdx;
            }
            if (r.level > 0) {
                row.setOutlineLevel((short)r.level);
            }
            if (r.level > Levels.size() - 1) {
                Levels.add(new Level(curRowIndex, prev_hide_kind));
            } else if (r.level < Levels.size() - 1) {
                this.closeLevels(Levels, Groups, r.level, curRowIndex, info);
            }
            prev_hide_kind = r.hide_kind;
            if (++curRowIndex != 50) continue;
            this.correctParagraphs(info);
        }
        if (this._frozenRows > 0) {
            this._isFrozenRows = true;
        }
        this.closeLevels(Levels, Groups, 0, curRowIndex - 1, info);
        for (int i = Groups.size() - 1; i >= 0; --i) {
            Group g = Groups.get(i);
            info.sheet.groupRow(g.beginRow, g.endRow);
            if (!g.collapsed || info.sheet.getLastRowNum() <= g.beginRow) continue;
            info.sheet.setRowGroupCollapsed(g.beginRow, true);
        }
        if (lastAutoFilterRowIndex >= 0) {
            info.sheet.setAutoFilter(new CellRangeAddress(lastAutoFilterRowIndex, lastAutoFilterRowIndex, 0, colsInFilter - 1));
        }
        if (t.bottomMargin() != 0.0) {
            CTRow row = this.addNewRow(info);
            this.setRowHeight(row, this.mm2pt(t.bottomMargin()));
            XSSFCellStyle style = (XSSFCellStyle)this.wb.createCellStyle();
            style.setFont((org.apache.poi.ss.usermodel.Font)this.convertToXSSFFont(t.getFont()));
            for (int i = 0; i < info.colCount; ++i) {
                CTCell cell = this.addNewCell(i, row, info);
                cell.setT(STCellType.INLINE_STR);
                cell.setS((long)style.getIndex());
            }
        }
    }

    private void setRowHeight(CTRow ctR, float height) {
        if (!ctR.getCustomHeight()) {
            ctR.setCustomHeight(true);
        }
        String string = String.valueOf(height);
        XmlDouble xmlDouble = (XmlDouble)XmlDouble.Factory.newInstance();
        xmlDouble.setStringValue(string);
        ctR.xsetHt(xmlDouble);
    }

    private void updateDimensionRef(Sheet sheet, int columnIndex, int rowNumber) {
        if (columnIndex < 0) {
            return;
        }
        XSSFSheet xSheet = this.wb.getXSSFWorkbook().getSheet(sheet.getSheetName());
        CTWorksheet ctSheet = xSheet.getCTWorksheet();
        ctSheet.getDimension().setRef("A1:" + CellReference.convertNumToColString((int)columnIndex) + rowNumber);
    }

    private void generateImage(DocImage im, SheetInfo sheetInfo, CTRow row) {
        byte[] data = im.getImageContent();
        if (data != null) {
            int pictureIdx = 0;
            pictureIdx = im.getImageType() != 4 && im.getImageType() != 3 ? this.wb.addPicture(data, 7) : (im.getImageType() == 3 ? this.wb.addPicture(data, 3) : this.wb.addPicture(data, 2));
            CreationHelper helper = this.wb.getCreationHelper();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
            anchor.setCol1(0);
            anchor.setCol2(sheetInfo.widthsCount - 1);
            anchor.setRow1(sheetInfo.rowCount - 1);
            anchor.setRow2(sheetInfo.rowCount - 1);
            anchor.setDx1(Units.toEMU((double)0.0));
            anchor.setDy1(Units.toEMU((double)0.0));
            anchor.setDx2(Units.toEMU((double)(this.mm2pt(im.getWidth()) / 20.0f)));
            anchor.setDy2(Units.toEMU((double)this.mm2pt(im.getHeight())));
            XSSFDrawing drawing = sheetInfo.sheet.getDrawingPatriarch();
            if (drawing == null) {
                drawing = sheetInfo.sheet.createDrawingPatriarch();
            }
            drawing.createPicture(anchor, pictureIdx);
            float picHeight = this.mm2pt(im.getHeight());
            if ((double)picHeight > row.getHt()) {
                this.setRowHeight(row, this.mm2pt(picHeight));
            }
            this.doc.addImage(im);
        }
    }

    private void applyBorders(XSSFCellStyle style, int borders) {
        style.setBorderBottom(this.convertToXSSFBorderStyle(DocBorders.bottomStyle(borders)));
        style.setBottomBorderColor(this.convertToXSSFColor(DocBorders.bottomColor(this.doc, borders)));
        style.setBorderLeft(this.convertToXSSFBorderStyle(DocBorders.leftStyle(borders)));
        style.setLeftBorderColor(this.convertToXSSFColor(DocBorders.leftColor(this.doc, borders)));
        style.setBorderRight(this.convertToXSSFBorderStyle(DocBorders.rightStyle(borders)));
        style.setRightBorderColor(this.convertToXSSFColor(DocBorders.rightColor(this.doc, borders)));
        style.setBorderTop(this.convertToXSSFBorderStyle(DocBorders.topStyle(borders)));
        style.setTopBorderColor(this.convertToXSSFColor(DocBorders.topColor(this.doc, borders)));
    }

    private XSSFCellStyle generateSimpleParagraph(DocParagraph p, DocCell c, SheetInfo sheetInfo, CTRow row, int rowIdx, int cellIdx) throws InformException {
        CTCell cell = this.addNewCell(cellIdx, row, sheetInfo);
        cell.setT(STCellType.INLINE_STR);
        int tw = 0;
        XSSFRichTextString content = new XSSFRichTextString();
        for (DocComponent cm : p.components()) {
            switch (cm.getType()) {
                case PARAGRAPH: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TEXT: {
                    DocText text = (DocText)cm;
                    content.append(text.getText(), this.convertToXSSFFont(text.getFont()));
                    tw += (int)text.getWidth();
                    break;
                }
                case IMAGE: {
                    this.generateImage((DocImage)cm, sheetInfo, row);
                }
            }
        }
        cell.setIs(content.getCTRst());
        int w = (int)Math.round(c.getWidth() * 131.29058);
        if (p.getLineAlign() == 0) {
            w = (int)Math.round(sheetInfo.sheetWidth * 131.29058);
        }
        if (w > 0 && sheetInfo.sheet.getColumnWidth(0) < w) {
            sheetInfo.sheet.setColumnWidth(0, Math.min(w, 65200));
        }
        XSSFCellStyle style = (XSSFCellStyle)this.wb.createCellStyle();
        style.setAlignment(this.convertToXSSFHorAlign(p.align()));
        int bgColor = p.getEffectiveColor();
        if (bgColor != 0x1FFFFFFF && bgColor != 0xFFFFFF) {
            style.setFillForegroundColor(this.convertToXSSFColor(bgColor));
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        this.applyBorders(style, c.borders());
        style.setWrapText(c.isCellWordWrap());
        style.setFont((org.apache.poi.ss.usermodel.Font)this.convertToXSSFFont(p.getFont()));
        cell.setS((long)style.getIndex());
        return style;
    }

    private void generateParagraph(DocParagraph p, SheetInfo sheet) throws InformException {
        CTRow ctRow = this.addNewRow(sheet);
        if (p.getHeight() != 0.0) {
            this.setRowHeight(ctRow, this.mm2pt(p.getHeight()));
        }
        sheet.paraRowIndexes.add(sheet.rowCount - 1);
        sheet.paraRowLineAlignes.add(p.getLineAlign());
        CTCell cell = this.addNewCell(0, ctRow, sheet);
        cell.setT(STCellType.INLINE_STR);
        int tw = 0;
        XSSFRichTextString content = new XSSFRichTextString();
        for (DocComponent cm : p.components()) {
            switch (cm.getType()) {
                case PARAGRAPH: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TEXT: {
                    DocText text = (DocText)cm;
                    content.append(text.getText(), this.convertToXSSFFont(text.getFont()));
                    tw += (int)text.getWidth();
                    break;
                }
                case IMAGE: {
                    this.generateImage((DocImage)cm, sheet, ctRow);
                }
            }
        }
        cell.setIs(content.getCTRst());
        int w = (int)Math.round((double)tw * 131.29058);
        if (p.getLineAlign() == 0) {
            w = (int)Math.round(sheet.sheetWidth * 131.29058);
        }
        if (!sheet.hasTables && w > 0 && sheet.sheet.getColumnWidth(0) < w) {
            sheet.sheet.setColumnWidth(0, Math.min(w, 65200));
        }
        XSSFCellStyle style = (XSSFCellStyle)this.wb.createCellStyle();
        style.setAlignment(this.convertToXSSFHorAlign(p.align()));
        int bgColor = p.getEffectiveColor();
        if (bgColor != 0x1FFFFFFF && bgColor != 0xFFFFFF) {
            style.setFillForegroundColor(this.convertToXSSFColor(bgColor));
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        style.setBorderBottom(this.convertToXSSFBorderStyle(p.getBorders().bottomBorder.getType()));
        style.setBottomBorderColor(this.convertToXSSFColor(p.getBorders().bottomBorder.getColor()));
        style.setBorderLeft(this.convertToXSSFBorderStyle(p.getBorders().leftBorder.getType()));
        style.setLeftBorderColor(this.convertToXSSFColor(p.getBorders().leftBorder.getColor()));
        style.setBorderRight(this.convertToXSSFBorderStyle(p.getBorders().rightBorder.getType()));
        style.setRightBorderColor(this.convertToXSSFColor(p.getBorders().rightBorder.getColor()));
        style.setBorderTop(this.convertToXSSFBorderStyle(p.getBorders().topBorder.getType()));
        style.setTopBorderColor(this.convertToXSSFColor(p.getBorders().topBorder.getColor()));
        style.setWrapText(p.getWordWrap());
        style.setFont((org.apache.poi.ss.usermodel.Font)this.convertToXSSFFont(p.getFont()));
        cell.setS((long)style.getIndex());
    }

    private void generatePageBreak(DocPageBreak pageBreak, SheetInfo sheet) throws InformException {
        sheet.sheet.setAutobreaks(false);
        sheet.sheet.setFitToPage(false);
        int splitRow = sheet.rowCount - 1;
        if (splitRow < 0) {
            splitRow = 0;
        }
        sheet.sheet.setRowBreak(splitRow);
    }

    private void generateComponents(Iterable<? extends DocComponent> components, SheetInfo sheet) throws InformException {
        for (DocComponent docComponent : components) {
            if (docComponent.getType() != Type.TABLE) continue;
            sheet.hasTables = true;
            break;
        }
        for (DocComponent docComponent : components) {
            switch (docComponent.getType()) {
                case PARAGRAPH: {
                    DocParagraph p = (DocParagraph)docComponent;
                    this.generateParagraph(p, sheet);
                    break;
                }
                case TABLE: {
                    DocTable t = (DocTable)docComponent;
                    if (t.transport_header) {
                        sheet.repeatHeader = true;
                    }
                    this.generateTable(t, sheet);
                    break;
                }
                case TEXT: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0435\u043a\u0441\u0442\u0430 \u0432\u043d\u0435 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430");
                }
                case PageBreak: {
                    this.generatePageBreak((DocPageBreak)docComponent, sheet);
                }
            }
        }
    }

    private void correctParagraphs(SheetInfo sheet) {
        if (sheet.colCount > 1) {
            for (Cursor.Integer i : sheet.paraRowIndexes) {
                CTRow row = this.getRow(sheet, i.value);
                if (row == null || row.sizeOfCArray() == 0) continue;
                int colCount = sheet.colCount;
                sheet.sheet.addMergedRegionUnsafe(new CellRangeAddress(i.value, i.value, 0, colCount - 1));
                long styleIndex = row.getCArray(0).getS();
                for (int cellIdx = 1; cellIdx < colCount; ++cellIdx) {
                    CTCell cell = this.addNewCell(cellIdx, row, sheet);
                    cell.setS(styleIndex);
                }
            }
            sheet.paraRowIndexes.clear();
        }
    }

    private static void setPageBreakPreview(SXSSFWorkbook wb, int sheetIdx) throws Exception {
        CTSheetView view;
        if (wb == null) {
            return;
        }
        if (sheetIdx < 0 || sheetIdx >= wb.getXSSFWorkbook().getNumberOfSheets()) {
            return;
        }
        CTWorksheet worksheet = wb.getXSSFWorkbook().getSheetAt(sheetIdx).getCTWorksheet();
        if (worksheet.getSheetViews() == null) {
            worksheet.addNewSheetViews().addNewSheetView();
            view = worksheet.getSheetViews().getSheetViewArray(0);
            view.setWorkbookViewId(0L);
        } else {
            view = worksheet.getSheetViews().getSheetViewArray(0);
        }
        XmlToken xmlToken = null;
        try {
            xmlToken = (XmlToken)XmlToken.Factory.parse("<xml-fragment workbookViewId=\"0\" tabSelected=\"true\" view=\"pageBreakPreview\"/>");
        }
        catch (XmlException xe) {
            xe.printStackTrace();
        }
        view.set((XmlObject)xmlToken);
    }

    private String truncSheetCaption(String sheetCaption) throws Exception {
        if (Strings.isVoid(sheetCaption)) {
            return "";
        }
        if ((sheetCaption = WorkbookUtil.createSafeSheetName((String)sheetCaption)).length() <= 25) {
            return sheetCaption;
        }
        return sheetCaption.substring(0, 26);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateBody(OutputStream out, String encoding) throws Exception {
        this.wb = new SXSSFWorkbook(15000);
        String msg = "\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 Freetype \u0438 Fontconfig";
        try {
            if (!SheetUtil.canComputeColumnWidth((org.apache.poi.ss.usermodel.Font)this.wb.getFontAt(0))) {
                throw new InformException(msg);
            }
        }
        catch (Exception e) {
            throw InformException.wrap(e, msg);
        }
        this.dataFormat = this.wb.createDataFormat();
        this.doc.prepareStore();
        boolean useGlobalProtect = false;
        boolean useFirstSheetProtect = false;
        String globalPassword = "";
        String firstSheetPassword = "";
        String password = "";
        boolean markAsFinal = false;
        int fspo = 0;
        int gspo = 0;
        int activeSheet = -1;
        int ns = 0;
        for (DocSection s : this.doc.sections()) {
            int activeSheetIndex;
            ++ns;
            if (!useFirstSheetProtect) {
                useFirstSheetProtect = s.getFirstPageProtection().getEnabled();
                firstSheetPassword = s.getFirstPageProtection().getPassword();
                fspo = s.getFirstPageProtection().getOptions();
            }
            if (!useGlobalProtect) {
                useGlobalProtect = s.getAllPageProtection().getEnabled();
                globalPassword = s.getAllPageProtection().getPassword();
                gspo = s.getAllPageProtection().getOptions();
            }
            if (!s.getPassword().isEmpty()) {
                password = s.getPassword();
            }
            if (s.getMarkAsFinal()) {
                markAsFinal = true;
            }
            if (activeSheet == (activeSheetIndex = s.getActiveSheet() - 1)) continue;
            activeSheet = activeSheetIndex;
        }
        this.NC = 0;
        int[] nc = new int[ns];
        int ci = 0;
        for (DocSection docSection : this.doc.sections()) {
            for (DocComponent docComponent : docSection.elements()) {
                if (docComponent.getType() != Type.TABLE) continue;
                DocTable docTable = (DocTable)docComponent;
                DocColumns cs = docTable.getColumns();
                if (nc[ci] < cs.size()) {
                    nc[ci] = cs.size();
                }
                if (this.NC >= nc[ci]) continue;
                this.NC = nc[ci];
            }
            ++ci;
        }
        boolean[][] grouped = new boolean[ns][this.NC];
        ci = 0;
        for (DocSection docSection : this.doc.sections()) {
            for (DocComponent docComponent : docSection.elements()) {
                if (docComponent.getType() != Type.TABLE) continue;
                DocTable tbl = (DocTable)docComponent;
                DocColumns cs = tbl.getColumns();
                for (int i = 0; i < cs.size(); ++i) {
                    DocColumn c = cs.get(i);
                    if (!c.getGrouped()) continue;
                    grouped[ci][i] = true;
                }
            }
            ++ci;
        }
        boolean bl = false;
        for (DocSection docSection : this.doc.sections()) {
            PaperSize ps;
            void var20_42;
            void var17_23;
            ++var17_23;
            String string = docSection.getPageCaption();
            if (string.isEmpty()) {
                String string2 = "\u041b\u0438\u0441\u0442 " + (int)var17_23;
            } else {
                int sidx = this.wb.getNumberOfSheets() + 1;
                Object sheetName = this.truncSheetCaption(string);
                while (this.wb.getSheet((String)sheetName) != null) {
                    sheetName = this.truncSheetCaption(string) + " (" + sidx + ")";
                    ++sidx;
                }
                String string3 = sheetName;
            }
            this.sheet = this.wb.createSheet((String)var20_42);
            if (docSection.getPageBreakPreview()) {
                XlsxGenerator.setPageBreakPreview(this.wb, (int)(var17_23 - true));
            }
            if (docSection.getHideSheet()) {
                this.wb.setSheetHidden((int)(var17_23 - true), true);
            }
            this.sheet.setDisplayGridlines(!docSection.getGridNotShow());
            if (useGlobalProtect && !"".equals(globalPassword)) {
                this.sheet.protectSheet(globalPassword);
                this.sheet.lockObjects((gspo & 1) != 0);
                this.sheet.lockScenarios((gspo & 2) != 0);
                this.sheet.lockFormatCells((gspo & 4) != 0);
                this.sheet.lockFormatColumns((gspo & 8) != 0);
                this.sheet.lockFormatRows((gspo & 0x10) != 0);
                this.sheet.lockInsertColumns((gspo & 0x20) != 0);
                this.sheet.lockInsertRows((gspo & 0x40) != 0);
                this.sheet.lockInsertHyperlinks((gspo & 0x80) != 0);
                this.sheet.lockDeleteColumns((gspo & 0x100) != 0);
                this.sheet.lockDeleteRows((gspo & 0x200) != 0);
                this.sheet.lockSelectLockedCells((gspo & 0x400) != 0);
                this.sheet.lockSort((gspo & 0x800) != 0);
                this.sheet.lockAutoFilter((gspo & 0x1000) != 0);
                this.sheet.lockPivotTables((gspo & 0x2000) != 0);
                this.sheet.lockSelectUnlockedCells((gspo & 0x4000) != 0);
                this.sheet.enableLocking();
            } else if (useFirstSheetProtect && !"".equals(firstSheetPassword) && var17_23 == true) {
                this.sheet.protectSheet(firstSheetPassword);
                this.sheet.lockObjects((fspo & 1) != 0);
                this.sheet.lockScenarios((fspo & 2) != 0);
                this.sheet.lockFormatCells((fspo & 4) != 0);
                this.sheet.lockFormatColumns((fspo & 8) != 0);
                this.sheet.lockFormatRows((fspo & 0x10) != 0);
                this.sheet.lockInsertColumns((fspo & 0x20) != 0);
                this.sheet.lockInsertRows((fspo & 0x40) != 0);
                this.sheet.lockInsertHyperlinks((fspo & 0x80) != 0);
                this.sheet.lockDeleteColumns((fspo & 0x100) != 0);
                this.sheet.lockDeleteRows((fspo & 0x200) != 0);
                this.sheet.lockSelectLockedCells((fspo & 0x400) != 0);
                this.sheet.lockSort((fspo & 0x800) != 0);
                this.sheet.lockAutoFilter((fspo & 0x1000) != 0);
                this.sheet.lockPivotTables((fspo & 0x2000) != 0);
                this.sheet.lockSelectUnlockedCells((fspo & 0x4000) != 0);
                this.sheet.enableLocking();
            }
            this.sheet.setRowSumsBelow(false);
            this.sheet.setRowSumsRight(false);
            double h = docSection.getPageHeight();
            double w = docSection.getPageWidth();
            ReportPageOrientation po = ReportPageOrientation.PORTRAIT;
            if (w == 210.0 && h == 297.0) {
                ps = PaperSize.A4_PAPER;
            } else if (w == 297.0 && h == 420.0) {
                ps = PaperSize.A3_PAPER;
            } else if (w == 148.0 && h == 210.0) {
                ps = PaperSize.A5_PAPER;
            } else {
                po = ReportPageOrientation.LANDSCAPE;
                ps = w == 297.0 && h == 210.0 ? PaperSize.A4_PAPER : (w == 420.0 && h == 297.0 ? PaperSize.A3_PAPER : (w == 210.0 && h == 148.0 ? PaperSize.A5_PAPER : PaperSize.A4_PAPER));
            }
            if (PageFormatLibrary.pageFormat((double)docSection.getPageWidth(), (double)docSection.getPageHeight(), (boolean)(docSection.getOrientation() == ReportPageOrientation.LANDSCAPE ? true : false)).id == PageFormatLibrary.PageFormat.CustomPageFormat.id) {
                po = docSection.getOrientation();
            }
            this.sheet.getPrintSetup().setLandscape(po == ReportPageOrientation.LANDSCAPE);
            this.sheet.getPrintSetup().setNoColor(docSection.getBlackAndWhite());
            ((XSSFPrintSetup)this.sheet.getPrintSetup()).setPaperSize(ps);
            if (docSection.getMaxPagesPerHeight() > 0 || docSection.getMaxPagesPerWidth() > 0) {
                this.sheet.setFitToPage(true);
                if (docSection.getMaxPagesPerHeight() >= 0) {
                    this.sheet.getPrintSetup().setFitHeight((short)docSection.getMaxPagesPerHeight());
                }
                if (docSection.getMaxPagesPerWidth() > 0) {
                    this.sheet.getPrintSetup().setFitWidth((short)docSection.getMaxPagesPerWidth());
                }
            } else {
                if (docSection.getMaxPagesPerHeight() <= 0) {
                    this.sheet.getPrintSetup().setFitHeight((short)0);
                }
                if (docSection.isUseXlsScale()) {
                    this.sheet.getPrintSetup().setScale(docSection.getScale());
                }
            }
            this.sheet.setMargin((short)0, docSection.margins().getLeft() / 25.0);
            this.sheet.setMargin((short)1, docSection.margins().getRight() / 25.0);
            this.sheet.setMargin((short)2, docSection.margins().getTop() / 25.0);
            this.sheet.setMargin((short)3, docSection.margins().getBottom() / 25.0);
            this.sheet.setZoom((int)docSection.getZoom());
            this.putHeaderFooterText(this.sheet, docSection);
            if (docSection.getDimension().length() != 0) {
                this.wb.setPrintArea((int)(var17_23 - true), docSection.getDimension());
            }
            SheetInfo i = new SheetInfo();
            i.sheet = this.sheet;
            i.sheetWidth = docSection.getPageWidth();
            i.sheetColWidths = 0.0;
            i.widthsCount = Math.max(docSection.widths.size(), 1);
            for (int k = 0; k < docSection.widths.size(); ++k) {
                double wk = Math.abs(docSection.widths.get(k));
                int p = (int)Math.round(wk * 131.29058);
                i.sheetColWidths += wk;
                this.sheet.setColumnWidth(k, Math.min(p, 65200));
            }
            this.generateComponents(docSection.elements(), i);
            this.correctParagraphs(i);
            int r = 0;
            while (r < nc[var17_23 - true]) {
                if (!grouped[var17_23 - true][r]) {
                    ++r;
                    continue;
                }
                int j = r;
                while (r < nc[var17_23 - true] && grouped[var17_23 - true][r]) {
                    ++r;
                }
                i.sheet.groupColumn(j, r - 1);
            }
            if (this._frozenCols > 0 || this._frozenRows > 0) {
                int fr = this._frozenRows > 0 ? this._frozenRows : 1;
                this.sheet.createFreezePane(this._frozenCols, fr);
                if (i.repeatHeader) {
                    this.sheet.setRepeatingRows(new CellRangeAddress(0, fr - 1, 0, i.colCount - 1));
                } else {
                    this.sheet.setRepeatingRows(null);
                }
            }
            this._frozenRows = 0;
            this._isFrozenRows = false;
            this.updateDimensionRef((Sheet)this.sheet, i.colCount - 1, i.rowCount);
        }
        if (!(password.isEmpty() && globalPassword.isEmpty() && firstSheetPassword.isEmpty())) {
            XSSFWorkbook xSSFWorkbook = this.wb.getXSSFWorkbook();
            CTWorkbook cTWorkbook = xSSFWorkbook.getCTWorkbook();
            if (!password.isEmpty()) {
                CTWorkbookProtection cTWorkbookProtection = cTWorkbook.addNewWorkbookProtection();
                cTWorkbookProtection.setWorkbookPassword(password.getBytes("UTF-8"));
                cTWorkbookProtection.setLockStructure(true);
            }
            if (markAsFinal) {
                POIXMLProperties.CustomProperties customProperties = xSSFWorkbook.getProperties().getCustomProperties();
                customProperties.addProperty("_MarkAsFinal", true);
            }
        }
        this.wb.setActiveSheet(activeSheet);
        this.wb.write(out);
        this.wb.close();
    }

    @Override
    public void generateHeaders(HttpServletResponse resp) throws Exception {
        resp.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        resp.setHeader("Content-disposition", String.format("attachment; filename*=\"utf8'ru-ru'%s.xlsx\"", this.caption.isEmpty() ? "noname" : this.caption));
    }

    private String getColorString(int c) throws InformException {
        return String.format("%02X%02X%02X", c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF);
    }

    private String getHeaderFontAsText(Font font) {
        if (font == null) {
            return "";
        }
        String fontName = font.getName();
        int fontSize = font.getSize();
        int fontStyle = font.getStyle();
        int color = font.getColor();
        StringBuilder hfText = new StringBuilder();
        hfText.append("&\"").append(fontName).append("\"").append("&").append(fontSize).append("&K").append(this.getColorString(color));
        if ((fontStyle & 1) == 1) {
            hfText.append("&B");
        }
        if ((fontStyle & 2) == 2) {
            hfText.append("&I");
        }
        if ((fontStyle & 4) == 4) {
            hfText.append("&U");
        }
        if ((fontStyle & 8) == 8) {
            hfText.append("&S");
        }
        return hfText.toString();
    }

    private boolean fillHeaderFooterText(DocSection section, StringBuilder left, StringBuilder center, StringBuilder right) {
        if (section == null || left == null || center == null || right == null) {
            return false;
        }
        String docTextString = "";
        for (DocComponent docComponent : section.elements()) {
            if (docComponent.getType() != Type.PARAGRAPH) continue;
            DocParagraph p = (DocParagraph)docComponent;
            block11: for (DocComponent pc : p.components()) {
                if (pc.getType() != Type.TEXT) continue;
                DocText dt = (DocText)pc;
                switch (dt.getDocumentWriterFiedKind()) {
                    case 0: {
                        docTextString = dt.getText();
                        break;
                    }
                    case 1: {
                        docTextString = "&P";
                        break;
                    }
                    case 2: {
                        docTextString = "&N";
                    }
                }
                switch (p.align()) {
                    case LEFT: {
                        left.append(this.getHeaderFontAsText(dt.getFont())).append(docTextString);
                        continue block11;
                    }
                    case CENTER: {
                        center.append(this.getHeaderFontAsText(dt.getFont())).append(docTextString);
                        continue block11;
                    }
                    case RIGHT: {
                        right.append(this.getHeaderFontAsText(dt.getFont())).append(docTextString);
                        continue block11;
                    }
                }
                left.append(this.getHeaderFontAsText(dt.getFont())).append(docTextString);
            }
        }
        return true;
    }

    private boolean putHeaderFooterText(SXSSFSheet sheet, DocSection section) {
        PageNumbers pn;
        if (sheet == null || section == null) {
            return false;
        }
        StringBuilder lhText = new StringBuilder();
        StringBuilder chText = new StringBuilder();
        StringBuilder rhText = new StringBuilder();
        StringBuilder lfText = new StringBuilder();
        StringBuilder cfText = new StringBuilder();
        StringBuilder rfText = new StringBuilder();
        if (section.getFirstPageHeader() != null) {
            this.fillHeaderFooterText(section.getFirstPageHeader(), lhText, chText, rhText);
        }
        if (section.getOtherPageHeader() != null) {
            this.fillHeaderFooterText(section.getOtherPageHeader(), lhText, chText, rhText);
        }
        if (section.getAllPagesHeader() != null) {
            this.fillHeaderFooterText(section.getAllPagesHeader(), lhText, chText, rhText);
        }
        if (section.getFirstPageFooter() != null) {
            this.fillHeaderFooterText(section.getFirstPageFooter(), lfText, cfText, rfText);
        }
        if (section.getOtherPageFooter() != null) {
            this.fillHeaderFooterText(section.getOtherPageFooter(), lfText, cfText, rfText);
        }
        if (section.getAllPagesFooter() != null) {
            this.fillHeaderFooterText(section.getAllPagesFooter(), lfText, cfText, rfText);
        }
        if ((pn = section.getPageNumbers()) != null && pn.enabled) {
            if (pn.location == 0) {
                switch (pn.align) {
                    case 0: {
                        lhText.append(this.getHeaderFontAsText(pn.getFont())).append(pn.getCaption()).append("&P");
                        break;
                    }
                    case 1: {
                        chText.append(this.getHeaderFontAsText(pn.getFont())).append(pn.getCaption()).append("&P");
                        break;
                    }
                    case 2: {
                        rhText.append(this.getHeaderFontAsText(pn.getFont())).append(pn.getCaption()).append("&P");
                    }
                }
            } else {
                switch (pn.align) {
                    case 0: {
                        lfText.append(this.getHeaderFontAsText(pn.getFont())).append(pn.getCaption()).append("&P");
                        break;
                    }
                    case 1: {
                        cfText.append(this.getHeaderFontAsText(pn.getFont())).append(pn.getCaption()).append("&P");
                        break;
                    }
                    case 2: {
                        rfText.append(this.getHeaderFontAsText(pn.getFont())).append(pn.getCaption()).append("&P");
                    }
                }
            }
        }
        sheet.getHeader().setLeft(lhText.toString());
        sheet.getHeader().setCenter(chText.toString());
        sheet.getHeader().setRight(rhText.toString());
        sheet.getFooter().setLeft(lfText.toString());
        sheet.getFooter().setCenter(cfText.toString());
        sheet.getFooter().setRight(rfText.toString());
        return true;
    }

    private float mm2pt(double val) {
        return (float)(val / 0.35277777777777775);
    }

    private void addFontToFontTable(Font font, int index) {
        int fontTableItemHash = this.getFontTableItemHash(font);
        if (this.fontTable.get(fontTableItemHash) == null) {
            this.fontTable.put(fontTableItemHash, new FontTableItem(index));
        }
    }

    private void addStyleToStyleTable(DocCell cell, short cellFormat, int index) {
        int styleTableItemHash = this.getStyleTableItemHash(cell, cellFormat);
        if (this.styleTable.get(styleTableItemHash) == null) {
            this.styleTable.put(styleTableItemHash, new StyleTableItem(index));
        }
    }

    private int getFontIndex(Font font) {
        int index = -1;
        FontTableItem item = this.fontTable.get(this.getFontTableItemHash(font));
        if (item != null) {
            index = item.getIndex();
        }
        return index;
    }

    private int getStyleIndex(DocCell cell, short cellFormat) {
        int index = -1;
        StyleTableItem item = this.styleTable.get(this.getStyleTableItemHash(cell, cellFormat));
        if (item != null) {
            index = item.getIndex();
        }
        return index;
    }

    private int getFontTableItemHash(Font font) {
        int result = font.getName() != null ? font.getName().hashCode() : 0;
        result = 31 * result + font.getSize();
        result = 31 * result + font.getStyle();
        result = 31 * result + font.getColor();
        return result;
    }

    private int getStyleTableItemHash(DocCell cell, short cellFormat) {
        int result = 0;
        result = 31 * result + cell.horizontalAlign().value();
        result = 31 * result + cell.verticalAlign().value();
        result = 31 * result + cell.getTextOrientation();
        result = 31 * result + (int)cell.getCellMargins().getLeft();
        result = 31 * result + cell.getEffectiveColor();
        result = 31 * result + this.getFontTableItemHash(cell.getFont());
        int borders = cell.borders();
        result = 31 * result + borders;
        result = 31 * result + cellFormat;
        return result;
    }

    private static class StyleTableItem {
        private final int _index;

        public StyleTableItem(int index) {
            this._index = index;
        }

        public int getIndex() {
            return this._index;
        }
    }

    private static class FontTableItem {
        private final int _index;

        public FontTableItem(int index) {
            this._index = index;
        }

        public int getIndex() {
            return this._index;
        }
    }

    private static class Group {
        public int beginRow;
        public int endRow;
        public boolean collapsed;

        public Group(int beginRow, int endRow, boolean collapsed) {
            this.beginRow = beginRow;
            this.endRow = endRow;
            this.collapsed = collapsed;
        }
    }

    private static class Level {
        public int beginRow;
        public int hide_kind;

        public Level(int beginRow, int hide_kind) {
            this.beginRow = beginRow;
            this.hide_kind = hide_kind;
        }
    }

    private static class SheetInfo {
        int rowCount = 0;
        int colCount = 0;
        int widthsCount = 0;
        boolean hasTables = false;
        boolean repeatHeader = false;
        SXSSFSheet sheet = null;
        IntegerList paraRowIndexes = new IntegerList(16);
        IntegerList paraRowLineAlignes = new IntegerList(16);
        double sheetWidth = 0.0;
        double sheetColWidths = 0.0;

        private SheetInfo() {
        }
    }
}

