/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.style;

import inform.adt.collections.AbstractHash;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.style.CellStyle;
import inform.agent.web.reports.style.DocCellStyle;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.TableMargins;
import java.util.concurrent.atomic.AtomicInteger;

public class DocCellStyleTable
extends AbstractHash<DocCellStyle> {
    private final AtomicInteger styleId = new AtomicInteger(-1);

    public DocCellStyle get(Font font, int color, TableMargins margins) {
        DocCellStyle e;
        int m = this.mask;
        int i = DocCellStyle.styleHashCode(font, color, margins) & m;
        while ((e = ((DocCellStyle[])this.data)[i]) != null && !DocCellStyle.styleEquals(e, font, color)) {
            i = i + 1 & m;
        }
        return e;
    }

    public DocCellStyle get(CellStyle style) {
        return this.get(style.getFont(), style.getColor(), style.getMargins());
    }

    public DocCellStyle add(Document document, Font font, int color, TableMargins margins) {
        DocCellStyle s = this.get(font, color, margins);
        if (s != null) {
            return s;
        }
        s = new DocCellStyle(document, this.styleId.incrementAndGet(), font, color, margins);
        super.add(s);
        return s;
    }

    public DocCellStyle add(Document document, CellStyle style) {
        DocCellStyle s = this.get(style);
        if (s != null) {
            return s;
        }
        s = new DocCellStyle(document, this.styleId.incrementAndGet(), style);
        super.add(s);
        return s;
    }

    @Override
    protected int hash(DocCellStyle s) {
        assert (s != null);
        return DocCellStyle.styleHashCode(s);
    }

    @Override
    protected boolean equals(DocCellStyle a, DocCellStyle b) {
        assert (a != null && b != null);
        return DocCellStyle.styleEquals(a, b);
    }

    protected DocCellStyle[] allocate(int count) {
        return new DocCellStyle[count];
    }
}

