/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.style;

import inform.agent.web.reports.document.DocFont;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.style.TextStyle;
import inform.agent.web.utils.Font;

public class DocTextStyle {
    protected final int id;
    protected final DocFont font;
    protected final int color;

    public DocTextStyle(Document document, int id, Font font, int color) {
        this.id = id;
        this.font = document.getDocFont(font);
        this.color = color;
    }

    public DocTextStyle(Document document, int id, TextStyle style) {
        this(document, id, style.getFont(), style.getColor());
    }

    public int getColor() {
        return this.color;
    }

    public DocFont getFont() {
        return this.font;
    }

    public int getId() {
        return this.id;
    }

    public static int styleHashCode(DocTextStyle s) {
        return Font.styleHashCodeByFontIndex(s.font) << 3 ^ s.color;
    }

    public static int styleHashCode(Font font, int color) {
        return Font.styleHashCodeByFontIndex(font) << 3 ^ color;
    }

    public static boolean styleEquals(DocTextStyle a, DocTextStyle s) {
        return a.color == s.color && Font.styleEqualsByFontIndex(a.font, s.font);
    }

    public static boolean styleEquals(DocTextStyle a, Font font, int color) {
        return a.color == color && Font.styleEqualsByFontIndex(a.font, font);
    }
}

