/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.rq;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.agent.Core;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.Row;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.types.DataType;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerTask;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ExecuteScript
extends AsmoServlet.WithSession {
    public ExecuteScript() {
        super(AsmoServlet.Type.JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, Session session) throws Throwable {
        response.setCharacterEncoding("WINDOWS-1251");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Type", "application/json");
        double requestOwner = ValueCaster.toDouble(request.getParameter("owner"));
        int requestUid = ValueCaster.toInt(request.getParameter("uid"));
        Node node = MtdEngine.getValidNode(Double.parseDouble(request.getParameter("node")));
        if (node.getType() != 47) {
            throw new IllegalArgumentException("ServerScript node expected");
        }
        SSContext.WebRequest ssContext = new SSContext.WebRequest(session.newRequestNo(), 4, session);
        ssContext.ownerId = requestOwner;
        ssContext.nodeId = node.getId();
        ssContext.uid = requestUid;
        String asyncId = request.getParameter("async");
        Context cx = Core.asmoJsContextFactory.enterContext();
        cx.setLanguageVersion(200);
        try {
            AbstractHttpConnection connection = ((Request)request).getConnection();
            ssHost.setSSContext(ssContext);
            try (ScriptServerSideHost ssHost = asyncId == null ? new ScriptServerSideHost(node.getId(), session.user(), (AbstractConnection)connection) : new ScriptServerSideHost(node.getId(), session, asyncId, (AbstractConnection)connection);){
                ConnectionManager dbManager = ConnectionManager.capture(-1, ssHost, "rq:ExecuteScript");
                try (ServerTask task = new ServerTask((SSContext)ssContext, node.getId(), ssHost, dbManager, null);){
                    ScriptableObject topLevelScope = ScriptableRequest.createTopLevelScope(cx, task, ssHost, dbManager);
                    ssHost.setTopLevelScope(topLevelScope);
                    task.load();
                    String prms = request.getParameter("parameters");
                    if (prms != null) {
                        ParametersList plist = task.getParameters();
                        for (Object pbi : (Object[])JSON.parse(prms)) {
                            Object[] pb = (Object[])pbi;
                            int pid = ValueCaster.toInt(pb[0]);
                            Parameter p = plist.get(pid);
                            if (p == null) continue;
                            Object value = pb[1];
                            if (value == null) {
                                p.clear();
                                continue;
                            }
                            if (value instanceof Map) {
                                p.setIgnore();
                                continue;
                            }
                            p.setRawValue(value);
                        }
                    }
                    task.setParentScope(topLevelScope);
                    ssHost.setConstants(task.getConstants());
                    task.executeScript(cx);
                    if (task.getOnExecute() == null || task.getOnExecute().length() <= 0) {
                        throw new InformException("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u044f onExecute \u0434\u043b\u044f " + node.toLogString());
                    }
                    ScriptableObject.callMethod(task, task.getOnExecute(), null);
                    if (dbManager.hasModifications()) {
                        StringBuilder message = new StringBuilder("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 ");
                        message.append(node.toLogString());
                        DoubleSet dsids = new DoubleSet();
                        int delimiter = 32;
                        for (Row r : dbManager.getModifiedRows()) {
                            dsids.add(r.getTableDescriptor().getNodeId());
                        }
                        if (dsids.size() > 1) {
                            message.append("\u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0430\u0445 ");
                        } else {
                            message.append("\u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ");
                        }
                        for (Cursor.Double c : dsids) {
                            message.append((char)delimiter).append(NumberConverter.doubleToString(c.value));
                            delimiter = 44;
                        }
                        throw new InformException(message.toString());
                    }
                    dbManager.commit();
                    PrintWriter w = response.getWriter();
                    w.append("{\"parameters\":{");
                    boolean nc = false;
                    for (Parameter p : task.getParameters().values()) {
                        if (!p.returnValue()) continue;
                        if (nc) {
                            w.append(',');
                        }
                        nc = true;
                        w.append('\"').append(Integer.toString(p.getId())).append('\"');
                        w.append(':');
                        if (p.getIsIgnored()) {
                            w.append("{}");
                            continue;
                        }
                        DataType t = p.getDataType();
                        Object v = p.getRawValue();
                        if (v instanceof Object[]) {
                            boolean _nc = false;
                            w.append('[');
                            for (Object av : (Object[])v) {
                                if (_nc) {
                                    w.append(',');
                                }
                                _nc = true;
                                ExecuteScript.storeParameterValue(w, t, av);
                            }
                            w.append(']');
                            continue;
                        }
                        ExecuteScript.storeParameterValue(w, t, v);
                    }
                    w.append("}}");
                }
                finally {
                    ((AbstractConnectionManager)dbManager).release();
                }
            }
        }
        finally {
            Context.exit();
        }
    }

    private static void storeParameterValue(Appendable out, DataType type, Object value) throws Throwable {
        if (value == null) {
            out.append("null");
        } else {
            switch (type) {
                case BOOLEAN: {
                    out.append(ValueCaster.toBoolean(value) != false ? "true" : "false");
                    break;
                }
                case DATE_TIME: {
                    if (value instanceof DateTimeInterval) {
                        throw new UnsupportedOperationException("DateTimeInterval");
                    }
                    out.append(ValueCaster.toNumber(value).toString());
                    break;
                }
                case FLOAT: 
                case DIRECTORY: 
                case INTERVAL: 
                case METATREE_NODE: 
                case PRIMARY_KEY: 
                case INTEGER: {
                    out.append(ValueCaster.toNumber(value).toString());
                    break;
                }
                case UNICODE: 
                case BIG_NUMBER: 
                case STRING: {
                    out.append(JSON.toString(ValueCaster.toString(value)));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported parameter type:" + type);
                }
            }
        }
    }

    private static class ScriptServerSideHost
    extends WebServerSideHost
    implements ScriptableHost {
        Scriptable topLevelScope;
        Constants constants;

        ScriptServerSideHost(double nodeId, Session.User user, AbstractConnection connection) {
            super(nodeId, user, connection);
        }

        ScriptServerSideHost(double nodeId, Session session, String asyncId, AbstractConnection connection) {
            super(nodeId, session, asyncId, connection);
        }

        @Override
        public Scriptable getTopLevelScope() {
            return this.topLevelScope;
        }

        @Override
        public void setTopLevelScope(Scriptable topLevelScope) {
            this.topLevelScope = topLevelScope;
        }

        @Override
        public Constants getConstants() {
            return this.constants;
        }

        @Override
        public void setConstants(Constants constants) {
            this.constants = constants;
        }

        @Override
        public SSContext getRootContext() {
            return this.getSSContext();
        }
    }
}

