/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.rq;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.scripts.SSContext;
import inform.agent.web.AsmoServlet;
import inform.agent.web.Session;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.ajax.JSON;

public class GetDistinctValues
extends AsmoServlet.WithSession {
    private static final int FETCH_LIMIT = 1024;

    public GetDistinctValues() {
        super(AsmoServlet.Type.JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp, Session session) throws Throwable {
        String termParam;
        FieldDescriptor fd;
        double ownerId;
        String requestValue;
        resp.setCharacterEncoding(TaggedWriter.ANSI.name());
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Content-Type", "application/json");
        String requestTable = req.getParameter("t");
        double tableId = Long.parseLong(requestTable);
        TableNode table = (TableNode)MtdEngine.getValidNode(tableId);
        TableDescriptor descr = table.getDescriptor();
        String requestField = req.getParameter("v");
        FieldDescriptor fv = descr.getFieldDescriptor(Integer.parseInt(requestField));
        String d = requestValue = req.getParameter("d");
        try {
            ownerId = ValueCaster.toDouble(req.getParameter("owner"));
        }
        catch (Throwable e) {
            ownerId = 0.0;
        }
        if (d == null) {
            fd = fv;
            for (FieldDescriptor f : descr.getFields()) {
                if (f.getType() != DataType.STRING) continue;
                fd = f;
                break;
            }
        } else {
            fd = descr.getFieldDescriptor(Integer.valueOf(requestValue));
        }
        DatabaseDescriptor dd = descr.getDatabaseDescriptor();
        SSContext.WebRequest ssContext = new SSContext.WebRequest(session.newRequestNo(), 2, session);
        ssContext.ownerId = ownerId;
        ssContext.nodeId = tableId;
        String sep = "";
        ssContext.script = "";
        if (!Strings.isVoid(requestField)) {
            ssContext.script = ssContext.script + sep + "field: " + requestField;
            sep = "\n";
        }
        if (!Strings.isVoid(requestValue)) {
            ssContext.script = ssContext.script + sep + "value: " + requestValue;
            sep = "\n";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT ").append(fv.getRawName()).append(',').append(fd.getRawName()).append(" FROM ");
        dd.appendTableRawName(descr.getRawName(), sql);
        String term = req.getParameter("term");
        if (term != null) {
            termParam = "%" + term.toUpperCase() + "%";
            sql.append(" WHERE upper(").append(fd.getRawName()).append(") LIKE ?");
        } else {
            termParam = null;
        }
        try (DatabaseConnection connection = dd.connect(null, "WEB:GetDistinctValues");
             PreparedStatement statement = connection.prepareStatement(sql.toString());){
            if (termParam != null) {
                statement.setString(1, termParam);
            }
            PrintWriter w = resp.getWriter();
            try (ResultSet rs = statement.executeQuery(ssContext);){
                w.append('[');
                boolean nc = false;
                int rcount = 0;
                while (rs.next()) {
                    if (nc) {
                        w.append(',');
                    }
                    nc = true;
                    w.append("{\"v\":");
                    w.append(JSON.toString((Object)rs.getString(1)));
                    w.append(",\"d\":");
                    w.append(JSON.toString((Object)rs.getString(2)));
                    w.append("}");
                    if (++rcount != 1024) continue;
                }
                w.append(']');
            }
        }
    }
}

