/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;

public class BorderStyle {
    public static final int NONE = 0;
    public static final int DOTTED = 1;
    public static final int THIN = 2;
    public static final int MEDIUM = 3;
    public static final int THICK = 4;
    public static final int DOUBLE = 5;
    public static final int TAG_WEB_BORDER_STYLE = 1;
    public static final int TAG_WEB_BORDER_COLOR = 2;
    private int type = 0;
    private int color = 0;

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.type = in.getInt();
                    break;
                }
                case 2: {
                    this.color = in.getInt();
                }
            }
        }
    }

    public void store(TaggedWriter out) throws IOException {
        out.putInt32(1, this.type);
        out.putInt32(2, this.color);
        out.flush();
    }

    public void storeAs(int tag, ByteArrayOutputStream stream, TaggedWriter writer, TaggedWriter out) throws IOException {
        stream.reset();
        writer.reset(stream);
        this.store(writer);
        out.putRaw(tag, stream);
    }

    public String getClassName() {
        return "Border";
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void reset() {
        this.type = 0;
        this.color = 0;
    }

    public void assign(BorderStyle style) {
        this.type = style.type;
        this.color = style.color;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BorderStyle) {
            BorderStyle that = (BorderStyle)obj;
            return that.type == this.type && that.color == this.color;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + this.type;
        hash = 19 * hash + this.color;
        return hash;
    }
}

