/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

public class Color {
    public static final int clNone = 0x1FFFFFFF;
    public static final int clBlack = 0;
    public static final int clWhite = 0xFFFFFF;
    public static final int clMaroon = 128;
    public static final int clGreen = 32768;
    public static final int clLime = 65280;
    public static final int clBlue = 0xFF0000;
    public static final int clGray = 0x808080;
    public static final int clYellow = 65535;
    public static final int clRed = 255;
    public static final int clTeal = 0x808000;
    public static final int clOlive = 32896;
    public static final int clSilver = 0xC0C0C0;
    public static final int clNavy = 0x800000;
    public static final int clAqua = 0xFFFF00;
    public static final int clFuchsia = 0xFF00FF;
    public static final int clPurple = 0x800080;
    public static final int clFontDefault = 0;
    public static final int clDefault = 0xFFFFFF;
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private static BasicColorDesc[] basicColorDescs;

    public static BasicColorDesc[] getBasicColorDesc() {
        if (basicColorDescs == null) {
            basicColorDescs = new BasicColorDesc[16];
            Color.basicColorDescs[0] = new BasicColorDesc("black", 0);
            Color.basicColorDescs[1] = new BasicColorDesc("silver", 0xC0C0C0);
            Color.basicColorDescs[2] = new BasicColorDesc("gray", 0x808080);
            Color.basicColorDescs[3] = new BasicColorDesc("white", 0xFFFFFF);
            Color.basicColorDescs[4] = new BasicColorDesc("maroon", 128);
            Color.basicColorDescs[5] = new BasicColorDesc("red", 255);
            Color.basicColorDescs[6] = new BasicColorDesc("purple", 0x800080);
            Color.basicColorDescs[7] = new BasicColorDesc("fuchsia", 0xFF00FF);
            Color.basicColorDescs[8] = new BasicColorDesc("green", 32768);
            Color.basicColorDescs[9] = new BasicColorDesc("lime", 65280);
            Color.basicColorDescs[10] = new BasicColorDesc("olive", 32896);
            Color.basicColorDescs[11] = new BasicColorDesc("yellow", 65535);
            Color.basicColorDescs[12] = new BasicColorDesc("navy", 0x800000);
            Color.basicColorDescs[13] = new BasicColorDesc("blue", 0xFF0000);
            Color.basicColorDescs[14] = new BasicColorDesc("teal", 0x808000);
            Color.basicColorDescs[15] = new BasicColorDesc("aqua", 0xFFFF00);
        }
        return basicColorDescs;
    }

    public static String toHtml(int color) {
        char[] buff = new char[7];
        buff[0] = 35;
        for (int i = 0; i < 3; ++i) {
            buff[i * 2 + 2] = HEX[color & 0xF];
            buff[i * 2 + 1] = HEX[(color >>= 4) & 0xF];
            color >>= 4;
        }
        return new String(buff);
    }

    public static int[] hexToRgb(String color) {
        int[] rgb = new int[3];
        if (color == null || color.equals("")) {
            return null;
        }
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        for (int i = 0; i < 3; ++i) {
            rgb[i] = Integer.valueOf(color.substring(i * 2, i * 2 + 2), 16);
        }
        return rgb;
    }

    public static String rgbToHex(int[] rgb) {
        String[] rgbHex = new String[3];
        for (int i = 0; i < 3; ++i) {
            rgbHex[i] = Integer.toString(rgb[i], 16);
            if (rgbHex[i].length() != 1) continue;
            rgbHex[i] = "0" + rgbHex[i];
        }
        return "#" + rgbHex[0] + rgbHex[1] + rgbHex[2];
    }

    public static int toColor(byte r, byte g, byte b) {
        int ri = r & 0xFF;
        int gi = g & 0xFF;
        int bi = b & 0xFF;
        return bi << 16 | gi << 8 | ri;
    }

    public static class BasicColorDesc {
        public String desc;
        public int color;

        public BasicColorDesc(String d, int c) {
            this.desc = d;
            this.color = c;
        }
    }
}

