/*
 * Decompiled with CFR 0.152.
 */
package inform.common;

import inform.adt.InformException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.WrappedException;

public class Exceptions {
    static StackTraceElement[] e2s(Throwable t, StringBuilder message, StringBuilder detailing, StringBuilder callstack) {
        StackTraceElement[] r;
        block21: {
            block19: {
                int si;
                StackTraceElement[] s;
                block20: {
                    boolean rt;
                    Throwable c;
                    if (t instanceof RhinoException) {
                        RhinoException rt2 = (RhinoException)t;
                        Object m = t instanceof WrappedException ? null : rt2.details();
                        m = m == null ? "" : ((String)m).trim();
                        detailing.append(t.getClass().getName()).append(": ").append((String)m);
                        ScriptStackElement[] stack = rt2.getScriptStack();
                        if (message.length() == 0) {
                            message.append((String)m);
                        }
                        detailing.append('\n');
                        if (stack == null || stack.length == 0) {
                            detailing.append("\tat ").append(rt2.sourceName()).append(':').append(rt2.lineNumber()).append('\n');
                        } else {
                            ScriptStackElement[] scriptStackElementArray = stack;
                            int n = scriptStackElementArray.length;
                            for (int i = 0; i < n; ++i) {
                                ScriptStackElement e = scriptStackElementArray[i];
                                if (e.functionName == null) {
                                    detailing.append("\tat ").append(e.fileName).append(':').append(e.lineNumber).append('\n');
                                    continue;
                                }
                                detailing.append("\tat ").append(e.functionName).append('(').append(e.fileName).append(':').append(e.lineNumber).append(")\n");
                            }
                        }
                    } else {
                        String m = t.getMessage();
                        m = m == null ? "" : m.trim();
                        detailing.append(t.getClass().getName()).append(": ").append(m);
                        if (message.length() == 0) {
                            if (t instanceof UnknownHostException) {
                                message.append("\u0425\u043e\u0441\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: ");
                            }
                            message.append(m);
                        }
                        detailing.append('\n');
                        if (t instanceof InformException) {
                            for (String d : ((InformException)t).details()) {
                                detailing.append('\t').append(d).append('\n');
                            }
                        }
                        if (t instanceof SQLException) {
                            SQLException e = (SQLException)t;
                            s = e.getSQLState();
                            if (s != null) {
                                detailing.append("\tSQLState: ").append((String)s).append('\n');
                            }
                            int left = 8;
                            while (left-- > 0 && (e = e.getNextException()) != null) {
                                detailing.append("\tNextException: ").append(e.getMessage()).append(", SQLState: ").append(e.getSQLState()).append('\n');
                            }
                        }
                    }
                    if ((c = t.getCause()) == null) break block19;
                    r = Exceptions.e2s(c, message, detailing, callstack);
                    s = t.getStackTrace();
                    int ri = r.length - 1;
                    for (si = s.length - 1; ri > 0 && si > 0 && r[ri].equals(s[si]); --ri, --si) {
                    }
                    boolean bl = rt = t instanceof InformException && ((InformException)t).wrapped();
                    if (!rt) break block20;
                    if (si <= 0) break block21;
                    callstack.append("rewrapped ");
                    for (int i = 1; i <= si; ++i) {
                        if (i > 1) {
                            callstack.append('\t');
                        }
                        callstack.append("at ").append(s[i]).append('\n');
                    }
                    break block21;
                }
                callstack.append("rethrowed as: ").append(t.getClass().getName()).append('\n');
                for (int i = 0; i <= si; ++i) {
                    callstack.append("\tat ").append(s[i]).append('\n');
                }
                break block21;
            }
            callstack.append(t.getClass().getName()).append('\n');
            for (StackTraceElement e : r = t.getStackTrace()) {
                callstack.append("\tat ").append(e).append('\n');
            }
        }
        return r;
    }

    public static String toString(Throwable t, StringBuilder detailing, StringBuilder callstack) {
        StringBuilder message = new StringBuilder();
        Exceptions.e2s(t, message, detailing, callstack);
        return message.toString();
    }

    public static String toFullString(Throwable t) {
        StringBuilder detailing = new StringBuilder();
        StringBuilder callstack = new StringBuilder();
        StringBuilder message = new StringBuilder();
        Exceptions.e2s(t, message, detailing, callstack);
        message.append('\n').append((CharSequence)detailing).append('\n').append((CharSequence)callstack);
        return message.toString();
    }

    public static String extractSqlException(Throwable e) {
        String m = e.getMessage();
        if (m == null && e.getCause() != null && e.getCause() != e) {
            m = Exceptions.extractSqlException(e.getCause());
        }
        if (m == null) {
            return "";
        }
        return m;
    }
}

