/*
 * Decompiled with CFR 0.152.
 */
package inform.common;

import inform.adt.InformException;
import inform.common.StandardTemplateIDGenerator;
import inform.common.TemplateIDGenerator;

public class IdGenerator {
    private static final StandardTemplateIDGenerator stdTemplateGenerator = new StandardTemplateIDGenerator();
    public static final double TEMPLATE_SEQUENCE_SHIFT = 100.0;
    public static final double TEMPLATE_SEQUENCE_LOGIN_SHIFT = 10.0;
    public static final int MAX_COUNTER = 99;
    public static final int MAX_LOGIN_COUNTER = 9;
    private static TemplateIDGenerator templateIDGenerator = stdTemplateGenerator;
    private static int maxCounter = 99;
    private static int counter = 99;
    private static double template_id;
    private static final Object loginMutex;
    private static int loginIDCounter;
    private static double loginIDTemplate;

    private IdGenerator() {
    }

    public static synchronized void setTemplateGenerator(TemplateIDGenerator templateIDGenerator) {
        IdGenerator.templateIDGenerator = templateIDGenerator;
        maxCounter = 99;
        counter = 99;
    }

    public static synchronized void setTemplateGenerator(TemplateIDGenerator templateIDGenerator, double template_id, int maxCounter) {
        IdGenerator.templateIDGenerator = templateIDGenerator;
        IdGenerator.maxCounter = maxCounter <= 0 ? 99 : maxCounter;
        if (template_id == 0.0) {
            counter = IdGenerator.maxCounter;
        } else {
            IdGenerator.template_id = template_id;
            counter = 1;
        }
    }

    public static synchronized void setStandardTemplate() {
        templateIDGenerator = stdTemplateGenerator;
        maxCounter = 99;
        counter = 99;
    }

    public static synchronized void setMaxCounter(int maxCounter) {
        IdGenerator.maxCounter = maxCounter <= 0 ? 99 : maxCounter;
    }

    public static synchronized double genId() throws InformException {
        if (counter >= maxCounter) {
            template_id = templateIDGenerator.generateTemplate();
            counter = 1;
            return template_id + (double)counter;
        }
        return template_id + (double)(++counter);
    }

    public static synchronized double generateTemplate() throws InformException {
        double templateId = templateIDGenerator.generateTemplate();
        return templateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double generateLoginTemplate() throws InformException {
        Object object = loginMutex;
        synchronized (object) {
            if (loginIDCounter >= 9) {
                double templateId = loginIDTemplate = IdGenerator.generateTemplate();
                loginIDCounter = 0;
                return templateId;
            }
            return loginIDTemplate + (double)(++loginIDCounter * 10);
        }
    }

    static {
        loginMutex = new Object();
        loginIDCounter = 10;
        loginIDTemplate = 0.0;
    }
}

