/*
 * Decompiled with CFR 0.152.
 */
package inform.common;

import inform.adt.Cache;
import inform.adt.Strings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.ScriptableObject;

public abstract class SmartScriptableObject
extends ScriptableObject {
    private static final Cache<Class, Proto> CLASS_PROTOS = new Cache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmartScriptableObject() {
        Proto proto;
        Class<?> cls = this.getClass();
        Cache<Class, Proto> cache = CLASS_PROTOS;
        synchronized (cache) {
            proto = CLASS_PROTOS.get(cls);
        }
        if (proto == null) {
            proto = new Proto(cls);
            cache = CLASS_PROTOS;
            synchronized (cache) {
                Proto p = CLASS_PROTOS.putAndGet(cls, proto);
                if (p != null) {
                    proto = p;
                    CLASS_PROTOS.put(cls, proto);
                }
            }
        }
        this.setPrototype(proto);
    }

    @Override
    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        if (typeHint == String.class) {
            return this.getClassName();
        }
        return super.getDefaultValue(typeHint);
    }

    private static class Proto
    extends ScriptableObject {
        final Class<?> clazz;

        public Proto(Class<?> clazz) {
            this.clazz = clazz;
            HashSet<String> defined = new HashSet<String>();
            do {
                for (Method m : clazz.getDeclaredMethods()) {
                    Method s;
                    FunctionTag f = m.getAnnotation(FunctionTag.class);
                    if (f != null) {
                        String name = f.name();
                        if (Strings.isVoid(name)) {
                            name = m.getName();
                        }
                        if (!defined.add(name)) continue;
                        FunctionObject method = new FunctionObject(name, m, this);
                        this.defineProperty(name, (Object)method, f.attributes());
                        continue;
                    }
                    PropertyTag p = m.getAnnotation(PropertyTag.class);
                    if (p == null) continue;
                    Object name = m.getName();
                    String propName = p.name();
                    if (!Strings.isVoid(propName) ? !defined.add(propName) : !defined.add((String)name)) continue;
                    if (((String)name).startsWith("get")) {
                        name = ((String)name).substring(3);
                        try {
                            s = clazz.getMethod("set" + (String)name, m.getReturnType());
                        }
                        catch (NoSuchMethodException e) {
                            s = null;
                        }
                        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
                    } else {
                        try {
                            s = clazz.getMethod((String)name, m.getReturnType());
                        }
                        catch (NoSuchMethodException e) {
                            s = null;
                        }
                    }
                    this.defineProperty((String)(Strings.isVoid(propName) ? name : propName), null, m, s, p.attributes() | (s == null ? 1 : 0));
                }
            } while ((clazz = clazz.getSuperclass()) != SmartScriptableObject.class);
        }

        @Override
        public String getClassName() {
            return this.clazz.getSimpleName() + "Proto";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PropertyTag {
        public int attributes() default 0;

        public String name() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface FunctionTag {
        public int attributes() default 0;

        public String name() default "";
    }
}

