/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.io.BytesInputStream;
import io.jsonwebtoken.impl.io.CharSequenceReader;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.Callable;

public class Streams {
    public static final int EOF = -1;

    public static byte[] bytes(InputStream in, String exmsg) {
        if (in instanceof BytesInputStream) {
            return ((BytesInputStream)in).getBytes();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        Streams.copy(in, out, new byte[8192], exmsg);
        return out.toByteArray();
    }

    public static InputStream of(byte[] bytes) {
        return new BytesInputStream(bytes);
    }

    public static InputStream of(CharSequence seq) {
        return Streams.of(Strings.utf8((CharSequence)seq));
    }

    public static Reader reader(byte[] bytes) {
        return Streams.reader(Streams.of(bytes));
    }

    public static Reader reader(InputStream in) {
        return new InputStreamReader(in, Strings.UTF_8);
    }

    public static Reader reader(CharSequence seq) {
        return new CharSequenceReader(seq);
    }

    public static void flush(Flushable ... flushables) {
        Objects.nullSafeFlush((Flushable[])flushables);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        Assert.notNull((Object)inputStream, (String)"inputStream cannot be null.");
        Assert.notNull((Object)outputStream, (String)"outputStream cannot be null.");
        Assert.notEmpty((byte[])buffer, (String)"buffer cannot be null or empty.");
        long count = 0L;
        int n = 0;
        while (n != -1) {
            n = inputStream.read(buffer);
            if (n > 0) {
                outputStream.write(buffer, 0, n);
            }
            count += (long)n;
        }
        return count;
    }

    public static long copy(final InputStream in, final OutputStream out, final byte[] buffer, String exmsg) {
        return Streams.run(new Callable<Long>(){

            @Override
            public Long call() throws IOException {
                Long l;
                try {
                    Streams.reset(in);
                    l = Streams.copy(in, out, buffer);
                }
                catch (Throwable throwable) {
                    Objects.nullSafeFlush((Flushable[])new Flushable[]{out});
                    Streams.reset(in);
                    throw throwable;
                }
                Objects.nullSafeFlush((Flushable[])new Flushable[]{out});
                Streams.reset(in);
                return l;
            }
        }, exmsg);
    }

    public static void reset(final InputStream in) {
        if (in == null) {
            return;
        }
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    in.reset();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void write(OutputStream out, byte[] bytes, String exMsg) {
        Streams.write(out, bytes, 0, Bytes.length(bytes), exMsg);
    }

    public static void write(final OutputStream out, final byte[] data, final int offset, final int len, String exMsg) {
        if (out == null || Bytes.isEmpty(data) || len <= 0) {
            return;
        }
        Streams.run(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                out.write(data, offset, len);
                return null;
            }
        }, exMsg);
    }

    public static void writeAndClose(OutputStream out, byte[] data, String exMsg) {
        try {
            Streams.write(out, data, exMsg);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        Objects.nullSafeClose((Closeable[])new Closeable[]{out});
    }

    public static <V> V run(Callable<V> c, String ioExMsg) {
        Assert.hasText((CharSequence)ioExMsg, (String)"IO Exception Message cannot be null or empty.");
        try {
            return c.call();
        }
        catch (Throwable t) {
            String msg = "IO failure: " + ioExMsg;
            if (!msg.endsWith(".")) {
                msg = msg + ".";
            }
            msg = msg + " Cause: " + t.getMessage();
            throw new io.jsonwebtoken.io.IOException(msg, t);
        }
    }
}

