/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class StAX2SAX {
    private final ContentHandler handler;
    private final LexicalHandler lhandler;
    private final XMLInputFactory xef;
    static final LexicalHandler NO_LEXICAL_HANDLER = new LexicalHandler(){

        @Override
        public void startDTD(String string, String string1, String string2) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String string) throws SAXException {
        }

        @Override
        public void endEntity(String string) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] chars, int i, int i1) throws SAXException {
        }
    };

    public StAX2SAX(ContentHandler handler) {
        this.handler = handler;
        this.lhandler = handler instanceof LexicalHandler ? (LexicalHandler)((Object)handler) : NO_LEXICAL_HANDLER;
        this.xef = XMLInputFactory.newInstance();
    }

    public void parse(XMLStreamReader xmlReader) throws XMLStreamException, SAXException {
        this.handler.setDocumentLocator(new LocatorConv(xmlReader));
        this.parse(this.xef.createXMLEventReader(xmlReader));
    }

    public void parse(XMLEventReader xmlReader) throws XMLStreamException, SAXException {
        while (xmlReader.hasNext()) {
            XMLEvent e = xmlReader.nextEvent();
            if (e.isStartDocument()) {
                this.handler.startDocument();
                continue;
            }
            if (e.isEndDocument()) {
                this.handler.endDocument();
                continue;
            }
            if (e.isStartElement()) {
                this.emitSE(e.asStartElement());
                continue;
            }
            if (e.isEndElement()) {
                this.emitEE(e.asEndElement());
                continue;
            }
            if (e.isProcessingInstruction()) {
                this.emitPi((ProcessingInstruction)e);
                continue;
            }
            if (e.isCharacters()) {
                this.emitChars(e.asCharacters());
                continue;
            }
            if (e.isAttribute()) {
                this.emitAttr((Attribute)e);
                continue;
            }
            if (e.isEntityReference()) {
                this.emitEnt((EntityDeclaration)e);
                continue;
            }
            if (e.isNamespace()) {
                this.emitNS((Namespace)e);
                continue;
            }
            if (e instanceof Comment) {
                this.emitComment((Comment)e);
                continue;
            }
            if (e instanceof DTD) {
                this.emitDTD((DTD)e);
                continue;
            }
            throw new SAXException("Unknown / unhandled event type " + e);
        }
    }

    private void emitSE(StartElement se) throws SAXException {
        Iterator aIter = se.getAttributes();
        this.handler.startElement(se.getName().getNamespaceURI(), se.getName().getLocalPart(), this.qnameToS(se.getName()), this.convertAttrs(aIter));
        Iterator it = se.getNamespaces();
        while (it.hasNext()) {
            this.emitNS((Namespace)it.next());
        }
    }

    private void emitEE(EndElement ee) throws SAXException {
        this.handler.endElement(ee.getName().getNamespaceURI(), ee.getName().getLocalPart(), this.qnameToS(ee.getName()));
        Iterator it = ee.getNamespaces();
        while (it.hasNext()) {
            this.emitNSGone((Namespace)it.next());
        }
    }

    private void emitPi(ProcessingInstruction pi) throws SAXException {
        this.handler.processingInstruction(pi.getTarget(), pi.getData());
    }

    private void emitChars(Characters chars) throws SAXException {
        if (chars.isIgnorableWhiteSpace()) {
            this.handler.ignorableWhitespace(chars.getData().toCharArray(), 0, chars.getData().length());
        } else {
            this.handler.characters(chars.getData().toCharArray(), 0, chars.getData().length());
        }
    }

    private void emitAttr(Attribute attribute) {
    }

    private void emitEnt(EntityDeclaration entityDeclaration) {
    }

    private void emitNS(Namespace namespace) throws SAXException {
        if (namespace.getPrefix() == null || namespace.getNamespaceURI() == null) {
            return;
        }
        this.handler.startPrefixMapping(namespace.getPrefix(), namespace.getNamespaceURI());
    }

    private void emitNSGone(Namespace namespace) throws SAXException {
        this.handler.endPrefixMapping(namespace.getPrefix());
    }

    private void emitComment(Comment comment) throws SAXException {
        this.lhandler.comment(comment.getText().toCharArray(), 0, comment.getText().length());
    }

    private void emitDTD(DTD dtd) {
    }

    private Attributes convertAttrs(Iterator<Attribute> attributes) {
        AttributesImpl toReturn = new AttributesImpl();
        while (attributes.hasNext()) {
            Attribute a = attributes.next();
            toReturn.addAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), this.qnameToS(a.getName()), a.getDTDType(), a.getValue());
        }
        return toReturn;
    }

    private String qnameToS(QName name) {
        if (name.getPrefix().length() == 0) {
            return name.getLocalPart();
        }
        return name.getPrefix() + ":" + name.getLocalPart();
    }

    static class LocatorConv
    implements Locator {
        private final XMLStreamReader reader;

        public LocatorConv(XMLStreamReader reader) {
            this.reader = reader;
        }

        @Override
        public final String getPublicId() {
            return this.reader.getLocation().getPublicId();
        }

        @Override
        public final String getSystemId() {
            return this.reader.getLocation().getSystemId();
        }

        @Override
        public final int getLineNumber() {
            return this.reader.getLocation().getLineNumber();
        }

        @Override
        public final int getColumnNumber() {
            return this.reader.getLocation().getColumnNumber();
        }
    }
}

