/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.Characterization;
import org.apache.commons.math3.geometry.partitioning.NodesSet;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;

class BoundaryBuilder<S extends Space>
implements BSPTreeVisitor<S> {
    BoundaryBuilder() {
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S> node) {
        return BSPTreeVisitor.Order.PLUS_MINUS_SUB;
    }

    @Override
    public void visitInternalNode(BSPTree<S> node) {
        Characterization<S> minusChar;
        SubHyperplane<S> plusOutside = null;
        SubHyperplane<S> plusInside = null;
        NodesSet<S> splitters = null;
        if (node.getCut() == null) {
            throw new MathInternalError();
        }
        Characterization<S> plusChar = new Characterization<S>(node.getPlus(), node.getCut().copySelf());
        if (plusChar.touchOutside() && (minusChar = new Characterization<S>(node.getMinus(), plusChar.outsideTouching())).touchInside()) {
            plusOutside = minusChar.insideTouching();
            splitters = new NodesSet<S>();
            splitters.addAll(minusChar.getInsideSplitters());
            splitters.addAll(plusChar.getOutsideSplitters());
        }
        if (plusChar.touchInside() && (minusChar = new Characterization<S>(node.getMinus(), plusChar.insideTouching())).touchOutside()) {
            plusInside = minusChar.outsideTouching();
            if (splitters == null) {
                splitters = new NodesSet();
            }
            splitters.addAll(minusChar.getOutsideSplitters());
            splitters.addAll(plusChar.getInsideSplitters());
        }
        if (splitters != null) {
            for (BSPTree<S> up = node.getParent(); up != null; up = up.getParent()) {
                splitters.add(up);
            }
        }
        node.setAttribute(new BoundaryAttribute(plusOutside, plusInside, splitters));
    }

    @Override
    public void visitLeafNode(BSPTree<S> node) {
    }
}

