define([
    'static.util.str'
], function(strutils) {
    var bytes2base64 = strutils.bytes_to_base64;
    return function(login, password) {
        function u2a(c) {
            if (c < 0x80)
                return c;
            if ((c >= 1040) && (c <= 1103))
                return c - 1040 + 192;
            if (c === 1025) //
                return 168;
            if (c === 1105) //
                return 184;
            throw '?' + c;
        }
        function s2b(s) {
            var r = [];
            for (var i = 0; i < s.length; i++)
                r.push(u2a(s.charCodeAt(i)));
            return r;
        }
        function rq(url) {
            var rq = new XMLHttpRequest();
            rq.open("GET", asmo.root + url, false);
            rq.send();
            if ((rq.readyState !== 4) || (rq.status !== 200))
                throw rq.readyState + ":" + rq.status + ":" + rq.responseText;
            var r = JSON.parse(rq.responseText);
            if (r.error)
                throw r.error;
            return r;
        }
        var du = login.split('\\'), domain = '';
        if (du.length > 1) {
            login = du[1];
            domain = du[0];
        }
        var ui = rq("/login/json?$user=" + encodeURIComponent(login));
        if (ui.ad)
            return require(['static.ntlm'], function(Ntlm) {
                var cred = Ntlm.createCredentials({hostname: ui.ad.hostname, domain: domain || ui.ad.domain, username: login, password: password});
                var m1 = Ntlm.createMessage1(cred);
                var m2 = rq('/login/json?$ad=' + encodeURIComponent(bytes2base64(m1.data)));
                var challenge = Ntlm.getChallenge(m2.ad);
                var m3 = Ntlm.createMessage3(challenge, cred);
                var m4 = rq('/login/json?$ad=' + encodeURIComponent(bytes2base64(m3.data)));
                if (!m4.id)
                    throw m4;
                return m4;
            });
        return require(['static.crypto.md5'], function(md5) {
            var s = login + ':' + ui.salt + ':' + password;
            var r = md5.md5(s2b(s));
            if (ui.disp) {
                r.push(58);//':'
                var k = md5.base64ToBytes(ui.disp);
                for (var i in k)
                    r.push(k[i]);
                r = md5.md5(r);
            }
            var h = md5.bytesToBase64(r);
            var l = rq("/login/json/?$user=" + encodeURIComponent(login) + "&$hash=" + encodeURIComponent(h));
            return l;
        });
    };
});
