define(function () {
    var bytes_to_base64 = (typeof btoa === 'undefined') ? function (bytes) {
        var B64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
        var i = 0, l = bytes.length, result = '';
        while (i < l) {
            var b0 = bytes[i++];
            var e1 = (b0 & 3) << 4;
            result += B64.charAt(b0 >> 2);
            if (i >= l)
                return result + B64.charAt(e1) + '==';
            var b1 = bytes[i++];
            result += B64.charAt(e1 | (b1 >> 4));
            var e2 = (b1 & 15) << 2;
            if (i >= l)
                return result + B64.charAt(e2) + '=';
            var b2 = bytes[i++];
            result += B64.charAt(e2 | (b2 >> 6)) + B64.charAt(b2 & 63);
        }
        return result;
    } : function (bytes) {
        return btoa(String.fromCharCode.apply(null, bytes));
    };
    
    function a2u(c) {
        if (c < 0x80)
            return c;
        if (c === 0xA8) //
            return 1025;
        if (c === 0xB8) //
            return 1105;
        if (c >= 0xC0)
            return c - 0xC0 + 1040;
        throw '?' + c;
    }

    function bytestr_to_ansi(bytestr) {
        var tmp = [];
        for (var i = 0, l = bytestr.length; i !== l; ++i)
            tmp.push(a2u(bytestr.charCodeAt(i)));
        return String.fromCharCode.apply(null, tmp);
    }
    return {
        bytes_to_base64: bytes_to_base64,
        bytestr_to_ansi: bytestr_to_ansi,
    };
});