define([
    'inform.agent.web.Styles',
    'inform.agent.web.forms.WebForm',
    'inform.agent.web.forms.Actioner'
], function(Styles, WebForm, Actioner) {
    var rAll = {
        'position': 'absolute !important',
        'box-sizing': 'border-box !important'
    };
    Styles.sheet().rules({
        '[class^="wcl-"]': rAll,
        '[class*=" wcl-"]': rAll,
        '.wcl_root': {
            'overflow': 'hidden'
        },
        '.wcl-hide-children>*': {
            'display': 'none !important'
        },
        '.wcl-measure': {
            'width': 'auto !important',
            'height': 'auto !important'
        }
    });
    var Control = {
        UNBOUND_MIN: {x: 0, y: 0},
        UNBOUND_MAX: {x: 9999, y: 9999},
        calculate: function() {
            return {
                min: Control.UNBOUND_MIN,
                max: Control.UNBOUND_MAX
            };
        },
        validate: function(arg) {
        }
    };
    var roots = [];
    function validateRoot(r)
    {
            var root = r.root, elem = r.elem;
            log.debug('validating root:', elem);
            var ca = root.calculate();
                var w = Math.min(Math.max(ca.min.x, elem.clientWidth), ca.max.x);
                var h = Math.min(Math.max(ca.min.y, elem.clientHeight), ca.max.y);
                root.validate({
                    calc: ca,
                    rect: {
                        p: {x: 0, y: 0},
                        s: {x: w, y: h}
                    }
                });
    }
    function resize() {
        for (var i = 0, l = roots.length; i < l; i++)
            validateRoot(roots[i]);
    }
    if (window.addEventListener)
        window.addEventListener('resize', resize, false);
    else
        window.attachEvent('onresize', resize);

    var validate_scheduled = false;
    function validate() {
        validate_scheduled = false;
        for (var i = 0, l = roots.length; i < l; i++) {
            var r = roots[i];
            if (!r.valid) {
                r.valid = true;
                validateRoot(roots[i]);
            }
        }
    }
    function stack() {
        Error.captureStackTrace(this, this.constructor);
    }
    return {
        _mk: function(parent, container, arg) {
            return new arg._(parent, container, arg);
        },
        create: function(container, arg) {
            Styles.addClass(container, 'wcl_root');
            var root, parent = {
                invalidate: function() {
                    if (log.debug.enabled)
                        log.debug('wcl-invalidate:', (new stack()).stack);
                    root.valid = false;
                    if (!validate_scheduled)
                    {
                        validate_scheduled = true;
                        setTimeout(validate);
                    }
                }
            };
            roots.push(root = {
                root: null,
                elem: container,
                valid: false
            });
            var r = root.root = this._mk(parent, container, arg);
            WebForm.updateIcons(container);
            parent.invalidate();
            return r;
        },
        _measure: function(element, func) {
            var cn = element.className;
            try {
                element.className = cn + ' wcl-measure';
                func && func();
                return {
                    x: element.offsetWidth,
                    y: element.offsetHeight
                };
            } finally {
                element.className = cn;
            }
        },
        _isModel: function(v) {
            return (v instanceof Function) && (v._listen instanceof Function);
        },
        _toModel: function(v) {
            if (this._isModel(v))
                return v;
            var r = function() {
                return v;
            };
            r._listen = function() {
            };
            return r;
        },
        createFModel: function(fget, fset) {
            var r = function() {
                return fget();
            };
            var listeners = [];
            r._listen = function(l) {
                listeners.push(l);
            };
            function notify(v) {
                for (var i in listeners)
                    listeners[i](v);
            }
            r.set = function(v) {
                fset(v);
                notify(v);
            };
            return {model: r, notify: notify};
        },
        createRWModel: function(v) {
            var value = v;
            return this.createFModel(function() {
                return value;
            }, function(v) {
                value = v;
            }).model;
        },
        _modelUpdater: function(model, fupdate) {
            if (this._isModel(model))
            {
                model._listen(fupdate);
                model = model();
                if (model === Actioner.WAIT)
                    return;
            }
            fupdate(model);
        },
        rtrunc: function(r) {
            return {
                p: {x: r.p.x | 0, y: r.p.y | 0},
                s: {x: r.s.x | 0, y: r.s.y | 0}
            };
        },
        _mkRecter: function(element, fsh) {
            var old = {x: -1, y: -1, w: -1, h: -1};
            return function(r) {
                var p = r.p, x = p.x | 0, y = p.y | 0, s = r.s, w = s.x | 0, h = s.y | 0;
                if (old.x !== x) {
                    element.style.left = x + 'px';
                    old.x = x;
                }
                if (old.y !== y) {
                    element.style.top = y + 'px';
                    old.y = y;
                }
                if (old.w !== w) {
                    element.style.width = w + 'px';
                    old.w = w;
                }
                if (old.h !== h) {
                    if (!fsh || fsh(h))
                        element.style.height = h + 'px';
                    old.h = h;
                }
            };
        },
        unit2px: function(s) {
            var m = s.match(/(-?[\d+\.]+)(\w+)?/);
            var v = Number(m[1]), u = m[2];
            if (u === 'mm')
                return v * 3.8;
            return v;
        },
        Control: Control
    };
});
