define([
    'static.wcl.Core',
    'inform.agent.web.Styles'
], function(Core, Styles) {
    Styles.sheet().rules({
        '.wcl-wrapper': {
            'margin': 0
        }
    });
    return function(parent, container, arg) {
        var element = arg.item;
        Styles.addClass(element, 'wcl-wrapper');
        container.appendChild(element);
        function getcsz() {
            return {x: element.offsetWidth, y: element.offsetHeight};
        }
        var lsz = getcsz();
        this.flowType = arg.flowType|0;
        if(arg.wdiID)
        {
            this.dbg = "Wrapper";
            this.wdiID = arg.wdiID;
        }
        if(arg.wdiNAME)
            this.wdiName = arg.wdiNAME;
        this.calculate = function() {
            if (element._wcl_calculate)
                return element._wcl_calculate();
            var ow = element.style.width, oh = element.style.height, op = element.style.position, od = element.style.display;
            try {
                element.style.width = element.style.height = '';
                element.style.position = 'static';
                element.style.display = 'inline-block';
                var sz = {
                    x: element.offsetWidth,
                    y: element.offsetHeight
                };
                var bcr = element.getBoundingClientRect();
                if ((bcr.right - bcr.left) % 1) {//rounding error
                    sz.x += 1;
                    sz.y += 1;
                }
                return {
                    min: sz,
                    max: sz
                };
            } finally {
                element.style.width = ow;
                element.style.height = oh;
                element.style.position = op;
                element.style.display = od;
            }
        };
        var recter = Core._mkRecter(element);
        this.validate = function(arg) {
            recter(arg.rect);
            if (element._wcl_validate)
                element._wcl_validate(arg);
            lsz = {x: arg.rect.s.x | 0, y: arg.rect.s.y | 0};
        };
        element._wcl_invalidate = function() {
            parent.invalidate();
        };
        (function watch() {
            var sz = getcsz();
            if ((lsz.x !== sz.x) || (lsz.y !== sz.y)) {
                if (element.offsetParent)//if inserted
                    parent.invalidate();
                lsz = sz;
            }
            setTimeout(watch, 250);
        })();
    };
});
