define(function()
{

    function fromRgb(r, g, b)
    {
        return r | (g << 8) | (b << 16);
    }
    
    function blend(Color1, Color2, a) 
    {
        var c1, c2;
        var r, g, b, v1, v2;

        c1 = Color1 & 0xFFFFFF;
        c2 = Color2 & 0xFFFFFF;
        v1 = c1 & 0xFF;
        v2 = c2 & 0xFF;
        r = Math.floor(a * (v1 - v2) / 256) + v2;
        v1 = (c1 >>> 8) & 0xFF;
        v2 = (c2 >>> 8) & 0xFF;
        g = Math.floor(a * (v1 - v2) / 256) + v2;
        v1 = (c1 >>> 16) & 0xFF;
        v2 = (c2 >>> 16) & 0xFF;
        b = Math.floor(a * (v1 - v2) / 256) + v2;
        return (b << 16) + (g << 8) + r;
    }
    
    return{
        Black:      0x000000,
        Maroon:     0x000080,
        Green:      0x008000,
        Olive:      0x008080,
        Navy:       0x800000,
        Purple:     0x800080,
        Teal:       0x808000,
        Gray:       0x808080,
        Silver:     0xC0C0C0,
        Red:        0x0000FF,
        Lime:       0x00FF00,
        Yellow:     0x00FFFF,
        Blue:       0xFF0000,
        Fuchsia:    0xFF00FF,
        Aqua:       0xFFFF00,
        LtGray:     0xC0C0C0,
        DkGray:     0x808080,
        White:      0xFFFFFF,
        MoneyGreen: 0xC0DCC0,
        SkyBlue:    0xF0CAA6,
        Cream:      0xF0FBFF,
        MedGray:    0xA4A0A0,
        fromRgb: fromRgb,
        blend:   blend
    };
});
