define( ["inform.agent.web.forms.Formats"]
,function(AsmoFormats)
{
    const BASE_UNIX = 2209161600000;
    const BASE_DATE = new Date(1899, 11, 30, 0, 0, 0, 0).valueOf();
    const DATE_DELTA = 693594;
    const MSECS_PER_DAY = 24 * 60 * 60 * 1000;
    const _01_01_1970_MSECS = 2209161600000;
    const DATE_INC_ERROR = "Date's increment value is not number!";
        
    function valueOf(v)
    {
        if(v instanceof Date)
            return fromMSec(v - BASE_DATE);
        return Number(v).toFixed(11);
    }
    
    function valueToDate(v)
    {
        return new Date(Number(v)*MSECS_PER_DAY+BASE_DATE);
    }
    
    function toString(v)
    {
        return AsmoFormats.findById(410).format(valueOf(v));
    }
    
    function dateToString(v)
    {
        var d = valueToDate(valueOf(v));
        return d.getDate() + "/" + d.getMonth() + 1 + "/" + d.getFullYear();
    }
    
    function stringToDate(v)
    {
        return valueOf(AsmoFormats.findById(401).parse(v));
    }
    
    function stringToTime(v)
    {      
        var m = null;
        if (v.length === "hh_mm".length)
            m = v.match( /(\d{1,2}):(\d{1,2})/ );
        else
            m = v.match( /(\d{1,2}):(\d{1,2}):(\d{1,2})/ );
        if ( !m )
            throw "not match";
        var hour = m[1] | 0, minute = m[2] | 0, second = m[3] | 0;
        if ( (hour >= 0) && (hour <= 23) && (minute >= 0) && (minute <= 59) && (second >= 0) && (second <= 59) )
            return fromMSec(second * 1000 + minute * 60 * 1000 + hour * 60 * 60 * 1000);
        throw "out of bounds";
    }

    function stringToDateTime(v)
    {
        var d = null;
        if (v.length === "dd_MM_yyyy_hh_mm".length)
            d = valueOf(AsmoFormats.findById(406).parse(v));
        else
            d = valueOf(AsmoFormats.findById(410).parse(v));
        return d;
    }
    
    function fromMSec(msec)
    {
        return (msec/MSECS_PER_DAY).toFixed(11);
    }
    
    function date(y, m, d, h, mi, s, ms) 
    { 
        return valueOf(new Date(y||2000, (m||1)-1, d||1, h||0, mi||0, s||0, ms||0));
    }
    
    function time(hour, minute, second, msec)
    {
        return fromMSec((msec||0) + (second||0) * 1000 + (minute||0) * 60 * 1000 + (hour||0) * 60 * 60 * 1000);
    }
    
    function tenDaysOf(v)
    {
        var day = valueToDate(valueOf(v)).getDate();
        return day <= 10 ? 1 : (day <= 20 ? 2 : 3);
    }
    
    function halfYearOf(v)
    {
       var d = valueToDate(valueOf(v));
       return (d.getMonth() / 6) | 0 ? 2 : 1;
    }
    
    function incYear(v, delta)
    {
        if (delta && (typeof(delta) !== 'number'))
            throw DATE_INC_ERROR;
        var d = valueToDate(valueOf(v));
        d.setFullYear(d.getFullYear() + (delta || 1));
        return valueOf(d);
    }
    
    function incMonth(v, delta)
    {
        if (delta && (typeof(delta) !== 'number'))
            throw DATE_INC_ERROR;
        var d = valueToDate(valueOf(v));
        d.setMonth(d.getMonth() + (delta || 1));
        return valueOf(d);
    }
    
    function incDay(v, delta)
    {
        if (delta && (typeof(delta) !== 'number'))
            throw DATE_INC_ERROR;
        var d = valueToDate(valueOf(v));
        d.setDate(d.getDate() + (delta || 1));
        return valueOf(d);
    }
    
    function incHour(v, delta)
    {
        if (delta && (typeof(delta) !== 'number'))
            throw DATE_INC_ERROR;
        var d = valueToDate(valueOf(v));
        d.setHours(d.getHours() + (delta || 1));
        return valueOf(d);
    }
    
    function beginOfMonth(v)
    {
        var d = valueToDate(valueOf(v)); 
        return valueOf(new Date(d.getFullYear(), d.getMonth(), 1));
    }
    
    function endOfMonth(v)
    {
        var d = valueToDate(valueOf(v));
        return valueOf(new Date(d.getFullYear(), d.getMonth() + 1, 0, 23, 59, 59, 999));
    }

    function beginOfYear(v)
    {
        var d = valueToDate(valueOf(v)); 
        return valueOf(new Date(d.getFullYear(), 0, 1));
    }

    function endOfYear(v)
    {
        var d = valueToDate(valueOf(v));
        return valueOf(new Date(d.getFullYear(), 11, 31, 23, 59, 59, 999));
    }

    function quartOf(v)
    {
        var d = valueToDate(valueOf(v));
        return ["1", "2", "3", "4"][(d.getMonth() / 3) | 0];
    }

    function yearOf(v)
    {
        var d = valueToDate(valueOf(v));
        return d.getFullYear();
    }
    
    function dayOf(v)
    {
        var d = valueToDate(valueOf(v));
        return d.getDate();
    }
    
    function monthOf(v)
    {
        var d = valueToDate(valueOf(v));
        return d.getMonth() + 1;
    }
    
    function hourOf(v)
    {
        var d = valueToDate(valueOf(v));
        return d.getHours();
    }

    function minuteOf(v)
    {
        var d = valueToDate(valueOf(v));
        return d.getMinutes();
    }
    
    function weekOfYear(v)
    {
        //ISO 8601 week numbering
        var d = valueToDate(valueOf(v));
        var target = new Date(d.valueOf());
        var day = (d.getDay() + 6) % 7;
        target.setDate(target.getDate() - day + 3);
        var firstThursday = target.valueOf();
        target.setMonth(0, 1);
        if (target.getDay() !== 4) {
            target.setMonth(0, 1 + ((4 - target.getDay()) + 7) % 7);
        }
        return 1 + Math.floor((firstThursday - target) / 604800000);
    }
    
    function dayOfYear(v)
    {
        var d = valueToDate(valueOf(v));
        return Math.floor(fromMSec(d - new Date(d.getFullYear(), 0, 0)));
    }

    function dayOfWeek(v)
    {
        var d = valueToDate(valueOf(v));
        return d.getDay() || 7;
    }    
    
    function isLeapYear(v)
    {
        if ((v^0) !== v)
            throw "Year's value must be integer!";
        return (v % 4) === 0 && ((v % 100) !== 0 || (v % 400) === 0);
    }

    function dateOf(v)
    {
        return Math.floor(valueOf(v));
    }
    
    function timeOf(v)
    {
        return valueOf(v) - Math.floor(valueOf(v));
    }
    
    function currentDate()
    {
        return dateOf(new Date());
    }
    
    function currentDateTime() 
    { 
        return valueOf(new Date());
    }
    
    function currentTime()
    {
        return timeOf(new Date());
    }

    function beginOfQuart(v)
    {
        var d = valueToDate(dateOf(v));
        var month = d.getMonth() <= 5 ? (d.getMonth() >= 3 ? 3 : 0) : (d.getMonth() >= 9 ? 9 : 6);
        d.setMonth(month, 1);
        return valueOf(d);
    }

    function beginOfWeek(v)
    {
        return Math.floor(valueOf(v)) - (dayOfWeek(v) - 1);
    }

    function endOfDay(v)
    {
        var d = valueToDate(valueOf(v));
        return valueOf(new Date(d.getFullYear(), d.getMonth(), d.getDate(), 23, 59, 59));
    }

    function endOfWeek(v)
    {
        return endOfDay(Math.floor(valueOf(v)) - (dayOfWeek(v) - 1) + 6);
    }
    
    function beginOfTenDays(v)
    {
        var tenDay = tenDaysOf(v);
        var d = valueToDate(v);        
        return date(d.getFullYear(), d.getMonth() + 1, (tenDay - 1)*10 + 1); 
    }
    
    function endOfTenDays(v)
    {
        var tenDay = tenDaysOf(v);
        if (tenDay === 3)
            return endOfMonth(v);
        var d = valueToDate(v);        
        return date(d.getFullYear(), d.getMonth() + 1, tenDay * 10, 23, 59, 59); 
    }
    
    function daysInTenDays(v)
    {
        return tenDaysOf(v) === 3 ? daysInMonth(v) - 20 : 10;
    }

    function daysInMonth()
    {
        var d = null;
        if (arguments.length === 1){
            d = valueOf(arguments[0]);
        } else if (arguments.length === 2) {
            var year = arguments[1], month = arguments[0];
            d = date(year, month, 1);            
        } else {
            throw " ";
        }        
        return dayOf(endOfMonth(d));
    }

    function daysInYear()
    {        
        if (arguments.length === 1){
            var d = valueOf(arguments[0]);
        } else {
            throw " ";
        }
        var firstDay = d <= 2200 ? date(d) : beginOfYear(d);
        return Math.floor(endOfYear(firstDay) - firstDay + 1);
    }
    
    function daysBetween(v1, v2)
    {
        return Math.abs(Math.floor(valueOf(v1) - valueOf(v2)));
    }

    
    function daysInHalfYear(v)
    {
        var start = beginOfHalfYear(v);
        var finish = endOfHalfYear(v);
        return daysBetween(start, finish);
    }    

    function beginOfHalfYear(v)
    {
        return halfYearOf(v) === 1 ? beginOfYear(v) : date(yearOf(v), 7);
    }
    
    function endOfHalfYear(v)
    {
        return halfYearOf(v) === 2 ? endOfYear(v) : endOfMonth(date(yearOf(v), 6));
    }
    
    function endOfQuart(v)
    {
        var month = monthOf(v);
        month = month <= 6 ? (month <= 3 ? 3 : 6) : ( month <= 9 ? 9 : 12);
        return endOfMonth(date(yearOf(v), month));
    }
    
    
    // 
    function incTenDays(v, delta)
    {
        var date2 = null, daysOfTenDay = null, incDays = null;
        if (delta > 0)
        {
            date2 = beginOfTenDays(v);
            daysOfTenDay = dayOf(v) - dayOf(date2);
            for ( var i = 0; i <= delta - 1; i++)
            {
                incDays = daysInTenDays(date2);
                date2 = incDay(date2, incDays);
            }
            date2 = incDay(date2, daysOfTenDay);
        }
        else
        {        
            date2 = endOfTenDays(v);
            daysOfTenDay = dayOf(date2) - dayOf(v);
            delta = -delta;
            for (var i = 0; i <= delta - 1; i++)
            {
                incDays = daysInTenDays(date2);
                date2 = incDay(date2, -incDays);
            }
            date2 = incDay(date2, -daysOfTenDay);
        }
        return date2;
    }
    
    
    function incHalfYear(v, delta)
    {
        var date2 = null, daysOfHalfYear = null, incDays = null;
        if (delta > 0)
        {
          date2 = beginOfHalfYear(v);
          daysOfHalfYear = dayOfYear(v) - dayOfYear(date2);
          for (var i = 0; i <= delta - 1; i++)
          {
            incDays = daysInHalfYear(date2);
            date2 = incDay(date2, incDays);
          }
          date2 = incDay(date2, daysOfHalfYear);
        }
        else
        {
          date2 = endOfHalfYear(v);
          daysOfHalfYear = dayOfYear(date2) - dayOfYear(v);
          delta = -delta;
          for (var i = 0; i <= delta - 1; i++)
          {
            incDays = daysInHalfYear(date2);
            date2 = incDay(date2, -incDays);
          }
          date2 = incDay(date2, -daysOfHalfYear);
        }
        return date2;
    }
    function _frameByZero()
    {
        var value = arguments[0].toString();
        var count = 2;
        if (arguments.length > 1)
            count = arguments[1];
        while (value.length < count)
            value = "0" + value;
        return value;
    }
    function _formatTimezoneOffset()
    {
        var value = Math.abs(arguments[0]);
        var sign = arguments[0] < 0 ? "+" : "-";
        var useGMTStr = arguments[1] ? true : false;
        var hours = _frameByZero(Math.floor(value / 60));
        var minutes = _frameByZero(Math.floor((value % 60) * 60));
        return useGMTStr ? "GMT" + sign + hours + ":" + minutes : sign + hours.toString() + minutes.toString();
    }
    function _getShortStr(value, count)
    {
        if (count >= value.length)
            return value;
        var res = value;        
        var idx = count - 1;
        while (/[]/.test(res[idx]) && (idx < value.length))
            idx++;
        return res.substr(0, count - 1) + res[idx];
    }
    function format(pattern, v)
    {
        var d = valueToDate(valueOf(v));
        var str = pattern;
        str = str.replace(/(YYYY+)/g, 
            function(){ 
                var match = arguments[1];
                return _frameByZero(d.getFullYear(), match.length); 
            });
        str = str.replace(/(yyyy+)/g, 
            function(){ 
                var match = arguments[1];
                return _frameByZero(d.getFullYear(), match.length); 
            });
        str = str.replace(/(YY+)/g, 
            function(){ 
                var match = arguments[1];
                return _frameByZero(d.getFullYear().toString().substr(2, 3), match.length); 
            });
        str = str.replace(/(yy+)/g, 
            function(){ 
                var match = arguments[1];
                return _frameByZero(d.getFullYear().toString().substr(2, 3), match.length); 
            });
        str = str.replace(/(MMM+)/g, 
            function(){ 
                var idx = arguments[2];
                var match = arguments[1];
                var monthIdx = d.getMonth();
                const BIG_MONTH_NAMES = [
                    "", "", "", "", "", "", 
                    "", "", "", "", "", ""
                ];
                const SMALL_MONTH_NAMES = [
                    "", "", "", "", "", "", 
                    "", "", "", "", "", ""
                ];
                return idx === 0 ? _getShortStr(BIG_MONTH_NAMES[monthIdx], match.length) : _getShortStr(SMALL_MONTH_NAMES[monthIdx], match.length);
            });
        str = str.replace(/(MM)/g, function(){ return _frameByZero(d.getMonth() + 1); });
        str = str.replace(/(d+)/g, function(){ return _frameByZero(d.getDate()); });
        str = str.replace(/(h+)/g, function(){ return _frameByZero(d.getHours()); });    
        str = str.replace(/(H+)/g, function(){ return _frameByZero(d.getHours()); });    
        str = str.replace(/(m+)/g, function(){ return _frameByZero(d.getMinutes()); });    
        str = str.replace(/(s+)/g, function(){ return _frameByZero(d.getSeconds()); });    
        str = str.replace(/(S+)/g, function(){ return _frameByZero(d.getMilliseconds()); });    
        str = str.replace(/G+/g, '..');
        str = str.replace(/'+/g, '');
        str = str.replace(/Z+/g, _formatTimezoneOffset(d.getTimezoneOffset()));
        str = str.replace(/z+/g, _formatTimezoneOffset(d.getTimezoneOffset(), true));
        str = str.replace(/(E+)/g, 
            function(){
                var idx = arguments[2];
                var match = arguments[1];
                var dayIdx = dayOfWeek(v) - 1;
                const BIG_DAY_NAMES = ["", "", "", "", "", "", ""];
                const SMALL_DAY_NAMES = ["", "", "", "", "", "", ""];
                return idx === 0 ? _getShortStr(BIG_DAY_NAMES[dayIdx], match.length) : _getShortStr(SMALL_DAY_NAMES[dayIdx], match.length);
            });
        return str;
    }
    
    return{
         BASE_DATE: BASE_DATE
        ,currentDate: currentDate
        ,currentDateTime: currentDateTime
        ,currentTime: currentTime
        ,date: date
        ,time: time
        ,value: valueOf
        ,valueToDate: valueToDate
        ,toString: toString
        ,stringToDate: stringToDate
        ,stringToTime: stringToTime
        ,stringToDateTime: stringToDateTime
        ,incHour: incHour
        ,incDay: incDay
        ,incMonth: incMonth
        ,incYear: incYear
        ,daysBetween: daysBetween
        ,daysInMonth: daysInMonth
        ,daysInYear: daysInYear
        ,isLeapYear: isLeapYear
        ,beginOfMonth: beginOfMonth
        ,endOfMonth: endOfMonth
        ,beginOfQuart: beginOfQuart
        ,endOfQuart: endOfQuart
        ,beginOfYear: beginOfYear
        ,endOfYear: endOfYear
        ,beginOfWeek: beginOfWeek
        ,endOfWeek: endOfWeek
        ,quartOf: quartOf
        ,yearOf: yearOf
        ,dayOf: dayOf
        ,monthOf: monthOf
        ,hourOf: hourOf
        ,minuteOf: minuteOf
        ,weekOfYear: weekOfYear
        ,dayOfYear: dayOfYear
        ,dayOfWeek: dayOfWeek
        ,dateToString: dateToString
        ,dateOf: dateOf
        ,timeOf: timeOf
        ,tenDaysOf: tenDaysOf
        ,beginOfTenDays: beginOfTenDays
        ,endOfTenDays: endOfTenDays
        ,incTenDays: incTenDays
        ,daysInTenDays: daysInTenDays
        ,halfYearOf: halfYearOf
        ,beginOfHalfYear: beginOfHalfYear
        ,endOfHalfYear: endOfHalfYear
        ,incHalfYear: incHalfYear
        ,daysInHalfYear: daysInHalfYear
        ,format: format
    };
});
