define(function()
{
    function trimLeft(v)
    {
        return v.trimLeft();
    }

    function trimRight(v)
    {
        return v.trimRight();
    }

    function trimAll(v)
    {
        return v.trim();
    }

    function left(v, n)
    {
       if ((n^0) !== n)
            throw "Second argument must be an integer!";
       if (n < 0)
            throw "Second argument must be a positive!";
        if (n > v.length)
            return v;
        else
            return v.substr(0, n);
    }
    
    function right(v, n)
    {
       if ((n^0) !== n)
            throw "Second argument must be an integer!";
       if (n < 0)
            throw "Second argument must be a positive!";
        if (n > v.length)
            return v;
        else
            return v.substr(v.length - n, n);
    }

    function replace(v, src, dest)
    {
        return v.replace(new RegExp(src, 'g'), dest);
    }

    function upper(v)
    {
        return v.toUpperCase();
    }

    function lower(v)
    {
        return v.toLowerCase();
    }
    
    return{
        trimLeft: trimLeft,
        trimRight: trimRight,
        trimAll: trimAll,
        left: left,
        replace: replace,
        upper: upper,
        lower: lower,
        right: right/*, 
        padR: padR, //  
        padL: padL,
        format: format, 
        formatFloat: formatFloat,
        formatToStrF: formatToStrF,
        floatToFixed: floatToFixed,
        valueSpelledOut: valueSpelledOut,
        numberToSpelledString: numberToSpelledString
        */
    };
});

