define( [
    "inform.agent.web.Styles",
    "inform.agent.web.NodeInfo"
], function( Styles, NodeInfo ) {
    Styles.sheet().rules( {
        'ul.metatree': {
            margin: 0,
            padding: '0 0 0 16px',
            '>li': {//node
                listStyle: 'none',
                '>div': {//row
                    position: 'relative',
                    display: 'inline-block',
                    lineHeight: '16px',
                    whiteSpace: 'nowrap',
                    padding: '1px 8px 1px 34px',
                    cursor: 'pointer',
                    '.active': {
                        borderRadius: '3px',
                        backgroundColor: '#CCEEFF'
                    },
                    ':hover': {
                        textDecoration: 'underline'
                    },
                    '>span': {//plus
                        position: 'absolute',
                        left: '0',
                        display: 'inline-block',
                        width: '16px',
                        textAlign: 'center',
                        cursor: 'default',
                        color: '#0080F0',
                        ':hover': {
                            backgroundColor: "#F0F0F0"
                        }
                    },
                    '>img': {
                        position: 'absolute',
                        left: '16px',
                        width: '16px'
                    }
                }
            },
            '.root': {
                textDecoration: 'none',
                fontStyle: 'normal',
                fontWeight: 'normal',
                padding: 0,
                margin: '1mm'
            }
        }
    } );
    function idset2arr(set) {
        var result = [];
        for (var i in set)
            result.push(Number(i));
        return result;
    }
    function createNode( id, arg ) {
        var li = document.createElement( "li" );
        li.className = "waiting";
        li._load = function() {
            li._load = null;
            var updated = false;
            function update() {
                if ( updated )
                    return;
                var ni = NodeInfo.fetch( id, NodeInfo.Options.NAME | NodeInfo.Options.IMAGE | NodeInfo.Options.TYPE | NodeInfo.Options.FIO );
                if ( !ni )
                    return;
                li.className = "";
                if ( !arg._filter_set || arg._filter_set[ni.type] )
                node.onclick = function() {
                    arg.onclick && arg.onclick( ni );
                };
                else {
                    node.style.textDecoration = 'none';
                    node.style.cursor = 'default';
                }
                function icon( idx ) {
                    var img = document.createElement( "img" );
                    var sz = (16 * (window.devicePixelRatio || 1)) | 0;
                    img.src = asmo.root + "/images/icons/" + sz + '/' + idx;
                    node.insertBefore( img, node._name );
                }
                var name = ni.name;
                if (ni.fio)
                    name += ' (' + ni.fio + ')';
                if ( "innerText" in node._name )
                    node._name.innerText = name;
                else
                    node._name.nodeValue = name;
                ni.image && icon( ni.image );
                (ni.type === 2) && icon( 5 );
                updated = true;
            }
            NodeInfo._listen( update );
            update();
            NodeInfo.fetchChildren( id, arg.filter ).then( function( children ) {
                plus.className = "";
                var ul = document.createElement( "ul" );
                ul.className = "metatree";
                ul.style.display = li._opened ? "" : "none";
                var cl = children.length, byid = li._byid = {};
                for ( var i = 0; i < cl; i++ ) {
                    var cid = children[i];
                    var n = byid[cid] = createNode( cid, arg );
                    ul.appendChild( n );
                    li._opened && n._load && n._load();
                }
                li.appendChild( ul );
                if ( cl )
                    plus.innerHTML = li._opened ? "&#8895;" : "&#5125;";
                plus.onclick = function( e ) {
                    e = e || window.event;
                    e && (e.stopPropagation ? e.stopPropagation() : (e.cancelBubble = true));
                    var op = li._opened = !li._opened;
                    if (op)
                        arg._opened[id] = true;
                    else
                        delete arg._opened[id];
                    arg.storage && arg.storage.set('on', idset2arr(arg._opened));
                    var ul = li.lastChild;
                    if ( op ) {
                        if ( li._load )
                            li._load();
                        else
                            for ( var i = 0; i < ul.children.length; i++ )
                                ul.children[i]._load && ul.children[i]._load();
                    }
                    ul.style.display = op ? "" : "none";
                    this.innerHTML = op ? "&#8895;" : "&#5125;";
                };
                if ( (id === arg.root) || (arg.toopen && arg.toopen[id]) )
                    plus.onclick();
                if ( arg.toslct && arg.toslct[id] ) {
                    arg._active && (arg._active._node.className = "");
                    (arg._active = li)._node.className = "active";
                }
            } );
        };
        li._opened = false;
        var node = document.createElement( "div" );
        var plus = document.createElement( "span" );
        plus.className = "waiting";
        plus.innerHTML = "&nbsp;";
        node.appendChild( plus );
        node.appendChild( node._name = document.createTextNode( "" ) );
        li.appendChild( node );
        li._node = node;
        li._open = function() {
            if ( this._opened )
                return;
            if ( !plus.onclick ) {
                arg.toopen = arg.toopen || {};
                arg.toopen[id] = true;
                this._load && this._load();
            } else
                plus.onclick();
        };
        return li;
    }
    var module = {
        create: function( arg ) {
            var ul = document.createElement( "ul" );
            ul.className = "metatree root";
            if ( arg.filter ) {
                var ff = arg._filter_set = {};
                for ( var i in arg.filter )
                    ff[arg.filter[i]] = true;
            }
            var opened = arg.storage && arg.storage('on') || [];
            arg._opened = {};
            for (var i in opened)
                arg._opened[opened[i]] = true;
            arg.toopen = arg._opened;
            var root = createNode( arg.root || 0, arg );
            ul.appendChild( root );
            root._load();
            ul._showNode = function( id ) {
                var updated = false;
                function update() {
                    if ( updated )
                        return;
                    var ni = NodeInfo.fetch( id, NodeInfo.Options.PATH );
                    if ( !ni )
                        return;
                    var node = root;
                    function step( id ) {
                        if ( !node )
                            return;
                        node._open();
                        if ( node._byid ) {
                            node = node._byid[id];
                            if ( !node )
                                return;
                            arg._active && (arg._active._node.className = "");
                            (arg._active = node)._node.className = "active";
                        } else {
                            arg.toslct = arg.toslct || {};
                            arg.toslct[id] = true;
                        }
                    }
                    var op = arg.toopen = arg.toopen || {};
                    for ( var i = 1, l = ni.path.length; i < l; i++ ) {
                        op[ni.path[i]] = true;
                        step( ni.path[i] );
                    }
                    step( id );
                    updated = true;
                }
                NodeInfo._listen( update );
                update();
                return this;
            };
            return ul;
        },
        select: function( id, filter ) {
            return require( ["inform.agent.web.Modal"], function( Modal ) {
                var result = Asyncs.create();
                var md = Modal.show( {
                    caption: " ",
                    content: module.create( {
                        filter: filter,
                        onclick: function( info ) {
                            md.close();
                            result.resolve( info );
                        }
                    } )._showNode( id )
                } );
                md.onclose = function() {
                    result.reject();
                    return true;
                };
                return result.promise();
            } );
        }
    };
    return module;
} );