define( ["static.jquery.jquery", "css!inform.agent.web.Tasks"], function( $ ) {
    return {
        create: function( parent ) {
            var tasks$ = $( "<div class='tasks'></div>" ).appendTo( parent );
            var img$ = $("<img src='" + asmo.root + "/static/images/ajax.gif'>");
            var stt$ = $( "<span class='state'></span>" );
            $( "<div class='header'></div>" ).append( img$ ).append( stt$ ).appendTo( tasks$ );
            var list$ = $( "<div class='list'></div>" ).appendTo( tasks$ );
            var log$ = $( "<div class='log' style='display:none'></div>" ).appendTo( tasks$ );
            function mkTask() {
                var task$ = $( "<div class='task'></div>" ).appendTo( list$ );
                var prg$ = $( "<div class='waiting' style='display:none'></div>" ).appendTo( task$ );
                var inf$ = $( "<div class='info'></div>" ).appendTo( task$ );
                var p_min = 0, p_max = 100, p_pos = 0;
                return {
                    update: function() {
                        prg$.width( (task$.width() - 0) * ((p_pos - p_min) / (p_max - p_min)) ).height( task$.height() );
                    },
                    process: function( cmd, arg ) {
                        switch ( cmd ) {
                            case "text":
                                inf$.text( arg );
                                break;
                            case "p_mn":
                                p_min = arg;
                                break;
                            case "p_mx":
                                p_max = arg;
                                break;
                            case "p_ps":
                                p_pos = arg;
                                break;
                            case "p_vs":
                                prg$.css( "display", arg ? "" : "none" );
                                break;
                        }
                    },
                    done: function() {
                        prg$.addClass( "done" );
                    },
                    fail: function() {
                        prg$.addClass( "fail" );
                    }
                };
            }
            var tasks = [mkTask()];
            return {
                failed: false,
                doned: false,
                process: function( changes ) {
                    for ( var i = 0, l = changes.length; i < l; i++ ) {
                        var ch = changes[i], cmd = ch[0], arg = ch[1];
                        switch ( cmd ) {
                            case "enter":
                                tasks.push( mkTask() );
                                break;
                            case "leave":
                                tasks.pop();
                                list$[0].removeChild( list$[0].lastChild );
                                break;
                            case "r_lg":
                                log$.append( $( "<div></div>" ).text( arg ) );
                                log$[0].style.display = "";
                                break;
                            default:
                                tasks[tasks.length - 1].process( cmd, arg );
                        }
                    }
                    for ( var i = 0, l = tasks.length; i < l; i++ )
                        tasks[i].update();
                },
                fail: function( e ) {
                    this.ready = true;
                    this.failed = true;
                    img$.attr("src", asmo.root + "/images/icons/32/107");
                    stt$.text( "" ).addClass( "error" );
                    tasks[tasks.length-1].fail( e );
                },
                done: function() {
                    this.ready = true;
                    img$.attr("src", asmo.root + "/static/images/ok.ico");
                    stt$.text( "" );
                    tasks[tasks.length-1].done();
                }
            };
        }
    };
} );