define( ["inform.agent.web.forms.Actioner", "inform.agent.web.forms.Requests", "static.wcl.libs.Dates", "inform.agent.web.forms.Formats"]
,function( Actioner, Requests, AsmoDates,  AsmoFormats) {
    var ALLVAL = {
        toString: function() {
            return "";
        }
    };
    var WAIT = Actioner.WAIT;
var URL_FETCH_RECORDS = "/rq/fetchRecords";
var _ID_GEN = (function() {
    var MAX_COUNTER = 99;
    var counter = MAX_COUNTER, template;
    var generateTemplate = (function() {
        var BASE_DATE = (new Date( 2000, 00, 01 )).valueOf(), MSECS_IN_DAY = 24 * 60 * 60 * 1000, TEMPLATE_DEV = (Math.random() * 1009) | 0, TEMPLATE_SEQUENCE_SHIFT = 100;
        var template_msecs = 0;
        return function() {
            var curr = (new Date()).valueOf();
            var msecs = ((curr - BASE_DATE) % (MSECS_IN_DAY * 365 * 333)) - TEMPLATE_DEV;
            if ( template_msecs >= msecs )
                msecs = template_msecs + 1;
            var result = msecs * TEMPLATE_SEQUENCE_SHIFT;
            template_msecs = msecs;
            return result;
        };
    })();
    return function() {
        if ( ++counter > MAX_COUNTER ) {
            counter = 1;
            template = generateTemplate();
        }
        return template + counter;
    };
})();
    var DataType = {
        PRIMARY_KEY: -1,
        NONE: 0,
        INTEGER: 1,
        FLOAT: 2,
        STRING: 3,
        DATE_TIME: 4,
        INTERVAL: 5,
        DIRECTORY: 6,
        BOOLEAN: 7,
        BLOB: 8,
        FILE: 9,
        METATREE_NODE: 10,
        VARIANT: 11,
        BIG_NUMBER: 12,
        UNICODE: 13,
        GEOMETRY: 14
    };
    function CBind( id, fid ) {
        this.id = id;
        this.fid = fid;
    }
    CBind.resolve = function( map, components ) {
        for ( var i in map )
            if ( map[i] instanceof CBind ) {
                var m = map[i], c = components[m.id];
                if ( !c )
                    throw "component(" + m.id + ") not found";
                if ( m.fid ) {
                    c = c._fbyid[m.fid];
                    if ( !c )
                        throw "field(" + m.id + ':' + m.fid + ") not found";
                }
                map[i] = c;
            }
    };
var Datasource = CLASS( {
    Field: CLASS( {
        constructor: function( datasource, descriptor, id, index ) {
            this._datasource = this._actioner = datasource;
            this._descriptor = descriptor;
            this.id = id;
            this.index = index;
        }
    }, Actioner.Referer ),
    constructor: function( fields ) {
        Datasource.inherited.constructor.call( this );
        this._fbyid = {};
        this._fbyname = {};
        this._fields = [];
        var idx = 0;
        for ( var id in fields ) {
            var fd = fields[id], f = new this.Field( this, fd, id|0, idx );
            this._fbyid[id] = f;
            if(fd.name)
                this._fbyname[fd.name] = f;
            if ( !fd.multilookup && (fd.type !== DataType.VARIANT) ) {
                this._fields.push( f );
                idx++;
            }
        }
    },
    _row: function( key ) {
        //returns [] or null{not loaded} or undefined{not found}
    }
}, Actioner );
var Parameters = CLASS( {
    constructor: function( fields, fvalues ) {
        Parameters.inherited.constructor.call( this, fields );
        this._data = [];
        var values;
        if ( (typeof fvalues) === "function" )
            values = fvalues( this );
        else
            values = fvalues || {};
        this._data = [];
        for ( var i in this._fields ) {
            var f = this._fields[i];
            var v = values[f.id];
            if ( v instanceof Datasource.Field )
                this._fields[i] = this._fbyid[f.id] = v;
            this._data.push( v );
        }
        this._dependOn( values );
    },
    _modify: function( row ) {
        return row;
    },
    _row: function() {
        return this._data;
    }
}, Datasource );
function eqs_arrays( a, b ) {
    if ( a.length !== b.length )
        return false;
    for ( var i = 0, l = a.length; i < l; i++ )
        if ( a[i] !== b[i] )
            return false;
    return true;
}
function eqs_sortpaths( a, b, cmpdir ) {
    if ( a === b )
        return true;
    if ( a.length !== b.length )
        return false;
    for ( var i = 0, l = a.length; i < l; i++ ) {
        var sa = a[i], sb = b[i];
        if ( cmpdir && (sa[0] !== sb[0]) )
            return false;
        if ( !eqs_arrays( sa[1], sb[1] ) )
            return false;
    }
    return true;
}
    function Array_insert( array, index, value ) {
        if ( array.length < index )
            array.length = index;
        array.splice( index, 0, value );
    }
    function generateOrder( ds, rows, ri0, ri1, us ) {
        var minri = ri0, maxri = ri1, i0 = ri0, i1 = ri1;
        while ( (minri > 0) && (rows[minri - 1] !== undefined) )
            minri--;
        var rl = rows.length;
        while ( (maxri < rl - 1) && (rows[maxri + 1] !== undefined) )
            maxri++;
        function isnull( v ) {
            return (v === null) || (v === undefined);
        }
        function expand( v0, v1 ) {
            if ( i0 <= minri ) {
                i0 = minri - 1;
                return false;
            }
            if ( i1 >= maxri ) {
                i1 = maxri + 1;
                return false;
            }
            if ( Math.abs( v1 - rows[i0 - 1][us.fidx] ) > Math.abs( rows[i1 + 1][us.fidx] - v0 ) )
                i0--;
            else
                i1--;
            return true;
        }
        var v0, v1;
        while ( true ) {
            if ( (i0 >= minri) && isnull( v0 = rows[i0][us.fidx] ) )
                i0--;
            else if ( (i1 <= maxri) && isnull( v1 = rows[i1][us.fidx] ) )
                i1++;
            else
                break;
        }
        while ( (i1 - i0) > Math.abs(v1 - v0) )
            if ( !expand( v0, v1 ) )
                break;
        var sk = us.sdir ? -1 : +1, step = 100;
        if ( i0 < minri ) {
            if ( i1 > maxri ) {
                var v = us.sdir ? (rows.length + 1) * step : 0;
                for ( var i = minri; i <= maxri; i++ )
                    ds._modify( rows[i] )[us.fidx] = (v += step * sk);
            } else {
                var v = v1;
                for ( var i = i1 - 1; i >= ri0; i-- )
                    ds._modify( rows[i] )[us.fidx] = (v -= step * sk);
            }
        } else {
            if ( i1 > maxri ) {
                var v = v0;
                for ( var i = i0 + 1; i <= ri1; i++ )
                    ds._modify( rows[i] )[us.fidx] = (v += step * sk);
            } else {
                step = (Math.abs( v1 - v0 ) / (i1 - i0)) | 0;
                var v = v0;
                for ( var i = i0 + 1; i < i1; i++ )
                    ds._modify( rows[i] )[us.fidx] = (v += step * sk);
            }
        }
    }
var TableDatasource = CLASS( {
    Cursor: CLASS( {
        EMPTY: {_ridx: -1, _row: function() {
                return undefined;
            }, _isEmpty: function() {
                return true;
            }, _rowsCount: function() {
                return 0;
            }, _hintAllNeed: function() {
            }
        },
        constructor: function( ck, ds, url ) {
            this._changeno = 0;
            this._rq = null;
            this._curkey = ck;
            this._datasource = ds;
            this._url = url;
            this.__init();
        }, __init: function() {
            var dds = this._datasource._descriptor;
            var virtual = dds.virtual && !dds.node;
            this._ridx = virtual ? -1 : 0;//83076
            this._rows = [];
            this._isempty = virtual ? true : WAIT;
            this._rscount = virtual ? 0 : WAIT;
            this._rscount_mod = 0;
            this._modifications = [];
            this._relocations = [];
            this._lost = false;
            this._lmax = virtual;
            this._full = virtual;
            this._hinted = false;
        }, __getRowsCount: function() {
            var r = this._rscount;
            return r === WAIT ? r : r + this._rscount_mod;
        }, _isEmpty: function() {
            var r = this._isempty;
            if ( (r === WAIT) && (this._rq === null) && (!this._lost) )
                this._load( 0 );
            return r;
        }, _rowsCount: function() {
            var r = this.__getRowsCount();
            if ( (r === WAIT) && (this._rq === null) && (!this._lost) )
                this._load( 0 );
            return r;
        },
        _row: function() {
            var ridx = this._ridx;
            if ( ridx < 0 )
                return undefined;
            var row = this._rows[ridx];
            if ( row !== undefined )
                return row;
            var rcnt = this.__getRowsCount();
            if ((rcnt !== WAIT) && (ridx >= (rcnt - (this._lmax ? 1 : 0))))
                return undefined;//none
            if ( (this._rq === null) && (!this._lost) )
                this._load( ridx );
            return null;
        },
        _hintAllNeed: function() {
            if (this._full || (this._rq !== null) || this._datasource._modifications.length)
                return;
            if (this._hinted)
                return;
            this._hinted = true;
            this._salt = 0;
            return this._loadRange();
        },
        __calcOrgIndexDelta: function( idx ) {
            var rels = this._relocations, result = 0;
            for ( var k in rels ) {
                var i = k | 0;
                if ( i > idx )
                    break;
                result = rels[k] - i;
            }
            return result;
        },
        __tryClampRIdx: function() {
            var rcnt = this.__getRowsCount();
            if ( rcnt === WAIT )
                return false;
            if ( this._lmax )
                rcnt--;
            this._ridx = Math.min( Math.max( this._ridx, 0 ), rcnt - 1 );
            return true;
        },
        _load: function( ridx ) {
            var eidx = ridx;
            while ((this._rows[eidx] === undefined) && ((eidx - ridx) < 4096))
                eidx++;
            while ((ridx > 0) && (this._rows[ridx] === undefined) && ((eidx - ridx) < 4096))
                ridx--;
            return this._loadRange(ridx, eidx);
        },
        _loadRange: function(ridx, eidx) {
            var self = this, url = this._url, rqcnt;
            if (arguments.length === 2) {
                var dri = this.__calcOrgIndexDelta( ridx );
                var dei = this.__calcOrgIndexDelta( eidx );
                url += "&limit=" + [ridx + dri, eidx + dei];
                rqcnt = (eidx + dei) - (ridx + dri) + 1;
            } else {
                ridx = 0;
                rqcnt = 0x0FFFFFFF;
            }
            if ( this._salt )
                url += "&salt=" + this._salt;
            var LIMIT = 256 * 1024;
            this._rq = Requests.execute( {
                caption: "   ",
                url: url + '&slimit=' + LIMIT
            } ).then( function( r ) {
                self._rq = null;
                if ( r.length > LIMIT )
                    throw "response is too big (" + ((((r.length / 1024 / 1024) * 100) | 0) / 100) + "M)";
                var result = JSON.parse( r );
                if ( result.lost ) {
                    self._lost = true;
                    if ( self._datasource._modifications.length === 0 )
                        self._invalidate();
                } else {
                    if ( result.salt ) {
                        if ( !self._salt )
                            self._salt = result.salt;
                        else if ( self._salt !== result.salt )
                            throw "salt mismatch";
                    }
                    if ( result.rcnt !== undefined ) {
                        self._isempty = result.rcnt !== 0;
                        self._rscount = result.rcnt;
                        self.__tryClampRIdx();
                    }
                    if ( result.rows.length < rqcnt )
                        self._full = true;
                    self._loaded( result.rows, ridx );
                }
                self._datasource._touch();
            }, function( e ) {
                self._rq = null;
                log.error( e );
            } );
            return this;
        },
        _loaded: function( rows, ridx ) {
            if ( rows.length === 0 )
                return;
            var rl = rows.length;
            if ( rows[rl - 1] === null ) {//end of cursor
                this._lmax = true;
                rl--;
            }
            this._rows.length = Math.max( this._rows.length, ridx + rl );
            this._relocations.length = Math.max( this._relocations.length, ridx + rl );
            for ( var i = 0; i < rl; i++ )
                this._rows[i + ridx] = rows[i];
            var ds = this._datasource, locs = ds._dmodel._locates, dd = ds._descriptor;
            if ( locs && locs[dd.id] ) {
                var l = locs[dd.id], fidx = l[0], vals = l[1];
                for ( var i in fidx )
                    fidx[i] = ds._fbyid[fidx[i]].index;
                for ( var ir = ridx; ir < ridx + rl; ir++ ) {
                    var row = this._rows[ir];
                    if ( row === undefined )
                            continue;
                    var ok = true;
                    for ( var ic = 0, lc = fidx.length; ic < lc; ic++ )
                        if ( vals[ic] !== row[fidx[ic]] ) {
                            ok = false;
                            break;
                        }
                    if ( ok ) {
                        this._ridx = ir;
                        delete locs[dd.id];
                        break;
                    }
                }
            }
        },
        _aplymod: function( mod ) {
            var rows = this._rows, ds = this._datasource;
            switch ( mod.act ) {
                case 'a':
                    var ridx = ++this._ridx;
                    var di = this.__calcOrgIndexDelta( ridx );
                    Array_insert( this._relocations, ridx + 1, ridx + di );
                    Array_insert( this._rows, ridx, mod.row );
                    this._modifications.push( {mod: mod, idx: ridx} );
                    var us = ds.__usersort();
                    if ( us )
                        generateOrder( ds, this._rows, this._ridx, this._ridx, us );
                    this._changeno++;
                    this._rscount_mod++;
                    break;
                case 'd':
                    for ( var i = 0, l = rows.length; i < l; i++ )
                        if ( ds._keyequals( rows[i], mod.org ) ) {
                            var di = this.__calcOrgIndexDelta( i + 1 );
                            this._relocations.splice( i, 2, i + 1 + di );
                            this._rows.splice( i, 1 );
                            this._modifications.push( {mod: mod, idx: i} );
                            this._changeno++;
                            this._rscount_mod--;
                            this.__tryClampRIdx();
                            break;
                        }
                    break;
                case 'm':
                    for ( var i = 0, l = rows.length; i < l; i++ )
                        if ( ds._keyequals( rows[i], mod.org ) ) {
                            this._modifications.push( {mod: mod, idx: i} );
                            rows[i] = mod.row;
                            this._changeno++;
                            break;
                        }
                    break;
            }
        },
        _undomod: function( mod ) {
            var mods = this._modifications, ml = mods.length;
            if ( ml === 0 )
                return false;
            var m = mods[ml - 1];
            if ( m.mod !== mod )
                return false;
            mods.pop();
            var rows = this._rows;
            switch ( mod.act ) {
                case 'a':
                    if ( !this._datasource._keyequals( rows[m.idx], mod.row ) )
                        throw "row mismatch";
                    rows.splice( m.idx, 1 );
                    this._changeno++;
                    this._rscount_mod--;
                    this.__tryClampRIdx();
                    return true;
                case 'd':
                    rows.splice( m.idx, 0, mod.org );
                    this._rscount_mod++;
                    this._changeno++;
                    return true;
                case 'm':
                    if ( !this._datasource._keyequals( rows[m.idx], mod.row ) )
                        throw "row mismatch";
                    rows[m.idx] = mod.org;
                    this._changeno++;
                    return true;
                default:
                    throw "Unknown mod-op: " + mod.act;
            }
        },
        _invalidate: function() {
            this.__init();
            this._salt = 0;
        }
    } ),
    constructor: function( datamodel, descriptor ) {
        TableDatasource.inherited.constructor.call( this, descriptor.fields );
        var self = this;
        this._dmodel = datamodel;
        this._descriptor = descriptor;
        this._sorting = (descriptor.sorting && descriptor.sorting.paths) || [];
        this._keyfields = [];
        this._modifications = [];
        var fgen = [], ke_body = "return true";
        for ( var i in this._fields ) {
            var f = this._fields[i];
            if ( f._descriptor.key ) {
                this._fbyid[-1] = f;
                this._keyfields.push( f );
                ke_body += '&&(r0[' + i + ']===r1[' + i + '])';
            }
            if ( f._descriptor.gen )
                fgen.push( f.id );
        }
        this._keyequals = new Function( "r0", "r1", ke_body );
        this._cursorsCache = {};
        this._curkeysCache = {};
        this._dependOn( descriptor.p_bindings );
        this._dependOn( descriptor.f_bindings );

        this.__fappend = fgen.length ? function( row, cs ) {
            return Requests.execute( {
                caption: "  ",
                url: "/rq/generateFieldValue?table=" + (descriptor.table || descriptor.node) +"&owner="+(descriptor.ownerId||0)+"&uid="+(descriptor.id||0) + "&field=" + fgen.join( ',' )
            } ).then( function done( r ) {
                r = JSON.parse( r );
                for ( var i = 0; i < fgen.length; i++ ) {
                    var f = self._fbyid[fgen[i]];
                    row[f.index] = r[i];
                }
                cs._changeno++;
                self._touch();
                return row;
            }, log.error );
        } : Asyncs.when;
    },
    _postinit: function( components ) {
        CBind.resolve( this._descriptor.p_bindings, components );
        this._dependOn( this._descriptor.p_bindings );
        CBind.resolve( this._descriptor.f_bindings, components );
        this._dependOn( this._descriptor.f_bindings );
        this._touch();
    },
    _keyequals: function ( r0, r1 ) {
        for ( var i = 0, l = this._keyfields.length; i < l; i++ ) {
            var kf = this._keyfields[i], idx = kf.index;
            if ( r0[idx] !== r1[idx] )
                return false;
        }
        return true;
    },
    _action: function( id ) {
        var cs = this._cursor();
        if ( !cs )
            return null;//no cursor
        if ( cs === this.Cursor.EMPTY )
            return null;//empty cursor
        var self = this;
        switch ( id ) {
            case 1://append
                return function() {
                    var r = self.__append();
                    self._touch();
                    return r;
                };
            case 2://delete
                var r = this._row();
                if ( !r )
                    return null;
                return function() {
                    return require( ["inform.agent.web.forms.AsyncUI"], function( AsyncUI ) {
                        return AsyncUI.confirm( " ?" ).done( function() {
                            self._delete( r );
                            self._touch();
                        } );
                    } );
                };
            case 3://move up
            case 4://move down
                var r = this._row();
                if ( !r )
                    return null;
                var us = this.__usersort();
                if ( !us )
                    return null;
                switch ( id ) {
                    case 3:
                        if ( cs._ridx < 1 )
                            return null;
                        return function() {
                            var ri0 = cs._ridx, ri1 = ri0-1, rows = cs._rows;
                            generateOrder( self, rows, ri1, ri0, us );
                            var row0 = rows[ri0], row1 = rows[ri1];
                            rows[ri0] = row1;
                            rows[ri1] = row0;
                            var v0 = row0[us.fidx], v1 = row1[us.fidx];
                            self._modify( row0 )[us.fidx] = v1;
                            self._modify( row1 )[us.fidx] = v0;
                            cs._ridx--;
                            cs._changeno++;
                            self._touch();
                        };
                    case 4:
                        if ( cs._ridx > cs._rows.length - 2 )
                            return null;
                        return function() {
                            var ri0 = cs._ridx, ri1 = ri0+1, rows = cs._rows;
                            generateOrder( self, rows, ri0, ri1, us );
                            var row0 = rows[ri0], row1 = rows[ri1];
                            rows[ri0] = row1;
                            rows[ri1] = row0;
                            var v0 = row0[us.fidx], v1 = row1[us.fidx];
                            self._modify( row0 )[us.fidx] = v1;
                            self._modify( row1 )[us.fidx] = v0;
                            cs._ridx++;
                            cs._changeno++;
                            self._touch();
                        };
                }
            default:
                var d = this._descriptor;
                if (d.sortings !== undefined) {
                    var sorting = d.sortings[id];
                    if (sorting !== undefined) {
                        if (!this._canSort())
                            return null;
                        return function() {
                            self._sort(sorting.paths);
                        };
                    }
                }
                break;
        }
        return null;
    },
    __usersort: function() {
        var ds = this._descriptor.sorting;
        if ( !ds || !ds.user || (ds.paths.length !== 1) || (ds.paths[0][1].length !== 1) )
            return null;
        if ( !eqs_sortpaths( this._sorting, ds.paths ) )
            return null;
        ds = this._sorting;
        var sf = this._fbyid[ ds[0][1][0] ];
        return {
            sdir: ds[0][0],
            fidx: sf.index
        };
    },
    _refresh: function() {
        for ( var i in this._cursorsCache )
            this._cursorsCache[i]._invalidate();
        this._touch();
    },
    __append: function() {
        var row = new Array( this._fields.length );
        var cs = this._cursor();
        if ( !cs )
            throw "no cursor";
        if ( cs === this.Cursor.EMPTY )
            throw "empty cursor";
        for ( var i = 0; i < row.length; i++ )
            if ( this._fields[i]._descriptor.key )
                row[i] = _ID_GEN();
            else
                row[i] = null;
        var d = this._descriptor;
        for ( var i in d.f_bindings ) {
            var p = d.f_bindings[i];
            if ( p instanceof CBind )
                throw "parent datasource not ready";
            if ( p instanceof Datasource.Field ) {
                var rr = p._datasource._row();
                if ( !rr )
                    throw "parent datasource not ready";
                var f = this._fbyid[i];
                row[f.index] = rr[p.index];
            }
        }
        var mod = {
            act: 'a',
            ds: this,
            row: row
        };
        var mm = this._dmodel._modifications;
        mm.push( mod );
        this._modifications.push( mod );
        cs._aplymod( mod );
        this._dmodel._touch();
        return this.__fappend( row, cs );
    },
    _delete: function( row ) {
        var mod = {
            act: 'd',
            ds: this,
            org: row
        };
        var mm = this._dmodel._modifications;
        var lm = mm[mm.length - 1];
        if ( lm && (lm.ds === this) && (lm.act === 'a') && (lm.row === row) ) {
            mm.pop();
            this._modifications.pop();
            for ( var ci in lm.csk )
                lm.csk[ci]._undomod( lm );
        } else {
            mm.push( mod );
            this._modifications.push( mod );
            for ( var ci in this._cursorsCache )
                this._cursorsCache[ci]._aplymod( mod );
        }
        this._dmodel._touch();
    },
    _modify: function( row ) {
        var mm = this._dmodel._modifications;
        var lm = mm[mm.length - 1];
        if ( !(lm && (lm.ds === this) && ((lm.act === 'a') || (lm.act === 'm')) && (lm.row === row)) ) {
            var mod = {
                act: 'm',
                ds: this,
                org: row.slice(),
                row: row
            };
            mm.push( mod );
            this._modifications.push( mod );
            for ( var ci in this._cursorsCache )
                this._cursorsCache[ci]._aplymod( mod );
        } else
            for (var ci in this._cursorsCache) {
                var cs = this._cursorsCache[ci];
                for (var i = 0, l = cs._rows.length; i < l; i++)
                    if (this._keyequals(cs._rows[i], lm.row)) {
                        cs._changeno++;
                        break;
                    }
            }
        this._dmodel._touch();
        return row;
    },
    _undomod: function( m ) {
        var mods = this._modifications, ml = mods.length;
        if ( !ml )
            throw "undomod:empty";
        var mo = mods[ml-1];
        if ( mo !== m )
            throw "undomod:mismatch";
        mods.pop();
        var ok = false;
        for ( var ci in this._cursorsCache ) {
            var cs = this._cursorsCache[ci];
            if ( cs._undomod( m ) )
                ok = true;
            if ( cs._lost && (ml === 1) )
                cs._invalidate();
        }
        return ok;
    },
    _scan: function( f, ctx ) {
        var cs = this._cursor( ctx );
        if ( !cs )
            return false;
        var ri = cs._ridx;
        try {
            f( cs );
            return true;
        } finally {
            cs._ridx = ri;
        }
    },
    _row: function( ctx ) {
        var cs = this._cursor( ctx );
        return cs ? cs._row() : null;
    },
    _cursor: function( ctx ) {
        var rower = ctx && ctx.rower || function( ds ) {
            return ds._row( {rower: rower} );
        };
        var d = this._descriptor;
        function gatherBindings( bindings, out ) {
            for ( var i in bindings ) {
                if ( i in out )
                    continue;
                var b = bindings[i];
                if ( b instanceof CBind )
                    return null;//not resolved
                if ( b instanceof Datasource.Field ) {
                    var ds = b._datasource;
                    var r = rower( ds );
                    if ( r === null )//not loaded
                        return null;
                    if ( r === undefined )//no row
                        return undefined;
                    b = r[b.index];
                }
                out[i] = b;
            }
            return true;
        }
        var pbindings = {}, fbindings = {}, r = true;
        if ( ctx && ctx.p_bindings )
            r = r && gatherBindings( ctx.p_bindings, pbindings );
        if ( ctx && ctx.f_bindings )
            r = r && gatherBindings( ctx.f_bindings, fbindings );
        r = r && gatherBindings( d.p_bindings, pbindings );
        r = r && gatherBindings( d.f_bindings, fbindings );
        if ( !r ) {
            if ( r === undefined )//no row
                return this.Cursor.EMPTY;
            return r;
        }
        function genurlkey( pbindings, fbindings ) {
            var result = "";
            var params = [];
            for ( var i in pbindings )
                params.push( [i|0, pbindings[i]] );
            if ( params.length )
                result += "&params=" + encodeURIComponent( JSON.stringify( params ) );
            var where = [];
            for ( var i in fbindings ) {
                if ( where.length )
                    where.push( '&&' );
                where.push( [{f:i | 0}, '=', fbindings[i]] );
            }
            if ( where.length )
                result += "&where=" + encodeURIComponent( JSON.stringify( where ) );
            return result;
        }
        if ( ctx && ctx.prefetch ) {
            var prefetch = ctx.prefetch;
            var prefcursors = [];
            var pprm = prefetch.parameter;
            var pv = pbindings[pprm.id];
            if ( pv === ALLVAL )
                pv = pprm.values;
            else {
                if ( !(pv instanceof Array) )
                    pv = [pv];
                pv = pv.concat( pprm.values );
            }
            var pvv = [], crows = {};
            var url = URL_FETCH_RECORDS + "?node=" + d.node + "&uid=" + d.id;
            if(d && d.ownerId)
                url += "&owner="+d.ownerId;
            url += "&fields=";
            for ( var i in this._fields ) {
                if ( i > 0 )
                    url += ',';
                url += this._fields[i].id;
            }
            var sk = this._sorting.length ? "&sort=" + encodeURIComponent(JSON.stringify(this._sorting)) : "";
            for ( var i = 0; i < pv.length; i++ ) {
                var v = pv[i];
                pbindings[pprm.id] = v;
                var uk = genurlkey( pbindings, fbindings );
                var ck = this._curkeysCache[uk];
                if (ck === undefined)
                    this._curkeysCache[uk] = ck = {};
                var cs = ck[sk];
                if (cs)
                    continue;
                var _url = url + uk + sk;
                if (this._cursorsCache[_url])
                    continue;
                pvv.push( v );
                crows[v] = [];
                prefcursors.push(this._cursorsCache[_url] = ck[sk] = new this.Cursor(ck, this, _url, this._sorting));
            }
            if ( !prefcursors.length )
                return null;
            pbindings[pprm.id] = pvv;
            var uk = genurlkey( pbindings, fbindings );
            url += uk + sk;
            var self = this;
            var rq = Requests.execute( {
                caption: "   ",
                url: url
            } ).then( function( r ) {
                for ( var i in prefcursors )
                    prefcursors[i]._rq = null;
                var LIMIT = 2048*1024;//~4mb
                if ( r.length > LIMIT )
                    throw "response is too big (" + ((((r.length / 1024 / 1024)*100)|0)/100) + "M)";
                var result = JSON.parse( r );
                var rows = result.rows;
                for ( var i = 0, l = rows.length; i < l; i++ ) {
                    var r = rows[i], v = r[prefetch.parent];
                    crows[v].push( r );
                }
                for ( var i = 0, l = prefcursors.length; i < l; i++ ) {
                    var cs = prefcursors[i], v = pvv[i], rows = crows[v];
                    cs._isempty = rows.length === 0;
                    cs._rscount = rows.length;
                    cs._full = true;
                    cs.__tryClampRIdx();
                    cs._loaded( rows, 0 );
                }
                self._touch();
            }, function( e ) {
                for ( var i in prefcursors )
                    prefcursors[i]._rq = null;
                log.error( e );
            } );
            for ( var i in prefcursors )
                prefcursors[i]._rq = rq;
            return null;
        }
        var uk = genurlkey( pbindings, fbindings );
        var ck = this._curkeysCache[uk];
        if ( ck === undefined )
            this._curkeysCache[uk] = ck = {};
        var sk = this._sorting.length ? "&sort=" + encodeURIComponent( JSON.stringify( this._sorting ) ) : "";
        var cs = ck[sk];
        if ( cs )
            return cs;
        var url = URL_FETCH_RECORDS + "?node=" + d.node + "&uid=" + d.id;
        if(d && d.ownerId)
            url += "&owner="+d.ownerId;
        url += "&fields=";
        for ( var i in this._fields ) {
            if ( i > 0 )
                url += ',';
            url += this._fields[i].id;
        }
        url += uk + sk;
        return this._cursorsCache[url] = ck[sk] = new this.Cursor( ck, this, url, this._sorting );
    },
    _canSort: function() {
        return this._modifications.length === 0;
    },
    _sort: function( sorting ) {
        if ( this._modifications.length !== 0 )
            throw "sort: modified";
        if ( !sorting ) {
            var ds = this._descriptor.sorting;
            if ( !ds ) {
                sorting = [];
                for ( var i in this._keyfields ) {
                    var kf = this._keyfields[i];
                    sorting.push( [0, [kf.id]] );
                }
            } else
                sorting = ds.paths;
        }
        this._sorting = sorting;
        this._touch();
    }
}, Datasource );
    var DirectoryFetcher = (function() {
        var dirs = {}, queue = [], LIMIT = 128;
        function exec() {
            if ( queue.length === 0 )
                return;
            var d = queue.shift(), keys;
            Requests.execute( function() {
                if ( d.keys.length > LIMIT ) {
                    keys = d.keys.slice( 0, LIMIT );
                    d.keys.splice( 0, keys.length );
                    queue.push( d );
                } else {
                    keys = d.keys;
                    d.keys = [];
                }
                var url = d.url;
                if ( keys.length === 1 )
                    url += keys[0];
                else
                    url += "{\"v\":" + encodeURIComponent( JSON.stringify( keys ) ) + '}';
                return {
                    url: url + ']'
                };
            } ).then( function done( r ) {
                var rows = JSON.parse( r ).rows;
                var dir = d.dir, pkidx = d.pkidx;
                for ( var i = 0, l = rows.length; i < l; i++ ) {
                    var row = rows[i];
                    dir._rows[row[pkidx]] = row;
                }
                for ( var i = 0, l = keys.length; i < l; i++ ) {
                    var k = keys[i];
                    if ( dir._rows[k]._rq )
                        dir._rows[k] = [];
                }
                dir._touch();
                exec();
            }, function fail( e ) {
                exec();
                throw e;
            } );
        }
        return function( dir, key ) {
            var did = dir._id;
            var d = dirs[did];
            if ( !d ) {
                var url = URL_FETCH_RECORDS + "?node=" + dir._descriptor.node;
                if(dir._descriptor.ownerId)
                    url += "&owner="+dir._descriptor.ownerId;
                url += "&fields=";
                var pkid = 0, pkidx = 0;
                for ( var i in dir._fields ) {
                    var f = dir._fields[i];
                    if ( f._descriptor.key && !pkid ) {
                        pkid = f.id;
                        pkidx = i;
                    }
                    if ( i > 0 )
                        url += ',';
                    url += f.id;
                }
                url += "&where=[{\"f\":"+pkid+"},\"=\",";
                dirs[did] = d = {
                    url: url,
                    keys: [],
                    pkidx: pkidx,
                    dir: dir
                };
            }
            var needInitialRq = queue.length === 0;
            var needDelay = false;
            if ( d.keys.length === 0 ) {
                queue.push( d );
                needDelay = true;
            }
            d.keys.push( key );
            if ( needInitialRq ) {
                if ( needDelay )
                    setTimeout( exec );
                else
                    exec();
            }
        };
    })();
var Directory = CLASS( {
    constructor: function( datamodel, descriptor ) {
        Directory.inherited.constructor.call( this, descriptor.fields );
        this._dmodel = datamodel;
        this._descriptor = descriptor;
        this._rows = {};
    },
    _refresh: function() {
        this._rows = {};
        this._touch();
    },
    _row: function( key ) {
        var row = this._rows[key];
        if ( row ) {
            if ( row._rq )
                return null;
            return row;
        }
        row = this._rows[key] = {_rq:true};
        DirectoryFetcher( this, key );
        return null;
    }
}, Datasource );
    function showParametersDialog( arg, title ) {
        return require([
            'inform.agent.web.forms.WebForm',
            'inform.agent.web.Modal',
            'inform.agent.web.Parameters',
            'static.jquery.jquery',
            'css!inform.agent.web.forms.WebForm'
        ], function(WF, Modal, P, $) {
            var form$ = $( "<div style='width:500px;padding-bottom:1em;overflow-y:auto'></div>" );
            title = title || "";
            var TMAP = {
                1:  P.INT,
                2:  P.FLT,
                3:  P.STR,
                7:  P.BLN
            };
            var PARAMS = [], row = arg.values;
            for ( var i in arg.fields ) {
                var p = arg.fields[i], t;
                if ( p.hidden === true )
                    continue;
                if ( p.directory )
                  t = new P.DIR(p.directory.table, p.directory.field, p.directory.display, p.type, p.directory.ownerId);
                else if ( p.type === DataType.DATE_TIME )
                  t = new P.DTM( p.format );
                else if ( p.type === DataType.METATREE_NODE )
                  t = new P.MTN( p.filter );
                else
                  t = TMAP[p.type];
                var v = row[i];
                if ( v === ALLVAL )
                    v = undefined;
                PARAMS.push( new P.P( t, p.caption, i, p.notNull===true, p.oneValue!==true, v ) );
            }
            var parmform = P.mkParmForm( form$, PARAMS );
            var result = Asyncs.create();
            var m = Modal.show( {
                caption: title,
                content: form$
            } );
            WF.autoFocus( m.content );
            m.addButton("OK", function(){
                    if ( !parmform.validate() )
                      return;
                    function pvalue( p ) {
                        if ( p.ignored )
                          return ALLVAL;
                        var r = [];
                        for ( var i in p.values )
                            r.push( p.values[i].getter() );
                        return r.length > 1 ? r : r[0];
                    }
                    var rrow = {};
                    for ( var i in parmform.PARAMS )
                    {
                        var p = parmform.PARAMS[i];
                        rrow[p.name] = pvalue( p );
                    }
                    m.close();
                    result.resolve( rrow );
            } );
            m.onclose = function() {
                    m.close();
                    result.reject();
            };
            form$.parent().css( "padding", 0 );
            return result.promise();
        } );
    }
var Datamodel = CLASS( {
    constructor: function( arg ) {
        Datamodel.inherited.constructor.call( this );
        this._datasources = {};
        this._children = [];
        this._parameters = null;
        if ( arg instanceof Datamodel ) {
            arg._children.push( this );
            this._parentDModel = arg;
            this._modifications = arg._modifications;
        } else
            this._modifications = [];
        this._rq = null;
    },
    _touch: function() {
        Datamodel.inherited._touch.call( this );
        this._parentDModel && this._parentDModel._touch();
    },
    _savepoint: function() {
        var ridxs = [];
        for ( var i in this._datasources ) {
            var ds = this._datasources[i];
            for ( var j in ds._cursorsCache ) {
                var cs = ds._cursorsCache[j];
                ridxs.push( {
                    cs: cs,
                    ri: cs._ridx
                } );
            }
        }
        var self = this;
        return {
            mods: this._modifications.slice(),
            ridx: ridxs,
            modified: function() {
                return self._modifications.length > this.mods.length;
            }
        };
    },
    _rollback: function( sp ) {
        for ( var mi = this._modifications.length-1; mi >= sp.mods.length; mi-- ) {
            var m = this._modifications[mi];
            if ( m.ds._undomod( m ) )
                m.ds._touch();
        }
        this._modifications.splice( sp.mods.length, this._modifications.length-sp.mods.length );
        for ( var i in sp.ridx ) {
            var rx = sp.ridx[i];
            rx.cs._ridx = rx.ri;
            rx.cs._datasource._touch();
        }
    },
    _make_param_so: function(parameters, param){
        var addMultiple = false;
        function castToBoolean(v)
        {
            if(v == ALLVAL)
                return;
            return !!v;
        }
        function castToFloat(v)
        {
            if(v == ALLVAL)
                return;
            if(v == null)
                return 0;
            if(v instanceof Date)
                return AsmoDates.value()
            switch(param._descriptor.type)
            {
            case DataType.BOOLEAN:
                return (!!v)? 0:1;
            case DataType.PRIMARY_KEY:
            case DataType.INTEGER:
            case DataType.FLOAT:
            case DataType.INTERVAL:
            case DataType.DIRECTORY:
            case DataType.METATREE_NODE:
            case DataType.DATE_TIME:
                return Number(v);
            default:
                return String(v);
            }
        }
        function castToDate(v)
        {
            if(v == ALLVAL)
                return;
            if(v == null)
                return AsmoDates.BASE_DATE;
            if(v instanceof Date)
                return v;
            switch(param._descriptor.type)
            {
            case DataType.BOOLEAN:
                return AsmoDates.BASE_DATE;;
            case DataType.PRIMARY_KEY:
            case DataType.INTEGER:
            case DataType.FLOAT:
            case DataType.INTERVAL:
            case DataType.DIRECTORY:
            case DataType.METATREE_NODE:
            case DataType.DATE_TIME:
                return AsmoDates.valueToDate(Number(v));
            default:
                return AsmoDates.BASE_DATE;;
            }
        }
        function castToString(v)
        {
            if(v == ALLVAL)
                return;
            if(v == null)
                return null;
            if(v instanceof Date)
                return AsmoFormats.findById(410).format(AsmoDates.value(v));
            switch(param._descriptor.type)
            {
            case DataType.DATE_TIME:
                return AsmoFormats.findById(410).format(Number(v));
            default:
                return ""+v;
            }
        }
        function castValue(v)
        {
            switch(param._descriptor.type)
            {
            case DataType.BOOLEAN:
                return castToBoolean(v);
            case DataType.PRIMARY_KEY:
            case DataType.INTEGER:
            case DataType.FLOAT:
            case DataType.INTERVAL:
            case DataType.DIRECTORY:
            case DataType.METATREE_NODE:
            case DataType.DATE_TIME:
                return castToFloat(v);
            default:
                return String(v);
            }
        }
        function singleValue()
        {
            var raw = parameters._data[param.index];
            if(raw == ALLVAL)
                return null;
            else if(Array.isArray(raw))
            {
                if(raw.length == 0)
                    return null;
                return raw[0];
            }
            else
                return raw;
        }
        function setValue(v)
        {
            parameters._data[param.index] = castValue(v);
        }
        function clearValue()
        {
            parameters._data[param.index] = null;
            addMultiple = false;
        }
        function addValue(v)
        {
            var raw = parameters._data[param.index];
            if(!addMultiple)
            {
                if(v == null)
                    clearValue();
                else
                    setValue(v);
                addMultiple = true;
            }
            var isOA = Array.isArray(raw);
            var isNA = Array.isArray(v);
            if(!isOA && !isNA)
            {
                if(raw == ALLVAL)
                    setValue(v);
                else
                    raw = [raw, castValue(v)];
            }
            else if(!isOA && isNA)
            {
                if(raw == ALLVAL)
                    raw = [];
                else
                    raw = [raw];
                for(var i = 0; i < v.length; ++i)
                    raw.push(castValue(v[i]));
            }
            else if(isOA && !isNA)
                raw.push(castValue(v));
            else
                for(var i = 0; i < v.length; ++i)
                    raw.push(castValue(v[i]));
        }
        var so;
        so = CLASS({
            constructor: function()
            {
                Object.defineProperty(this, "name", {value: param._descriptor.name});
                Object.defineProperty(this, "id", {value: param.id});
                Object.defineProperty(this, "caption", {value: param._descriptor.caption});
                Object.defineProperty(this, "isIgnored", {get: function() { return parameters._data[param.index] == ALLVAL; } });
                Object.defineProperty(this, "asBoolean", {get: function() { return castToBoolean(singleValue()); }, set: function(v) { setValue(v); } });
                Object.defineProperty(this, "asNumber", {get: function() { return castToFloat(singleValue()); }, set: function(v) { setValue(v); } });
                Object.defineProperty(this, "asDate", {get: function() { return castToDate(singleValue()); }, set: function(v) { setValue(v); } });
                Object.defineProperty(this, "asDateValue", {get: function() { return castToFloat(singleValue()); }, set: function(v) { setValue(v); } });
                Object.defineProperty(this, "asString", {get: function() { return castToString(singleValue()); }, set: function(v) { setValue(v); } });
                Object.defineProperty(this, "asArray", {
                    get: function() 
                    { 
                        var raw = parameters._data[param.index];
                        if(raw == ALLVAL)
                            return [];
                        if(Array.isArray(raw))
                            return raw.slice();
                        return [raw];
                    }, 
                    set: function(v) { setValue(v); } 
                });
                Object.defineProperty(this, "valueCount",{
                    get: function(){
                        var raw = parameters._data[param.index];
                        if(raw == ALLVAL)
                            return 0;
                        else if(Array.isArray(raw))
                            return raw.length;
                        else
                            return 1;
                    }}
                );
                Object.defineProperty(this, "value",{get: singleValue, set: setValue} );
            },
            valueByIndex: function(index)
            {
                var raw = parameters._data[param.index];
                if(Array.isArray(raw))
                {
                    if(index < 0 || index >= raw.length)
                        return;
                    return raw[index];
                }
                if(index == 0)
                {
                    if(raw == ALLVAL)
                        return null;
                    if(raw == null)
                        return null;
                    return raw;
                }
                return;
            },
            addValue: addValue,
            addMultiple: function(v) { addMultiple = true; addValue(v); },
            clear: clearValue,
            setIgnore: function()
            {
                parameters._data[param.index] = ALLVAL;
            }
        });
        return new so();
    },
    _action: function( id ) {
        if ( this._rq !== null )
            return null;
        var self = this, m = !!this._modifications.length;
        switch ( id ) {
            case 1://save
                if (m) {
                    m = false;
                    for (var i = 0, l = this._modifications.length; i < l; ++i)
                        if (!this._modifications[i].ds._descriptor.virtual) {
                            m = true;
                            break;
                        }
                }
                return m ? function() {
        var body = [];
        for ( var i in self._modifications ) {
            var m = self._modifications[i];
            if (m.ds._descriptor.virtual)
                continue;
            ctx = [];
            ctx.push(m.ds._descriptor.table);
            ctx.push(m.ds._descriptor.id||0);
            ctx.push(m.ds._descriptor.ownerId||0);
            switch ( m.act ) {
                case 'm':
                    var kf = [], mf = [];
                    for ( var j in m.ds._keyfields ) {
                        var f = m.ds._keyfields[j];
                        kf.push( [f.id, m.org[f.index]] );
                    }
                    for ( var j in m.row ) {
                        var v = m.row[j];
                        if ( v !== m.org[j] )
                            mf.push( [m.ds._fields[j].id, v] );
                    }
                    if ( mf.length )
                        body.push( [0, ctx, kf, mf] );
                    break;
                case 'a':
                    var af = [];
                    for ( var j in m.row ) {
                        var v = m.row[j];
                        if ( v !== null )
                            af.push( [m.ds._fields[j].id, v] );
                    }
                    body.push( [1, ctx, [], af] );
                    break;
                case 'd':
                    var df = [];
                    for ( var j in m.ds._keyfields ) {
                        var f = m.ds._keyfields[j];
                        df.push( [f.id, m.org[f.index]] );
                    }
                    body.push( [2, ctx, df, []] );
                    break;
            }
        }
        return self._rq = Requests.execute( {
            caption: " ",
            type: "POST",
            url: "/rq/commitRecords",
            headers: {"Content-Type": "text/plain; charset=UTF-8"},
            data: JSON.stringify( body )
        } ).then( function( r ) {
            self._rq = null;
            self._modifications.splice( 0, self._modifications.length );
            (function clearmods( dm ) {
                for ( var i in dm._datasources ) {
                    var ds = dm._datasources[i];
                    if ( ds._modifications ) {
                        ds._modifications = [];
                        for ( var j in ds._curkeysCache ) {
                            var cs = ds._curkeysCache[j];
                            cs._modifications = [];
                            if ( cs._lost )
                                cs._invalidate();
                        }
                        ds._touch();
                    }
                }
                for ( var i in dm._children )
                    clearmods( dm._children[i] );
                dm._touch();
            })( self );
        }, function( e ) {
            self._rq = null;
            self._touch();
            log.error( e );
        } );
                } : null;
            case 2://undo
                return m ? function() {
                    self._rollback( {mods:[]} );
                    self._touch();
                } : null;
            case 3://refresh
                return m ? null : function() {
                    for ( var i in self._datasources )
                        if ( self._datasources[i]._dmodel === self )
                            self._datasources[i]._refresh();
                    for ( var i in self._children ) {
                        var a = self._children[i]._action( 3 );
                        if ( !a )
                            throw "disabled action";
                        a();
                    }
                };
            case 4://params
                var fields = [], values = [], mapping = [];
                for ( var i in self._parameters._fields ) {
                    var f = self._parameters._fields[i];
                    if ( f._descriptor.hidden )
                        continue;
                    var row = f._datasource._row();
                    if ( row === null )
                        return null;//loading
                    if ( row === undefined )
                        return null;//no row
                    fields.push( f._descriptor );
                    values.push( row[f.index] );
                    mapping.push( f );
                }
                return fields.length ? function() {
                    showParametersDialog( {
                        values: values,
                        fields: fields
                    }, " " ).done( function(values) {
                        var params = self._parameters;
                        var row = params._row();
                        for ( var i = 0; i < mapping.length; i++ ) {
                            var f = mapping[i];
                            var ds = f._datasource, row = ds._row();
                            if ( row === null )
                                throw "not loaded";
                            if ( row === undefined )
                                throw "no row";
                            row[f.index] = values[i];
                            ds._touch();
                        }
                    } );
                } : null;
        }
    }
}, Actioner );
    function mkFieldPath( fids, dsid, datasources ) {
        var result = [];
        var _ = datasources[dsid] || dsid;
        for ( var i = 0; i < fids.length; i++ ) {
            var f = _._fbyid[ fids[i]];            
            if (f !== undefined && f !== null)
            {
                result.push( f );
                _ = f._descriptor.directory && datasources[f._descriptor.directory.table];
            }
        }
        return result;
    }
    function getCachedFieldMultilookup( f ) {
        var mlf = f._multilookup;
        if ( !mlf ) {
            var tmp = [], fd = f._descriptor, ds = f._datasource;
            if ( fd.multilookup )
                for ( var j = 0, lj = fd.multilookup.length; j < lj; j++ )
                    tmp.push( mkFieldPath( fd.multilookup[j], ds, ds._dmodel._datasources ) );
            f._multilookup = mlf = tmp;
        }
        return mlf;
    }
    function gatherFPathDeps( fpath, deps ) {
        for ( var i = 0, l = fpath.length; i < l; i++ ) {
            var f = fpath[i];
            deps[f._datasource._id] = f._datasource;
            if ( f._descriptor.multilookup ) {
                var mlf = getCachedFieldMultilookup( f );
                for ( var j = 0, lj = mlf.length; j < lj; j++ )
                    gatherFPathDeps( mlf[j], deps );
            }
        }
        return deps;
    }
    function fetchFPathValue( fpath, row, typo ) {
        var v = fetchFPathValue.NVAL;
        for ( var i = 0, l = fpath.length; i < l; i++ ) {
            var f = fpath[i];
            if ( i || !row )
                row = f._datasource._row( v );
            if ( row === null )
                return fetchFPathValue.WAIT;
            if ( row === undefined )
                return fetchFPathValue.NVAL;
            var fd = f._descriptor;
            typo && (typo.type = fd.type);
            if ( fd.multilookup || (fd.type === DataType.VARIANT) ) {
                var mlf = getCachedFieldMultilookup( f );
                for ( var j = 0, lj = mlf.length; j < lj; j++ ) {
                    var v = fetchFPathValue( mlf[j], row, typo );
                    if ( v === fetchFPathValue.WAIT )
                        return v;
                    if ( (v !== fetchFPathValue.NVAL) && (v !== null) )
                        break;
                }
            } else
                v = row[f.index];
            if ( v === undefined )
                return fetchFPathValue.NVAL;
            if ( (v === null) || (v === ALLVAL) )
                break;
        }
        return v;
    }
    fetchFPathValue.WAIT = Actioner.WAIT;
    fetchFPathValue.NVAL = new String();
    var DefaultContext = {
        rower: function( ds ) {
            return ds._row( DefaultContext );
        }
    };
    return {
        ALLVAL: ALLVAL,
        DataType: DataType,
        Datamodel: Datamodel,
        Datasource: Datasource,
        Parameters: Parameters,
        TableDatasource: TableDatasource,
        Directory: Directory,
        mkFieldPath: mkFieldPath,
        gatherFPathDeps: gatherFPathDeps,
        fetchFPathValue: fetchFPathValue,
        showParametersDialog: showParametersDialog,
        createCachedContext: function() {
            var cache = {}, ctx = {
                rower: function( ds ) {
                    var id = ds._id;
                    var r = cache[id];
                    if ( !r )
                        cache[id] = r = ds._row( ctx );
                    return r;
                },
                init: function( ds, row ) {
                    cache = {};
                    cache[ds._id] = row;
                }
            };
            return ctx;
        },
        DefaultContext: DefaultContext,
        CBind: CBind
    };
} );
