define( [
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.forms.Requests",
    "static.teechart.teechart",
    "static.jquery.jquery"
], function( WebForm, DM, Requests, Tee, $ ) {
    return function( descriptor ) {
        this._postinit = function(components) {
            var diag$ = descriptor.element;
            var diag = diag$[0];
            if ( diag$) {
                diag$.attr("width", diag$.width())
                diag$.attr("height", diag$.height())
                var ch = new Tee.Chart(diag);
                var teeSeries = null;
                var sDescs = [];
                var sDesc = undefined;
                var SDesc = CLASS( {
                        constructor: function(props, teeSeries) {
                            this.teeSeries = teeSeries;
                            this.props = props;
                            this.xfpath = null;
                            if (this.props && this.props.x && this.props.x._datasource)
                                this.xfpath = DM.mkFieldPath( [this.props.x.id], this.props.x._datasource, components.datamodel._datasources );
                            this.yfpath = null;
                            if (this.props && this.props.y && this.props.y._datasource)
                                this.yfpath = DM.mkFieldPath( [this.props.y.id], this.props.y._datasource, components.datamodel._datasources );
                            this.lfpath = null;
                            if (this.props && this.props.l && this.props.l._datasource)
                                this.lfpath = DM.mkFieldPath( [this.props.l.id], this.props.l._datasource, components.datamodel._datasources );
                        }
                    } );
                for (var i in descriptor.seriesList)
                    if (descriptor.seriesList[i])
                    {
                        teeSeries = null;
                        switch (descriptor.seriesList[i].type)
                        {
                            case 0: teeSeries = new Tee.Line();     break;
                            case 1: teeSeries = new Tee.Area();     break;
                            case 2: teeSeries = new Tee.PointXY();  break;
                            case 3: teeSeries = new Tee.Bar();      break;
                            case 4: teeSeries = new Tee.HorizBar(); break;
                            case 5: teeSeries = new Tee.Pie();      break;
                        }
                        teeSeries.title = descriptor.seriesList[i].title;
                        ch.addSeries(teeSeries);
                        sDesc = new SDesc(descriptor.seriesList[i], teeSeries);
                        sDescs.push(sDesc);
                    }
                }
                for (var i in sDescs)
                    (function(desc){
                        var seriesWaiterTimeout = null;
                        var ds = null;
                        if ( desc.props )
                        {
                            if ( desc.props.x && desc.props.x._datasource )
                                ds = desc.props.x._datasource;
                            else
                                if ( desc.props.y && desc.props.y._datasource )
                                    ds = desc.props.y._datasource;
                        }
                        function update(){
                            var rcount = undefined;
                            var ok = true;
                            var v = undefined;
                            var isPie = desc.props.type == 5;
                            var isx = desc.xfpath && desc.xfpath.length;
                            var isy = desc.yfpath && desc.yfpath.length;
                            var isl = desc.lfpath && desc.lfpath.length;
                            if ( !ds._scan( function( cursor ) {
                                cursor._hintAllNeed();
                                rcount = cursor._rowsCount();
                                if ( rcount === DM.fetchFPathValue.WAIT ) {
                                    ok = false;
                                    return;
                                }
                                clearTimeout( seriesWaiterTimeout );
                                seriesWaiterTimeout = null;

                                if ( isx && isy && ( !isPie ) )
                                    if ( desc.teeSeries.data.x )
                                        desc.teeSeries.data.x.length = 0;
                                    else
                                        desc.teeSeries.data.x = [];
                                if ( ( isy || isPie ) && desc.teeSeries.data.values.length )
                                    desc.teeSeries.data.values.length = 0;
                                if ( isl && desc.teeSeries.data.labels && desc.teeSeries.data.values.labels )
                                    desc.teeSeries.data.labels.length = 0;

                                for ( cursor._ridx = 0; cursor._ridx < rcount; cursor._ridx++ ) {
                                    var crow = cursor._row();
                                    if ( !crow ) {
                                        ok = false;
                                        return;
                                    }
                                    if ( isx )
                                    {
                                        v = DM.fetchFPathValue( desc.xfpath );
                                        if (v === DM.fetchFPathValue.WAIT)
                                        {
                                            ok = false;
                                            return;
                                        }
                                        if ( isPie )
                                            desc.teeSeries.data.values.push( v );
                                        else
                                            desc.teeSeries.data.x.push( v );
                                    }
                                    if ( isy )
                                    {
                                        v = DM.fetchFPathValue( desc.yfpath );
                                        if (v === DM.fetchFPathValue.WAIT)
                                        {
                                            ok = false;
                                            return;
                                        }
                                        desc.teeSeries.data.values.push( v );
                                    }
                                    if ( isl )
                                    {
                                        v = DM.fetchFPathValue( desc.lfpath );
                                        if (v === DM.fetchFPathValue.WAIT)
                                        {
                                            ok = false;
                                            return;
                                        }
                                        desc.teeSeries.data.labels.push( v );
                                    }
                                }
                                ch.draw();
                            } ) || !ok ) {
                                if ( !seriesWaiterTimeout )
                                seriesWaiterTimeout = setTimeout( function() {
                                    if ( !seriesWaiterTimeout )//IE8 bug
                                        return;
                                }, 250 );
                            }
                        }
                        if ( ds )
                        {
                            ds._listen( update );
                            update();
                        }
                    })(sDescs[i]);
            };
        };
} );


