define( [
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.forms.Requests",
    "static.jquery.jquery"
    , 'inform.agent.web.Styles'
    , 'static.wcl.Core'
], function(DM, Requests, $, Styles, Wcl) {
    Styles.sheet().rules({
        'div.doc': {
            border: '1px solid #D0D0D0',
            overflow: 'auto',
            '.waiting > span': {
                padding: '1em',
                display: 'inline-block'
            }
        }
    });
    var HEX = "0123456789ABCDEF".split( "" );
    function make( datasources ) {
        this._wcl_calculate = function() {
            return {
                min: {x:50, y:50}/*magic*/,
                max: Wcl.Control.UNBOUND_MAX
            };
        };
        var element$ = $( this );
        var node = element$.attr( "data-node" );
        if ( node ) {
            element$.addClass( "waiting" ).text( "..." );
            Requests.execute( {
                url: "/bdoc/" + node
            } ).then( function( r ) {
                element$.html( r ).removeClass( "waiting" );
            } );
            return;
        }
        var dsid = element$.attr( "data-datasource" );
        var fid = element$.attr( "data-datafield" );
        if ( dsid && fid ) {
            var datasource = datasources[dsid];
            var fpath = DM.mkFieldPath( fid.split( ',' ), dsid, datasources );
            var fl = fpath[fpath.length-1];
            var rq = null;
            function update() {
                var v = DM.fetchFPathValue( fpath );
                if ( v === DM.fetchFPathValue.WAIT )
                    element$.addClass( "waiting" ).html( "<span>...</span>" );
                else {
                    if ( rq )
                        rq.abort();
                    switch ( fl._descriptor.type ) {
                        case DM.DataType.STRING:
                            element$.text( v ).removeClass( "waiting" );
                            break;
                        case DM.DataType.BLOB:
                        case DM.DataType.FILE:
                            var dd = datasource._descriptor, table = dd.table || dd.node;
                            var fok = false, key = 0, row = datasource._row();
                            if ( !row ) {
                                element$.empty().removeClass( "waiting" );
                                break;
                            }
                            for ( var i in datasource._keyfields ) {
                                var f = datasource._keyfields[i];
                                key = row[f.index];
                                fok = true;
                                break;
                            }
                            if ( !fok )
                                throw "no key field found";
                            rq = Requests.execute( {
                                caption: " ",
                                url: "/bdoc/" + table + '/' + fl.id + '/' + key
                            } );
                            rq.then( function( r ) {
                                element$.html( r ).removeClass( "waiting" );
                            });
                            break;
                    }
                }
            }
            datasource._listen( update );
            update();
        }
    }
    return {
        initialization: function( root$, components ) {
            root$.find( "div.doc" ).each( function() {
                make.call( this, components.datamodel._datasources );
            } );
        }
    };
} );