define( [
    "inform.agent.web.forms.Actioner",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.NodeInfo",
    "static.jquery.jquery"
  , 'css!inform.agent.web.forms.WebForm'
], function( Actioner, DM, NI, $ ) {
    var ActionList = CLASS( {
        constructor: function( adesrc, components ) {
            ActionList.inherited.constructor.call( this );
            this._dmodel = components.datamodel;
            this._actions = [];
            var acts = (typeof adesrc === "string") ? adesrc.split( ';' ) : adesrc;
            for ( var i in acts ) {
                var a = acts[i];
                if ( typeof a === "string" )
                    a = a.split( ':' );
                var ac = components[a[0]];
                this._dependOn( [ac] );
                this._actions.push( {
                    com: ac,
                    act: a[1] | 0
                } );
            }
        },
        _action: function() {
            var a = this._actions[0], act = a.com._action( a.act );
            if ( !act || (act === Actioner.WAIT) )
                return act;
            var self = this;
            return function( arg ) {
                var sp = self._dmodel._savepoint(), args = {savepoint: sp, event: arg.event};
                var result = Asyncs.when( act(args) );
                for ( var i = 1, l = self._actions.length; i < l; i++ )
                    result = result.then( (function( idx ) {
                        var a = self._actions[idx];
                        return function() {
                            var r = Asyncs.create();
                            function tryit() {
                                act = a.com._action( a.act );
                                if ( !act )
                                    r.reject( "disabled action" );
                                else if ( act !== Actioner.WAIT )
                                    Asyncs.when( act(args) ).then( r.resolve, r.reject );
                                else
                                    setTimeout( tryit, 250 );
                            }
                            tryit();
                            return r.promise();
                        };
                    })( i ) );
                result.fail( function() {
                    arguments.length && log.error.apply( log, arguments );
                    self._dmodel._rollback( sp );
                    self._dmodel._touch();
                } );
                return result;
            };
        }
    }, Actioner );
    var setTextContent;
    if ( navigator.appName === "Microsoft Internet Explorer" )
        setTextContent = function( node, text ) {
            if ( (text === null) || (text === undefined) )
                node.innerText = "";
            else
                node.innerText = text;
        };
    else if ( "innerText" in document.body )
        setTextContent = function( node, text ) {
            node.innerText = (text === null) || (text === undefined) ? "" : text;
        };
    else
        setTextContent = function( node, text ) {
            node.textContent = text;
        };
    var module;
    return module = {
        ActionList: ActionList,
        setTextContent: setTextContent,
        formatCellValue: function( cell, v, type, fmt, expr ) {
            var html = false;
            switch ( type ) {
                case DM.DataType.NONE:
                    if ( fmt && (v !== null) && (v !== undefined) )
                        v = fmt.format( v );
                    break;
                case DM.DataType.INTEGER:    
                    if ( (v !== null) && (v !== undefined) )
                        v = Number(v).toFixed(0);
                    break;
                case DM.DataType.FLOAT:
                case DM.DataType.DATE_TIME:
                    if ( fmt && (v !== null) && (v !== undefined) )
                        v = fmt.format( v );
                    else
                        if (v && (typeof(v) !== 'number')) 
                            v = '';
                    break;
                case DM.DataType.BOOLEAN:
                    var tmp = "<img src='" + asmo.root + "/static/images/cb_";
                    if ( (v === null) || (v === undefined) )
                        tmp += 'n';
                    else
                        tmp += v ? 'c' : 'u';
                    v = tmp + ".png' class='check'/>";
                    html = true;
                    break;
                case DM.DataType.METATREE_NODE:
                    if ( (v !== null) && (v !== undefined) ) {
                        var ni = NI.fetch( v, NI.Options.NAME | NI.Options.IMAGE | NI.Options.FIO );
                        if ( !ni )
                            return false;
                        v = ni.image ? "<img src='" + asmo.root + "/images/icons/16/" + ni.image + "'>" : "";
                        v += fmt ? fmt.format( ni ) : ni.name;
                    }
                    html = true;
                    break;
            }
            if ( cell._value !== v ) {
                cell._value = v;
                if ( html || ( expr && expr.isHtml ) )
                    cell.innerHTML = ((v === null) || (v === undefined)) ? "&nbsp;" : v;
                else
                    setTextContent( cell, v );
            }
            return true;
        },
        updateIcons: function( root ) {
            $( root ).find( "img[data-icon]" ).each( function() {
                var e$ = $( this ), ico = e$.attr( "data-icon" ), src = e$.attr( "src" );
                if ( src && (src.lastIndexOf( ico ) === src.length - ico.length) )
                    return;
                var sz = (24 * (window.devicePixelRatio || 1)) | 0, pfx = asmo.root + "/images/icons/" + sz + '/';
                e$.attr( "src", pfx + ico );
            } );
        },
        autoFocus: function( root ) {
            $( root ).find( "button,input,textarea" ).first().focus();
        },
        mkMainForm: function(arg) {
            return require([
                'inform.agent.web.Styles',
                'static.wcl.Core',
                'static.wcl.Utils',
                'static.wcl.layouts.Flow',
                'static.wcl.controls.Button',
                'static.wcl.controls.Toolbar',
                'static.wcl.controls.Label',
                'static.wcl.controls.ScrollPane',
                'inform.agent.web.forms.Dropdown',
                'inform.agent.web.Modal'
            ], function(Styles, Wcl, Utils, Flow, Button, Toolbar, Label, ScrollPane, DD, Modal) {
                var onafteruserchanged = arg.onAfterUserChanged;
                Styles.sheet().rules({
                    '.wcl-mainmenu': {
                        'background-color': '#E0E0E0',
                        'background-image': ['url(' + asmo.root + '/static/images/btn_normal.png)', 'linear-gradient(top, #FFFFFF, #E0E0E0)'],
                        'background-repeat': 'repeat-x',
                        'border-bottom': '1px solid #AAAAAA',
                        'box-shadow': '0 0 2px #808080'
                    }
                });
                function smartopen(path, name) {
                    var w = name === window.name ? window : window.open('', name);
                    log.debug('pathname:', w.location.pathname, path, w.document.hidden);
                    function fallback() {
                        window.open(path, name);
                    }
                    if (w && (w.location.pathname === path)) {
                        if (w === window)
                            return;
                        if ('hidden' in w.document) {
                            w.focus();
                            log.debug('hidden0:', w.document.hidden);
                            if (w.document.hidden)
                                setTimeout(function () {
                                    log.debug('hidden1:', w.document.hidden);
                                    if (w.document.hidden !== false)
                                        fallback();
                                }, 250);
                            return;
                        }
                    }
                    fallback();
                }
                var result;
                function MainMenu(parent, container, arg) {
                    var element = document.createElement('div');
                    element.className = 'wcl-mainmenu';
                    container.appendChild(element);
                    var username = Wcl.createRWModel();
                    function updateuser(u) {
                        asmo.user = u;
                        u && username.set((u.fio || u.name) + ' &#9660;');
                    }
                    updateuser(asmo.user);
                    var items = [
                        {_: Button, icon: 45, style: {'border': 0}, onclick: function() {
                            var path = asmo.root || '/', name = asmo.pathToName(path);
                            smartopen(path, name);
                        }, hint: '   '},
                        {_: Label, text: arg.title, style: {
                                'color': '#0080F0',
                                'font-weight': 'bold',
                                'padding-right': '1em',
                                'overflow': 'hidden',
                                'text-overflow': 'ellipsis',
                        }}
                    ];
                    items[1] = {_: function (parent, container, arg) {
                            var item = Wcl._mk(parent, container, arg.item);
                            var firstvalidate = true;
                            this.calculate = function () {
                                var c = item.calculate();
                                var mnx = Math.min(c.min.x + 1, document.body.clientWidth / 2);
                                return {
                                    _ic: c,
                                    min: {
                                        x: mnx,
                                        y: c.min.y
                                    },
                                    max: {
                                        x: Math.max(c.max.x, mnx),
                                        y: c.max.y
                                    }
                                };
                            };
                            this.validate = function (arg) {
                                if (firstvalidate) {
                                    firstvalidate = false;
                                    Styles.removeClass(element.parentNode, 'wcl-cloak');
                                }
                                item.validate({rect: arg.rect, calc: arg.calc._ic});
                            };

                        }, item: items[1]};
                    var flow = Wcl._mk(parent, element, {
                        _: Flow, type: Flow.HORZ,
                        items: items
                    });
                    this.toolbar = flow.appendItem({_: Toolbar});
                    this.userbar = flow.appendItem({_: Flow, type: Flow.HORZ});
                    flow.appendItem({_: Utils.Spacer, type: Utils.Spacer.HORZ});
                    flow.appendItem({_: Button, text: '', className: 'activities debug', onclick: function() {}});
                    flow.appendItem({_: Button, text: username, icon: 12, onclick: function() {
                        function login() {
                            try {
                                Styles.sheet().rules({
                                    'form.login': {
                                        'padding': '1em 1em 0',
                                        '>*': {
                                            'display': 'inline-block',
                                            'vertical-align': 'top',
                                            'margin-bottom': '0.5em',
                                            'margin-left': '0.5em'
                                        },
                                        '>label>span': {
                                            'display': 'block',
                                            'color': 'gray',
                                            'font-weight': 'bold',
                                            'padding-top': '0.2em'
                                        },
                                        '.waiting': {
                                            'opacity': '0.75',
                                            'filter': 'e("alpha(opacity = 75)")'
                                        }
                                    }
                                });
                                require(["css!inform.agent.web.forms.WebForm"]);
                                var e$ = $('<form class="login" action="about:blank" target="saveautocomplete"><div style="display:block;margin-bottom:1em"><img src="'+asmo.root+'/static/images/login.png" style="vertical-align:top;width:32px"><span style="margin-left:0.5em;display:inline-block;white-space:pre-wrap">   ,   \n    </span></div><label><input id="usr" name="usr" type="text" autofocus><span> </span></label><label><input id="psw" type="password"><span></span></label><label><input type="submit" value="&nbsp;&nbsp;OK&nbsp;&nbsp;"></label></form>');
                                var md = Modal.show({
                                    caption: arg.title,
                                    content: e$
                                });
                                $('<iframe name="saveautocomplete" src="about:blank" style="display:none"></iframe>').appendTo(md.content);
                                e$.find('#usr').focus();
                                function auth() {
                                    var ctrls = e$.find('#usr,#psw,input[type=submit]');
                                    ctrls.attr('disabled', true);
                                    e$.addClass('waiting');
                                    require(['static.auth'], function(auth) {
                                        return auth(e$.find('#usr').val(), e$.find('#psw').val());
                                    }).then(function(ui) {
                                        updateuser(ui);
                                        onafteruserchanged && onafteruserchanged(ui);
                                        md.close();
                                    }, function(e) {
                                        ctrls.attr('disabled', false);
                                        e$.removeClass('waiting');
                                        alert(e);
                                    });
                                }
                                e$[0].onsubmit = auth;
                            } catch (e) {
                                alert(e);
                            }
                        }
                        function logout() {
                            $.ajax({
                                url: asmo.root + '/logout/json',
                                async: false,
                                dataType: 'json'
                            }).done(function(ui) {
                                updateuser(ui);
                                onafteruserchanged && onafteruserchanged(ui);
                            });
                        }
                        var elem = this;
                        function withlogout(func) {
                            if (result.onBeforeUserChange)
                                return function() {
                                    Asyncs.when(result.onBeforeUserChange()).then(function(r) {
                                        r && func();
                                    });
                                };
                            return func;
                        }
                        var source = asmo.user.anonymous ? [{value: login, label: ''}] : [{value: withlogout(login), label: ' '}, {value: withlogout(logout), label: ''}];
                        DD.show({
                            element: elem,
                            source: source,
                            value: function() {
                                if (arguments.length)
                                    arguments[0]();
                            }
                        });
                    }});
                    this.calculate = function() {
                        var ca = flow.calculate();
                        return {
                            min: {x: ca.min.x + 4, y: ca.min.y + 5},
                            max: {x: ca.max.x + 4, y: ca.max.y + 5},
                            _ch: ca
                        };
                    };
                    var recter = Wcl._mkRecter(element);
                    this.validate = function(arg) {
                        recter(arg.rect);
                        var r = arg.rect, c = arg.calc, p = {
                            x: r.p.x + 2,
                            y: r.p.y + 2
                        }, s = {
                            x: r.s.x - 4,
                            y: r.s.y - 5
                        };
                        flow.validate({rect: {p: p, s: s}, calc: c._ch});
                    };
                }
                var df = document.createDocumentFragment();
                while (document.body.firstChild)
                    df.appendChild(document.body.firstChild);
                var mf = Wcl.create(document.body, {_: Flow, type: Flow.VERT, flowType: 59, gap: 0});
                var m = mf.appendItem({_: MainMenu, icon: arg.icon, title: arg.caption});
                function Expander(parent, container, arg) {
                    var item = this.item = arg.item && Wcl._mk(parent, container, arg.item);
                    var flowType = arg.flowType;
                    var minw = (!arg.minw)? 0:Wcl.unit2px(arg.minw);
                    var minh = (!arg.minh)? 0:Wcl.unit2px(arg.minh);
                    var maxw = (!arg.maxw)? 0:Wcl.unit2px(arg.maxw);
                    var maxh = (!arg.maxh)? 0:Wcl.unit2px(arg.maxh);
                    this.calculate = function() {
                        var c = item && item.calculate();
                        return {
                            min: c ? c.min : {x: 0, y: 0},
                            max: Wcl.Control.UNBOUND_MAX,
                            _ca: c
                        };
                    };
                    this.validate = function(arg) {
                        var p =
                            {
                                rect: {
                                    p: arg.rect.p,
                                    s: {
                                        x: arg.rect.s.x,
                                        y: Math.min(arg.rect.s.y, (!!arg.calc._ca)?arg.calc._ca.max.y:0)
                                    }
                                },
                                calc: arg.calc._ca
                            };
                        if(maxw > 0)
                            p.rect.s.x = Math.min(Math.max(p.calc.min.x, maxw), p.rect.s.x);
                        if(minw > 0)
                            p.rect.s.x = Math.max(minw, p.rect.s.x);
                        switch(flowType&0x30)
                        {
                        case 0x10:
                        case 0x30:
                            if(p.rect.s.x < arg.rect.s.x)
                                p.rect.p.x = arg.rect.p.x+(arg.rect.s.x-p.rect.s.x)/2;
                            break;
                        case 0x20:
                            if(p.rect.s.x < arg.rect.s.x)
                                p.rect.p.x = arg.rect.p.x+arg.rect.s.x-p.rect.s.x;
                            break;
                        }
                        if(maxh > 0)
                            p.rect.s.y = Math.min(Math.max(p.calc.min.y, maxh), p.rect.s.y);
                        if(minh > 0)
                            p.rect.s.y = Math.max(minh, p.rect.s.y);
                        item && item.validate(p);
                    };
                }
                var s = mf.appendItem({_: ScrollPane, item: {_: Expander, flowType: arg.flowType, minw: arg.minw, minh: arg.minh, maxw: arg.maxw, maxh: arg.maxh, item: arg.item}});
                s.element.appendChild(df);
                return result = {
                    element: s.element,
                    item: s.item.item,
                    menu: {
                        appendItem: function(arg) {
                            return m.userbar.appendItem(arg);
                        }
                    },
                    toolbar: {
                        addButton: function(arg) {
                            m.toolbar.appendItem({_: Button, text: arg.caption, icon: arg.icon, onclick: arg.onclick});
                        }
                    }
                };
            });
        },
        color2hex: (function() {
            var HEX = "0123456789ABCDEF".split( "" );
            return function( v ) {
                if ( (v === null) || (v === undefined) )
                    return "";
                if ( v === 0x1FFFFFFF )//clNone
                    return "";
                return '#' + HEX[(v >> 4) & 0xF] + HEX[v & 0xF] + HEX[(v >> 12) & 0xF] + HEX[(v >> 8) & 0xF] + HEX[(v >> 20) & 0xF] + HEX[(v >> 16) & 0xF];
            };
        })(),
        assignTextStyle: function( style, v ) {
            if ( typeof v === "string" ) {
                var sp = v.split( ',' );
                v = 0;
                for ( var i in sp )
                    switch ( sp[i] ) {
                        case "fsBold":
                            v |= 1;
                            break;
                        case "fsItalic":
                            v |= 2;
                            break;
                        case "fsUnderline":
                            v |= 4;
                            break;
                        case "fsStrikeOut":
                            v |= 8;
                            break;
                    }
            } else
                v = v | 0;
            (v & 1) && (style.fontWeight = "bold");
            (v & 2) && (style.fontStyle = "italic");
            (v & 4) && (style.textDecoration = "underline");
            (v & 8) && (style.textDecoration += " line-through");
        }
    };
} );
