define([    
      'inform.agent.web.forms.Datamodel'
    , 'inform.agent.web.forms.WebForm'  
    , 'inform.agent.web.forms.Formats'
    , 'inform.agent.web.utils.Strings'
    , 'inform.agent.web.Styles'
    , 'inform.agent.web.Expressions'
], function (DM, F, Formats, Strings, Styles, Expressions) {
    
    function fetchOptional( expressions, ctx ) {
        var result = {};
        for ( var i in expressions ) {
            var e = expressions[i];
            if ( !e )
                continue;
            var v = e.evaluate( ctx );
            if ( v === Expressions.WAIT )
                return null;
            if ( (v !== Expressions.NVAL) && (v !== null) )
                result[i] = v;
        }
        return result;
    }    
    
    function checkVeer(column) {        
        var dsid = Elements.dataset(column, "datasource-veer");
        if (!dsid)
            return false;

        var ddskid = Elements.dataset(column, "datasource-veer-data");
        if (!ddskid)
            return false;
        var ddsid = Elements.dataset(column, 'datasource');
        if (!ddsid || (ddsid !== ddskid))
            return false;
        return true;
    }
    
    function getVeerDef(column, datasources) {        
        var dsid = Elements.dataset(column, "datasource-veer");
        if (!dsid)
            return null;
        var fid = Elements.dataset(column, "datafield-veer");                
        var fp = null, sfp = null;                
        if (dsid && fid) {
            sfp = fid.split( ',' );
            fp = DM.mkFieldPath(sfp, dsid, datasources);
        }

        var ddskid = Elements.dataset(column, "datasource-veer-data");
        if (!ddskid)
            return null;
        
        var dfkid = Elements.dataset(column, "datafield-veer-data");                
        var dfkp = null, sdfkp = null;
        if (ddskid && dfkid) {
            sdfkp = dfkid.split( ',' );
            dfkp = DM.mkFieldPath(sdfkp, ddskid, datasources);
        }


        var cfid = Elements.dataset(column, "datafield-veer-caption");                
        var cfp = null, scfp = null;                
        if (dsid && cfid) {
            scfp = cfid.split( ',' );
            cfp = DM.mkFieldPath(scfp, dsid, datasources);
        }

        var capfmt = Elements.dataset(column, "veer-caption-format");                
        if (capfmt) {
            var fmtopt = Elements.dataset(column, 'veer-caption-format-option');
            capfmt = Formats.byIdAndOption(capfmt, fmtopt && Strings.base64_to_bytestr(fmtopt));
        }

        var ddtype = parseInt(Elements.dataset(column, 'datatype'));
        var ddsid = Elements.dataset(column, 'datasource');
        if (!ddsid || (ddsid !== ddskid))
            return null;
        var dfid = Elements.dataset(column, 'datafield');
        var dsfp = null, dfp = null;
        if ( ddsid && dfid ) {
            dsfp = dfid.split( ',' );
            dfp = DM.mkFieldPath( dsfp, ddsid, datasources );
        }
        var fmt = Elements.dataset(column, 'format');        
        if ( fmt ) {
            var fmtopt = Elements.dataset(column, 'format-option');
            fmt = Formats.byIdAndOption(fmt, fmtopt && Strings.base64_to_bytestr(fmtopt));
        }
        
        var veerDef = {
            veerDS: dsid,            
            veerFPath: fp,
            dataDS: ddskid,
            dataKeyFPath: dfkp,
            dataFPath: dfp,
            dataType: ddtype,
            dataFormat: fmt,
            captFPath: cfp,
            captFormat: capfmt,            
            baseCol: column            
        };        
        return veerDef;
    }
    
    function makeGridVeerList(){
        var veersIsLoaded = [];
        var veerDatasources = [];
        var veerFieldPaths = [];
        var dataDatasources = [];
        var dataFieldPaths = [];
        var dataKeyFieldPaths = [];
        var dataFormats = [];
        var dataTypes = [];
        var captionFieldPaths = [];
        var captionFormats = [];      
        var baseColumns = [];
        var baseHeaders = [];

        var grid = null;
        var gridUpdate = null;
        var hcellList = null;    
        var columns = null;
        var autosizedColumns = null;
        var gridColumns = null;
        var datasourceList = null;
        var header = null;
        var sheet = null;    
        var thMap = [];
        var colsMap = null;

        function prepareThMap(needReset) {
            if (!header)
                return;
            thMap = [];
            var trs = header.getElementsByTagName("tr");
            if (needReset){
                for (var r = 0; r < trs.length; r++){
                    var ths = trs[r].getElementsByTagName("th");
                    for (var thi = 0; thi < ths.length; thi++){
                        var th = ths[thi];
                        var oldColSpan = th.getAttribute("old-colspan");
                        if (oldColSpan)
                            th.colSpan = oldColSpan;
                    }
                }
            }

            for (var c = 0; c < gridColumns.length; c++){
                thMap[c] = [];
                for (var r = 0; r < trs.length; r++){
                    thMap[c][r] = 1;
                }
            }

            for (var r = 0; r < trs.length; r++){
                var ths = trs[r].getElementsByTagName("th");
                var c = 0;
                for (var thi = 0; thi < ths.length; thi++){
                    while (!thMap[c][r])
                        c++;
                    var th = ths[thi];
                    for (var i = 0; i < th.colSpan; i++){
                        for (var k = 0; k < th.rowSpan; k++)
                            thMap[c + i][r + k] = 0;
                    }
                    thMap[c][r] = 1;
                    if (!th.getAttribute("old-colspan"))
                        th.setAttribute("old-colspan", th.colSpan);
                    c += th.colSpan;
                }
            }        
        }

        function insertAfter(elem, refElem, offset) {
            var parent = refElem.parentNode;
            var next = refElem.nextSibling;
            for (var i = 0; i < offset; i++){
                if (next)
                    next = next.nextSibling;
            }
            if (next) {
                return parent.insertBefore(elem, next);
            } else {
                return parent.appendChild(elem);
            }
        }   

        function isColumnExists(ridx, veerIndex){        
            if (hcellList.length){
                var buff = "vr_" + baseColumns[veerIndex].id + "_" + ridx;
                for (var i = 0; i < hcellList.length; i++){
                    if (hcellList[i].getAttribute("data-colid") === buff)
                        return true;                   
                }
            }
            return false;
        }

        function validateVeerCell(column, ctx, cell)
        {
            var veerIndex = column.veerIndex;
            if (!veerIndex)
                return true;
            var ok = true;
            var value = undefined; 
            if (!dataDatasources[veerIndex]._scan(function(cursor) { 
                var rcount = cursor._rowsCount();
                if (rcount === DM.fetchFPathValue.WAIT) {
                    ok = false;
                    return false;
                }            
                for (cursor._ridx = 0; cursor._ridx < rcount; cursor._ridx++) 
                {
                    var row = cursor._row();
                    if (!row) {
                        ok = false;
                        break;
                    }
                    ctx.init(dataDatasources[veerIndex], row);
                    var key = DM.fetchFPathValue(dataKeyFieldPaths[veerIndex], ctx.rower(dataDatasources[veerIndex]));
                    if (key === DM.fetchFPathValue.WAIT) 
                    {
                        ok = false;
                        break;
                    }
                    if (column.keyValue === key)
                    {
                        if (column.expr) {
                            value = column.expr.evaluate(ctx);
                            if (value === DM.fetchFPathValue.WAIT)
                                return false;
                            if (value === DM.fetchFPathValue.NVAL)
                                value = undefined;
                        } else
                            value = DM.fetchFPathValue(dataFieldPaths[veerIndex], ctx.rower(dataDatasources[veerIndex]));
                        ok = value !== DM.fetchFPathValue.WAIT;
                        var v;
                        if (!(v = fetchOptional({
                            rc: column.exprColor,
                            tc: column.exprTextColor,
                            ts: column.exprTextStyle
                        }, ctx)))
                            return false;
                        cell.style.backgroundColor = F.color2hex(v.rc);
                        cell.style.color = F.color2hex(v.tc);
                        F.assignTextStyle(cell.style, v.ts);
                        break;
                    }
                }
            })|| !ok ) {
                return false;
            }            
            if (!F.formatCellValue(cell, value, column.type, column.fmt, column.expr))
                return false;
            return true;
        }
        function computeColumnOffset(veerIndex){
            var result = 0;
            for (var i = 0; i < columns.length; i++)
                if (columns[i].id === baseColumns[veerIndex].id)
                    return i;
            return result;
        }
        
        function appendColToColMap(gridCol, veerIndex) {
            var key = gridCol.id + ":" + header.id;
            colsMap[key] = {
                colExpr: Elements.dataset(baseColumns[veerIndex], 'expression'),
                colExprColor: Elements.dataset(baseColumns[veerIndex], 'color-expression'),
                colExprTextColor: Elements.dataset(baseColumns[veerIndex], 'textcolor-expression'),
                colExprTextStyle: Elements.dataset(baseColumns[veerIndex], 'textstyle-expression')                    
            };
        }
        
        function buildColumns(v, capt, ridx, veerIndex, veerOffset){
            if (!v || !columns || !capt)
                return;      
            var th = null;
            var value = capt;
            if (isColumnExists(ridx, veerIndex))
                return;
            if (hcellList.length){
                th = document.createElement('th'); 
                th.setAttribute("data-colid", "vr_" + baseColumns[veerIndex].id + "_" + ridx);
                th.setAttribute("class", "c" + baseColumns[veerIndex].id);
                th.setAttribute("veer-index", veerIndex);
                var rowSpan = baseHeaders[veerIndex].rowSpan;
                th.setAttribute("rowspan", rowSpan);
                insertAfter(th, baseHeaders[veerIndex], ridx);
                if ( captionFormats[veerIndex] && value )
                    value = captionFormats[veerIndex].format( value );
                else
                    if (!value)
                        value = "&nbsp;";
                th.innerHTML = value;
            }
            var gridCol = document.createElement("col");
            gridCol.setAttribute("id", "vr_" + baseColumns[veerIndex].id + "_" + ridx); 
            gridCol.setAttribute("veer-index", veerIndex);
            var ranging = Elements.dataset(baseColumns[veerIndex], "ranging");
            gridCol.setAttribute("data-ranging", ranging);
            var startWidth = baseColumns[veerIndex].getAttribute("start-width");
            gridCol.setAttribute("start-width", startWidth);

            insertAfter(gridCol, baseColumns[veerIndex], ridx);
            var rule = sheet.rule('.grid[id="' + header.id + '"] .c' + baseColumns[veerIndex].id);
            appendColToColMap(gridCol, veerIndex);
            var expr = Elements.dataset(baseColumns[veerIndex], 'expression');
            var exprColor = Elements.dataset(baseColumns[veerIndex], 'color-expression');
            var exprTextColor = Elements.dataset(baseColumns[veerIndex], 'textcolor-expression');
            var exprTextStyle = Elements.dataset(baseColumns[veerIndex], 'textstyle-expression');                    

            var column = {
                id: "vr_" + baseColumns[veerIndex].id + "_" + ridx,                    
                header: th,
                type: dataTypes[veerIndex],
                expr: expr ? Expressions.make(expr, datasourceList, colsMap, "data", []) : null,
                exprColor: exprColor ? Expressions.make(exprColor, datasourceList, colsMap, "color", []) : null,
                exprTextColor: exprTextColor ? Expressions.make(exprTextColor, datasourceList, colsMap, "textColor", []) : null,
                exprTextStyle: exprTextStyle ? Expressions.make(exprTextStyle, datasourceList, colsMap, "textStyle", []) : null,
                cells: [],
                fmt: dataFormats[veerIndex],            
                changeno: 0,
                keyValue: v,
                veerIndex: veerIndex,
                rule: rule, 
                startWidth: startWidth,
                validate: function(ctx, cell) {
                    return validateVeerCell(this, ctx, cell);
                }
            };
            columns.splice(veerOffset + 1 + ridx, 0, column);
            for (var aci = 0; aci < autosizedColumns.length; aci++)
                if (autosizedColumns[aci] > veerOffset + ridx)
                    autosizedColumns[aci] = autosizedColumns[aci] + 1;
            if (Elements.dataset(baseColumns[veerIndex], 'ranging') !== "fixed") { 
                for ( var i = 1; i < gridColumns.length; i++ ) {
                    if (gridColumns[i].id === gridCol.id) {
                        autosizedColumns.push(i);
                        break;
                    }
                }       
            }
        }

        function listenVeerData(func, veerIndex){
            dataDatasources[veerIndex]._listen(func);        
        }

        function correctColSpanForTopHeader(currentHeader, veerSize, veerOffset){
            if (!currentHeader || !currentHeader.parentNode)
                return;        
            var topTr = currentHeader.parentNode.previousSibling;
            if (!topTr || (topTr.tagName !== "TR")){
                return; //      ,   
            }

            var r = topTr.rowIndex;
            var ths = topTr.getElementsByTagName("th");
            var c = 0;
            var th = null;
            for (var thi = 0; thi < ths.length; thi++){
                th = ths[thi];
                while (!thMap[c][r])
                    c++;
                c += th.colSpan;
                if (c > veerOffset)
                    break;
            }
            th.colSpan = th.colSpan + veerSize - 1;        
            correctColSpanForTopHeader(th, veerSize, veerOffset);
        }

        function removeColumns(veerIndex){
            if (!columns)
                return;         

            for (var i = gridColumns.length - 1; i >= 0; i--){
                var gridCol = gridColumns[i];
                var gvidx = gridCol.getAttribute("veer-index");
                if (gvidx && (gvidx == veerIndex)){
                    for (var aci = 0; aci < autosizedColumns.length; aci++)
                        if (autosizedColumns[aci] > i)
                            autosizedColumns[aci] = autosizedColumns[aci] - 1;
                    for (var aci = autosizedColumns.length - 1; aci >= 0; aci--)
                        if (autosizedColumns[aci] === i){                        
                            autosizedColumns.splice(aci, 1);
                            break;
                        }
                }
            }

            for (var i = 0; i < gridColumns.length; ){
                var gridCol = gridColumns[i];
                var gvidx = gridCol.getAttribute("veer-index");
                if (gvidx && (gvidx == veerIndex)){
                    baseColumns[veerIndex].parentNode.removeChild(gridCol);
                }
                else
                    i++;
            }

            for (var i = 0; i < columns.length; ){
                var cl = columns[i];
                var cvidx = cl.veerIndex;
                if(cvidx && (cvidx === veerIndex)){
                    cl.header && cl.header.parentNode && cl.header.parentNode.removeChild(cl.header);
                    columns.splice(i, 1);
                }
                else
                    i++;
            }
        }

        function init(veerDef, cols, autosizedCols, datasources, gbody, hcells, gridCols, hdr, vrIndex, colMap){
            if (!veerDef || !cols)
                return false;
            columns = cols;
            autosizedColumns = autosizedCols;
            gridColumns = gridCols;
            grid = gbody;
            hcellList = hcells;        
            datasourceList = datasources;
            header = hdr;
            sheet = Styles.sheet(gbody.parentNode);
            colsMap = colMap;

            veerDatasources[vrIndex] = datasourceList[veerDef.veerDS];        
            if (!veerDatasources[vrIndex])
                return false;
            veerFieldPaths[vrIndex] = veerDef.veerFPath;
            if (!veerFieldPaths[vrIndex])
                return false;
            dataDatasources[vrIndex] = datasourceList[veerDef.dataDS];
            if (!dataDatasources[vrIndex])
                return false;
            dataFieldPaths[vrIndex] = veerDef.dataFPath;
            if (!dataFieldPaths[vrIndex])
                return false;
            dataKeyFieldPaths[vrIndex] = veerDef.dataKeyFPath;
            if (!dataKeyFieldPaths[vrIndex])
                return false;
            dataFormats[vrIndex] = veerDef.dataFormat;
            dataTypes[vrIndex] = veerDef.dataType;
            if (!dataTypes[vrIndex])
                dataTypes[vrIndex] = 0;
            captionFieldPaths[vrIndex] = veerDef.captFPath;
            if (!captionFieldPaths[vrIndex])
                return false;
            captionFormats[vrIndex] = veerDef.captFormat;
            baseColumns[vrIndex] = veerDef.baseCol;
            if (!baseColumns[vrIndex])
                return false;        
            for (var i = 0; i < hcellList.length; i++) {
                var colId = Elements.dataset(hcellList[i], 'colid');
                if (colId === baseColumns[vrIndex].id) {
                    baseHeaders[vrIndex] = hcellList[i];
                    break;
                }
            }
            if (!baseHeaders[vrIndex])
                return false;           
            return true;
        }

        var updateVeerDatasource = function(veerIndex, isLastVeer, isFirstVeer){        
                return function () {
                    var ok = true;
                    if (!veerDatasources[veerIndex]._scan(function(cursor) { 
                        var rcount = cursor._rowsCount();
                        if (rcount === DM.fetchFPathValue.WAIT) {
                            ok = false;
                            return;
                        }            
                        var ctx = DM.createCachedContext();                    
                        removeColumns(veerIndex);
                        prepareThMap(isFirstVeer);
                        var veerOffset = computeColumnOffset(veerIndex);
                        for (cursor._ridx = 0; cursor._ridx < rcount; cursor._ridx++) {
                            var row = cursor._row();
                            if (!row) {
                                ok = false;
                                break;
                            }
                            ctx.init(veerDatasources[veerIndex], row);
                            var v = DM.fetchFPathValue(veerFieldPaths[veerIndex], ctx.rower(veerDatasources[veerIndex]));
                            var capt = DM.fetchFPathValue(captionFieldPaths[veerIndex], ctx.rower(veerDatasources[veerIndex]));
                            if (v === DM.fetchFPathValue.WAIT || capt === DM.fetchFPathValue.WAIT) {
                                ok = false;
                                break;
                            }
                            if (v === DM.fetchFPathValue.NVAL)
                            {
                                continue; 
                            }
                            if (capt === DM.fetchFPathValue.NVAL)
                                capt = " ";
                            buildColumns(v, capt, cursor._ridx, veerIndex, veerOffset);                
                        }
                        correctColSpanForTopHeader(baseHeaders[veerIndex], rcount, veerOffset);
                    })|| !ok) {            
                    } else {           
                        veersIsLoaded[veerIndex] = true;
                        if (isLastVeer)
                            gridUpdate();
                    }
                };
            };

        function updateVeerColumns(veerDef, cols, autosizedColumns, datasources, gbody, hcells, 
                gridCols, hdr, vrIndex, gridUpdateFunc, isLastVeer, isFirstVeer, colMap){
            veersIsLoaded[vrIndex] = false;
            gridUpdate = gridUpdateFunc;
            if (!init(veerDef, cols, autosizedColumns, datasources, gbody, hcells, 
                gridCols, hdr, vrIndex, colMap))
                return;
            var uvd = updateVeerDatasource(vrIndex, isLastVeer, isFirstVeer);  
            veerDatasources[vrIndex]._listen(uvd);        
        }
        
        var gridVeerList = {
            updateVeerColumns: updateVeerColumns,
            listenVeerData: listenVeerData
        };
        return gridVeerList;
    }
    
    return {
        veerDef: getVeerDef,
        checkVeer: checkVeer,
        makeGridVeerList: makeGridVeerList
    };
} );


