define( [
    "inform.agent.web.forms.Actioner",
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.Styles",
    "static.jquery.jquery"
    , 'static.wcl.Core'
    , 'static.wcl.Theme'
    , 'static.wcl.Utils'
    , 'static.wcl.controls.Button'
    , 'static.wcl.layouts.Flow'
], function(Actioner, WebForm, DM, Styles, $, Wcl, Theme, Utils, Button, Flow) {
    var FIRST_TAB_STYLE = {
        borderLeftStyle: 'solid'
    };
    Styles.sheet().rule( "div.wcl-pages" ).style( {
        '>button': {
            borderLeftStyle: "none",
            borderBottomLeftRadius: 0,
            borderBottomRightRadius: 0,
            zIndex: 1,
            color: "black",
            fontStyle: "normal",
            fontWeight: "normal",
            textDecoration: "none",
            ':first-child': {
                borderLeftStyle: "solid"
            },
            '.active': {
                ':hover': {
                    backgroundColor: 'white'
                },
                backgroundColor: "white",
                backgroundImage: "none",
                borderBottomColor: "transparent",
                borderTop: "2px solid",
                color: "#0080F0"
            }
        },
        '.showall>div': {
            display: 'block'
        },
        '>div': {
            display: "none",
            border: "1px solid #D0D0D0",
            '.active': {
                display: "block"//IE7bug
            },
            ':empty': {
                display: "none"
            }
        }
    } );
    function WclControl(parent, container, arg) {
        var components = arg.cmps;
        var element = document.createElement('div');
        element.className = 'wcl-pages';
        var tabsflow = Wcl._mk(this, element, {_: Flow, type: Flow.HORZ, gap: 0, halign: Flow.HALIGN.LEFT});
        var pages = [];
        var TWO_BORDER_WIDTHS = 2;
        var apidx = 0;
        this.flowType = arg.flowType|0;
        this.calculate = function() {
            var r = {
                min: {x: 0, y: 0},
                max: {x: 0, y: 0},
                _pc: [],
                _bc: tabsflow.calculate()
            };
            Styles.addClass(element, 'showall');
            try {
            for (var i = 0; i < pages.length; i++) {
                var c = pages[i].item.calculate();
                r._pc[i] = c;
                if (!pages[i].page.firstChild)
                    continue;
                r.min.x = Math.max(r.min.x, c.min.x);
                r.min.y = Math.max(r.min.y, c.min.y);
                r.max.x = Math.max(r.max.x, c.max.x);
                r.max.y = Math.max(r.max.y, c.max.y);
            }
            r.min.x = Math.max(r.min.x + TWO_BORDER_WIDTHS, r._bc.min.x);
            r.min.y += r._bc.min.y - 1 + TWO_BORDER_WIDTHS;
            r.max.x = Math.max(r.max.x + TWO_BORDER_WIDTHS, r._bc.max.x);
            r.max.y += r._bc.max.y - 1 + TWO_BORDER_WIDTHS;
            } finally {
                Styles.removeClass(element, 'showall');
            }
            return r;
        };
        var recter = Wcl._mkRecter(element);
        this.validate = function(arg) {
            var r = arg.rect, rr = {
                p: {x: 0, y: Theme.LINECONTROL_HEIGHT - 1},
                s: {x: r.s.x, y: r.s.y - Theme.LINECONTROL_HEIGHT + 1}
            };
            recter(r);
            tabsflow.validate({
                rect: {p: {x:0, y:0}, s: {x: r.s.x, y: Theme.LINECONTROL_HEIGHT}},
                calc: arg.calc._bc
            });
            if (apidx === -1)
                return;
            var page = pages[apidx];
            page.rctr(rr);
            page.item.validate({
                rect: {
                    p: {x: 0, y: 0},
                    s: {x: rr.s.x - TWO_BORDER_WIDTHS, y: rr.s.y - TWO_BORDER_WIDTHS}
                },
                calc: arg.calc._pc[apidx]
            });
        };
        this.invalidate = function() {
            parent.invalidate();
        };
        function activate() {
            for (var i = 0; i < pages.length; i++) {
                var p = pages[i];
                if (p !== this.page)
                    Styles.removeClass(p.page, 'active');
            }
            var buttons = element.getElementsByTagName('button');
            for (var i = 0; i < buttons.length; i++)
                if (buttons[i].parentNode === element)
                    Styles.removeClass(buttons[i], 'active');
            this.mcls.set('active');
            Styles.addClass(this.page, 'active');
            apidx = this.index;
            parent.invalidate();
        }
        function uactivate() {
            for ( var i = 0; i < pages.length; i++ ) {
                var b = pages[i];
                b._uactive = b === this;
            }
        }
        function updateAction() {
            var disabled = !!this._executing, onclick = null;
            if ( !disabled ) {
                var act = this._action && this._action._action();
                if ( !(disabled = !act) ) {
                    var self = this;
                    onclick = function( e ) {
                        function always() {
                            self._executing = false;
                            updateAction.call( self );
                        }
                        self._executing = true;
                        self._preclick && self._preclick.call( self );
                        act = self._action._action();
                        if (!act)
                            throw 'disabled action';
                        act( {event: e || window.event} ).then( always, always );
                        updateAction.call( self );
                    };
                }
            }
            var old = this.mclk();
            this.mclk.set(onclick);
            if (!old !== !onclick)
                this._component && this._component._touch();
        }
        function mkButton(page, button) {
            button.mcls = Wcl.createRWModel('');
            button.mclk = Wcl.createRWModel(function() {
                button._preclick();
            });
            var dsid = page.ds && page.ds._id;
            if ( !dsid ) {
              setTimeout(function() {
                var act = page.postaction;
                if ( act )
                    button._action = new (WebForm.ActionList)( act, components );
                if (button._action) {
                    function update() {
                        updateAction.call( button );
                    }
                    button._action._listen( update );
                    update();
                }
              } );
                tabsflow.appendItem({
                    _: Button,
                    text: page.text,
                    onclick: button.mclk,
                    className: button.mcls
                });
                return;
            }
            var dsflow = tabsflow.appendItem({_: Flow, type: Flow.HORZ, gap: 0, halign: Flow.HALIGN.LEFT});
            var datasource = page.ds;
            var fp = page.fcap;
            var tmoWait, buttons = [];
            if (page.postaction)
            setTimeout(function() {
                var act = button._action = new (WebForm.ActionList)(page.postaction, components);
                for (var i in buttons)
                    buttons[i]._action = act;
                function update() {
                    for (var i in buttons)
                        updateAction.call(buttons[i]);
                }
                button._action._listen(update);
                update();
            });
            function dsupdate() {
                var ok = true;
                if ( !datasource._scan( function( cursor ) {
                    var rcount = cursor._rowsCount();
                    if ( rcount === DM.fetchFPathValue.WAIT ) {
                        ok = false;
                        return;
                    }
                    clearTimeout( tmoWait );
                    tmoWait = null;
                    while (buttons.length > rcount) {
                        var b = buttons.pop();
                        dsflow.removeItem(b.item);
                    }
                    if (rcount === 0) {
                        Styles.removeClass(button.page, 'active');
                        apidx = -1;
                        parent.invalidate();
                    }
                    var ridx = cursor._ridx;
                    var ctx = DM.createCachedContext();
                    var has_news = false;
                    for ( cursor._ridx = 0; cursor._ridx < rcount; cursor._ridx++ ) {
                        var row = cursor._row();
                        if ( !row ) {
                            ok = false;
                            break;
                        }
                        ctx.init( datasource, row );
                        var v = DM.fetchFPathValue( fp, ctx.rower( fp[0]._datasource ) );
                        if ( v === DM.fetchFPathValue.WAIT ) {
                            ok = false;
                            break;
                        }
                        if ( v === DM.fetchFPathValue.NVAL )
                            continue;
                        var b;
                        if (cursor._ridx >= buttons.length) {
                            var mcap = Wcl.createRWModel(v);
                            var mcls = Wcl.createRWModel('');
                            var preclick = (function(ridx) {
                                return function() {
                                    uactivate.call(button);
                                    b.cursor._ridx = ridx;
                                    datasource._touch();
                                };
                            })(cursor._ridx);
                            var mclk = Wcl.createRWModel(preclick);
                            buttons.push(b = {
                                index: button.index,
                                _action: button._action,
                                mcap: mcap,
                                mcls: mcls,
                                mclk: mclk,
                                page: button.page,
                                _preclick: preclick,
                                item: dsflow.appendItem({
                                    _: Button,
                                    text: mcap,
                                    onclick: mclk,
                                    style: cursor._ridx === 0 ? FIRST_TAB_STYLE : undefined,
                                    className: mcls
                                })
                            });
                            has_news = true;
                        } else {
                            b = buttons[cursor._ridx];
                            b.mcap && b.mcap.set(v);
                        }
                        b.cursor = cursor;
                        b.mcls.set(ridx === cursor._ridx ? 'active' : '');
                    }
                    if (has_news && button._action)
                        button._action._touch();
                    if ( button._uactive ) {
                        var b = buttons[ridx];
                        b && activate.call( b );
                    }
                } ) || !ok && !tmoWait )
                    tmoWait = setTimeout( function() {
                        if ( !tmoWait )//IE8 bug
                            return;
                        for (var i in buttons)
                            buttons[i].mcls.set('waiting');
                    }, 250 );
            }
            datasource._listen( dsupdate );
            dsupdate();
        }
        for (var i = 0; i < arg.pages.length; i++)
            if (arg.pages[i].active) {
                apidx = i;
                break;
            }
        for (var i = 0; i < arg.pages.length; i++) {
            var p = arg.pages[i];
            var page = {
                index: i,
                _uactive: i === apidx,
                _preclick: function() {
                    uactivate.call(this);
                    activate.call(this);
                }
            };
            var c = (function( b ) {
                return new (CLASS( {
                    constructor: function() {
                        Actioner.constructor.call( this );
                    },
                    _action: function( id ) {
                        return (id === 1) && b.mclk() ? function() {
                            if ( b._activating )
                                return;
                            b._activating = true;
                            try {
                                uactivate.call( b );
                                activate.call( b );
                            } finally {
                                b._activating = false;
                            }
                        } : null;
                    }
                }, Actioner ));
            })(page);
            pages.push(page);
            page._component = components[p.id] = c;
            var acls = i === apidx ? ' active' : '';
            var p = arg.pages[i];
            var pe = document.createElement('div');
            pe.className = 'wcl-page' + acls;
            p.item._ = Utils.Margin(p.item._);
            page.page = pe;
            page.rctr = Wcl._mkRecter(pe);
            page.item = Wcl._mk(parent, pe, p.item);
            mkButton(p, page);
            page.mcls.set(acls);
            element.appendChild(pe);
        }
        container.appendChild(element);
    }
    return {
        WclControl: WclControl
    };
} );
