define( [
  'inform.agent.web.Styles'
  , 'static.wcl.Core'
  , 'static.wcl.Theme'
  , 'static.wcl.layouts.Flow'
], function(Styles, Wcl, Theme, Flow) {
    var dragged = null;
    document.onmousemove = /*window.ontouchmove = */function( e ) {
        if ( !dragged )
            return;
        e = e || window.event;
        var t = e.changedTouches ? e.changedTouches[0] : e;
        if ( dragged._svert ) {
            var y = (t.pageY || t.clientY) + dragged._oy;
            dragged.style.top = y + "px";
        } else {
            var x = (t.pageX || t.clientX) + dragged._ox;
            dragged.style.left = x + "px";
        }
        e.preventDefault ? e.preventDefault() : (e.cancelBubble = true);
    };
    document.onmouseup = /*window.ontouchend = */function( e ) {
        if ( !dragged )
            return;
        e = e || window.event;
        var t = e.changedTouches ? e.changedTouches[0] : e;
        dragged._ondrop && dragged._ondrop(t);
        dragged.parentNode && dragged.parentNode.removeChild( dragged );
        dragged = null;
    };
    Styles.sheet().rules({
        '.wcl-splitter': {
            'background-color': '#C0C0C0',
            border: '1px solid white',
            '.dragger': {
                'z-index': 9,
                'background-color': 'white',
                position: 'fixed !important',//to prevent scrollbars
                border: '1px solid gray'
            },
            '.horz': {
                cursor: 'e-resize'
            },
            '.vert': {
                cursor: 'n-resize'
            }
        }
    });
    function Splitters(parent, container, arg) {
        this.invalidate = function() {
            parent.invalidate();
        };
        this.flowType = arg.flowType|0;
        this.validFlowType = arg.flowType != undefined;
        if(arg.wdiID)
        {
            this.dbg = "Splitters";
            this.wdiID = arg.wdiID;
        }
        if(arg.wdiNAME)
            this.wdiName = arg.wdiNAME;
        var block;
        if(arg.block)
        {
            var element = document.createElement('div');
            element.className = 'wcl-panel';
            arg.style && Styles.apply(element.style, arg.style);
            container.appendChild(element);
            container = element;
            block = Wcl._mkRecter(element);
        }
        var items = [], gap = Theme.GAP, t = arg.type, splitters = [];
        for (var i = 0, l = arg.items.length; i < l; i++) {
            if (i) {
                var spl = document.createElement('div');
                spl.className = 'wcl-splitter ' + (t === Flow.HORZ ? 'horz' : 'vert');
                spl._index = i - 1;
                spl.onmousedown = function( e ) {
                    e = e || window.event;
                    var drg = document.createElement('div');
                    drg.draggable = true;
                    drg.className = this.className + ' dragger';
                    drg._splitter = this;
                    drg._svert = t === Flow.VERT;
                    var ox = 0, oy = 0;
                    var c = this;
                    while (c) {
                        ox += c.offsetLeft - c.scrollLeft;
                        oy += c.offsetTop - c.scrollTop;
                        c = c.offsetParent;
                    }
                    drg._sx = (e.pageX || e.clientX);
                    drg._ox = ox - drg._sx;
                    drg._sy = (e.pageY || e.clientY);
                    drg._oy = oy - drg._sy;
                    drg.style.width = this.offsetWidth + 'px';
                    drg.style.height = this.offsetHeight + 'px';
                    container.appendChild(drg);
                    drg.style.left = ox + 'px';
                    drg.style.top = oy + 'px';
                    drg._ondrop = function() {
                        for (var i = 0; i < this._splitter._index; i++) {
                            var sp = splitters[i];
                            sp._value = (t === Flow.HORZ ? sp.offsetLeft : sp.offsetTop) - sp._offset;
                        }
                        var c = container;
                        var ox = 0, oy = 0;
                        while (c) {
                            ox += c.offsetLeft - c.scrollLeft;
                            oy += c.offsetTop - c.scrollTop;
                            c = c.offsetParent;
                        }
                        var sp = this._splitter;
                        sp._value = (t === Flow.HORZ ? (this.offsetLeft - ox) : (this.offsetTop - oy)) - this._splitter._offset;
                        parent.invalidate();
                    };
                    dragged = drg;
                    e.preventDefault ? e.preventDefault() : (e.cancelBubble = true);
                };
                container.appendChild(spl);
                splitters.push(spl);
            }
            items.push(Wcl._mk(parent, container, arg.items[i]));
        }
        this.calculate = function() {
            var r = {
                min: {x: 0, y: 0},
                max: {x: 0, y: 0},
                _ch: []
            };
            for (var i = 0, l = items.length, sl = splitters.length; i < l; i++) {
                var c = items[i].calculate();
                c.flowType = (items[i].flowType|0)&0x33;
                r._ch.push(c);
                r.min[t.m] += c.min[t.m];
                r.max[t.m] += c.max[t.m];
                if (i < sl) {
                    var sv = splitters[i]._value;
                    if (sv !== undefined) {
                        var mn = r.min[t.m] = Math.max(r.min[t.m], sv);
                        r.max[t.m] = Math.max(Math.min(r.max[t.m], sv), mn);
                    }
                }
                if (i !== 0) {
                    r.min[t.m] += gap;
                    r.max[t.m] += gap;
                }
                if (r.min[t.o] < c.min[t.o])
                    r.min[t.o] = c.min[t.o];
                if (r.max[t.o] < c.max[t.o])
                    r.max[t.o] = c.max[t.o];
            }
            if((this.flowType&0x30) == 0x30)
                r.max[t.m] = Wcl.Control.UNBOUND_MAX[t.m];
            return r;
        };
        this.validate = function(arg) {
            var ii = [];
            var r = arg.rect, s = r.s, c = arg.calc;
            if(block)
            {
                block(r);
                r.p.x = 0;
                r.p.y = 0;
            }
            var splmoved = false;
            for (var si = splitters.length - 1; si >= 0; si--) {
                var lsp = splitters[si];
                if (lsp._value) {
                    var smn = 0;
                    for (var i = 0; i <= si; i++) {
                        var ci = c._ch[i];
                        var val = splitters[i]._value - (smn + gap);
                        val = Math.max(val, ci.min[t.m]);
                        ii.push({item: items[i], flowType: (ci.flowType||0)&0x3, calc: ci, val: val});
                        smn += val;
                        if (i)
                            smn += gap;
                    }
                    var xx = [];
                    for (var i = si + 1, l = items.length; i < l; i++) {
                        var ci = c._ch[i];
                        xx.push({item: items[i], flowType: 0, calc: ci, max: ci.max[t.m], val: ci.min[t.m]});
                        smn += ci.min[t.m] + gap;
                    }
                    //Flow._algorithmComplex(xx, s[t.m], s[t.m] - smn, gap);
                    Flow._algorithm(xx, s[t.m] - smn);
                    ii = ii.concat(xx);
                    splmoved = true;
                    break;
                }
            }
            if (!splmoved) {
                for (var i = 0, l = items.length; i < l; i++) {
                    var ci = c._ch[i];
                    ii.push({item: items[i], flowType: (ci.flowType||0)&0x3, calc: ci, max: ci.max[t.m], val: ci.min[t.m]});
                }
                Flow._algorithmComplex(ii, s[t.m], s[t.m] - c.min[t.m], gap);
            }
            var pp = {x: r.p.x, y: r.p.y};
            var ppp = {x: 0, y: 0};
            for (var i = 0, l = ii.length, sl = splitters.length; i < l; i++) {
                var n = ii[i], x = {};
                x[t.m] = n.val;
                x[t.o] = s[t.o];
                ppp.x = pp.x;
                ppp.y = pp.y;
                if(n.d > 0)
                    ppp[t.m] = r.p[t.m]+n.d;
                n.item.validate({rect: {p: ppp, s: x}, calc: n.calc});
                ppp[t.m] += n.val;
                if (i < sl) {
                    var sp = splitters[i];
                    if (t === Flow.HORZ) {
                        sp.style.left = (ppp.x | 0) + 'px';
                        sp.style.top = (ppp.y | 0) + 'px';
                        sp.style.width = (gap | 0) + 'px';
                        sp.style.height = (s.y | 0) + 'px';
                    } else {
                        sp.style.left = (ppp.x | 0) + 'px';
                        sp.style.top = (ppp.y | 0) + 'px';
                        sp.style.width = (s.x | 0) + 'px';
                        sp.style.height = (gap | 0) + 'px';
                    }
                    sp._offset = r.p[t.m];
                }
                pp[t.m] += n.val+gap;
            }
        };
    }
    return {
        WclControl: function(parent, container, arg) {
            this.invalidate = function() {
                parent.invalidate();
            };
            var block;
            if(arg.block)
            {
                var element = document.createElement('div');
                element.className = 'wcl-panel';
                arg.style && Styles.apply(element.style, arg.style);
                container.appendChild(element);
                container = element;
                block = Wcl._mkRecter(element);
            }
            var gap = Theme.GAP;
            var items = [], hasL = false, hasR = false;
            if (arg.items)
                for (var ri = 0, rl = arg.items.length; ri < rl; ri++) {
                    var aitem = arg.items[ri];
                    if (!(aitem instanceof Array))
                        items.push([null, Wcl._mk(parent, container, aitem), null]);
                    else {
                        items.push([
                            aitem[0] && Wcl._mk(parent, container, aitem[0]),
                            aitem[1] && Wcl._mk(parent, container, aitem[1]),
                            aitem[2] && Wcl._mk(parent, container, aitem[2])
                        ]);
                        hasL |= !!aitem[0];
                        hasR |= !!aitem[2];
                    }
                }
            this.flowType = arg.flowType|0;
            this.validFlowType = arg.flowType != undefined;
            if(arg.wdiID)
            {
                this.dbg = "WebPanel";
                this.wdiID = arg.wdiID;
            }
            if(arg.wdiNAME)
                this.wdiName = arg.wdiNAME;
            if(arg.wdiID)
                this.wdiID = arg.wdiID;
            if(arg.wdiNAME)
                this.wdiName = arg.wdiNAME;
            this.calculate = function() {
                var cws = Array(3), rhs = Array(items.length);
                for (var i = 0; i < cws.length; i++)
                    cws[i] = {min: 0, max: 0};
                for (var i = 0; i < rhs.length; i++)
                    rhs[i] = {min: 0, max: 0, flowType: 0, d: 0};
                var cc = Array(items.length);
                for (var i = 0, l = items.length; i < l; i++) {
                    var item = items[i], rh = rhs[i];
                    function ic(item, rh, cw) {
                        if (!item)
                            return item;
                        var c = item.calculate();
                        c.flowType = (item.flowType|0)&0x33;
                        cw.min = Math.max(cw.min, c.min.x);
                        cw.max = Math.max(cw.max, c.max.x);
                        rh.min = Math.max(rh.min, c.min.y);
                        rh.max = Math.max(rh.max, c.max.y);
                        return c;
                    }
                    rh.flowType = item[1].flowType;
                    cc[i] = [
                        ic(item[0], rh, cws[0]),
                        ic(item[1], rh, cws[1]),
                        ic(item[2], rh, cws[2])
                    ];
                }
                var r = {
                    min: {x: 0, y: 0},
                    max: {x: 0, y: 0},
                    _cw: cws,
                    _rh: rhs,
                    _cc: cc
                };
                for (var i = 0, l = cws.length; i < l; i++) {
                    var cw = cws[i];
                    r.min.x += cw.min;
                    r.max.x += cw.max;
                }
                var cgp = ((hasL | 0) + (hasR | 0)) * gap;
                r.min.x += cgp;
                r.max.x += cgp;
                for (var i = 0, l = rhs.length; i < l; i++) {
                    var rh = rhs[i];
                    r.min.y += rh.min;
                    r.max.y += rh.max;
                }
                r.min.y += (rhs.length - 1) * gap;
                r.max.y += (rhs.length - 1) * gap;
                if((this.flowType&0x30) == 0x30)
                    r.max.x = Wcl.Control.UNBOUND_MAX.x;
                return r;
            };
            function FlowAlg(cc, s, dm, gap, validFlowType) {
                var rr = [];
                for (var i = 0, l = cc.length; i < l; i++) {
                    var ci = cc[i];
                    if(validFlowType)
                        rr.push({max: ci.max, val: ci.min, flowType: ci.flowType, d: 0});
                    else
                        rr.push({max: ci.max, val: ci.min, d: 0});
                }
                if(validFlowType)
                    Flow._algorithmComplex(rr, s, dm, gap);
                 else
                    Flow._algorithm(rr, dm);
                return rr;
            }
            this.validate = function(arg) {
                var r = arg.rect, s = r.s, c = arg.calc;
                if(block)
                {
                    block(r);
                    r.p.x = 0;
                    r.p.y = 0;
                }
                var cws = FlowAlg(c._cw, s.x, s.x - c.min.x, 0, false);
                var rhs = FlowAlg(c._rh, s.y, s.y - c.min.y, gap, this.validFlowType);
                var py = r.p.y;
                for (var i = 0, l = items.length; i < l; i++) {
                    var rh = rhs[i], item = items[i];
                    if (item[0] || item[2]) {
                        var px = r.p.x;
                        function vi(ii, dy) {
                            var iitem = item[ii];
                            if (!iitem)
                                return;
                            iitem.validate({
                                rect: {
                                    p: {x: px, y: (dy > 0)? r.p.y+dy : py},
                                    s: {x: cws[ii].val, y: rh.val}
                                },
                                calc: c._cc[i][ii]
                            });
                        }
                        if (hasL) {
                            vi(0, cws[0].d);
                            px += cws[0].val + gap;
                        }
                        vi(1, cws[1].d);
                        px += cws[1].val + gap;
                        vi(2, cws[2].d);
                    } else
                        item[1].validate({
                            rect: {
                                p: {x: r.p.x, y: (rh.d > 0)? r.p.y+rh.d:py},
                                s: {x: r.s.x, y: rh.val}
                            },
                            calc: c._cc[i][1]
                        });
                    py += rh.val + gap;
                }
            };
        },
        Splitters: Splitters,
        initialization: function( root$, components ) {
            root$.find( "div.splitters" ).each( function() {
                make( this );
            } );
        }
    };
} );
